package com.shizentai.app.arcam;

import java.nio.IntBuffer;

import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL11;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.opengl.GLU;
import android.opengl.GLUtils;
import android.view.SurfaceHolder;

/**
 * 
 * @author Shizentai Factory Co.
 *
 */
public class Render
{
	public class Texture 
	{
    int id;
    int width;
    int height;
    int size;
	}
	public class MarkerDesc
	{
		long pattern;
		int cf;		// *2^16
		int dir;
		int posx;
		int posy;
		int lockon;
		int lockonCount;
		final int[] matrix = new int [ 16 ];
		MarkerDesc prev;
	}

	static final int marker_max_detect = 50;
	static final int cf_threshold = (int)(0.7 * (1<<16));
	static final int marker_width = 40;
	static final int[] marker_center = { 0, 0 };
	static final int marker_angle_inc = 10<<16;
	static final int marker_distance_dbllock = 230*230;
  static final int marker_lockon_none = 0;
  static final int marker_lockon_far = 1;
  static final int marker_lockon_near = 2;
  static final int marker_lockon_count_max = 3;
	
	arcamView view;
	
	EGL10 egl;
	EGLDisplay dpy;
	EGLContext eglCtx;
	EGLSurface eglSurface;
	GL11 gl;
	
	int camWidth, camHeight;					// カメラ表示領域の大きさ
	int surfaceWidth, surfaceHeight;	// サーフェスの大きさ
	int camimgWidth;									// カメラ実写画像を描画するテクスチャの一辺の長さ
	
  public Texture texCamimg;
  float[] fmatProj;
	Models models; 
	
	MarkerDesc[][] markerDescs;
	int markerPage;
	int lastMarkers;

	int countDraw;
	int markerAngle;
	final int[] marker_scrpos = new int [ marker_max_detect<<2 ];
	
	public Render( arcamView view, SurfaceHolder holder, int surfaceWidth, int surfaceHeight, int camWidth, int camHeight )
	{
		this.view = view;
		
		// OpenGL初期化
		egl = (EGL10)EGLContext.getEGL();
		dpy = egl.eglGetDisplay( EGL10.EGL_DEFAULT_DISPLAY );
		int[] eglVersion = new int [ 2 ];
		egl.eglInitialize( dpy, eglVersion );
		final int[] eglPxConfig = {
				EGL10.EGL_RED_SIZE, 5,
				EGL10.EGL_GREEN_SIZE, 6,
				EGL10.EGL_BLUE_SIZE, 5,
				EGL10.EGL_DEPTH_SIZE, 16,
				EGL10.EGL_NONE
		};
		EGLConfig[] configs = new EGLConfig[ 1 ];
		int[] numConfig = new int [ 1 ];
		egl.eglChooseConfig( dpy, eglPxConfig, configs, 1, numConfig );
		EGLConfig eglConfig = configs[ 0 ];
		eglCtx = egl.eglCreateContext( dpy, eglConfig, EGL10.EGL_NO_CONTEXT, null );
		eglSurface = null;
		gl = null;

		eglSurface = egl.eglCreateWindowSurface( dpy, eglConfig, holder, null );
		egl.eglMakeCurrent( dpy, eglSurface, eglSurface, eglCtx );
		gl = (GL11)eglCtx.getGL();
		this.surfaceWidth = surfaceWidth;
		this.surfaceHeight = surfaceHeight;
		this.camWidth = camWidth;
		this.camHeight = camHeight;
		init();

		models = new Models(); 
		texCamimg = makeTexture( camWidth, camHeight, 0 );
 		camimgWidth = ( surfaceWidth > surfaceHeight )? surfaceWidth * texCamimg.size / texCamimg.width
 																									: surfaceHeight * texCamimg.size / texCamimg.height;
 		countDraw = 0;
 		markerAngle = 0;
 		fmatProj = null;
 		lastMarkers = 0;
 		markerPage = 0;
 		markerDescs = new MarkerDesc[ 2 ][];
 		for ( int i=0; i<2; i++ )
 		{
 			markerDescs[ i ] = new MarkerDesc [ marker_max_detect ];
 			for ( int k=0; k<marker_max_detect; k++ )
 				markerDescs[ i ][ k ] = new MarkerDesc();
 		}
	}

	@Override
	protected void finalize() throws Throwable
	{
		try
		{
			super.finalize();
		}
		finally
		{
			destroy();
		}
	}

	public void destroy()
	{
		// OpenGL終了
		if ( egl != null )
		{
			if ( texCamimg != null )
				gl.glDeleteTextures( 1, new int[]{ texCamimg.id }, 0 );
			egl.eglMakeCurrent( dpy, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT );
			egl.eglDestroySurface( dpy, eglSurface );
			egl.eglDestroyContext( dpy, eglCtx );
			egl.eglTerminate( dpy );
			egl = null;
		}
	}

	void setDrawMode2D()
	{
		gl.glViewport( 0, 0, surfaceWidth, surfaceHeight );
		gl.glMatrixMode( GL11.GL_MODELVIEW );
		gl.glLoadIdentity();
		gl.glMatrixMode( GL11.GL_PROJECTION );
		gl.glLoadIdentity();
    gl.glOrthof( -surfaceWidth>>1, surfaceWidth>>1, -surfaceHeight>>1, surfaceHeight>>1, -1.0F, 1.0F );    
    gl.glTranslatef( -surfaceWidth>>1, surfaceHeight>>1, 0 );
	}
	void setDrawMode3D()
	{
		gl.glMatrixMode( GL11.GL_MODELVIEW );
		gl.glLoadIdentity();
	}
	void setDrawModeCamera()
	{
		gl.glMatrixMode( GL11.GL_MODELVIEW );
		gl.glLoadIdentity();
		if ( fmatProj != null )
		{
			gl.glViewport( 0, 0, surfaceWidth, surfaceHeight );
			gl.glMatrixMode( GL11.GL_PROJECTION );
			gl.glLoadMatrixf( fmatProj, 0 );
		}
	}
	
  void init()
  {
    setDrawMode2D();

    //クリア色の設定
    gl.glClearColorx( 0, 0, 0, 0 );
    
    gl.glEnable( GL11.GL_TEXTURE_2D );
    gl.glEnable( GL11.GL_DEPTH_TEST );
    //gl.glEnable( GL11.GL_ALPHA_TEST );
    gl.glBlendFunc( GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA );
    //gl.glEnable( GL11.GL_BLEND );
    gl.glEnable( GL11.GL_POINT_SMOOTH );
    gl.glEnable( GL11.GL_CULL_FACE );
    gl.glCullFace( GL11.GL_BACK );
  }
  
	public void setProjectionMatrix( double[] mat )
	{
		fmatProj = new float [ 16 ];
		for ( int i=0; i<16; i++ )
			fmatProj[ i ] = (float)mat[ i ];
	}
	
  void drawTexture( Texture texture, int x, int y, int w, int h )
  {
    models.drawPanel( gl, texture.id, x, y, w, h );
  }    
  void drawTexture( Texture texture, int x, int y )
  {
  	drawTexture( texture, x, y, texture.width, texture.height );
  }    
  
	// ビットマップのリサイズ
	Bitmap resizeBitmap( Bitmap bmp, int w, int h, Bitmap.Config fmt, int srcw, int srch )
	{
		Bitmap result = Bitmap.createBitmap( w, h, fmt );
		Canvas c = new Canvas( result );
		c.drawBitmap( bmp, new Rect(0,0,srcw,srch), new Rect(0,0,w,h), null );
		return result;
	}
	Bitmap resizeBitmap( Bitmap bmp, int w, int h )
	{
		return resizeBitmap( bmp, w, h, Bitmap.Config.ARGB_8888, bmp.getWidth(), bmp.getHeight() );
	}

	// テクスチャの読み込み
	Texture makeTexture( Bitmap bmp )
	{
		// リサイズ
		int w = Math.max( bmp.getWidth(), bmp.getHeight() );
		int size;
		for (size = 32; size < 1024; size <<= 1)
		{
			if (w <= size)
				break;
		}

		// 画像データの生成
		Bitmap result = resizeBitmap( bmp, size, size );
		//IntBuffer buf = IntBuffer.allocate( size * size );
		//result.copyPixelsToBuffer( buf );
		//result.recycle();
		
		// テクスチャの設定
		int[] texid = new int[]{0};
		gl.glGenTextures( 1, texid, 0 );
		gl.glBindTexture( GL11.GL_TEXTURE_2D, texid[0] );
		GLUtils.texImage2D( GL11.GL_TEXTURE_2D, 0, result, GL11.GL_UNSIGNED_BYTE );
		//gl.glTexImage2D( GL11.GL_TEXTURE_2D, 0, GL11.GL_RGBA, size, size, 0, GL11.GL_RGBA, GL11.GL_UNSIGNED_BYTE, buf );
		gl.glTexParameterf( GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_LINEAR );
		gl.glTexParameterf( GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_LINEAR );
		gl.glBindTexture( GL11.GL_TEXTURE_2D, 0 );

		// テクスチャオブジェクトの生成
		Texture texture = new Texture();
		texture.id = texid[0];
		texture.width = bmp.getWidth();
		texture.height = bmp.getHeight();
		texture.size = size;
		return texture;
	}

	// 空テクスチャ作成
	Texture makeTexture( int width, int height, int texsize )
	{
		int w = Math.max( width, height );
		int size = texsize;
		if ( size == 0 )
		{
			for (size = 32; size < 1024; size <<= 1)
			{
				if (w <= size)
					break;
			}
		}
		IntBuffer buf = IntBuffer.allocate( size * size );
		
		// テクスチャの設定
		int[] texid = new int[]{0};
		gl.glGenTextures( 1, texid, 0 );
		gl.glBindTexture( GL11.GL_TEXTURE_2D, texid[0] );
		gl.glTexImage2D( GL11.GL_TEXTURE_2D, 0, GL11.GL_RGBA, size, size, 0, GL11.GL_RGBA, GL11.GL_UNSIGNED_BYTE, buf );
		gl.glTexParameterf( GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MAG_FILTER, GL11.GL_LINEAR );
		gl.glTexParameterf( GL11.GL_TEXTURE_2D, GL11.GL_TEXTURE_MIN_FILTER, GL11.GL_LINEAR );
		gl.glBindTexture( GL11.GL_TEXTURE_2D, 0 );

		// テクスチャオブジェクトの生成
		Texture texture = new Texture();
		texture.id = texid[0];
		texture.width = width;
		texture.height = height;
		texture.size = size;
		return texture;
	}
  
	public void setTextureImage( Texture tex, Bitmap bmp, int bmpw, int bmph )
	{
		GLUtils.texSubImage2D( GL11.GL_TEXTURE_2D, 0, 0, 0, bmp );
	}
	public void setTextureImage( Texture tex, IntBuffer imgbuf, int bmpw, int bmph )
	{
		imgbuf.position( 0 );
		gl.glBindTexture( GL11.GL_TEXTURE_2D, tex.id );
		gl.glTexSubImage2D( GL11.GL_TEXTURE_2D, 0, 0, 0, bmpw, bmph, GL11.GL_RGBA, GL11.GL_UNSIGNED_BYTE, imgbuf );
		gl.glBindTexture( GL11.GL_TEXTURE_2D, 0 );
	}
	
	
  public void flip()
  {
  	egl.eglSwapBuffers( dpy, eglSurface );
  }
  
  public void draw( ARtk.MarkerInfo[] markerinfo )
  {
  	countDraw++;
  	
  	//
  	// マーカーを同定し、モデルビュー行列を導出する
  	//
  	MarkerDesc[] curMarkers = markerDescs[ markerPage ];
  	MarkerDesc[] prevMarkers = markerDescs[ markerPage^1 ];
  	markerPage ^= 1;
		for ( int i=0; i<markerinfo.length; i++ )
		{
			ARtk.MarkerInfo mi = markerinfo[ i ];
			MarkerDesc desc = curMarkers[ i ];
			desc.pattern = -1;
			desc.prev = null;
			
			// 前回マーカーのうち、現在マーカーと距離が最も近く閾値未満のものを同じものとみなす
			if ( lastMarkers > 0 )
			{
				final int distance_same = 10*10;	// 前回検出されたマーカーと同じものだと判定する距離の二乗
				long d = 10000*10000;
				for ( int q=0; q<lastMarkers; q++ )
				{
					if ( prevMarkers[ q ].pattern >= 0 )
					{
						int dx = mi.posx - prevMarkers[ q ].posx;
						int dy = mi.posy - prevMarkers[ q ].posy;
						int t = dx*dx + dy*dy;
						if ( d > t )
						{
							d = t;
							if ( d < distance_same )
								desc.prev = prevMarkers[ q ];
						}
					}
				}
			}
			
			if ( desc.prev == null )
			{
				if ( mi.cf < cf_threshold  ||  mi.id < 0 )
					continue;
			}
			else
			{
				if ( desc.prev.cf < cf_threshold ) 
					continue;
			}
			
			if ( mi.id >= 0 )
			{
				desc.pattern = view.getPattern( (int)mi.id );
				desc.dir = mi.dir;
				desc.cf = ( desc.prev == null )? mi.cf : Math.max( mi.cf, desc.prev.cf );
			}
			else
			{
				desc.pattern = desc.prev.pattern;
				desc.dir = desc.prev.dir;
				desc.cf = desc.prev.cf;
			}
			desc.posx = mi.posx;
			desc.posy = mi.posy;
			
			if ( desc.prev == null )
				ARtk.arGetTransMat( mi, marker_center[ 0 ], marker_center[ 1 ], marker_width, desc.matrix );
			else
				ARtk.arGetTransMatCont( mi, desc.prev.matrix, marker_center[ 0 ], marker_center[ 1 ], marker_width, desc.matrix );  
			
			// オブジェクトがカメラの後ろに回ることはない
			if ( desc.matrix[ 2+3*4 ] < 0 )
			{
				desc.pattern = -1;
				continue;
			}
		}
		lastMarkers = markerinfo.length;
  	
  	
  	//
  	// 画面クリア
  	//
  	gl.glClear( GL11.GL_COLOR_BUFFER_BIT | GL11.GL_DEPTH_BUFFER_BIT );
  	
  	//
  	// 背景描画
  	//
  	setDrawMode2D();  	
  	gl.glDisable( GL11.GL_DEPTH_TEST );
  	drawTexture( texCamimg, 0, 0, camimgWidth, camimgWidth );
  	gl.glEnable( GL11.GL_DEPTH_TEST );
  	
  	//
  	// オブジェクト描画
  	//
  	setDrawModeCamera();
  	gl.glMatrixMode( GL11.GL_MODELVIEW );

		// 光源設定
  	setLight();
  	gl.glEnable( GL11.GL_LIGHTING );
  	
  	// モデルを描画
  	gl.glPushMatrix();
  	int locked_markers = 0;
  	for ( int i=0; i<markerinfo.length; i++ )
  	{
			MarkerDesc desc = curMarkers[ i ];
			
			desc.lockon = marker_lockon_none;
			if ( desc.cf >= cf_threshold )
			{
		  	gl.glLoadMatrixx( desc.matrix, 0 );
				switch ( (int)desc.pattern )
				{
				case 0:
					// モデル 犬
			  	gl.glColor4x( 1<<16, 1<<16, 1<<16, 1<<16 );  
			  	gl.glTranslatex( 0, -15<<16, 0 );
			  	gl.glScalex( (1<<16)/10, (1<<16)/10, (1<<16)/10 );
					JNIutils.drawModel( 0 );
					break;

				case 1:
			  	// 照準、ロックオンカーソル
					int x,y,z,d;
					x = desc.matrix[ 3*4+0 ];
					y = desc.matrix[ 3*4+1 ];
					z = desc.matrix[ 3*4+2 ];
					d = ((int)((x*(long)x)>>32)) + ((int)((y*(long)y)>>32)) + (int)((z*(long)z)>>32);
					int[] pos = getScreenCoodinate( 0, 0, 0 );
					//int[] pos = getScreenCoodinate( 0, 120<<16, 0 );
					marker_scrpos[ (locked_markers<<2)+0 ] = pos[ 0 ];
					marker_scrpos[ (locked_markers<<2)+1 ] = pos[ 1 ];
					marker_scrpos[ (locked_markers<<2)+2 ] = d;
					marker_scrpos[ (locked_markers<<2)+3 ] = i;
					locked_markers++;
					
					desc.lockon = ( d < marker_distance_dbllock )? marker_lockon_near : marker_lockon_far;
					if ( desc.prev == null )
						desc.lockonCount = 0;
					else
						desc.lockonCount = ( desc.lockon == desc.prev.lockon )? Math.min( desc.prev.lockonCount+1, marker_lockon_count_max ) : 0;
					
					break;
				}
			}
  	}
  	
  	gl.glPopMatrix();
/*  	
 		// 立方体を描画
    gl.glTranslatef(0, 0, 300.0f);
    gl.glScalef(10f, 10f, 10f);
		gl.glRotatef( 30, 1f, 0, 0 );
		gl.glRotatef( 45, 0, 1f, 0 );
  	gl.glColor4f(0.7f, 0.7f, 0.7f, 1.0f);
		IntBuffer prevface = IntBuffer.allocate( 1 );
		gl.glGetIntegerv( GL11.GL_FRONT_FACE, prevface );
    gl.glFrontFace( GL11.GL_CW );
  	models.setCubeBuffers( gl );
    gl.glDrawElements(GL11.GL_TRIANGLES, 36, GL11.GL_UNSIGNED_BYTE, mIndexBuffer);
    gl.glFrontFace( prevface.get( 0 ) );
*/    
  	gl.glDisable( GL11.GL_LIGHTING );

  	
  	// 照準、ロックオンカーソル描画
  	boolean isNear = false;
  	setDrawMode2D();  	
  	gl.glDisable( GL11.GL_DEPTH_TEST );
  	
  	for ( int i=0; i<locked_markers; i++ )
  	{
  		int x = marker_scrpos[ (i<<2)+0 ];
  		int y = marker_scrpos[ (i<<2)+1 ];
  		//int d = marker_scrpos[ (i<<2)+2 ];
  		int idx = marker_scrpos[ (i<<2)+3 ];
			MarkerDesc desc = curMarkers[ idx ];
			
			if ( desc.prev != null )
			{
				// ダブルロックオン→通常ロックオンではアニメーションしない
				if ( desc.prev.lockon == marker_lockon_near 	&&  desc.lockon == marker_lockon_far  &&  desc.lockonCount < marker_lockon_count_max )
					desc.lockonCount = marker_lockon_count_max;
			}
			for ( int q=0; q<2; q++ )
			{
				gl.glPushMatrix();
				int scale = 150;
				
				if ( desc.lockonCount < marker_lockon_count_max )
				{
					int c = marker_lockon_count_max+1 - desc.lockonCount;
					int jumplines = surfaceWidth>>4;
					scale += jumplines * (c + q*4);
				}

				if ( desc.lockon == marker_lockon_near )
				{
			  	models.drawDoubleLockonCursor( gl, x, y, scale, markerAngle );
			  	markerAngle += marker_angle_inc;
			  	isNear = true;
				}
				else
				{
			  	models.drawLockonCursor( gl, x, y, scale, ((countDraw & 3)<2) );
				}

				gl.glPopMatrix();
				if ( desc.lockonCount >= marker_lockon_count_max )
					break;
			}
			
		}
  	
  	if ( isNear )
  		models.drawReticulumNear( gl, surfaceWidth>>1, surfaceHeight>>1, 220 );
  	else
  		models.drawReticulumFar( gl, surfaceWidth>>1, surfaceHeight>>1, 100 );
  	
  	gl.glEnable( GL11.GL_DEPTH_TEST );
  }


  void setLight()
  {
  	final int light_diffuse[]  = { (int)(0.9*(1<<16)), (int)(0.9*(1<<16)), (int)(0.9*(1<<16)), (int)(1.0*(1<<16)) };	// 拡散反射光
  	final int light_specular[] = { (int)(1.0*(1<<16)), (int)(1.0*(1<<16)), (int)(1.0*(1<<16)), (int)(1.0*(1<<16)) };	// 鏡面反射光
  	final int light_ambient[]  = { (int)(0.3*(1<<16)), (int)(0.3*(1<<16)), (int)(0.3*(1<<16)), (int)(0.1*(1<<16)) };	// 環境光
  	final int light_position[] = { (int)(0.0*(1<<16)), (int)(0.0*(1<<16)), (int)(0.0*(1<<16)), (int)(1.0*(1<<16)) };	// 位置と種類

  	// 光源の設定
  	gl.glLightxv( GL11.GL_LIGHT0, GL11.GL_DIFFUSE,  light_diffuse, 0 );	 // 拡散反射光の設定
  	gl.glLightxv( GL11.GL_LIGHT0, GL11.GL_SPECULAR, light_specular, 0 ); // 鏡面反射光の設定
  	gl.glLightxv( GL11.GL_LIGHT0, GL11.GL_AMBIENT,  light_ambient, 0 );	 // 環境光の設定
  	gl.glLightxv( GL11.GL_LIGHT0, GL11.GL_POSITION, light_position, 0 ); // 位置と種類の設定

  	gl.glShadeModel( GL11.GL_SMOOTH );	// シェーディングの種類の設定
  	gl.glEnable( GL11.GL_LIGHT0 );		// 光源の有効化
  }
  
  int[] getScreenCoodinate( int x, int y, int z )
  {
  	float[] modelview = new float [ 16 ];
  	float[] projection = new float [ 16 ];
  	int[] viewport = new int [ 4 ];
  	gl.glGetFloatv( GL11.GL_MODELVIEW_MATRIX, modelview, 0 );
  	gl.glGetFloatv( GL11.GL_PROJECTION_MATRIX, projection, 0 );
  	gl.glGetIntegerv( GL11.GL_VIEWPORT, viewport, 0 );

  	float[] winpos = new float[ 3 ];
  	final float[] worldpos = { x/65536.0F, y/65536.0F, z/65536.0F };
  	GLU.gluProject( 
  			worldpos[ 0 ], worldpos[ 1 ], worldpos[ 2 ],
  			modelview, 0, projection, 0, viewport, 0, winpos, 0 );
  	
  	return new int[]{ (int)winpos[ 0 ], viewport[ 3 ]-(int)winpos[ 1 ] };
  }
  
}
