/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/BellagioRoot.cs#19 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * AvŜ̃IuWFNgc[̃[gBʏBellagioPluginēJnɂȂقANUniteXgłB
 * ɊgLbg̃[hB
 */

using System;
using System.IO;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Xml;
using System.Drawing;
using System.Resources;
using System.Windows.Forms;

using Travis.ORT;

using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Environment;
using Bellagio.Common;
using Bellagio.Forms;
using Bellagio.Ordering;
using Bellagio.Bookmark;

using Poderosa;
using Poderosa.Plugins;
using Poderosa.Forms;

namespace Bellagio {

    //^C̓ςIvV
    internal static class BDebugOpts {
#if DEBUG
        public static bool TRACE_TIME = false;
        public static bool TRACE_DDE = false;
        public static bool TRACE_MINUTELY_QUOTE = false;
        public static bool TRACE_TIME_AND_SALES_FROM_PRIMARY =false ;
        public static bool TRACE_RANKINGVIEW_SPLIT = true;
        public static bool TRACE_INDICATOR_CACHE = true;
        public static bool TRACE_DATA_SUBSCRIBER = false;
        public static bool UITEST_ALLOW_ORDER_IN_OFFLINE = true;
        public static bool TRACE_DATE_BASED_QUOTE = true;
#else
        public static bool TRACE_TIME = false;
        public static bool TRACE_DDE = false;
        public static bool TRACE_MINUTELY_QUOTE = false;
        public static bool TRACE_TIME_AND_SALES_FROM_PRIMARY = false;
        public static bool TRACE_RANKINGVIEW_SPLIT = false;
        public static bool TRACE_INDICATOR_CACHE = false;
        public static bool TRACE_DATA_SUBSCRIBER = false;
        public static bool UITEST_ALLOW_ORDER_IN_OFFLINE = false;
        public static bool TRACE_DATE_BASED_QUOTE = false;
#endif
    }


    public static class BellagioRoot {
        private static BellagioEnvironmentParam _envParam;
        private static BellagioPathInfo _pathInfo;
        private static IntraDayTradeProvider _intraDayTradeProvider;
        private static LightIntraDayTradeProvider _lightIntraDayTradeProvider;
        private static OrderDataProvider _orderDataProvider;
        private static RealtimeItaProvider _itaProvider;
        private static DateBasedQuoteProvider _dailyQuoteProvider;
        private static DataSourceHost _dataSourceHost;
        private static GlobalStockCollection _globalStocks;
        private static TimeManager _timeManager;
        private static DataSubscriberManager _dataSubscriberManager;
        private static ValueSystemRoot _functionLib;
        private static SchemaRoot _schema;
        private static FixedPreferences _fixedPreference;
        private static DynamicPreference _extensionKitPreference;
        private static BookmarkFeature _bookmark;
        private static BellagioIcons _commonIcons;
        private static UIError _UIError;

        //B̒iKł͏IvVĊ{IȃIuWFNgQ쐬B
        //ł̓G[oĂ͂ȂȂBIO֌W̑͋֎~BG[̏o\鏈́ALoadXebvōs
        public static void Init(BellagioEnvironmentParam env_param) {
            //Poderosa̒ᐅ
            RuntimeUtil.messageBoxTitle = BellagioVersionInfo.APPLICATION_CAPTION;
            WindowManagerConstants.APPLICATION_TITLE = BellagioVersionInfo.APPLICATION_CAPTION;
            //PoderosaPluginEnv.WINDOW_CAPTION_KEY = BellagioVersionInfo.APPLICATION_CAPTION;
            //PoderosaPluginEnv.MODULE_FILENAME_KEY = BellagioVersionInfo.APPLICATION_CAPTION;

            _envParam = env_param;
            _pathInfo = new BellagioPathInfo();
            _intraDayTradeProvider = new IntraDayTradeProvider();
            _lightIntraDayTradeProvider = new LightIntraDayTradeProvider();
            _orderDataProvider = new OrderDataProvider();
            _itaProvider = new RealtimeItaProvider();
            _dailyQuoteProvider = new DateBasedQuoteProvider();
            _schema = new SchemaRoot();
            _globalStocks = new GlobalStockCollection();
            _dataSourceHost = new DataSourceHost();
            _timeManager = new TimeManager();
            _dataSubscriberManager = new DataSubscriberManager();
            _functionLib = new ValueSystemRoot();
            _fixedPreference = new FixedPreferences();
            _extensionKitPreference = new DynamicPreference("extensionKitConfig");
            _commonIcons = new BellagioIcons();
            _bookmark = new BookmarkFeature();
            _UIError = new UIError();

            if(_envParam.RUN_LOCAL_TIMER) {
                _timeManager.StartLocalDataMode(new BTime(9, 0, 0), 6, 10);
                // _timeManager.StartLocalDataMode(new BTime(10, 50, 0), 6, 30);
            }
            
            if(_envParam.RUN_SECONDLY_TIMER) _timeManager.InitMinutelyTickMode();
            if(_envParam.RUN_DATA_SUBSCRIBER_ENGINE) {
                _dataSubscriberManager.Start();
                _timeManager.SetLastListener(_dataSubscriberManager.ReserveExecByTime); //ԓ̂Zbg
            }
        }
        //InitƑ΂ɂȂI
        public static void Terminate() {
            if(_envParam.RUN_LOCAL_TIMER) _timeManager.StopTimer();
            if(_envParam.RUN_DATA_SUBSCRIBER_ENGINE) _dataSubscriberManager.Terminate();
            _dataSourceHost.Logout();
        }

        //I̊Jn
        public static void ExitApplication() {
            BellagioPlugin.Instance.PoderosaApplication.ExitApplication();
        }

        public static BellagioEnvironmentParam EnvironmentParam {
            get {
                return _envParam;
            }
        }
        public static IntraDayTradeProvider IntraDayTradeProvider {
            get {
                return _intraDayTradeProvider;
            }
        }
        public static LightIntraDayTradeProvider LightIntraDayTradeProvider {
            get {
                return _lightIntraDayTradeProvider;
            }
        }
        public static RealtimeItaProvider ItaProvider {
            get {
                return _itaProvider;
            }
        }
        public static DateBasedQuoteProvider DateBasedQuoteProvider {
            get {
                return _dailyQuoteProvider;
            }
        }
        public static OrderDataProvider OrderDataProvider {
            get {
                return _orderDataProvider;
            }
        }
        public static GlobalStockCollection GlobalStockCollection {
            get {
                return _globalStocks;
            }
        }

        public static DataSourceHost DataSourceHost {
            get {
                return _dataSourceHost;
            }
        }
        public static TimeManager TimeManager {
            get {
                return _timeManager;
            }
        }
        public static DataSubscriberManager DataSubscriberManager {
            get {
                return _dataSubscriberManager;
            }
        }
        public static ValueSystemRoot Functions {
            get {
                return _functionLib;
            }
        }
        public static SchemaRoot SchemaRoot {
            get {
                return _schema;
            }
        }
        public static FixedPreferences FixedPreferences {
            get {
                return _fixedPreference;
            }
        }
        public static DynamicPreference ExtensionKitPreference {
            get {
                return _extensionKitPreference;
            }
        }
        public static BellagioIcons CommonIcons {
            get {
                return _commonIcons;
            }
        }
        public static Control MainThreadControl {
            get {
                return BellagioPlugin.Instance.MainWindow;
            }
        }
        public static BellagioPathInfo PathInfo {
            get {
                return _pathInfo;
            }
        }
        public static BookmarkFeature Bookmark {
            get {
                return _bookmark;
            }
        }
        public static UIError UIError {
            get {
                return _UIError;
            }
        }


        public static void ReplaceSchemaRoot(SchemaRoot root) {
            _schema = root;
        }

#if UNITTEST //eXĝ݃_CNgȓǂݍ݂s
        //eXĝтɓeς肤镔
        public static void BootForTest() {
            FillGlobalStockCollectionForTests();
        }
        public static void LoadExtensionFileFromStream(string filename, TextReader reader, bool clear) {
            if(clear && _schema!=null)
                _schema.Unload();
            if(_schema==null)
                _schema = new SchemaRoot();
            XmlORReader xr = new XmlORReader(filename, reader);
            ExtensionKit kit = new ExtensionKit(filename);
            xr.Read(_schema.ExtensionKitSchema, kit);
            kit.Load();
            _schema.AddFixedExtensionKit(kit);
        }

        private static void FillGlobalStockCollectionForTests() {
            _globalStocks.Clear();

            for(int i=0; i<_envParam.UNITTEST_STOCK_COUNT; i++) {
                BasicStockProfile stock = new BasicStockProfile("", (i+1).ToString(), StockProfileFlags.None, 1000);
                stock.CreatePrimary(StockExchange.T, StockExchangeSubType.Ichibu, StockFlags.None);
                _globalStocks.Add(stock);
            }
            if(_envParam.USE_DEMONSTRATION_STOCKS) {
                DemonstrationStocks.CreateAndStartRandomFeed();
            }
        }
#endif
    }


    //p[^
    public class BellagioEnvironmentParam {
        public int UNITTEST_STOCK_COUNT; //UnitTestpɍ쐬B
        public bool USE_DEMONSTRATION_STOCKS;
        public bool USE_EXTENSION_FILE;
        public bool RUN_DATA_SUBSCRIBER_ENGINE;
        public bool RUN_LOCAL_TIMER;
        public bool RUN_SECONDLY_TIMER;
        public bool SAVE_PREFERENCE;

        //prʂ̉ނ̏

        //WUnitTest eXg̎ނɂĂ͂炳ɌʂɃp[^͕ω
        public void SetupForUnitTest() {
            UNITTEST_STOCK_COUNT = 0;
            USE_DEMONSTRATION_STOCKS = false;
            USE_EXTENSION_FILE = false;
            SAVE_PREFERENCE = false;
            RUN_LOCAL_TIMER = false;
            RUN_SECONDLY_TIMER = false;
            RUN_DATA_SUBSCRIBER_ENGINE = false;
        }
        //J
        public void SetupForDevelopment() {
            UNITTEST_STOCK_COUNT = 0;
            USE_DEMONSTRATION_STOCKS = false;
            USE_EXTENSION_FILE = true;
            SAVE_PREFERENCE = false;
            RUN_LOCAL_TIMER = false;
            RUN_SECONDLY_TIMER = true;
            RUN_DATA_SUBSCRIBER_ENGINE = true;
        }
        //i
        public void SetupForRelease() {
            UNITTEST_STOCK_COUNT = 0;
            USE_DEMONSTRATION_STOCKS = false;
            USE_EXTENSION_FILE = true;
            SAVE_PREFERENCE = true;
            RUN_LOCAL_TIMER = false;
            RUN_SECONDLY_TIMER = true;
            RUN_DATA_SUBSCRIBER_ENGINE = true;
        }
    }

    //Gh[Uɂ͐ݒs\ȍ
    public class BRuntimeOpts {
        public static int MAX_PASSWORD_LENGTH = 10;
#if DEBUG
        public static bool SAVE_PASSWORD = true;
        public static bool ENABLE_ALERT_DEMO = true;
        public static bool TRACE_HEARTBEAT = true;
        public static bool TRACE_DEBUG_COMMAND = true;
#else
        public static bool SAVE_PASSWORD = false;
        public static bool ENABLE_ALERT_DEMO = false;
        public static bool TRACE_HEARTBEAT = false;
        public static bool TRACE_DEBUG_COMMAND = false;
#endif
    }


    public class BellagioPathInfo {
        private string _homeDir;
        private string _dataHomeDir;
        private string _extensionDir;
        private string _preferenceFile;

        //ɂقȂ͍͍̂lȂ
        public BellagioPathInfo() {
            string f = typeof(BellagioRoot).Assembly.Location;
            _homeDir = f.Substring(0, f.LastIndexOf('\\')+1);
            _dataHomeDir = System.Environment.GetFolderPath(System.Environment.SpecialFolder.ApplicationData) + "\\" + BellagioVersionInfo.USER_DATA_PATH;
            if(!Directory.Exists(_dataHomeDir)) Directory.CreateDirectory(_dataHomeDir);
            _dataHomeDir += "\\";
            Debug.Assert(_dataHomeDir.EndsWith("\\"));
            _extensionDir = _homeDir + "extension";
            _preferenceFile = _dataHomeDir + "options.conf";
            
        }

        public string DataHomeDir {
            get {
                return _dataHomeDir;
            }
        }
        public string AppHomeDir {
            get {
                return _homeDir;
            }
        }
        public string ExtensionDir {
            get {
                return _extensionDir;
            }
        }
        public string PreferenceFile {
            get {
                return _preferenceFile;
            }
        }
    }

    public class BellagioIcons : SuperToolTipControl.IImageProvider{
        private Icon _appIcon;
        private IconList _largeSessions;
        private IconList _smallSessions;
        private IconList _controlBoxes;
        private IconList _smallCommandButtons;
        private IconList _optionDialogButtons;
        private const string RESOURCE_NAME = "Bellagio.Images";

        public BellagioIcons() {
            SuperToolTipControl._imageProvider = this;
        }

        public Icon AppIcon16 {
            get {
                if(_appIcon==null) {
                    IBellagioEditionSpecificInfo[] editions = (IBellagioEditionSpecificInfo[])BellagioPlugin.Instance.PoderosaWorld.PluginManager.FindExtensionPoint(BellagioConstants.EDITION_SPECIFIC_INFO_EXTENSION).GetExtensions();
                    _appIcon = editions[0].AppIcon;
                }
                return _appIcon;
            }
        }

        public IconList LargeSessions {
            get {
                if(_largeSessions==null) _largeSessions = new IconList(RESOURCE_NAME,
                    BellagioVersionInfo.EDITION==BellagioEditions.HatchukunTX? "large_sessions" : "tps_large_sessions",
                    24, 24);
                return _largeSessions;
            }
        }

        public IconList SmallSessions {
            get {
                if(_smallSessions==null) _smallSessions = new IconList(RESOURCE_NAME, "small_sessions", 16, 16);
                return _smallSessions;
            }
        }

        public IconList ControlBoxes {
            get {
                if(_controlBoxes==null) _controlBoxes = new IconList(RESOURCE_NAME, "control_boxes", 20, 20);
                return _controlBoxes;
            }
        }
        public IconList SmallCommandButtons {
            get {
                if(_smallCommandButtons==null) _smallCommandButtons = new IconList(RESOURCE_NAME, "small_command_buttons", 16, 16);
                return _smallCommandButtons;
            }
        }
        public IconList OptionDialogButtons {
            get {
                if(_optionDialogButtons==null) _optionDialogButtons = new IconList(RESOURCE_NAME, "option_dialog", 32, 32);
                return _optionDialogButtons;
            }
        }

        System.Drawing.Image SuperToolTipControl.IImageProvider.GetCrossImage(bool hovering) {
            return this.ControlBoxes.GetBitmap(hovering? 0 : 1, 0);
        }

        System.Drawing.Image SuperToolTipControl.IImageProvider.GetDropDownImage(bool hovering) {
            return this.ControlBoxes.GetBitmap(hovering? 0 : 1, 1);
        }
    }

    public static class BUtil {
        //poGetAdapterȈՂɏ悤
        public static IAdaptable DefaultGetAdapter(IAdaptable obj, Type adapter) {
            BellagioPlugin p = BellagioPlugin.Instance;
            if(p==null)
                return null; //NUnitȂǁAeXgBellagioPlugin͗ps
            else
                return p.PoderosaWorld.AdapterManager.GetAdapter(obj, adapter);
        }
        public delegate void ShowMessageBoxDelegate(Control location, string message, MessageBoxIcon icon);
        public static void ShowWarningMessageBox(string message) {
            ShowMessageBox(null, message, MessageBoxIcon.Warning);
        }
        public static void ShowWarningMessageBox(Control location, string message) {
            ShowMessageBox(location, message, MessageBoxIcon.Warning);
        }
        public static void ShowInformationMessageBox(string message) {
            ShowMessageBox(null, message, MessageBoxIcon.Information);
        }

        public static void ShowMessageBox(Control location, string message, MessageBoxIcon icon) {
            if(IsExecutingInMainThread) {
                Form owner = location==null? null : location.FindForm();
                if(owner==null)
                    MessageBox.Show(message, BellagioVersionInfo.APPLICATION_CAPTION, MessageBoxButtons.OK, icon);
                else
                    MessageBox.Show(owner, message, BellagioVersionInfo.APPLICATION_CAPTION, MessageBoxButtons.OK, icon);
            }
            else {
                Form f = BellagioPlugin.Instance.MainWindow;
                Debug.Assert(f!=null); //TODO {nullłsłق
                if(!f.IsDisposed) //IŔjĂXLbv
                    f.Invoke(new ShowMessageBoxDelegate(ShowMessageBox), location, message, icon);
            }
        }

        public static bool IsExecutingInMainThread {
            get {
                return !BellagioPlugin.Instance.MainWindow.InvokeRequired;
            }
        }
        //UnitTestœĂ邩ǂ̔ NUnit^C邩ǂ݂͂Ȃ
        public static bool UnderUnitTest {
            get {
                return BellagioPlugin.Instance==null;
            }
        }
        public static bool UnderApplication {
            get {
                return !UnderUnitTest;
            }
        }
    }

}
