/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 *
 * Tick`
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;

using Travis;
using Travis.LocationOperation;
using Sansa.Runtime;
using Bellagio.Forms;
using Bellagio.Data;
using Bellagio.Drawing;
using Bellagio.Values;

namespace Bellagio.Chart {
    public class TickGraphicsSettings : DrawingSettingsBase {
        public enum LayoutStyle {
            None, //Ȃ
            List, //I[\hbNXȕ\
            Graph, //Ot`
        }

        public DSInt styleI; //int`X^C
        public LayoutStyle layoutStyle {
            get {
                return (LayoutStyle)styleI.V;
            }
            set {
                styleI.UnderlyingItem.AsInt().Value = (int)value;
            }
        }
        //X^C
        public DSFont font;
        public DSBrush backColor;
        public DSBrush priceColor;
        public DSBrush volumeColor;

        //Ot`̂
        public DSInt graphPitch;
        public DSBrush smallTickColor; //ۂ̕`small/largeԂ̃Of[V
        public DSBrush largeTickColor;
        public DSPenStyle priceScalePen;
        public DSFont volumeFont; //ۂ̃x(Pʐ\)
        public DSInt graphPriceWidth;

        //Xg`̂
        public DSBrush timeColor;
        public DSBrush priceUpColor;
        public DSBrush priceDownColor;
        public DSInt listPitch;
        public DSInt listTimeWidth;
        public DSInt listSignWidth;

        public TickGraphicsSettings(string id)
            : base(id) {
        }

        protected override void CreateElements() {
            styleI = DefineInt("styleI", 0);
            font = DefineFont("font", DSFont.GenericFontName, 10);
            backColor = DefineBrush("backColor", Color.Black);
            priceColor = DefineBrush("priceColor", Color.Yellow);
            volumeColor = DefineBrush("volumeColor", Color.Honeydew);

            graphPitch = DefinePositiveInt("graphPitch", 15);
            smallTickColor = DefineBrush("smallTickColor", Color.LightBlue);
            largeTickColor = DefineBrush("largeTickColor", Color.FromArgb(0xFF, 0x20, 0x20));
            priceScalePen = DefinePenStyle("priceScalePen", Color.Green, BPenStyle.DashStyle.Dot, 1);
            volumeFont = DefineFont("volumeFont", DSFont.GenericFontName, 7.0F);
            graphPriceWidth = DefinePositiveInt("graphPriceWidth", 60);

            timeColor = DefineBrush("timeColor", Color.Honeydew);
            priceUpColor = DefineBrush("priceUpColor", Color.Red);
            priceDownColor = DefineBrush("priceDownColor", Color.Cyan);
            listPitch = DefinePositiveInt("listPitch", 15);
            listTimeWidth = DefinePositiveInt("listTimeWidth", 72);
            listSignWidth = DefinePositiveInt("listSignWidth", 20);
        }

        public LayoutStyle Style {
            get {
                return (LayoutStyle)styleI.V;
            }
        }
    }

    public class TickLayoutParam {
        private TickGraphicsSettings.LayoutStyle layoutStyle;
        private TickGraphicsSettings _s;

        public TickLayoutParam(TickGraphicsSettings s) {
            _s = s;
            layoutStyle = s.layoutStyle;
        }

        public TickGraphicsSettings.LayoutStyle LayoutStyle {
            get {
                return layoutStyle;
            }
            set {
                layoutStyle = value;
            }
        }
    }

    public class TickGraphics : ViewContentGraphics {
        private Stock _stock;
        private TickGraphicsSettings _settings;
        private TickLayoutParam _layout;
        private BRect _bound;
        private TickData[] _ticks; //XibvVbg𓾂BTimeAndSalesƂ͋tɁA擪ŐVTICKB̔z̒\\TickTCYł
        private int _lastTickPriceDiffSign; //ŌTick͏㉺ׂƂ킯ɂ͂Ȃ̂
        //Ot`łgȂAvZ͏ɂĂ
        private class ScaleInfo {
            public int minPrice;
            public int maxPrice;
            public int yobine;
            public LinearTranslator translator;

            public ScaleInfo(LinearTranslator tr, int minP, int maxP, int y) {
                translator = tr;
                minPrice = minP;
                maxPrice = maxP;
                yobine = y;
            }
        }
        private ScaleInfo _scaleInfo;

        public TickGraphics(Control control, IPlatformBridge platform, TickGraphicsSettings settings, TickLayoutParam lp) : base(platform, control) {
            _settings = settings;
            _layout = lp;
            _bound = new BRect();
            _rectangleOperator = new RectangleOperatorBuilder()
                .ProbeBRect(_bound).Finish();
        }
        public BRect Bound {
            get {
                return _bound;
            }
        }

        public void StartMotion(TimeAndSales ts, Stock stock, bool enable_animation) {
            _stock = stock; //PʊĂђlvZɎg

            int c = GetMaxTickCountByLayout() + 1;
            if(c==1) return; //\łȂƂ

            if(_ticks==null || _ticks.Length!=c) _ticks = new TickData[c];

            //_ticks̒ɍŐṼf[^jIɑ
            int len = Math.Min(c, ts.Count);
            for(int i=0; i<c; i++) {
                int index = ts.Count-1-i;
                if(index>=0)
                    _ticks[i] = ts.TickAt(index);
                else
                    _ticks[i] = null;

                if(i==c-1) {
                    TickData s = ts.TickAtOrNull(index-1); //ɂPÔ...
                    _lastTickPriceDiffSign = (_ticks[i]!=null && s!=null)? _ticks[i].Price.CompareTo(s.Price) : 0;
                }
            }

            //PriceScalevZ Ot`łgȂAvZ͏ɂĂ
            if(_ticks[0]==null)
                _scaleInfo = null; //Ȃꍇ
            else 
                _scaleInfo = BuildPriceTranslator();

            if(_container!=null)
                base.DataUpdateDirect();
            if(enable_animation)
                _dataAnimationTimer.Initialize();

        }
        protected override void BuildScaleInfo() {
        }
        protected override void InvalidateForDataAnimationTick() {
            InvalidateRect(_bound);
        }
        public override void Dispose() {
            
        }

        public int PriceHitTest(Point point) {
            if(_layout.LayoutStyle==TickGraphicsSettings.LayoutStyle.List) {
                int index = (point.Y - (_bound.Top+3)) /  _settings.listPitch.V - 1; //wb_̕-1
                if(_ticks!=null && index>=0 && _ticks.Length > index) {
                    TickData td = _ticks[index];
                    if(td!=null) return td.Price;
                }
            }
            else {
                if(_scaleInfo!=null) {
                    int p = (int)_scaleInfo.translator.Inverse(point.Y);
                    //Ăђl̐{Ŋۂ߂
                    return p - ((p + _scaleInfo.yobine/2) % _scaleInfo.yobine);
                }
            }

            return -1;
        }

        public override void Paint(Graphics g, Rectangle clip) {
            //`悷܂łɂ̓ZbgĂȂƂ
            if(_ticks==null || _scaleInfo==null) return;
            Debug.Assert(_settings!=null);

            if(_layout.LayoutStyle==TickGraphicsSettings.LayoutStyle.List)
                PaintNormalStyle(g, clip);
            else {
                System.Drawing.Drawing2D.SmoothingMode mode = g.SmoothingMode;
                g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
                PaintGraphStyle(g, clip);
                g.SmoothingMode = mode;
            }
        }


        //eTICK̕`惋[́AOԁFOԂ̈ʒuŃtF[hC@ԁFn-1`nԂ̈ʒuֈړ@Xg(n):n-1̈ʒuŃtF[hAEg@ƂȂB
        //͂ǂ̕\X^CłʁB
        private void PaintNormalStyle(Graphics g, Rectangle clip) {
            //܂wb_
            Rectangle rc = new Rectangle(_bound.Left + 24, _bound.Top + 11, _bound.Width-48, _settings.listPitch.V);
            if(rc.IntersectsWith(clip)) {
                DrawStringUtil.MiddleLeft(g, "", _settings.font.F, _settings.timeColor.B, rc.Left, rc.Top);
                DrawStringUtil.MiddleLeft(g, "i", _settings.font.F, _settings.priceColor.B, rc.Left + _settings.listTimeWidth.V + _settings.listSignWidth.V, rc.Top);
                DrawStringUtil.MiddleRight(g, "", _settings.font.F, _settings.volumeColor.B, rc.Right-8, rc.Top);
            }
                

            //\́AtF[hCEAEg̏dȂ肪ƂlčŌƂ̑OЂԂ
            int tl = _ticks.Length;
            for(int j=0; j<tl; j++) {
                int i = j;
                if(tl>=2) {
                    if(j==tl-2) j = tl-1;
                    else if(j==tl-1) j = tl-2;
                }
                Debug.Assert(i>=0 && i<_ticks.Length);

                TickData t = _ticks[i];
                if(t==null) break;

                rc = new Rectangle(_bound.Left + 24, _bound.Top + 11 + (i+1)*_settings.listPitch.V, _bound.Width-48, _settings.listPitch.V);
                if(rc.IntersectsWith(clip)) {
                    int price_sign;
                    if(i==tl-1)
                        price_sign = _lastTickPriceDiffSign;
                    else {
                        TickData prev = _ticks[i+1];
                        price_sign = prev==null? 0 : t.Price.CompareTo(prev.Price);
                    }
                    DrawNormalStyleTick(g, t, i, rc, price_sign);
                }
            }
        }
        private void DrawNormalStyleTick(Graphics g, TickData t, int index, Rectangle rc, int price_sign) {
            double prog = _dataAnimationTimer.IsActive()? _dataAnimationTimer.value() : 1.0;
            DSBrush price_brush = price_sign==0? _settings.priceColor : price_sign>0? _settings.priceUpColor : _settings.priceDownColor;

            if(index==0) {
                Brush bt = new SolidBrush(DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.timeColor.col, prog));
                Brush bp = new SolidBrush(DrawingUtil.ProportionalColor(_settings.backColor.col, price_brush.col, prog));
                Brush bv = new SolidBrush(DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.volumeColor.col, prog));
                DrawNormalStyleTickB(g, t, price_sign, rc.X, rc.Y, bt, bp, bv);
                bt.Dispose();
                bp.Dispose();
                bv.Dispose();
            }
            else if(index==_ticks.Length-1) {
                Brush bt = new SolidBrush(DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.timeColor.col, 1.0-prog));
                Brush bp = new SolidBrush(DrawingUtil.ProportionalColor(_settings.backColor.col, price_brush.col, 1.0-prog));
                Brush bv = new SolidBrush(DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.volumeColor.col, 1.0-prog));
                DrawNormalStyleTickB(g, t, price_sign, rc.X, rc.Y-_settings.listPitch.V, bt, bp, bv);
                bt.Dispose();
                bp.Dispose();
                bv.Dispose();
            }
            else {
                int dy = (int)(_settings.listPitch.V * (prog - 1.0));
                DrawNormalStyleTickB(g, t, price_sign, rc.X, rc.Y + dy, _settings.timeColor.B, price_brush.B, _settings.volumeColor.B);
            }
        }
        private void DrawNormalStyleTickB(Graphics g, TickData t, int price_sign, int x, int y, Brush tb, Brush pb, Brush vb) {
            DrawStringUtil.MiddleLeft(g, FormatTime(t), _settings.font.F, tb, x, y);
            x += _settings.listTimeWidth.V;

            if(price_sign > 0)
                DrawStringUtil.MiddleLeft(g, "", _settings.font.F, pb, x, y);
            else if(price_sign < 0)
                DrawStringUtil.MiddleLeft(g, "", _settings.font.F, pb, x, y);
            DrawStringUtil.MiddleLeft(g, t.Price.ToString(), _settings.font.F, pb, x + _settings.listSignWidth.V, y);

            DrawStringUtil.MiddleRight(g, t.Volume.ToString(), _settings.font.F, vb, _bound.Right-24, y);
        
        }

        //OtX^C`
        private void PaintGraphStyle(Graphics g, Rectangle clip) {
            if(_scaleInfo==null) return;

            //li̎B
            int price = _scaleInfo.minPrice;
            int yobine = _scaleInfo.yobine;
            int yobine_count = (_scaleInfo.maxPrice - _scaleInfo.minPrice) / yobine;
            Debug.Assert(yobine_count > 0); //BuildScaleInfoŒĂ
            //܂ׂɂȂ肷Ȃ悤ɒ
            int yobine_step = 1;
            int yobine_height = _bound.Height / yobine_count; //PĂђl̍
            if(_bound.Height > 20) { //20ȉƖ[vɂȂ̂Ŗh~
                while(yobine_height < 20) { 
                    yobine_step *= 10;
                    yobine *= 10;
                    yobine_count = (_scaleInfo.maxPrice - _scaleInfo.minPrice) / yobine;
                    yobine_height = yobine_count==0? _bound.Height : _bound.Height / yobine_count;
                }


                Pen pen = _settings.priceScalePen.P;
                while(price <= _scaleInfo.maxPrice) {
                    if((price % yobine)==0) {
                        int y = (int)_scaleInfo.translator.Translate(price);
                        g.DrawLine(pen, _bound.Left + 6, y, _bound.Right-_settings.graphPriceWidth.V, y);
                        DrawStringUtil.MiddleRight(g, price.ToString(), _settings.font.F, _settings.priceColor.B, _bound.Right-6, y);
                    }
                    price += _scaleInfo.yobine;
                }
            }

            //eTick
            int tl = _ticks.Length;
            for(int j=0; j<tl; j++) { //m[}X^CƓl̗Rŕ`揇
                int i = j;
                if(tl>=2) {
                    if(j==tl-2) j = tl-1;
                    else if(j==tl-1) j = tl-2;
                }
                Debug.Assert(i>=0 && i<_ticks.Length);

                TickData t = _ticks[i];
                if(t==null) break;
                DrawGraphStyleTick(g, t, i, _bound.Right-_settings.graphPriceWidth.V-8 - _settings.graphPitch.V * i, (int)_scaleInfo.translator.Translate(t.Price));
            }
        }
        private void DrawGraphStyleTick(Graphics g, TickData t, int index, int x, int y) {
            double prog = _dataAnimationTimer.IsActive()? _dataAnimationTimer.value() : 1.0;
            int units = GetUnits(t);
            Color col = ToColor(units);
            Brush br_c;
            Brush br_v;

            if(index==0) {
                br_c = new SolidBrush(DrawingUtil.ProportionalColor(_settings.backColor.col, col, prog));
                br_v = new SolidBrush(DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.volumeColor.col, prog));
                x += (int)(_settings.graphPitch.V * (1 - prog));
                DrawGraphStyleTickB(g, t, x, y, br_c, br_v);
                br_v.Dispose();
            }
            else if(index==_ticks.Length-1) {
                br_c = new SolidBrush(DrawingUtil.ProportionalColor(_settings.backColor.col, col, 1.0-prog));
                br_v = new SolidBrush(DrawingUtil.ProportionalColor(_settings.backColor.col, _settings.volumeColor.col, 1.0-prog));
                x += _settings.graphPitch.V;
                DrawGraphStyleTickB(g, t, x, y, br_c, br_v);
                br_v.Dispose();
            }
            else {
                br_c = new SolidBrush(col);
                x += (int)(_settings.graphPitch.V * (1 - prog));
                DrawGraphStyleTickB(g, t, x, y, br_c, _settings.volumeColor.B);
            }

        }
        private void DrawGraphStyleTickB(Graphics g, TickData t, int x, int y, Brush br_c, Brush br_v) {
            int radius = ToRadius(GetUnits(t));
            g.FillEllipse(br_c, x-radius, y-radius, radius*2, radius*2);
            br_c.Dispose();

            string txt = GetUnits(t).ToString();
            SizeF szf = g.MeasureString(txt, _settings.volumeFont.F);
            g.DrawString(txt, _settings.volumeFont.F, br_v, x-szf.Width/2, y+radius);
        }

        private int ToRadius(int units) {
            if(units<5)
                return 3;
            else if(units<20)
                return 4;
            else if(units<100)
                return 5;
            else if(units<500)
                return 6;
            else
                return 7;
        }
        private Color ToColor(int units) {
            int l = SimpleLog(units);
            if(l > 12) l = 12;
            return DrawingUtil.ProportionalColor(_settings.smallTickColor.col, _settings.largeTickColor.col, (double)l / 12.0);
        }
        private static int SimpleLog(int value) {
            Debug.Assert(value > 0);
            //ȂʂłQƂΐ
            int r = 30;
            int f = 0x40000000;
            while((value & f)==0 && f>=1) {
                f >>= 1;
                r--;
            }
            return r;
        }
        private int GetUnits(TickData tick) {
            int u = _stock.Profile.VolumeUnit;
            if(u==50) u = 10;
            if(u==500) u = 100;

            return tick.Volume / u;
        }

        private ScaleInfo BuildPriceTranslator() {
            Debug.Assert(_ticks[0]!=null); //ȂƂ͂邱
            int min_price = _ticks[0].Price;
            int max_price = min_price;
            for(int i=1; i<_ticks.Length; i++) {
                TickData tick = _ticks[i];
                if(tick!=null) {
                    min_price = Math.Min(min_price, tick.Price);
                    max_price = Math.Max(max_price, tick.Price);
                }
            }
            //܂łōőEŏ̒lB
            int yobine = _stock.Profile.IsDerivative? MarketUtil.GetDerivativeYobine((DerivativeStockProfile)_stock.Profile) : (MarketUtil.YobineIncrement(max_price) - max_price); //㑤̌ĂђlgBłȂƂ͂ݏo邱Ƃ
            bool flag = true;
            while((max_price-min_price) < yobine * 4) { //ȂƂS܂Ō݂ɍLĂ
                if(flag)
                    max_price += yobine;
                else
                    min_price = FloorMultiple(min_price-yobine, yobine);

                flag = !flag;
            }
            //̌Ăђl̔{ɑBႦΒli1998`2005ɕzĂꍇA1995ɂȂB
            min_price = FloorMultiple(min_price, yobine);
            
            return new ScaleInfo(LinearTranslator.Solve(max_price, _bound.Top+12, min_price, _bound.Bottom-18),
                min_price, max_price, yobine);
        }

        //TickCAEg\ł邩vZ
        private int GetMaxTickCountByLayout() {
            //Debug.WriteLine(String.Format("height={0} pitch={1}", _bound.Height, _settings.listPitch.V));
            if(_layout.LayoutStyle==TickGraphicsSettings.LayoutStyle.List)
                return Math.Max(0, (_bound.Height-11) / _settings.listPitch.V - 1); //wb_̂Ps
            else
                return Math.Max(0, (_bound.Width-_settings.graphPriceWidth.V-8) / _settings.graphPitch.V);
        }
        public static string FormatTime(TickData td) {
            //CujOZbV̎͒Kv
            int raw_time = td.Time;
            if(MarketUtil.GetEveningOpenTime(StockExchange.O).AsInt() <= raw_time && raw_time <= MarketUtil.GetEveningCloseTime(StockExchange.O).AsInt()) {
                raw_time += 12 * 3600;
            }
            return BTime.FormatHHMM(raw_time);
        }
        //valueȉstep̔{ōő̂̂Ԃ
        private static int FloorMultiple(int value, int step) {
            return value - (value % step);
        }
    }

    //STICK\
    public class AllTickListForm : BellagioDefaultForm, BellagioListView.IBellagioListViewClient {

        private ContextMenu _contextMenu;

        //private Button _exportButton; }篂ȂȂ
        private Stock _stock;
        private BellagioListView _listView;
        private bool _reverseOrder;
        private TimeAndSales _data;
    
        public AllTickListForm(Stock stock, TimeAndSales ts) {
            Debug.Assert(ts!=null);
            // ̌ĂяóAWindows.Forms tH[ fUCiŕKvłB
            InitializeComponent();
            _listView.AddColumn("", 60, 60, 100);
            _listView.AddColumn("i", 60, 60, 200);
            _listView.AddColumn("", 60, 60, 200);
            _listView.MultiSelect = true;

            _listView.ColumnClick += new ColumnClickEventHandler(OnListViewColumnClick);
            _listView.DoubleClick += new EventHandler(OnListViewDoubleClick);
            _stock = stock;
            _data = ts;
            this.Height = 420;
            
            // TODO: InitializeComponent Ăяǒɏǉ܂B
            this.Width = 240;
        }

        private void OnListViewColumnClick(object sender, ColumnClickEventArgs e) {
            if(e.Column!=0) return; //ȊO
            _reverseOrder = !_reverseOrder;
            InitContent();
        }
        protected override void OnShown(EventArgs e) {
            base.OnShown(e);
            InitContent();

        }
        private void InitContent() {
            this.Cursor = Cursors.WaitCursor;
            this.Text = "҂...";
            _listView.Columns[0].Text = _reverseOrder? "" : "";
            _listView.BeginUpdate();
            _listView.SuspendLayout();
            _listView.Items.Clear();
            string[] texts = new string[_listView.Columns.Count];
            ListViewItem[] items = new ListViewItem[_data.Count];
            for(int i=0; i<items.Length; i++) {
                TickData td = _data.TickAt(_reverseOrder? items.Length-1-i : i);
                texts[0] = TickGraphics.FormatTime(td);
                texts[1] = td.Price.ToString();
                texts[2] = td.Volume.ToString();
                ListViewItem item = new ListViewItem(texts);
                item.Tag = td;
                items[i] = item;
                //for(int i=0; i<this.Columns.Count-1; i++) item.SubItems.Add(""); //킹̂߂SubItem쐬

                //_listView.AddItem(td);
            }
            _listView.Items.AddRange(items);
            _listView.ResumeLayout();
            _listView.EndUpdate();
            this.Cursor = Cursors.Default;
            this.Text = String.Format("ݒl {0}", _stock.Profile.Name);
        }

        private void InitializeComponent() {
            //this._exportButton = new Button();
            this._listView = new BellagioListView(this);
            this.SuspendLayout();
            /*
            // 
            // _exportButton
            // 
            this._exportButton.Location = new System.Drawing.Point(24, 0);
            this._exportButton.Name = "_exportButton";
            this._exportButton.Size = new System.Drawing.Size(96, 23);
            this._exportButton.TabIndex = 1;
            this._exportButton.FlatStyle = FlatStyle.System;
            this._exportButton.TextAlign = ContentAlignment.MiddleLeft;
            this._exportButton.Click += new EventHandler(OnExportButtonClicked);
            this._exportButton.Text = "GNX|[g(&E)...";
            */
            // 
            // _listView
            // 
            this._listView.Location = new System.Drawing.Point(0, 0);
            this._listView.Name = "_listView";
            this._listView.TabIndex = 1;
            this._listView.FullRowSelect = true;
            this._listView.GridLines = true;
            this._listView.Name = "_listView";
            this._listView.TabIndex = 1;
            this._listView.MultiSelect = false;
            this._listView.Activation = ItemActivation.OneClick;
            this._listView.View = System.Windows.Forms.View.Details;
 
            // 
            // ScreeningResultPane
            // 
            this.Controls.Add(this._listView);
            this.ResumeLayout(false);

        }


        protected override void OnResize(EventArgs e) {
            base.OnResize(e);
            int w = this.ClientSize.Width;
            _listView.Width = w;
            _listView.Height = this.ClientSize.Height;// -_exportButton.Bottom;
        }

        private void InitContextMenu() {
            _contextMenu = new ContextMenu();
            //Util.AddMenuItem(_contextMenu, "Cɓ֒ǉ(&B)...", new EventHandler(OnAddToBookmark));
            AddMenuItem(_contextMenu, "Nbv{[hփRs[(&C)", new EventHandler(OnCopyResult));
            AddMenuItem(_contextMenu, "CSV`ŕۑ(&S)...", new EventHandler(OnSaveResult));
        }
        private static void AddMenuItem(Menu parent, string text, EventHandler handler) {
            MenuItem mi = new MenuItem();
            mi.Text = text;
            mi.Click += handler;
            parent.MenuItems.Add(mi);
        }

        protected override bool ProcessDialogKey(Keys keyData) {
            if(keyData==(Keys.Control|Keys.A)) {
                SelectAllItem();
                return true;
            }
            else if(keyData==(Keys.Control|Keys.C)) {
                OnCopyResult(_listView, new EventArgs());
                return true;
            }
            else
                return base.ProcessDialogKey(keyData);
        }

        /*
        private void OnExportButtonClicked(object sender, EventArgs args) {
            if(_contextMenu==null) InitContextMenu();
            _contextMenu.Show(this, new Point(_exportButton.Left, _exportButton.Bottom));
        }
        */
        private void OnCopyResult(object sender, EventArgs args) {
            ListViewUtil.CopyListViewContentToClipboard(_listView, false, new ListViewUtil.ItemChecker(ListViewItemChecker));
        }
        private void OnSaveResult(object sender, EventArgs args) {
            ListViewUtil.SaveListViewContentToFile("ݒl̕ۑ", _listView, false, new ListViewUtil.ItemChecker(ListViewItemChecker));
        }
        private bool ListViewItemChecker(ListViewItem li) {
            return li.Selected;
        }

        private void OnListViewDoubleClick(object sender, EventArgs e) {
            SelectAllItem();
        }
        private void SelectAllItem() {
            this.Cursor = Cursors.WaitCursor;
            _listView.BeginUpdate();
            ListView.SelectedIndexCollection c = _listView.SelectedIndices;
            c.Clear();
            for(int i=0; i<_listView.Items.Count; i++) c.Add(i);
            _listView.EndUpdate();
            this.Cursor = Cursors.Default;
        }

        #region IBellagioListViewClient o

        void BellagioListView.IBellagioListViewClient.DrawColumnHeader(Graphics g, Rectangle r, ColumnHeader header) {
        }

        void BellagioListView.IBellagioListViewClient.DrawItemBackground(Graphics g, Rectangle r, ListViewItem item) {
        }

        void BellagioListView.IBellagioListViewClient.DrawItemBody(Graphics g, Rectangle r, int[] lefts, ListViewItem item) {
            SolidBrush br = new SolidBrush(item.Selected? Color.LightBlue : (item.Index & 1)==0? Color.White : Color.FromArgb(0xf1, 0xf0, 0xf3));
            g.FillRectangle(br, r);
            br.Dispose();

            TickData td = (TickData)item.Tag;
            Brush tb = SystemBrushes.WindowText;
            g.DrawString(TickGraphics.FormatTime(td), _listView.Font, tb, lefts[0], r.Top);
            g.DrawString(td.Price.ToString(), _listView.Font, tb, lefts[1], r.Top);
            g.DrawString(td.Volume.ToString(), _listView.Font, tb, lefts[2], r.Top);
        }

        void BellagioListView.IBellagioListViewClient.OnMouseMoveInListView(MouseEventArgs e) {
        }

        void BellagioListView.IBellagioListViewClient.OnMouseEnterToListView(EventArgs e) {
        }


        #endregion
    }

}
