/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/RealtimeIta.cs#7 $
 * $DateTime: 2008/03/13 13:20:43 $
 * 
 * ̃f[^IuWFNg
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Bellagio.Values;
using Poderosa;

namespace Bellagio.Data {
    public enum ItaStatus {
        OK, //
        Yorimae, //ԑO
        Kehai, //Czl̂
        Hike, //
    }

    //̓DataSubscriberVXeɂ݂ꂽ
    public class RealtimeIta : StockPrimaryData {
        private int _itaSize;

        //DataSource̒ʒm𐏎fBAsyncUpdatełꂪ_ask, _bidɃRs[AO̔Ƃ̍ItaMotionɃZbgAbv
        private Ita _askWork; 
        private Ita _bidWork;

        private Ita _askCurrent;
        private Ita _bidCurrent;

        private Ita _askPrevious; //Aj[V\[X
        private Ita _bidPrevious;
        private ItaMotion _askMotion;
        private ItaMotion _bidMotion;
        
        private int _priceCurrent; //lilBÔƂ͖Ȃ
        private bool _allowedPriceEffectChange;

        private ItaStatus _itaStatus;
        
        private long _lastMotionTime; //Ōɔ̓X^[gBbVɂȂƂ̃Aj[V̗h~

        public RealtimeIta(Stock stock, int ita_size) : base(stock) {
            _itaSize = ita_size;
            Reset();
        }
        public void Reset() {
            _askWork = new Ita(_itaSize, AskBid.Ask);
            _bidWork = new Ita(_itaSize, AskBid.Bid);
            _askCurrent = new Ita(_itaSize, AskBid.Ask);
            _bidCurrent = new Ita(_itaSize, AskBid.Bid);
            _priceCurrent = 0;
        }

        //݂̃XibvVbg
        public Ita Ask {
            get {
                return _askCurrent;
            }
        }
        public Ita Bid {
            get {
                return _bidCurrent;
            }
        }
        public Ita AskWork {
            get {
                return _askWork;
            }
        }
        public Ita BidWork {
            get {
                return _bidWork;
            }
        }

        public ItaMotion AskMotion {
            get {
                return _askMotion;
            }
        }
        public ItaMotion BidMotion {
            get {
                return _bidMotion;
            }
        }
        public int TradingMotionPrice {
            get {
                return _priceCurrent;
            }
        }
        public ItaStatus ItaStatus {
            get {
                return _itaStatus;
            }
            set {
                _itaStatus = value;
            }
        }

        private void SetupItaMotion() {
            int motion_price = 0; //PriceMotionSetupItaMotionłĂ͂Ȃ̂ŕۑ

            if(_askPrevious==null) { //
                _askPrevious = new Ita(_askCurrent.Size, AskBid.Ask);
                _bidPrevious = new Ita(_bidCurrent.Size, AskBid.Bid);
                _askPrevious.Import(_askCurrent);
                _bidPrevious.Import(_bidCurrent);

                _askMotion = new ItaMotion(_askCurrent.Size);
                _bidMotion = new ItaMotion(_bidCurrent.Size);
            }
            else {
                SashineMotion m = _askMotion.FindByPriceMotion(SashinePriceMotion.Tick);
                if(m==null) m = _bidMotion.FindByPriceMotion(SashinePriceMotion.Tick);

                if(m!=null) motion_price = m.Sashine.Price;
            }

            _askMotion.Create(_askPrevious, _askCurrent);
            _bidMotion.Create(_bidPrevious, _bidCurrent);
            if(motion_price!=0) SetupPriceMotion(motion_price);

            _askPrevious.Import(_askCurrent);
            _bidPrevious.Import(_bidCurrent);

            //ŏIl\̂IntraDayTradep\ȎɌ
            IntraDayTrade dt = BellagioRoot.IntraDayTradeProvider.Lookup(_stock);
            
            if(dt!=null) {
                int p = dt==null? 0 : dt.CurrentPriceInfo.CurrentPrice.Value;
                SetupPriceEffectInternal(_priceCurrent, p);
                _priceCurrent = p;
            }
            else
                SetupPriceEffectInternal(0, 0);
            _allowedPriceEffectChange = true; //̂ƂP񂾂͒li̕ω
        }
        private void ClearIta() {
            _askPrevious = null;
            _bidPrevious = null;
            _askMotion = null;
            _bidMotion = null;
        }
        public override bool FireEventToSubscriberManager() {
            long t = DateTime.Now.Ticks;
            if(t < _lastMotionTime + 10000 * 500) return true; //500ms ̊Ԉ2chň]BAj[V̂߂ɂ͎dȂ̂...

            _lastMotionTime = t;
            _askCurrent.Import(_askWork);
            _bidCurrent.Import(_bidWork);

            SetupItaMotion();
            BellagioRoot.DataSubscriberManager.ReserveExecByStock(_stock, SubscribeDataKind.Ita);
            return false;
        }
        public override void FireErrorEventToSubscriberManager(string msg) {
            BellagioRoot.DataSubscriberManager.ReserveErrorByStock(_stock, SubscribeDataKind.Ita, msg);
        }


        //li̕\`Ԃ̍XV
        //@Tick͔Ƃ͓ƗɂĂ̂ŁÃ[ōXVB
        //  * [VƂɎꂽliō쐬B
        //  * ́AliςƂ͔ςĂBTICKsē͂ƂItaMotionĂȂ̂łł悢̂AtƍB
        //  * Ȃ̂ŁASetupItaMotion̂ƂP񂾂AIɕύX`X^
        //  * PriceMotionɂ͂̐͋y΂Ȃ
        public void SetupPriceEffect(int new_price) {
            SetupPriceMotion(new_price);

            if(!_allowedPriceEffectChange) return;

            SetupPriceEffectInternal(_priceCurrent, new_price);
            _priceCurrent = new_price;
            
            _allowedPriceEffectChange = false;
        }
        private void SetupPriceEffectInternal(int prev_price, int new_price) {

            SashineMotion m;
            _askMotion.ClearPriceEffect();
            _bidMotion.ClearPriceEffect();

            //wl[Vƒli̊֌W܂PriceEffect͂̂ƂB
            //FedeInŐVpriceɈv -> FadeIn
            //FadeOutŋpriceɈv -> FadeOut
            //MoveŐV/pricê݂Ɉv -> FadeIn/Out
            //MoveŗɈv -> Active

            bool eq = prev_price==new_price;
            m = _askMotion.FindByPrice(prev_price);
            if(m!=null) AdjustPriceEffect(m, false, eq);
            m = _bidMotion.FindByPrice(prev_price);
            if(m!=null) AdjustPriceEffect(m, false, eq);
            m = _askMotion.FindByPrice(new_price);
            if(m!=null) AdjustPriceEffect(m, true, eq);
            m = _bidMotion.FindByPrice(new_price);
            if(m!=null) AdjustPriceEffect(m, true, eq);

        }
        private void AdjustPriceEffect(SashineMotion m, bool for_new_price, bool eq_price) {
            if(m.Action==SashineAction.Move) {
                if(for_new_price)
                    m.PriceEffect = eq_price? SashinePriceEffect.Active : SashinePriceEffect.FadeIn;
                else
                    m.PriceEffect = eq_price? SashinePriceEffect.Active : SashinePriceEffect.FadeOut;
            }
            else if(m.Action==SashineAction.FadeIn || m.Action==SashineAction.ScrollIn) {
                if(for_new_price)
                    m.PriceEffect = SashinePriceEffect.FadeIn;
            }
            else {
                if(!for_new_price)
                    m.PriceEffect = SashinePriceEffect.FadeOut;
            }
        }
        private void SetupPriceMotion(int price) {
            SashineMotion m = _askMotion.FindByPrice(price);
            if(m!=null) m.PriceMotion = SashinePriceMotion.Tick;
            m = _bidMotion.FindByPrice(price);
            if(m!=null) m.PriceMotion = SashinePriceMotion.Tick;
        }
    }

    public class RealtimeItaInitializer : StockPrimaryDataInitializer {
        private RealtimeIta _ita;
        private bool _setItaCalled;

        public RealtimeItaInitializer(RealtimeIta ita)
            : base(ita) {
            _ita = ita;
        }
        public void SetIta(Ita ask, Ita bid) {
            _ita.AskWork.Import(ask, _ita.AskWork.Size);
            _ita.BidWork.Import(bid, _ita.BidWork.Size);
            _setItaCalled = true;
        }

        public override bool IsCompleted {
            get { return _setItaCalled; }
        }

        public override void CompleteInitialization() {
            
        }
    }
}
