/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 * 
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;
using System.Media;

using Bellagio.Environment;
using Bellagio.Forms;

namespace Bellagio.Ordering {
    //mFʁ@̊mFłpB̂Ƃ̂߂PinCode͂]n
    public class OrderConfirmDialog : BellagioDefaultForm {
        private OrderConfirmDrawing _drawing;
        private Panel _mainPanel;
        private Label _pinCodeLabel;
        private TextBox _pinCodeBox;
        private CheckBox _omitConfirmDialog;
        private CheckBox _savePinCode;
        private RibbonMenuButton _orderButton;
        private RibbonMenuButton _cancelButton;

        public OrderConfirmDialog(string caption, TradeOrderItem item, bool show_pincode, string torihikiSuffix) {
            FormUtil.AdjustStyleForModalDialog(this);
            this.Text = caption;

            _drawing = new OrderConfirmDrawing(item);
            _drawing.TorihikiSuffix = torihikiSuffix;

            _mainPanel = new Panel();
            _mainPanel.Paint += delegate(object sender, PaintEventArgs args) {
                _drawing.Draw(args.Graphics);
            };

            _omitConfirmDialog = new CheckBox();
            _omitConfirmDialog.Text = "mFʂȗ(&R)";
            _omitConfirmDialog.CheckedChanged += delegate(object sender, EventArgs args) { //mFʂȗƁApincodeL͋
                _savePinCode.Checked = true;
                _savePinCode.Enabled = !_omitConfirmDialog.Checked;
            };

            _savePinCode = new CheckBox();
            _savePinCode.Text = "ÏؔԍL(&N)";

            _orderButton = FormUtil.CreateRibbonCommandButton("", OrderingPlugin.OrderingIcons.GetBitmap(0), new MouseEventHandler(OnOrder));
            _cancelButton = FormUtil.CreateRibbonCommandButton("", OrderingPlugin.OrderingIcons.GetBitmap(1), new MouseEventHandler(OnCancel));
            this.AcceptButton = _orderButton;
            _orderButton.DialogResult = DialogResult.OK;
            _orderButton.Size = new Size(52, 52);
            this.CancelButton = _cancelButton;
            _cancelButton.DialogResult = DialogResult.Cancel;
            _cancelButton.Size = new Size(52, 52);

            _mainPanel.BackColor = Color.Black;
            _mainPanel.Location = new Point(0,0);
            _mainPanel.Size = new Size(BellagioRoot.FixedPreferences.Ordering.OrderConfirmDrawingSettings.totalWidth+8, _drawing.TotalHeight+8);
            _pinCodeLabel = FormUtil.CreateLabel("Ïؔԍ(&P)");
            _pinCodeBox = new TextBox();
            _pinCodeBox.PasswordChar = '*';
            _pinCodeLabel.Location = new Point(_mainPanel.Left + 8, _mainPanel.Bottom + 8);
            _pinCodeLabel.Size = new Size(100, 19);
            _pinCodeBox.Location = new Point(_pinCodeLabel.Right, _pinCodeLabel.Top);
            _pinCodeBox.Size = new Size(100, 19);
            _omitConfirmDialog.Location = new Point(_mainPanel.Left + 8, _mainPanel.Bottom + 28);
            _omitConfirmDialog.Size = new Size(220, 19);
            _omitConfirmDialog.Checked = !BellagioRoot.FixedPreferences.Ordering.ShowOrderConfirmDialog;
            _savePinCode.Location = new Point(_mainPanel.Left + 8, _mainPanel.Bottom + 48);
            _savePinCode.Size = new Size(220, 19);
            _savePinCode.Checked = BellagioRoot.FixedPreferences.AutoPinCode;
            _orderButton.Location = new Point(_mainPanel.Width - 120, _mainPanel.Bottom+4);
            _cancelButton.Location = new Point(_mainPanel.Width - 60, _mainPanel.Bottom+4);

            this.ClientSize = new Size(_mainPanel.Width, _mainPanel.Height + 66);

            this.Controls.AddRange(new Control[] { _mainPanel, _pinCodeLabel, _pinCodeBox, _omitConfirmDialog, _savePinCode, _orderButton, _cancelButton });

            _pinCodeLabel.Visible = show_pincode;
            _pinCodeBox.Visible = show_pincode;
            _omitConfirmDialog.Visible = show_pincode;
            _savePinCode.Visible = show_pincode;

            if(show_pincode && BellagioRoot.FixedPreferences.AutoPinCode && BellagioRoot.FixedPreferences.PinCodeVerified)
                _pinCodeBox.Text = BellagioRoot.FixedPreferences.SavedPinCode;
            else
                _pinCodeBox.Text = "";
        }

        public string PinCode {
            get {
                return _pinCodeBox.Text;
            }
        }
        public bool SavePinCodeChecked {
            get {
                return _savePinCode.Checked;
            }
        }
        public bool ShowConfirmDialogChecked {
            get {
                return !_omitConfirmDialog.Checked;
            }
        }

        private void OnOrder(object sender, MouseEventArgs args) {
            if(_omitConfirmDialog.Visible)
                BellagioRoot.FixedPreferences.Ordering.ShowOrderConfirmDialog = !_omitConfirmDialog.Checked;
            if(_savePinCode.Visible)
                BellagioRoot.FixedPreferences.AutoPinCode = _savePinCode.Checked;
        }
        private void OnCancel(object sender, MouseEventArgs args) {
        }

    }
}
