/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Alert/AlertSchema.cs#6 $
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

using Poderosa;
using Poderosa.Preferences;

using Travis.ORT;
using Bellagio.Values;
using Bellagio.Environment;

namespace Bellagio.Alert {
    public class AlertConditionSchema : ExtensionKitItemWithParameter {
        public ORText title;
        public ORText condition; //̕]ʂfalse=>trueɂȂuԂVOiɂȂ
        public ORText soundFile;

        public AlertConditionSchema() {
            parameter = new ORCollectionMember<ExtensionParameter>();
        }

        private void AvoidWarning() {
            condition = new ORText();
        }

    }
    public class AlertSchemaCollection : ViewSchemaCollection<AlertConditionSchema> {
        private List<AlertConditionSchema> _data;

        public AlertSchemaCollection() {
            _data = new List<AlertConditionSchema>();
        }
        public AlertConditionSchema Find(string name) {
            foreach(AlertConditionSchema ss in _data)
                if(!ss.id.IsOmitted && ss.id.Value==name) return ss;

            return null;
        }

        public override void Clear() {
            _data.Clear();
        }
        public override int Count {
            get {
                return _data.Count;
            }
        }
        public override void Add(AlertConditionSchema item) {
            _data.Add(item);
        }
        public override AlertConditionSchema this[int index] {
            get {
                return _data[index];
            }
        }
        public override IEnumerator GetEnumerator() {
            return _data.GetEnumerator();
        }


    }

}
