/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Bookmark/SelectBookmarkFolderDialog.cs#3 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;

namespace Bellagio.Bookmark {
    public class SelectBookmarkFolderDialog : System.Windows.Forms.Form {
        private System.Windows.Forms.Button _okButton;
        private System.Windows.Forms.Button _cancelButton;
        private System.Windows.Forms.TreeView _treeView;
        private BookmarkFolder _selectedFolder;
        private System.Windows.Forms.Button _createFolderButton;

        private string _defaultFolderName;
        private bool _emptyFolderAllowed;

        /// <summary>
        /// KvȃfUCiϐłB
        /// </summary>
        private System.ComponentModel.Container components = null;

        public SelectBookmarkFolderDialog() {
            //
            // Windows tH[ fUCi T|[gɕKvłB
            //
            InitializeComponent();

            //
            // TODO: InitializeComponent ĂяǒɁARXgN^ R[hǉĂB
            //
            _emptyFolderAllowed = true;
        }


        public BookmarkFolder ResultFolder {
            get {
                return _selectedFolder;
            }
        }

        public void SetForceEmptyFolderMode(string default_folder_name) {
            _defaultFolderName = default_folder_name;
            _emptyFolderAllowed = false;
        }

        /// <summary>
        /// gpĂ郊\[XɌ㏈s܂B
        /// </summary>
        protected override void Dispose(bool disposing) {
            if(disposing) {
                if(components != null) {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows tH[ fUCiŐꂽR[h
        /// <summary>
        /// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
        /// R[h GfB^ŕύXȂłB
        /// </summary>
        private void InitializeComponent() {
            this._okButton = new System.Windows.Forms.Button();
            this._cancelButton = new System.Windows.Forms.Button();
            this._treeView = new System.Windows.Forms.TreeView();
            this._createFolderButton = new System.Windows.Forms.Button();
            this.SuspendLayout();
            // 
            // _okButton
            // 
            this._okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
            this._okButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._okButton.Location = new System.Drawing.Point(136, 152);
            this._okButton.Name = "_okButton";
            this._okButton.TabIndex = 0;
            this._okButton.Text = "OK";
            this._okButton.Click += new System.EventHandler(this.OnOK);
            // 
            // _cancelButton
            // 
            this._cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this._cancelButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._cancelButton.Location = new System.Drawing.Point(224, 152);
            this._cancelButton.Name = "_cancelButton";
            this._cancelButton.TabIndex = 1;
            this._cancelButton.Text = "LZ";
            // 
            // _treeView
            // 
            this._treeView.Location = new System.Drawing.Point(0, 0);
            this._treeView.Name = "_treeView";
            this._treeView.ShowRootLines = false;
            this._treeView.Size = new System.Drawing.Size(304, 144);
            this._treeView.TabIndex = 2;
            this._treeView.ImageList = Bellagio.Common.ImageListForm.ImageList16;
            this._treeView.LabelEdit = true;
            // 
            // _createFolderButton
            // 
            this._createFolderButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._createFolderButton.Location = new System.Drawing.Point(8, 152);
            this._createFolderButton.Name = "_createFolderButton";
            this._createFolderButton.Size = new System.Drawing.Size(88, 23);
            this._createFolderButton.TabIndex = 3;
            this._createFolderButton.Text = "tH_̍쐬";
            this._createFolderButton.Click += new System.EventHandler(this.OnCreateFolder);
            // 
            // SelectBookmarkFolder
            // 
            this.AcceptButton = this._okButton;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.CancelButton = this._cancelButton;
            this.ClientSize = new System.Drawing.Size(304, 182);
            this.Controls.Add(this._createFolderButton);
            this.Controls.Add(this._treeView);
            this.Controls.Add(this._cancelButton);
            this.Controls.Add(this._okButton);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "SelectBookmarkFolder";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "tH_̑I";
            this.ResumeLayout(false);

        }
        #endregion

        protected override void OnLoad(EventArgs e) {
            base.OnLoad(e);
            InitTreeView();
        }


        private void InitTreeView() {
            TreeNode r = BookmarkUtil.CreateTreeNode(BellagioRoot.Bookmark.RootFolder, true);
            _treeView.Nodes.Add(r);
            _treeView.SelectedNode = r;
            _treeView.BeforeLabelEdit += new NodeLabelEditEventHandler(OnBeforeLabelEdit);
            _treeView.AfterLabelEdit += delegate(object sender, NodeLabelEditEventArgs args) {
                BookmarkUtil.OnAfterLabelEdit(sender, args); //Ńf[^\ɒʒm
                BookmarkFolder f = args.Node.Tag as BookmarkFolder;
                if(f!=null) {
                    BellagioRoot.Bookmark.FireEvent.RefreshFolder(f);
                    _treeView.SelectedNode = args.Node;
                }
            };
            r.Expand();
        }

        private void OnBeforeLabelEdit(object sender, NodeLabelEditEventArgs e) {
            if(e.Node.Parent==null) e.CancelEdit = true; //[ĝl[͂Ȃ
        }
        private void OnOK(object sender, EventArgs args) {
            _selectedFolder = (BookmarkFolder)_treeView.SelectedNode.Tag;
            if(!_emptyFolderAllowed) {
                if(!_selectedFolder.IsEmpty) {
                    BUtil.ShowWarningMessageBox(this, "̃tH_w肷Kv܂");
                    this.DialogResult = DialogResult.None;
                }
            }
        }

        private void OnCreateFolder(object sender, System.EventArgs e) {
            TreeNode n = _treeView.SelectedNode;
            BookmarkFolder bfp = (BookmarkFolder)n.Tag;
            if(bfp != null) {
                BookmarkFolder bf = new BookmarkFolder(_emptyFolderAllowed? bfp.GetNewFolderCandidateName() : _defaultFolderName);
                bfp.AddItem(bf);
                //Cɂʒm
                BellagioRoot.Bookmark.FireEvent.RefreshFolder(bfp);

                TreeNode r = BookmarkUtil.CreateTreeNode(bf, true);
                n.Nodes.Add(r);
                n.Expand();

                r.BeginEdit();

            }
        }
    }
}
