/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Evaluators/EvaluatorBuildContext.cs#6 $
 * $DateTime: 2007/10/25 12:56:12 $
 * EvaluatorBuildContext̎BȊOKvɂȂCz͂܂Ȃ
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

//using Poderosa.Util.Collections;
using Bellagio.Values;
using Bellagio.Script;
//using Bellagio.Environment;

namespace Bellagio.Evaluators {

    public class EvaluatorBuildContext {
        private BT _currentType;
        private int _argumentCount;
        private List<LocalVariable> _locals;
        private List<int> _invokeArgSizes;
        private List<BMethod.ExternalBoundValueTag> _externalContextValues;

        private EvaluatorBuildContext _externalValuesHolder; //̖O

        private IParameterProvider _parameterHolder;
        private List<INamedValue> _referredParameters;

        //gpOɏ邱
        internal static ValueSystemRoot _root;

        public EvaluatorBuildContext(IParameterProvider parameterHolder) {
            _parameterHolder = parameterHolder;
            _locals = new List<LocalVariable>();
            _externalContextValues = new List<BMethod.ExternalBoundValueTag>();
            _invokeArgSizes = new List<int>();
            _referredParameters = new List<INamedValue>();
        }
        public void Initialize(BT context, LocalVariable[] arguments) {
            _currentType = context;
            _locals.Clear();
            _referredParameters.Clear();
            if(arguments==null)
                _argumentCount = 0;
            else {
                _argumentCount = arguments.Length;
                foreach(LocalVariable v in arguments)
                    _locals.Add(v);
            }
        }
        public void Initialize(BT context, ParameterListDefinition arg_def) {
            //Xg
            List<LocalVariable> args = new List<LocalVariable>();
            for(int i=0; i<arg_def.Count; i++) {
                LocalVariable lv = new LocalVariable(arg_def.NameAt(i), TypeDescToBT(arg_def.TypeDescAt(i)), i);
                args.Add(lv);
            }
            this.Initialize(context, args.ToArray());
        }

        private LocalVariable FindLocal(string name) {
            foreach(LocalVariable v in _locals)
                if(v.Name==name) return v;
            return null;
        }

        public IParameterProvider ParameterProvider {
            get {
                return _parameterHolder;
            }
        }

        public INamedValue GetParameter(string name) {
            if(_parameterHolder==null) return null;

            INamedValue p = _parameterHolder.FindParameter(name);

            if(p==null)
                return null; //TODO OȂĂ񂾂
            else {
                if(!_referredParameters.Contains(p))
                    _referredParameters.Add(p);
                return p;
            }
        }

        public NamedValueCollection ResolveValue(string name) {
            //[JD`FbN
            LocalVariable nv = FindLocal(name);
            if(nv!=null)
                return new NamedValueCollection(nv);

            //Õ[J̗D
            if(_externalValuesHolder!=null) {
                nv = _externalValuesHolder.FindLocal(name);
                if(nv!=null) {
                    int index = this.DefineLocal(nv.Name, nv.BT);
                    BMethod.ExternalBoundValueTag tag = new BMethod.ExternalBoundValueTag(nv, _locals[index]);
                    _externalContextValues.Add(tag);
                    return new NamedValueCollection(tag.internalVar);
                }
            }

            //ɃO[o
            return _root.Resolve(name, _currentType); //Bꌩ邩AnullB֐IuWFNgƂĂ̎QƂ
        }

        public IBSystemFunction ResolveSystemFunction(string name) {
            return _root.ResolveSystem(name, _currentType);
        }

        public int DefineLocal(string name, BT type) {
            if(name.Length > 0) {
                INamedValue x = FindLocal(name);
                if(x!=null) throw new ScriptException(String.Format("ϐ {0} ̏d`܂", name));
            }
            _locals.Add(new LocalVariable(name, type, _locals.Count));
            return _locals.Count-1;
        }
        public int AllocateInvokeArgMemory(int size) {
            _invokeArgSizes.Add(size);
            return _invokeArgSizes.Count-1;
        }


        public void SetExternalValueHolders(EvaluatorBuildContext ext) {
            _externalValuesHolder = ext;
        }


        public BT ContextType {
            get {
                return _currentType;
            }
            set {
                _currentType = value;
            }
        }

        public BT TypeDescToBT(TypeDesc t) {
            return _root.TypeDescToBT(t);
        }

        //͂낢ƏWvɎg
        public List<INamedValue> GetReferredParameters() {
            return _referredParameters;
        }

        //\zIƂ̎擾
        public LocalVariable[] Intermediates {
            get {
                LocalVariable[] t = new LocalVariable[_locals.Count - _argumentCount];
                _locals.CopyTo(_argumentCount, t, 0, t.Length);
                return t;
            }
        }
        public LocalVariable[] Arguments {
            get {
                LocalVariable[] t = new LocalVariable[_argumentCount];
                _locals.CopyTo(0, t, 0, _argumentCount);
                return t;
            }
        }
        public int[] InvokeArgSizes {
            get {
                return _invokeArgSizes.ToArray();
            }
        }
        public BMethod.ExternalBoundValueTag[] ExternalContextValues {
            get {
                return _externalContextValues.ToArray();
            }
        }

    }

}
