/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Forms/SimpleLogViewer.cs#4 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 * eLXg{bNXgăseLXg\@ÑG[\Ɏgp
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.Diagnostics;

namespace Bellagio.Forms {
    public class SimpleLogViewer : Form {
        private TextBox _textBox;
        private Button _okButton;

        public SimpleLogViewer() {
            _textBox = new TextBox();
            _textBox.ReadOnly = true;
            _textBox.Multiline = true;
            _okButton = FormUtil.CreateOKButton();

            this.StartPosition = FormStartPosition.CenterScreen;
            this.FormBorderStyle = FormBorderStyle.FixedDialog;
            this.ShowInTaskbar = false;
            this.MinimizeBox = false;
            this.MaximizeBox = false;

            this.Size = new Size(400, 300);
            _okButton.Location = new Point((this.ClientSize.Width - _okButton.Width)/2, this.ClientSize.Height - 8 - _okButton.Height);
            _textBox.Location = new Point(0, 0);
            _textBox.Size = new Size(this.ClientSize.Width, _okButton.Top-8);
            this.Controls.Add(_okButton);
            this.Controls.Add(_textBox);
        }

        public void SetMultiLineText(string[] text) {
            _textBox.Lines = text;
        }
    }
}
