/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/PowerInfoDialog.cs#8 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;

using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Evaluators;
using Bellagio.Forms;
using Bellagio.Environment;

using Poderosa;
using Poderosa.Forms;

namespace Bellagio.Ordering {
    public class PowerInfoDialog : BellagioDefaultForm {
        private Label _displayLabel;
        private ComboBox _displayOptionBox;
        private Button _updateButton;
        private Panel _mainPanel;

        private PowerInfoDrawing _drawing;

        public PowerInfoDialog(Form owner) {
            FormUtil.AdjustStyleForModelessFixedDialog(this, owner);
            this.Text = "]͏";
            
            _updateButton = FormUtil.CreateImageAndTextButton(BellagioRoot.CommonIcons.SmallCommandButtons.GetBitmap(0), "XV(&R)", new EventHandler(OnRefreshButtonClick));
            _drawing = new PowerInfoDrawing(BellagioRoot.FixedPreferences.Ordering.PowerInfoDrawingSettings);
            _displayLabel = FormUtil.CreateLabel("\(&D)");
            _displayOptionBox = FormUtil.CreateComboBox("̂", "+Mp", "+敨", "ׂ");
            _displayOptionBox.SelectedIndex = BellagioRoot.FixedPreferences.Ordering.PowerInfoDisplayStyle;
            SetDisplayOption();
            _displayOptionBox.SelectedIndexChanged += new EventHandler(OnDisplayOptionChanged);

            _mainPanel = new Panel();
            _mainPanel.BackColor = Color.Black;
            _mainPanel.Paint += delegate(object sender, PaintEventArgs args) {
                _drawing.Draw(args.Graphics, _mainPanel.ClientRectangle);
            };
            _mainPanel.ClientSize = new Size(340, 0); //͂ƂŒ
            this.ClientSize = new Size(_mainPanel.Width, 0);

            _displayLabel.Location = new Point(2, 2);
            _displayLabel.Size = new Size(48, 19);
            _displayOptionBox.Location = new Point(52, 2);
            _displayOptionBox.Size = new Size(80, 19);
            _mainPanel.Location = new Point(2, 26);
            _updateButton.Size = new Size(88, 24);
            _updateButton.Location = new Point(this.ClientSize.Width - _updateButton.Width - 2, 2);

            this.Controls.AddRange(new Control[] { _displayLabel, _displayOptionBox, _mainPanel, _updateButton });

            BellagioRoot.OrderDataProvider.EnsureDataSource();
            BellagioRoot.OrderDataProvider.StockBuyingPowerInfo.AddListener(new DataThreadToMainThread(ReceiveStockBuyingPowerInfo));
            BellagioRoot.OrderDataProvider.DerivativeBuyingPowerInfo.AddListener(new DataThreadToMainThread(ReceiveDerivativeBuyingPowerInfo));

            //\Ƀf[^Ȃ΍XV
            _drawing.DerivativeInfo = BellagioRoot.OrderDataProvider.DerivativeBuyingPowerInfo.Value;
            _drawing.StockInfo = BellagioRoot.OrderDataProvider.StockBuyingPowerInfo.Value;
            if(_drawing.DerivativeInfo==null || _drawing.StockInfo==null)
                OnRefreshButtonClick(null, null);

            AdjustSize();
        }
        protected override void OnFormClosing(FormClosingEventArgs e) {
            base.OnFormClosing(e);
            if(!BellagioPlugin.Instance.PoderosaApplication.IsExitingApplication) {
                e.Cancel = true;
                InternalHide();
            }
        }
        private void InternalHide() {
            this.Hide();
            IPoderosaMainWindow w = BellagioPlugin.Instance.ActivePoderosaWindow;
            if(w!=null) w.AsForm().Activate();
        }

        private long _lastRefreshTime;
        private void OnRefreshButtonClick(object sender, EventArgs args) {
            if(!BellagioRoot.DataSourceHost.IsConnected) {
                BUtil.ShowWarningMessageBox("̎擾ł܂B");
                return;
            }

            long time = DateTime.Now.Ticks / 10000; //msP
            if(time < _lastRefreshTime+1000) return; //ߐڍXV͖

            _drawing.DerivativeInfo = null;
            _drawing.StockInfo = null;
            _mainPanel.Invalidate();
            //Refresh͎sOrderDataProviderŃbZ[W{bNXoĂ܂̂ŁA̎擾łƂ̂ݎɂ悤ɂ
            BellagioRoot.OrderDataProvider.StockBuyingPowerInfo.Refresh();
        }
        private void ReceiveStockBuyingPowerInfo() {
            if(this.IsDisposed || !this.Visible) return;
            _drawing.StockInfo = BellagioRoot.OrderDataProvider.StockBuyingPowerInfo.Value;
            _mainPanel.Invalidate();
            if(_drawing.StockInfo!=null)
                BellagioRoot.OrderDataProvider.DerivativeBuyingPowerInfo.Refresh();
        }
        private void ReceiveDerivativeBuyingPowerInfo() {
            if(this.IsDisposed || !this.Visible) return;
            _drawing.DerivativeInfo = BellagioRoot.OrderDataProvider.DerivativeBuyingPowerInfo.Value;
            _lastRefreshTime = DateTime.Now.Ticks / 10000;

            _mainPanel.Invalidate();
        }

        private void OnDisplayOptionChanged(object sender, EventArgs args) {
            SetDisplayOption();
            BellagioRoot.FixedPreferences.Ordering.PowerInfoDisplayStyle = _displayOptionBox.SelectedIndex;
            AdjustSize();
            _mainPanel.Invalidate();
        }
        private void SetDisplayOption() {
            int i = _displayOptionBox.SelectedIndex;
            _drawing.SetVisibiliy(i==1 || i==3, i==2 || i==3);
        }

        private void AdjustSize() {
            _mainPanel.Height = _drawing.GetItemCount() * BellagioRoot.FixedPreferences.Ordering.PowerInfoDrawingSettings.itemHeight.V + 12;
            this.ClientSize = new Size(this.ClientSize.Width, _mainPanel.Height + 19);
        }

        protected override bool ProcessDialogKey(Keys keyData) {
            if(keyData==Keys.F5) {
                OnRefreshButtonClick(null, null);
                return true;
            }
            return base.ProcessDialogKey(keyData);
        }

    }
}
