/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/TestData/DrawingTests.cs#12 $
 * $DateTime: 2007/12/28 19:23:38 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Chart;
using Bellagio.Ordering;
using Bellagio.Drawing;

using Bellagio.Environment;
using Poderosa;

//DrawingnNX̓mF邽߂̃f[^B
//OvWFNgɂĂ̂AinternalȃNXттg߂ɓAZuɓĂ
namespace Bellagio.TestData {
    public class TestChartData : IChartDataSource {
        private ChartDrawingSettings _settings;
        private ChartSectionInfo _sectionInfo;
        private ConcreteQuote _priceRecord; //_lastMinuteCandle͊܂܂Ȃ
        private RuntimeOscillatorGroupSet _oscillatorGroupSet;
        private RuntimeIndicatorSet _indicators;
        private Stock _stock;
        private int _scale;

        public TestChartData() {
            _sectionInfo = ChartSectionInfo.Empty;
            _oscillatorGroupSet = new RuntimeOscillatorGroupSet();
            _indicators = new RuntimeIndicatorSet();
            _stock = new BasicStockProfile("TEST", "TEST", StockProfileFlags.None, 1).CreatePrimary(StockExchange.T, StockExchangeSubType.Ichibu, StockFlags.None);
            _scale = 3;

            _settings = new ChartDrawingSettings("");
            
            CreateQuote();
        }
        private void CreateQuote() {
            Random r = new Random();
            ConcreteQuote pr = new ConcreteQuote(Quote.QuoteUnit.Minutely, _scale);
            int time = MarketUtil.GetZenbaOpenTime(StockExchange.T).AsInt();
            //10{Ȃ悤ɂĂ݂
            for(int i=0; i<10; i++) {
                Candle c = new Candle(pr, pr.Count, time, 0, 0);
                c.Flags = CandleFlags.Nil;
                pr.Add(c);
                time += _scale*60;
            }

            int close = MarketUtil.GetGobaCloseTime(StockExchange.T).AsInt();
            int zc = MarketUtil.GetZenbaCloseTime(StockExchange.T).AsInt();
            int price = 1000;
            while(time < close) {
                int high = price + r.Next(10);
                int low = price - r.Next(10);
                int e = Math.Min(high, Math.Max(low, price - 10 + r.Next(20)));
                Candle y = new Candle(pr, pr.Count, time, price, high, low, e, r.Next(1000), CandleFlags.None);
                pr.Add(y);

                price = e;
                time += _scale*60;

                if(time==zc) time = MarketUtil.GetGobaOpenTime(StockExchange.T).AsInt(); //Wv
            }

            _priceRecord = pr;
        }

        ChartSchema IChartDataSource.SourceSchema {
            get {
                return null;
            }
        }

        public ChartSectionInfo SectionInfo {
            get {
                AdjustSectionInfo();
                return _sectionInfo;
            }
        }


        Candle IChartDataSourceBase.GetCandleAt(CHARTPOSITION position) {
            return _priceRecord.CandleAt(position.ToDataIndex());
        }
        int IChartDataSourceBase.GetDateOrTimeAt(CHARTPOSITION position) {
            int di = position.ToDataIndexSoft();
            if(di!=-1)
                return _priceRecord.CandleAt(di).Time;
            else
                return -1;
        }
        bool IChartDataSourceBase.GetChartPositionAt(int raw_time, out CHARTPOSITION result) {
            result = CHARTPOSITION.Empty(this.SectionInfo);
            return false;
        }
        int IChartDataSource.GetNextDateOrTimeAt(CHARTPOSITION position) {
            int di = position.ToDataIndexSoft();
            if(di!=-1)
                return _priceRecord.CandleAt(di).Time + _scale*60;
            else
                return -1;
        }


        RuntimeIndicatorSet IChartDataSourceBase.Indicators {
            get {
                return _indicators;
            }
        }
        Stock IChartDataSourceBase.Stock {
            get {
                return _stock;
            }
        }
        int IChartDataSourceBase.LastClosePrice {
            get {
                return 1000;
            }
        }
        CandleExtraChart IChartDataSource.GetCandleExtraChart(CHARTPOSITION position) {
            return null;
        }

        double IChartDataSourceBase.GetIndicatorValue(RuntimeIndicatorElement ind, CHARTPOSITION pos) {
            return Double.NaN;
        }
        bool IChartDataSource.IsTimeLabelRequired(int raw_time, out string str) {
            str = null;
            if((raw_time % 3600)==0) {
                str = String.Format("{0}:00", raw_time/3600);
                return true;
            }
            return false;
        }
        string IChartDataSource.GetTimeLabel(int raw_time) {
            return raw_time.ToString();
        }
        RuntimeOscillatorGroupSet IChartDataSource.OscillatorGroupSet {
            get {
                return _oscillatorGroupSet;
            }
        }

        //SetChartDataSourceinternalȂ̂...
        public void ConnectToDrawing(ChartDrawing dr) {
            dr.SetChartDataSource(this);
            dr.DataUpdateDirect();
        }
        public void ResizeDrawing(ChartDrawing dr, Rectangle rect) {
            dr.RectOp.Rect(rect);
            dr.DataUpdateDirect();
        }
        public ChartDrawingSettings ChartDrawingSettings {
            get {
                return _settings;
            }
        }

        private void AdjustSectionInfo() {
            //RealTimeChartDocumentĂR[ĥ߂Ƃт
            int t;
            int mc = _priceRecord.Count *_scale; 

            if(mc > 0)
                t = ((mc-1) / _scale) + 1; //ōlق킩₷B
            else
                t = 0;

            StockExchange m = StockExchange.T;
            int zenba_minutes = (MarketUtil.GetZenbaCloseTime(m).AsMinutelyInt() - MarketUtil.GetZenbaOpenTime(m).AsMinutelyInt()) / 60;
            bool goba = mc > zenba_minutes; //ɓ˓Ă邩ǂ
            int section_count = goba? 3 : 1;

            if(_sectionInfo==null || _sectionInfo.SectionCount!=section_count) { //쐬̕KvƂ
                //ܒx݂͂T{̃`[gŌŒ
                if(goba)
                    _sectionInfo = new ChartSectionInfo(new ChartSectionType[] { ChartSectionType.Data, ChartSectionType.Space, ChartSectionType.Data }, new int[] { zenba_minutes/_scale, 5, t - zenba_minutes/_scale });
                else
                    _sectionInfo = new ChartSectionInfo(ChartSectionType.Data, t);
            }
            else { //̒łƂ
                _sectionInfo.UpdateLength(_sectionInfo.LastData.index, goba? t - zenba_minutes/_scale : t);
            }

        }
    }

    /*
    public class TestScatterData {
        private class Entry {
            public ScatterGraphData body;
        }
        private Entry _data1;
        private Entry _data2;
        private int _tickCount;
        private Random _random;
        private ScatterGraph _graph;

        public TestScatterData(ScatterGraph graph) {
            _graph = graph;
            _random = new Random();
            _data1 = new Entry();
            _data2 = new Entry();

            _data1.body = new ScatterGraphData("X inc Y rnd", Color.Blue, 5);
            CreateRandomScatterData(_data1, true);

            _data2.body = new ScatterGraphData("X dec Y rnd", Color.Red, 5);
            CreateRandomScatterData(_data2, false);

            _tickCount = 0;
            Timer t = new Timer();
            t.Interval = 1000;
            t.Tick += new EventHandler(OnTick); //Ƃ邪eXgf[^Ȃ̂łɂȂ
            t.Start();

            _graph.BeginDataUpdate();
            _graph.DataSet.Clear();
            _graph.DataSet.Add(_data1.body);
            _graph.DataSet.Add(_data2.body);
            _graph.EndDataUpdate();
        }
        //X͒Pȃf[^AY̓_ŏ
        private void CreateRandomScatterData(Entry entry, bool inc) {

            double valueX = 0;
            double valueY = 0;
            int count = 0;
            for(int i=entry.body.NodeCount-1; i>=0; i--) {
                valueX += inc? 1 : -1;
                valueY += _random.NextDouble()-0.5;
                ScatterGraphData.Node n = entry.body.GetNodeAt(i);
                n.ValueX = valueX;
                n.ValueY = valueY;
                n.Label = String.Format("{0:d2}", count);
                n.Visible = true;
                count++;
            }
        }

        //f[^{̂̍XV
        private void OnTick(object sender, EventArgs args) {
            ScatterGraphData.Node n;
            _tickCount++;
            //_data1,2łقړR[hȂ̂A

            _graph.BeginDataUpdate();

            //T񂲂ƂɃm[hc
            if(_tickCount % 5 == 0) {
                for(int i=_data1.body.NodeCount-1; i>=1; i--) {
                    n = _data1.body.GetNodeAt(i);
                    ScatterGraphData.Node p = _data1.body.GetNodeAt(i-1);
                    n.Import(p);
                    n.UseAnimation = false; //Aj[V͂Ȃ
                    n = _data2.body.GetNodeAt(i);
                    p = _data2.body.GetNodeAt(i-1);
                    n.Import(p);
                    n.UseAnimation = false;
                }
            }

            n = _data1.body.GetNodeAt(0);
            n.ValueX = n.ValueX + 1;
            n.ValueY = n.ValueY + (_random.NextDouble() - 0.5)*3;
            n.UseAnimation = true;

            n = _data2.body.GetNodeAt(0);
            n.ValueX = n.ValueX - 1;
            n.ValueY = n.ValueY + (_random.NextDouble() - 0.5)*3;
            n.UseAnimation = true;

            _graph.EndDataUpdate();
        }
    }
    */
    public class OrderingTestUtil {
        public static Stock CreateTestStock() {
            return new BasicStockProfile("ZFH", "5405", StockProfileFlags.None, 1000).CreatePrimary(StockExchange.T, StockExchangeSubType.Ichibu, StockFlags.None);
        }
        public static IOrderDataTestUtil GetOrderDataTestUtil() {
            IDataSourceEnvironment t = BellagioRoot.DataSourceHost.ExternalEnvironment;
            return (IOrderDataTestUtil)t.OrderDataSource.GetAdapter(typeof(IOrderDataTestUtil));
        }
    }

    public class ItaTestFeeder {
        private RandomItaFeeder _randomFeeder;
        private TimeAndSales _timeAndSales;
        private Random _random;
        public ItaTestFeeder() {
            _random = new Random();

            _randomFeeder = new RandomItaFeeder(5);
            _randomFeeder.VolumeUnit = 1000;
            _randomFeeder.PriceStep = 1;
            _randomFeeder.VolumeFactor = 100;
            _randomFeeder.InitIta(700);
            _timeAndSales = new TimeAndSales();
        }


        public void StartItaAnimation(ItaGraphics gr) {
            //JASDAQ`̃V~[g
#if false
            int top = _randomFeeder.Ask.Size-1;
            bool t = _random.Next(2)==0;
            _randomFeeder.Ask.SetDirect(top, _randomFeeder.Ask.SashineAt(top).Price, t? 0 : _randomFeeder.Ask.SashineAt(top).Volume);
            _randomFeeder.Bid.SetDirect(top, _randomFeeder.Bid.SashineAt(top).Price, !t? 0 : _randomFeeder.Bid.SashineAt(top).Volume);
#endif
            TickData tick = _randomFeeder.Update(_randomFeeder.Ask, _randomFeeder.Bid, 0, 1, 3);
            gr.StartItaMotion(_randomFeeder.AskResult, _randomFeeder.BidResult, false);
        }
    }
}
