/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: DocumentAndViewEx.cs,v 1.13 2006/11/03 09:17:55 okajima Exp $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

using Poderosa.Forms;
using Poderosa.Commands;
using Poderosa.UI;
using Poderosa.View;

namespace Poderosa.Sessions
{
    /// <summary>
    /// <ja>
    /// hLgC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface that shows document
    /// </en>
    /// </summary>
    public interface IPoderosaDocument : ICommandTarget {
        /// <summary>
        /// <ja>
        /// hLg̃ACRłB
        /// </ja>
        /// <en>
        /// Icon of the document.
        /// </en>
        /// </summary>
        Image Icon {
            get;
        }
        /// <summary>
        /// <ja>
        /// hLg̃LvVłB
        /// </ja>
        /// <en>
        /// Caption of the document.
        /// </en>
        /// </summary>
        string Caption {
            get;
        }
        /// <summary>
        /// <ja>
        /// hLg\ZbVłB
        /// </ja>
        /// <en>
        /// Session that composes the document.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// W̃^[~iG~[^ƂėpꍇÃC^[tFCX́A
        /// <seealso cref="Poderosa.Sessions.ITerminalSession">ITerminalSession</seealso>ւƕϊł܂B
        /// </ja>
        /// <en>
        /// This interface can be converted into <seealso cref="Poderosa.Sessions.ITerminalSession">ITerminalSession</seealso> when using it as a standard terminal emulator. 
        /// </en>
        /// </remarks>
        ISession OwnerSession {
            get;
        }
    }

    /// <summary>
    /// <ja>
    /// r[\C^[tFCXłB
    /// </ja>
    /// <en>
    /// The interface that show the view.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// <para>
    /// ŌɃANeBuɂȂr[́A<seealso cref="Poderosa.Forms.IPoderosaMainWindow">IPoderosaMainWindow</seealso>
    /// <see cref="IPoderosaMainWindow.LastActivatedView">LastActivatedViewvpeB</see>Ŏ擾ł܂B
    /// </para>
    /// <para>
    /// ܂<seealso cref="CommandTargetUtil">CommandTargetUtil</seealso>
    /// <see cref="CommandTargetUtil.AsViewOrLastActivatedView">AsViewOrLastActivatedView\bh</see>
    /// ĂяoƁAR}hs̈Ƃēn^[Qbgr[ւƕϊł܂B
    /// </para>
    /// </ja>
    /// <en>
    /// <para>
    /// The view that became active at the end can be got in the 
    /// <see cref="IPoderosaMainWindow.LastActivatedView">LastActivatedView property</see> of 
    /// <seealso cref="Poderosa.Forms.IPoderosaMainWindow">IPoderosaMainWindow</seealso>. 
    /// </para>
    /// <para>
    /// Moreover, the target passed as an argument when the command is executed can be converted into the 
    /// view by calling the <see cref="CommandTargetUtil.AsViewOrLastActivatedView">AsViewOrLastActivatedView method</see> 
    /// of <seealso cref="CommandTargetUtil">CommandTargetUtil</seealso>. 
    /// </para>
    /// </en>
    /// </remarks>
    public interface IPoderosaView : IPoderosaControl, ICommandTarget {
        /// <summary>
        /// <ja>
        /// r[ɌтĂhLg܂B
        /// </ja>
        /// <en>
        /// Document tie to view
        /// </en>
        /// </summary>
        IPoderosaDocument Document {
            get;
        }
        /// <summary>
        /// <ja>
        /// ݑIĂ镔ISelectionłB
        /// </ja>
        /// <en>
        /// ISelection that shows part that has been selected now.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// ISelection<seealso cref="ITextSelection">ITextSelection</seealso>ւƕϊA<see cref="ITextSelection.GetSelectedText">GetSelectedText\bh</see>
        /// ĂяoƁAݑIĂ镶擾ł܂B
        /// 
        /// <code>
        /// ITextSelection select = (ITextSelection)<var>view</var>.CurrentSelection.GetAdapter(
        ///     typeof(ITextSelection));
        /// if ((select != null) &amp;&amp; (!select.IsEmpty))
        /// {
        ///     MessageBox.Show(select.GetSelectedText(TextFormatOption.Default));
        /// }
        /// </code>
        /// </ja>
        /// <en>
        /// The character string that has been selected now can be acquired by converting ISelection into 
        /// <seealso cref="ITextSelection">ITextSelection</seealso>, and calling the 
        /// <see cref="ITextSelection.GetSelectedText">GetSelectedText method</see>. 
        /// 
        /// <code>
        /// ITextSelection select = (ITextSelection)<var>view</var>.CurrentSelection.GetAdapter(
        ///     typeof(ITextSelection));
        /// if ((select != null) &amp;&amp; (!select.IsEmpty))
        /// {
        ///     MessageBox.Show(select.GetSelectedText(TextFormatOption.Default));
        /// }
        /// </code>
        /// </en>
        /// </remarks>
        ISelection CurrentSelection {
            get;
        }

        /// <summary>
        /// <ja>
        /// r[̐eƂȂtH[܂B
        /// </ja>
        /// <en>
        /// Form that becomes parents of view.
        /// </en>
        /// </summary>
        IPoderosaForm ParentForm {
            get;
        }
    }

    //r[NX
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IViewFactory : IAdaptable {
        IPoderosaView CreateNew(IPoderosaForm parent);
        Type GetViewType();
    }


    //r[Windows.Formš^𓮓IɕύXł^Cṽr[
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IContentReplaceableView : IPoderosaView {
        IViewManager ViewManager {
            get;
        }
        IPoderosaView GetCurrentContent();
        IPoderosaView AssureViewClass(Type viewclass);
        void AssureEmptyViewClass();
    }
    //gC^tF[XBReplaceContentĂ΂邽тɒʒm󂯂悤ɂ
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IContentReplaceableViewSite : IAdaptable {
        IContentReplaceableView CurrentContentReplaceableView { get; set; }
    }

    //r[p̕WR}hBIPoderosaViewIvViŒ񋟂B

    /// <summary>
    /// <ja>
    /// r[̕WR}h񋟂܂B
    /// </ja>
    /// <en>
    /// Offered a standard command of the view.
    /// </en>
    /// </summary>
    public interface IGeneralViewCommands : IAdaptable {
        /// <summary>
        /// <ja>
        /// Nbv{[hփRs[܂B
        /// </ja>
        /// <en>
        /// Copy to the clipboard. 
        /// </en>
        /// </summary>
        IPoderosaCommand Copy { get; }
        /// <summary>
        /// <ja>
        /// Nbv{[h\t܂B
        /// </ja>
        /// <en>
        /// Paste from the clipboard. 
        /// </en>
        /// </summary>
        IPoderosaCommand Paste { get; }
        //IPoderosaCommand Cut { get; } g^[~iG~[^ƂƂŁAJbg͕WɊ܂߂
    }


    /// <summary>
    /// <ja>
    /// r[}l[W܂B
    /// </ja>
    /// <en>
    /// It shows the view manager.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// r[}l[ẂA<seealso cref="IPoderosaMainWindow">IPoderosaMainWindow</seealso>
    /// <see cref="IPoderosaMainWindow.ViewManager">ViewManagervpeB</see>擾ł܂B
    /// </ja>
    /// <en>
    /// The view manager can acquire it from the <see cref="IPoderosaMainWindow.ViewManager">ViewManager property</see> of <seealso cref="IPoderosaMainWindow">IPoderosaMainWindow</seealso>. 
    /// </en>
    /// </remarks>
    public interface IViewManager : IAdaptable {
        /// <summary>
        /// 
        /// </summary>
        /// <exclude/>
        Control RootControl { get; }
        /// <summary>
        /// <ja>
        /// VhLg쐬邽߂̃r[܂B
        /// </ja>
        /// <en>
        /// Create the view to make a new document.
        /// </en>
        /// </summary>
        /// <returns><ja>ꂽr[Ԃ܂B</ja><en>return thr created view</en></returns>
        IPoderosaView GetCandidateViewForNewDocument();
        /// <summary>
        /// <ja>
        /// ̃r[EBhEłB
        /// </ja>
        /// <en>
        /// Window to which this view belongs
        /// </en>
        /// </summary>
        IPoderosaMainWindow ParentWindow { get; }
    }

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface ISplittableViewManager : IViewManager {
        //factorynull̂Ƃ́Aview̃NX񋟂factoryg
        CommandResult SplitHorizontal(IContentReplaceableView view, IViewFactory factory);
        CommandResult SplitVertical(IContentReplaceableView view, IViewFactory factory);
        CommandResult Unify(IContentReplaceableView view, out IContentReplaceableView next_focus);
        CommandResult UnifyAll(out IContentReplaceableView next_focus);
        bool CanSplit(IContentReplaceableView view);
        bool CanUnify(IContentReplaceableView view);
        bool IsSplitted();

        IPoderosaView[] GetAllViews();

        string FormatSplitInfo();
        void ApplySplitInfo(string value);
    }

    //֌W̕ύX̃Cxgnh
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IViewFormatEventHandler {
        void OnSplit(ISplittableViewManager viewmanager);
        void OnUnify(ISplittableViewManager viewmanager);
    }
}
