/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: PoderosaWorld.cs,v 1.7 2006/11/03 09:17:55 okajima Exp $
 */
using System;
using System.Diagnostics;
using System.Globalization;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

using Poderosa.Plugins;

namespace Poderosa.Boot
{
	internal class InternalPoderosaWorld : IPoderosaWorld, IPoderosaApplication, IStartupContextSupplier {

        private static InternalPoderosaWorld _instance;

		private AdapterManager _adapterManager;
		private StringResource _stringResource;
        private PoderosaCulture _poderosaCulture;
        private PoderosaLog _poderosaLog;
        private PluginManager _pluginManager;
        private IExtensionPoint _rootExtension;
        private PoderosaStartupContext _startupContext;
        private bool _exitingApplication;

        public InternalPoderosaWorld(PoderosaStartupContext context) {
            _instance = this;
            _startupContext = context;
            _poderosaCulture = new PoderosaCulture();
            _poderosaLog = new PoderosaLog(this);
			_adapterManager = new AdapterManager();
            _stringResource = new StringResource("Bellagio.Hermes.Poderosa.Plugin.strings", typeof(InternalPoderosaWorld).Assembly);
            _poderosaCulture.AddChangeListener(_stringResource);
            _pluginManager = new PluginManager(this);
            //[g
            _rootExtension = _pluginManager.CreateExtensionPoint(ExtensionPoint.ROOT, typeof(IRootExtension), null);
        }

        #region IPoderosaWorld
        public IAdapterManager AdapterManager {
			get {
				return _adapterManager;
			}
        }
        public IPluginManager PluginManager {
            get {
                return _pluginManager;
            }
        }
        public IPoderosaCulture Culture {
            get {
                return _poderosaCulture;
            }
        }
        #endregion

        #region IStartupContextSupplier
        public StructuredText Preferences {
            get {
                return _startupContext.Preferences;
            }
        }
        public string PreferenceFileName {
            get {
                return _startupContext.PreferenceFileName;
            }
        }
        #endregion

        #region IAdaptable
        public IAdaptable GetAdapter(Type type) {
            //ftHgOK
            return _adapterManager.GetAdapter(this, type);
        }
        #endregion
        /*
        public StringResource StringResource {
            get {
                return _stringResource;
            }
        }
        */
        #region IPoderosaApplication
        /*public IPoderosaWorld PoderosaWorld {
            get {
                return this;
            }
        }*/
        public IPoderosaWorld Start() {
            RuntimeUtil._poderosaApplication = this;

            DefaultTracer tracer = new DefaultTracer(_stringResource);
            _startupContext.Tracer = tracer;

            //Step1 vOC̍\Ə
            _pluginManager.InitializePlugins(_startupContext);

            //G[|[g
            if(!tracer.Document.IsEmpty) ReportBootError(tracer.Document);

            //Step2 [gGNXeV̎s
            RunRootExtensions();

            return this;
        }
        public void Shutdown() {
            _pluginManager.Shutdown();
        }
        public void ExitApplication() {
            if(_exitingApplication) return; //QdsȂ

            _exitingApplication = true;
            Application.Exit();
        }
        public bool IsExitingApplication {
            get {
                return _exitingApplication;
            }
        }

        public string HomeDirectory {
            get {
                return _startupContext.HomeDirectory;
            }
        }
        public string ProfileHomeDirectory {
            get {
                return _startupContext.ProfileHomeDirectory;
            }
        }
        public IPoderosaLog PoderosaLog {
            get {
                return _poderosaLog;
            }
        }
        public string[] CommandLineArgs {
            get {
                return _startupContext.CommandLineArgs;
            }
        }
        public string InitialOpenFile {
            get {
                return _startupContext.InitialOpenFile;
            }
        }
        #endregion

        private void RunRootExtensions() {
            IRootExtension[] rootextensions = (IRootExtension[])_rootExtension.GetExtensions();
            IGUIMessageLoop message_loop = null;
            foreach (IRootExtension extension in rootextensions) {
                if (extension is IGUIMessageLoop) {
                    if (message_loop != null)
                        _startupContext.Tracer.Trace("PoderosaWorld.Messages.DuplicatedMessageLoopExtension", message_loop.GetType().Name, extension.GetType().Name);
                    else
                        message_loop = (IGUIMessageLoop)extension;
                }
                extension.InitializeExtension();
            }

            //bZ[W[vt̂݂΂sB
            if (message_loop != null) message_loop.RunExtension();
        }


        //V[gJbg
        public static StringResource Strings {
            get {
                return _instance._stringResource;
            }
        }

        private static void ReportBootError(TraceDocument document) {
            StringBuilder bld = new StringBuilder();
            foreach(TraceDocItem item in document) {
                if(bld.Length>0) bld.Append("\n");
                bld.Append(item.Data);
            }

            //WinFormsɗȂł΃xXg
            System.Windows.Forms.MessageBox.Show(bld.ToString(), "Poderosa", System.Windows.Forms.MessageBoxButtons.OK, System.Windows.Forms.MessageBoxIcon.Error);
        }
	}

    internal class PoderosaCulture : IPoderosaCulture {
        private CultureInfo _initialCulture;
        private CultureInfo _currentCulture;
        private List<ICultureChangeListener> _listeners;
        private bool _isJapaneseOS;

        public PoderosaCulture() {
            _initialCulture = CultureInfo.CurrentUICulture;
            _isJapaneseOS = _initialCulture.Name.StartsWith("ja");
            _currentCulture = _initialCulture;
            _listeners = new List<ICultureChangeListener>();
        }

        public CultureInfo InitialCulture {
            get {
                return _initialCulture;
            }
        }

        public CultureInfo CurrentCulture {
            get {
                return _currentCulture;
            }
        }

        public bool IsJapaneseOS {
            get {
                return _isJapaneseOS;
            }
        }

        public void SetCulture(CultureInfo culture) {
            _currentCulture = culture;
            //ʂ̓vOC̃[hœo^͂B̃P[Xł͉vOCEXTPĂяoăeLXg擾BȂ̂ŁÃ[v͋t̂قguȂ
            for(int i=_listeners.Count-1; i>=0; i--) _listeners[i].OnCultureChanged(culture);
        }

        public void AddChangeListener(ICultureChangeListener listener) {
            Debug.Assert(listener!=null);
            _listeners.Add(listener);
        }

        public void RemoveChangeListener(ICultureChangeListener listener) {
            Debug.Assert(listener!=null);
            _listeners.Remove(listener);
        }
    }
}
