/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: PoderosaWorldEx.cs,v 1.10 2006/11/03 09:17:55 okajima Exp $
 */
using System;
using System.Globalization;

namespace Poderosa.Plugins
{
    /// <summary>
    /// <ja>
    /// vOCvOC{̂ƒʐM邽߂̃C^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface to communicate from plug-in with main body of plug-in.
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// ̃C^[tFCX́APoderosa{̂
    /// <seealso cref="IPlugin.InitializePlugin">IPlugin.InitializePlugin</seealso>\bhĂяo
    /// ہAƂēn܂B<br/>
    /// vOCł́ÃC^[tFCX[JϐȂǂɕۑĂAvOC{̂Ƃ̒ʐMɗp܂B<br/>
    /// </ja>
    /// <en>
    /// When Poderosa calls the IPlugin.InitializePlugin method and it initializes it, this interface is passed as an argument. 
    /// This interface is preserved in the local variable etc. , and it uses it to communicate with the main body of the plug-in on the plug-in side. 
    /// </en>
    /// </remarks>
    /// <ja><see href="chap01_01.html">{̂ƃvOC̊{C^[tFCX</see></ja>
    /// <en><see href="chap01_01.html">Basic interface between Poderosa and plug-in.</see></en>
	public interface IPoderosaWorld : IAdaptable {
        /// <summary>
        /// <ja>
        /// <seealso cref="IAdapterManager">IAdapterManagerC^[tFCX</seealso>Ԃ܂B
        /// </ja>
        /// <en>
        /// Return the <seealso cref="IAdapterManager">IAdapterManager interface.</seealso>
        /// </en>
        /// </summary>
        IAdapterManager AdapterManager { get; }
        /// <summary>
        /// <ja>
        /// <seealso cref="IPluginManager">IPluginManagerC^[tFCX</seealso>Ԃ܂B
        /// </ja>
        /// <en>
        /// Return the <seealso cref="IPluginManager">IPluginManager interface</seealso>.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <seealso cref="IPluginManager">IPluginManagerC^[tFCX</seealso>Ԃ܂B
        /// vOCł́ÃC^[tFCXʂāÃvOC񋟂C^[tFCXg|Cg擾ł܂B
        /// </ja>
        /// <en>
        /// Return the <seealso cref="IPluginManager">IPluginManager interface</seealso>Ԃ܂B
        /// The interface and the extension point that other plug-ins offer through this interface can be acquired on the plug-in side. 
        /// </en>
        /// </remarks>
        /// <ja><see href="chap02.html">Poderosa{̂ƃvOCƂ̂Ƃ</see></ja>
        /// <en><see href="chap02.html">Communication of Poderosa and plug-in</see></en>
        IPluginManager PluginManager { get; }
        /// <summary>
        /// <ja>
        /// <seealso cref="IPoderosaCulture">IPoderosaCulture</seealso>C^[tFCXԂ܂B
        /// </ja>
        /// <en>
        /// Return the <seealso cref="IPoderosaCulture">IPoderosaCulture</seealso> interface.
        /// </en>
        /// </summary>
        IPoderosaCulture Culture { get; }
    }

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IPoderosaApplication : IAdaptable {
        string HomeDirectory { get; }
        string ProfileHomeDirectory { get; }
        IPoderosaLog PoderosaLog { get; }
        string[] CommandLineArgs { get; }
        IPoderosaWorld Start();
        void Shutdown(); //̓bZ[W[vȈ
        void ExitApplication(); //bZ[W[vIOAVbg_EJn
        bool IsExitingApplication { get; }
        string InitialOpenFile { get; } //wnull
    }

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IStartupContextSupplier : IAdaptable {
        StructuredText Preferences { get; }
        string PreferenceFileName { get; } //preference͏Ƀt@CǂނƂ͌ȂBnull̂Ƃ
    }

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface IPoderosaCulture {
        CultureInfo InitialCulture { get; }
        CultureInfo CurrentCulture { get; }
        void SetCulture(CultureInfo culture);
        void AddChangeListener(ICultureChangeListener listener);
        void RemoveChangeListener(ICultureChangeListener listener);

        //OS{ꂩǂ
        bool IsJapaneseOS { get; }
    }

    //ύXʒm

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    public interface ICultureChangeListener {
        void OnCultureChanged(CultureInfo newculture);
    }
}
