/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: DrawUtil.cs,v 1.3 2006/07/16 03:21:52 osawa Exp $
 */
using System;
using System.Drawing;
using System.Diagnostics;

using Poderosa.UI;

namespace Poderosa.Util.Drawing {
    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
	public class DrawUtil {
		//ۂ݂̂Border`悷
		internal enum RoundBorderElement {
			Outer,
			Inner,
			Light,
			LightLight
		}
        /// <summary>
        /// 
        /// </summary>
        /// <exclude/>
		public class RoundRectColors {
			public uint border_color;
			public uint outer_color;
			public uint inner_color;
			public uint light_color;
			public uint lightlight_color;

			internal uint GetColor(RoundBorderElement e) {
				switch(e) {
					case RoundBorderElement.Inner:
						return inner_color;
					case RoundBorderElement.Outer:
						return outer_color;
					case RoundBorderElement.Light:
						return light_color;
					case RoundBorderElement.LightLight:
						return lightlight_color;
				}
				Debug.Assert(false, "should not reach here");
				return 0;
			}
							  
		}
		
		//̊ۂ݂`ƂA[x,y]ŎQƂ
		private static readonly RoundBorderElement[,] _round_border_info = new RoundBorderElement[3,3] {
          { RoundBorderElement.Outer,      RoundBorderElement.LightLight, RoundBorderElement.Light      },
          {	RoundBorderElement.LightLight, RoundBorderElement.Light,      RoundBorderElement.LightLight },
          { RoundBorderElement.Light,      RoundBorderElement.LightLight, RoundBorderElement.Inner      },
		};

		public static void DrawRoundRect(Graphics g, int x, int y, int width, int height, RoundRectColors colors) {
			IntPtr hdc = g.GetHdc();
			const int ROUND_SIZE = 3; //3*3sNZ͎Oŕ`
			IntPtr pen = Win32.CreatePen(0, 1, colors.border_color);
			Win32.SelectObject(hdc, pen);
			//
			Win32.MoveToEx(hdc, x+ROUND_SIZE, y);
			Win32.LineTo(hdc, x+width-ROUND_SIZE+1, y);
			//
			Win32.MoveToEx(hdc, x+ROUND_SIZE, y+height);
			Win32.LineTo(hdc, x+width-ROUND_SIZE+1, y+height);
			//
			Win32.MoveToEx(hdc, x, y+ROUND_SIZE);
			Win32.LineTo(hdc, x, y+height-ROUND_SIZE+1);
			//E
			Win32.MoveToEx(hdc, x+width, y+ROUND_SIZE);
			Win32.LineTo(hdc, x+width, y+height-ROUND_SIZE+1);
			
			Win32.DeleteObject(pen);
			
			DrawRoundCorner(hdc, x,       y,        1, 1, colors); //
			DrawRoundCorner(hdc, x+width, y,       -1, 1, colors); //E
			DrawRoundCorner(hdc, x,       y+height, 1,-1, colors); //
			DrawRoundCorner(hdc, x+width, y+height,-1,-1, colors); //E

			g.ReleaseHdc(hdc);
		}

		//z̎QƂɉ]Ă̂ɒ
		private static void DrawRoundCorner(IntPtr hdc, int bx, int by, int dx, int dy, RoundRectColors colors) {
			int y = by;
			for(int j=0; j<3; j++) {
				int x = bx;
				for(int i=0; i<3; i++) {
					Win32.SetPixel(hdc, x, y, colors.GetColor(_round_border_info[i,j]));
					x += dx;
				}
				y += dy;
			}
		}
			
		//Px𔼕ɂFԂ
		public static Color DarkColor(Color src) {
			return Color.FromArgb(src.R/2, src.G/2, src.B/2);
		}
		public static Color LightColor(Color src) {
			return Color.FromArgb(src.R/2+128, src.G/2+128, src.B/2+128);
		}

		//COLORREFɑΉԂ
		public static uint ToCOLORREF(Color c) {
			uint t = (uint)c.ToArgb();
			//COLORREF0x00BBGGRRAToArgb0x00RRGGBB
			uint r = (t & 0x00FF0000) >> 16;
			uint b = (t & 0x000000FF) << 16;
			t &= 0x0000FF00;
			return t | r | b;
		}
		public static uint MergeColor(uint col1, uint col2) {
			uint r = (((col1 & 0x0000FF) + (col2 & 0x0000FF)) >> 1) & 0x0000FF;
			uint g = (((col1 & 0x00FF00) + (col2 & 0x00FF00)) >> 1) & 0x00FF00;
			uint b = (((col1 & 0xFF0000) + (col2 & 0xFF0000)) >> 1) & 0xFF0000;
			return r | g | b;
		}
        public static Color MergeColor(Color c1, Color c2, double v) {
            double r1 = (double)c1.R;
            double g1 = (double)c1.G;
            double b1 = (double)c1.B;
            double r2 = (double)c2.R;
            double g2 = (double)c2.G;
            double b2 = (double)c2.B;

            return Color.FromArgb((int)(r1*v+r2*(1-v)), (int)(g1*v+g2*(1-v)), (int)(b1*v+b2*(1-v)));
        }

        //Of[VĂ̕`
        public static void FillHorizontalGradation(Graphics g, int x, int y, int width, int height, Color top_color, Color bottom_color) {
            for(int i=0; i<height; i++) {
                double t = i / (double)height;
                Color c = MergeColor(bottom_color, top_color, t);
                Pen pen = new Pen(c);
                g.DrawLine(pen, x, y+i, x+width, y+i);
                pen.Dispose();
            }
        }

        //ȗL ... ̕`
        public static void DrawOmittedMark(Graphics g, int x, int y, Color color, bool is_bold) {

            IntPtr hdc = g.GetHdc();
            uint c = ToCOLORREF(color);
            if(is_bold) {
                Win32.SetPixel(hdc, x, y, c);
                Win32.SetPixel(hdc, x+1, y, c);
                Win32.SetPixel(hdc, x+3, y, c);
                Win32.SetPixel(hdc, x+4, y, c);
                Win32.SetPixel(hdc, x+6, y, c);
                Win32.SetPixel(hdc, x+7, y, c);
            }
            else {
                Win32.SetPixel(hdc, x, y, c);
                Win32.SetPixel(hdc, x+2, y, c);
                Win32.SetPixel(hdc, x+4, y, c);
            }
            g.ReleaseHdc(hdc);
        }
    }
}
