/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Bookmark/BookmarkPane.cs#3 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;

using Poderosa;
using Poderosa.Commands;


using Bellagio.Environment;
using Bellagio.Chart;
using Bellagio.Common;
using Bellagio.Data;
using Bellagio.Forms;
using Bellagio.Values;
using Bellagio.Ordering;

namespace Bellagio.Bookmark {
    public class BookmarkPane : BellagioDefaultForm, IBookmarkEventListener {

        const int DD_EXPAND_FOLDER_WAIT = 500;
        const int DD_SCROLL_WAIT = 50;

        //private bool _ignoreBookmarkEvent;
        private TreeNode _rootNode;
        private ContextMenu _folderContextMenu;
        private ContextMenu _stockContextMenu;
        private MenuItem _orderMenuItem;
        private DateTime _dragOverTime;

        private TreeView _treeView;

        private ChartSchema _defaultChartSchema; //_uNbNŎg`[g

        /// <summary>
        /// KvȃfUCiϐłB
        /// </summary>
        private System.ComponentModel.Container components = null;

        public BookmarkPane() {
            // ̌ĂяóAWindows.Forms tH[ fUCiŕKvłB
            InitializeComponent();
            this.Text = "ubN}[N";

            // TODO: InitializeComponent Ăяǒɏǉ܂B
            //InitTreeView();

        }

        /// <summary>
        /// gpĂ郊\[XɌ㏈s܂B
        /// </summary>
        protected override void Dispose(bool disposing) {
            if(disposing) {
                if(components != null) {
                    components.Dispose();
                }
                BellagioRoot.Bookmark.RemoveEventListener(this);
            }
            base.Dispose(disposing);
        }

        #region R|[lg fUCiŐꂽR[h
        /// <summary>
        /// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
        /// R[h GfB^ŕύXȂłB
        /// </summary>
        private void InitializeComponent() {
            this._treeView = new TreeView();
            this.SuspendLayout();
            // 
            // _treeView
            // 
            this._treeView.AllowDrop = true;
            this._treeView.Dock = System.Windows.Forms.DockStyle.Fill;
            this._treeView.HotTracking = true;
            this._treeView.LabelEdit = true;
            this._treeView.Location = new System.Drawing.Point(0, 0);
            this._treeView.Name = "_treeView";
            this._treeView.ShowRootLines = false;
            this._treeView.Sorted = false;
            this._treeView.TabIndex = 0;
            this._treeView.ImageList = ImageListForm.ImageList16;
            this._treeView.MouseUp += new System.Windows.Forms.MouseEventHandler(this.OnTreeViewClicked);
            this._treeView.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.OnAfterSelect);
            this._treeView.AfterLabelEdit += new System.Windows.Forms.NodeLabelEditEventHandler(BookmarkUtil.OnAfterLabelEdit);
            this._treeView.BeforeLabelEdit += new System.Windows.Forms.NodeLabelEditEventHandler(this._treeView_BeforeLabelEdit);
            this._treeView.ItemDrag += new System.Windows.Forms.ItemDragEventHandler(this.OnItemDrag);
            this._treeView.DragEnter += new System.Windows.Forms.DragEventHandler(this.OnDragEnter);
            this._treeView.DragOver += new System.Windows.Forms.DragEventHandler(this.OnDragOver);
            this._treeView.DragDrop += new System.Windows.Forms.DragEventHandler(this.OnDragDrop);

            // 
            // BookmarkPane
            // 
            this.Controls.Add(this._treeView);
            this.Name = "BookmarkPane";
            this.ResumeLayout(false);

        }
        #endregion

        private void InitTreeView() {
            _treeView.BeginUpdate();
            _rootNode = BookmarkUtil.CreateTreeNode(BellagioRoot.Bookmark.RootFolder, false);
            _treeView.Nodes.Add(_rootNode);
            _treeView.SelectedNode = _rootNode;
            _treeView.DoubleClick += new EventHandler(OnTreeViewDoubleClick); 

            _rootNode.Expand();
            _treeView.EndUpdate();
        }
        private void InitContextMenu() {
            //tH_ɂĂ͂̒Ŋł̂PoderosaCommandɂ͂Ȃ
            _folderContextMenu = new ContextMenu();
            FormUtil.AddMenuItem(_folderContextMenu, "tH_̍쐬(&F)", new EventHandler(OnCreateFolderMenu));
            FormUtil.AddMenuItem(_folderContextMenu, "O̕ύX(&N)", delegate(object sender, EventArgs args) {
                _treeView.SelectedNode.BeginEdit();
            });
            FormUtil.AddMenuItem(_folderContextMenu, "폜(&R)", new EventHandler(OnRemoveMenu));

            //ChartMenuGroups.ChartSchemaMenuGroupŊyɂƂ낾AœR}hCommandTarget̃r[ŎĂɔĂ̂ŎgȂ
            _stockContextMenu = new ContextMenu();
            List<ChartSchema> r = new List<ChartSchema>();
            BellagioRoot.SchemaRoot.CollectStaticChartSchema(r);
            foreach(ChartSchema cs in r) {
                if(_defaultChartSchema==null && cs.ChartUnit==Quote.QuoteUnit.Daily) _defaultChartSchema = cs; //ŏɌftHgƂ
                AddOpenChartMenu(cs);
            }
            if(r.Count > 0)
                FormUtil.AddMenuItem(_stockContextMenu, "-", null);
            r.Clear();
            BellagioRoot.SchemaRoot.CollectRealTimeChartSchema(r);
            foreach(ChartSchema cs in r) {
                AddOpenChartMenu(cs);
            }
            if(r.Count > 0)
                FormUtil.AddMenuItem(_stockContextMenu, "-", null);
            if(Ordering.OrderingPlugin.Instance!=null) {
                _orderMenuItem = FormUtil.AddMenuItem(_stockContextMenu, "(&O)...", new EventHandler(OnOrder));
                FormUtil.AddMenuItem(_stockContextMenu, "-", null);
            }
            FormUtil.AddMenuItem(_stockContextMenu, "폜(&R)", new EventHandler(OnRemoveMenu));
        }
        private void AddOpenChartMenu(ChartSchema cs) {
            //[vnew郍[JϐłȂƂB
            ChartOpenCommand cmd = new ChartOpenCommand(cs, null, BellagioRoot.FixedPreferences.OpenBookMarkWithNewTab? ChartOpenCommand.OpenStyleT.NewTab : ChartOpenCommand.OpenStyleT.SameSchema);
            MenuItem mi = FormUtil.AddMenuItem(_stockContextMenu, cs.description.ParseMandatoryString(), delegate(object sender, EventArgs args) {
                StockBookmark bm = _treeView.SelectedNode.Tag as StockBookmark;
                cmd.CommandTargetStock = (Stock)bm.Value;
                BellagioPlugin.Instance.CommandManager.Execute(cmd, BellagioPlugin.Instance.ActivePoderosaWindow);
            });
            mi.Tag = cmd;
        }


        //OnLoadInitTreeViewȂȂARXgN^ŌĂԂƕςȃXN[o[TreeɏoĂ܂
        protected override void OnLoad(EventArgs e) {
            base.OnLoad(e);
            InitTreeView();
            BellagioRoot.Bookmark.AddEventListener(this);
        }

        //nbVe[uăeΒT̂͑Ȃ邪...
        private TreeNode FindNode(BookmarkFolder folder) {
            if(_rootNode.Tag==folder) return _rootNode;
            return FindNode(_rootNode, folder);
        }
        private TreeNode FindNode(TreeNode pivot, BookmarkFolder folder) {
            foreach(TreeNode ch in pivot.Nodes) {
                if(ch.Tag==folder) return ch;

                if(ch.Tag is BookmarkFolder) {
                    TreeNode d = FindNode(ch, folder);
                    if(d!=null) return d;
                }
            }
            return null;
        }
        private void _treeView_BeforeLabelEdit(object sender, NodeLabelEditEventArgs e) {
            if(e.Node.Tag is StockBookmark || e.Node.Parent==null)
                e.CancelEdit = true;
        }

        private void OnAfterSelect(object sender, TreeViewEventArgs e) {
            StockBookmark m = e.Node.Tag as StockBookmark;
            /*
            if(m!=null)
              m  InternalCommand.ShowBrand(Env.BrandCollection.FindBrand(m.Code));
            */
        }
        private void OnTreeViewClicked(object sender, MouseEventArgs args) {
            if(args.Button!=MouseButtons.Right) return;
            if(_folderContextMenu==null) InitContextMenu();

            TreeNode nd = _treeView.GetNodeAt(args.X, args.Y);
            if(nd!=null) {
                _treeView.SelectedNode = nd;
                //AdjustContextMenu(nd.Tag as IBookmarkItem);
                if(nd.Tag is BookmarkFolder) {
                    bool root = nd.Parent==null;
                    _folderContextMenu.MenuItems[1].Enabled = !root; //l[A폜̃j[𖳌
                    _folderContextMenu.MenuItems[2].Enabled = !root;
                    _folderContextMenu.Show(this, args.Location);
                }
                else {
                    StockBookmark bm = nd.Tag as StockBookmark;
                    if(bm!=null) {
                        Stock stock = bm.Stock;
                        ICommandTarget target = BellagioPlugin.Instance.ActivePoderosaWindow;
                        foreach(MenuItem mi in _stockContextMenu.MenuItems) {
                            ChartOpenCommand cmd = mi.Tag as ChartOpenCommand;
                            if(cmd!=null) {
                                cmd.CommandTargetStock = stock;
                                mi.Enabled = cmd.CanExecute(target);
                            }
                        }
                        if(_orderMenuItem!=null) _orderMenuItem.Enabled = ChartCommands.CanOrder(stock) && BellagioRoot.DataSourceHost.IsConnected;
                        _stockContextMenu.Show(this, args.Location);

                    }
                }
            }
        }
        private void OnTreeViewDoubleClick(object sender, EventArgs args) {
            if(_folderContextMenu==null) InitContextMenu();
            Debug.Assert(_defaultChartSchema!=null);

            TreeNode node = _treeView.SelectedNode;
            if(node==null) return;
            StockBookmark bm = node.Tag as StockBookmark;
            if(bm!=null) {
                ChartOpenCommand cmd = new ChartOpenCommand(_defaultChartSchema, (Stock)bm.Value,
                    BellagioRoot.FixedPreferences.OpenBookMarkWithNewTab? ChartOpenCommand.OpenStyleT.NewTab : ChartOpenCommand.OpenStyleT.SameSchema);
                BellagioPlugin.Instance.CommandManager.Execute(cmd, BellagioPlugin.Instance.ActivePoderosaWindow);
            }
        }

        private void OnCreateFolderMenu(object sender, EventArgs args) {
            TreeNode t = _treeView.SelectedNode;
            BookmarkFolder bfp = t.Tag as BookmarkFolder;
            if(bfp != null) {
                BookmarkFolder bf = new BookmarkFolder(bfp.GetNewFolderCandidateName());
                bfp.AddItem(bf);

                TreeNode r = BookmarkUtil.CreateTreeNode(bf, true);
                t.Nodes.Add(r);
                t.Expand();

                r.BeginEdit();
            }
        }
        private CommandResult OnRemoveMenu(ICommandTarget target) {
            OnRemoveMenu(null, null); //EventHandlerłƂȂ
            return CommandResult.Succeeded;
        }

        private void OnRemoveMenu(object sender, EventArgs args) {
            IBookmarkItem m = _treeView.SelectedNode.Tag as IBookmarkItem;
            BookmarkFolder f = ToParentFolder(_treeView.SelectedNode);
            if(m!=null && f!=null) {
                f.RemoveItem(m);
                BellagioRoot.Bookmark.FireEvent.RefreshFolder(f);
            }
        }
        private void OnOrder(object sender, EventArgs args) {
            StockBookmark bm = _treeView.SelectedNode.Tag as StockBookmark;
            if(bm!=null) {
                Stock stock = bm.Stock;
                OrderFormParameter p = OrderFormParameter.ForNewPosition(stock.Profile);
                OrderingPlugin.Instance.Commands.OpenOrderFormCommand(BellagioPlugin.Instance.ActivePoderosaWindow, p);
            }
        }

        private void OnItemDrag(object sender, System.Windows.Forms.ItemDragEventArgs args) {
            _treeView.DoDragDrop((TreeNode)args.Item, DragDropEffects.Move);
        }
        private void OnDragEnter(object sender, System.Windows.Forms.DragEventArgs args) {
            args.Effect = DragDropEffects.Move;
            _dragOverTime = DateTime.Now;
        }
        private void OnDragOver(object sender, System.Windows.Forms.DragEventArgs args) {
            try {
                Point p = _treeView.PointToClient(new Point(args.X, args.Y));
                TreeNode item = _treeView.GetNodeAt(p.X, p.Y);
                //qփhbv̂͋Ȃ
                if(item==null || BookmarkUtil.IsAncestorOf((TreeNode)args.Data.GetData(typeof(TreeNode)), item)) {
                    args.Effect = DragDropEffects.None;
                    return;
                }

                double d = DateTime.Now.Subtract(_dragOverTime).TotalMilliseconds;
                if(d >= DD_EXPAND_FOLDER_WAIT) {
                    item.Expand();
                    _dragOverTime = DateTime.Now;
                }
                else if(d >= DD_SCROLL_WAIT) {
                    if(item.PrevVisibleNode!=null && !item.PrevVisibleNode.IsVisible) {
                        item.PrevVisibleNode.EnsureVisible();
                        _dragOverTime = DateTime.Now;
                    }
                    if(item.NextVisibleNode!=null && !item.NextVisibleNode.IsVisible) {
                        item.NextVisibleNode.EnsureVisible();
                        _dragOverTime = DateTime.Now;
                    }
                }
                _treeView.SelectedNode = item;
                args.Effect = DragDropEffects.Move;
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.Message);
                Debug.WriteLine(ex.StackTrace);
            }
        }

        private void OnDragDrop(object sender, DragEventArgs args) {
            try {
                TreeNode src = (TreeNode)args.Data.GetData(typeof(TreeNode));
                TreeNode dest = _treeView.GetNodeAt(_treeView.PointToClient(new Point(args.X, args.Y)));
                if(dest==null || src==dest) return;

                IBookmarkItem destItem = (IBookmarkItem)dest.Tag;
                IBookmarkItem srcItem = (IBookmarkItem)src.Tag;
                BookmarkFolder srcParent = ToParentFolder(src);
                BookmarkFolder destParent = ToParentFolder(dest);
                if(destItem!=null && srcItem!=null && srcParent!=null) {
                    //hbv悪tH_Ȃ炻̖ɒǉ
                    if(destItem is BookmarkFolder) {
                        BookmarkFolder destFolder = (BookmarkFolder)destItem;
                        if(srcItem is BookmarkFolder) {
                            BookmarkFolder srcFolder = (BookmarkFolder)srcItem;
                            BookmarkFolder ch = destFolder.FindChildFolderByName(srcFolder.Name);
                            if(ch!=null && ch!=srcFolder) {
                                BUtil.ShowWarningMessageBox(this, "łɓvf܂");
                                return;
                            }
                        }
                        if(srcItem is StockBookmark) {
                            if(BookmarkUtil.ContainsStockBookmark(destFolder, (Stock)srcItem.Value)) {
                                BUtil.ShowWarningMessageBox(this, "łɓo^Ă܂");
                                return;
                            }
                        }
                        srcParent.RemoveItem(srcItem);
                        destFolder.AddItem(srcItem);
                        src.Remove();
                        dest.Nodes.Add(src);
                    }
                    else if(src.Parent==dest.Parent) { //ZԈړ
                        Debug.Assert(srcParent==destParent);
                        srcParent.RemoveItem(srcItem);
                        srcParent.InsertItem(srcItem, destItem);
                        int index = dest.Index;
                        src.Remove();
                        dest.Parent.Nodes.Insert(index, src);
                    }
                }
                
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.Message);
                Debug.WriteLine(ex.StackTrace);
            }

        }

        private static BookmarkFolder ToParentFolder(TreeNode node) {
            if(node==null) return null;

            TreeNode p = node.Parent;
            if(p!=null)
                return p.Tag as BookmarkFolder;
            else
                return null;
        }

        //IBookmarkEventListener o
        void IBookmarkEventListener.RefreshFolder(BookmarkFolder f) {
            TreeNode oldnode = FindNode(f);

            bool expanded = oldnode.IsExpanded;
            _treeView.BeginUpdate();
            oldnode.Text = f.Name;
            oldnode.Nodes.Clear();
            BookmarkUtil.CreateTreeNodeAndAppend(oldnode, f, false);
            _treeView.EndUpdate();
            if(expanded) oldnode.Expand();
        }
        /*
        public void OnChildAdded(BookmarkFolder parent, BookmarkItem child, BookmarkItem neighbor) {
            //if(_ignoreBookmarkEvent) return;
            TreeNode r = child.CreateTreeNode(false);	// Drag&DragłEvent̂false
            TreeNode p = FindNode(parent);
            if(neighbor!=null) {
                int ii = p.Nodes.IndexOf(FindNode(neighbor));		// ƐM
                p.Nodes.Insert(ii, r);
            }
            else {
                p.Nodes.Add(r);
            }

            if(child is BookmarkFolder)
                r.BeginEdit(); //tH_쐬͂ɕҏWJn
            else
                _treeView.SelectedNode = r;
        }

        public void OnChildRemoved(BookmarkFolder parent, BookmarkItem child) {
            //if(_ignoreBookmarkEvent) return;
            TreeNode r = FindNode(child);
            r.Remove();
        }
        */
    }
}
