/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/ChartMisc.cs#15 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * `[g̕`
 * OmegaChartChartDrawingɑc悪邪ς
 */
using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Diagnostics;

using Sansa.Runtime;
using Travis.LocationOperation;

using Bellagio.Drawing;
using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Forms;

namespace Bellagio.Chart {
    //zúAiɏoAEɉiAɃ^C}[BIV[^͌
    public class ChartDrawingSettings : DrawingSettingsBase {
        public enum LayoutStyle {
            None,
            Normal
        }
        public DSInt layoutStyleI; //\邩ǂ̃ZbeBO

        public DSBrush backColor;
        public DSBrush candleColor; //E\NF
        public DSBrush highlightCandleColor;
        public DSInt candleSpacing; //E\NƃE\N̊Ԋu
        public DSInt candleWidth; //u̕vł邱Ƃɒ

        public DSBrush fushiColor; //߂̃eLXgF
        public DSBrush splitColor; //̃eLXgF

        public DSInt priceLabelWidth; //i\GA̕
        public DSInt priceScaleUnitInPixel; //lîPڐ̃sNZB`̓sŕKɈvȂƂ
        public DSBrush priceLabelColor; //liڐF
        public DSFont priceLabelFont; //liڐtHg
        public DSPenStyle priceLineStyle; //؂̃X^C

        public DSInt volumeAreaHeight; //o\GA̍
        public DSInt volumeScaleUnitInPixel; //ôPڐ̃sNZB`̓sŕKɈvȂ
        public DSBrush volumeGraphColor; //oGA̐F
        public DSBrush volumeLabelColor; //oxF
        public DSFont volumeLabelFont; //oڐtHg
        public DSPenStyle volumeLineStyle; //؂̃X^C
        public DSPenStyle creditLongPen;   //Mpc̐F
        public DSPenStyle creditShortPen; 

        public DSInt timeLabelHeight; //tE\GA̍
        public DSBrush timeLabelColor; //tExF
        public DSFont timeLabelFont; //tExtHg
        public DSPenStyle timeLineStyle; //tE؂

        //Ip
        public DSFont stockBoxFont;  //{bNXtHg
        public DSBrush stockCodeColor; //{bNXR[hF
        public DSBrush stockNameColor; //{bNX̐F

        //}EXǐ
        public DSPenStyle mousePriceLineStyle; //}EXǐ(i)
        public DSPenStyle mouseTimeLineStyle; //}EXǐ(tE)

        public DSFont oscillatorScaleFont; //IV[^̐ltHg
        public DSInt oscillatorMargin; //IV[^O[v̏㉺Ɏ}[W
        public DSInt oscillatorDefaultHeight; //IV[^P̍
        public DSPenStyle oscillatorScalePen; //IV[^ڐ

        public double tickAnimationTime; //ɑ΂Aj[Vɂ鎞
        public DSFont stockInfoFont; //tHg
        public DSInt detailedStockInfoX; //\XW

        public DSBrush freeLineColor; //RF
        public DSBrush hoveredFreeLineColor; //RF(tH[JX)

        public DSBrush warningColor; //\̈s\̌xF

        public ChartDrawingSettings(string id)
            : base(id) {
        }

        protected override void CreateElements() {

            //_CAOŕҏWƂAReloadPreferenceɂčXV̒l悤ɂȂĂ邽߂ɂ͕Kv
            GetFolder().AddChangeListener(BellagioRoot.FixedPreferences.Chart);

            layoutStyleI = DefineInt("layoutStyle", 1);

            backColor = DefineBrush("backColor", Color.Black);
            candleColor = DefineBrush("candleColor", Color.White);
            highlightCandleColor = DefineBrush("highlightCandleDrawing", Color.Coral);
            candleSpacing = DefineInt("candleSpacing", 2);
            candleWidth = DefinePositiveInt("candleWidth", 3);
            fushiColor = DefineBrush("fushiColor", Color.LightGray);
            splitColor = DefineBrush("splitColor", Color.LightGray);

            priceLabelWidth = DefinePositiveInt("priceLabelWidth", 40);
            priceScaleUnitInPixel = DefinePositiveInt("priceScaleUnitInPixel", 40);
            priceLabelColor = DefineBrush("priceLabelColor", Color.White);
            priceLineStyle = DefinePenStyle("priceLineStyle", Color.DarkOliveGreen, BPenStyle.DashStyle.Dot, 1);
            priceLabelFont = DefineFont("priceLabelFont", "lr SVbN", 8.0F);

            stockBoxFont = DefineFont("stockBoxFont", "lr SVbN", 11.0F);
            stockCodeColor = DefineBrush("stockCodeColor", Color.Gold);
            stockNameColor = DefineBrush("stockNameColor", Color.White);

            volumeAreaHeight = DefinePositiveInt("volumeAreaHeight", 80);
            volumeScaleUnitInPixel = DefinePositiveInt("volumeScaleUnitInPixel", 20);
            volumeGraphColor = DefineBrush("volumeGraphColor", Color.DarkOliveGreen/*Color.FromArgb(144, 200, 112)*/);
            volumeLabelColor = DefineBrush("volumeLabelColor", Color.LightGray);
            volumeLabelFont = DefineFont("volumeLabelFont", "lr SVbN", 8.0F);
            volumeLineStyle = DefinePenStyle("volumeLineStyle", Color.DarkOliveGreen, BPenStyle.DashStyle.Dot, 1);
            creditLongPen = DefinePenStyle("creditLongPen", Color.Red, BPenStyle.DashStyle.Solid, 1);
            creditShortPen = DefinePenStyle("creditShortPen", Color.LightBlue, BPenStyle.DashStyle.Solid, 1);

            timeLabelHeight = DefinePositiveInt("timeLabelHeight", 16);
            timeLabelColor = DefineBrush("timeLabelColor", Color.White);
            timeLineStyle = DefinePenStyle("timeLineStyle", Color.DarkOliveGreen, BPenStyle.DashStyle.Dot, 1);
            timeLabelFont = DefineFont("timeLabelFont", "lr SVbN", 8.0F);

            oscillatorScaleFont = DefineFont("oscillatorScaleFont", "lr SVbN", 8.0F);
            oscillatorMargin = DefinePositiveInt("oscillatorMargin", 5);
            oscillatorDefaultHeight = DefinePositiveInt("oscillatorDefaultHeight", 60);
            oscillatorScalePen = DefinePenStyle("oscillatorScalePen", Color.Beige, BPenStyle.DashStyle.Dot, 1);

            mousePriceLineStyle = DefinePenStyle("mousePriceLineStyle", Color.LightGray, BPenStyle.DashStyle.Dot, 1);
            mouseTimeLineStyle = DefinePenStyle("mouseTimeLineStyle", Color.LightGray, BPenStyle.DashStyle.Dot, 1);

            tickAnimationTime = 0.5;

            stockInfoFont = DefineFont("stockInfoFont", "lr SVbN", 9.0F);
            detailedStockInfoX = DefinePositiveInt("detailedStockInfoX", 320);

            freeLineColor = DefineBrush("freeLineColor", Color.Yellow);
            hoveredFreeLineColor = DefineBrush("hoveredFreeLineColor", Color.Yellow);

            warningColor = DefineBrush("warningColor", Color.Red);
        }

        public LayoutStyle layoutStyle {
            get {
                return (LayoutStyle)layoutStyleI.V;
            }
            set {
                layoutStyleI.UnderlyingItem.AsInt().Value = (int)value;
            }
        }
        //vZł^Cv
        public int candlePitch {
            get {
                return candleSpacing.V + (candleWidth.V*2 + 1);
            }
        }

    }

    //kڏ
    public class ChartScaleInfo : GraphScaleInfoBase {
        //lɎgp
        public class PriceMoveEffectT {
            public bool available;
            public bool isUptick;
            public double lastPrice;
            public double semiLastPrice;
        }
        private ChartDrawing _parent;
        private LinearTranslatorAnimation _priceTranslator;  //f[^XVɌvZ
        private LinearTranslatorAnimation _volumeTranslator; //op
        private LinearTranslator[] _oscillators; //IV[^B̓Aj[VȂ
        private GraphScaleUnit _priceScaleUnit;
        private GraphScaleUnit _volumeScaleUnit;
        private PriceMoveEffectT _priceMoveEffect;
        //`悵悤ƂĂ͈͂̉i͈
        private double _maxPrice;
        private double _minPrice;
        private double _maxVolume;

        public ChartScaleInfo(ChartDrawing parent)
            : base(parent) {
            _parent = parent;
            _priceMoveEffect = new PriceMoveEffectT();
            _priceTranslator = new LinearTranslatorAnimation(this);
            _volumeTranslator = new LinearTranslatorAnimation(this);
        }
        //KXXV yCgƂɎs Translator͗ps̂ƂnullɂȂ
        public void UpdateScale(GraphScaleUnit price_scale, GraphScaleUnit volume_scale, LinearTranslator price_tr, LinearTranslator volume_tr, GraphUpdateReason reason) {

            if(price_tr!=null) {
                _priceScaleUnit  = price_scale;
                _priceTranslator.Update(price_tr);
            }
            if(volume_tr!=null) {
                _volumeScaleUnit = volume_scale;
                _volumeTranslator.Update(volume_tr);
            }

            //reasonResizeȂ̂łfalseɂȂ邱Ƃɒ
            _translatorChanging = (reason & (GraphUpdateReason.Direct|GraphUpdateReason.Data))==GraphUpdateReason.Data &&
                (price_tr!=null && !_priceScaleUnit.Eq(price_scale) || (volume_tr!=null && !_volumeScaleUnit.Eq(volume_scale)));

        }
        public void AdjustOscillatorGroupCount(int count) {
            if(_oscillators==null || _oscillators.Length!=count)
                _oscillators = new LinearTranslator[count];
        }

        public void SetPriceRange(double max_price, double min_pirce, double max_volume) {
            _maxPrice = max_price;
            _minPrice = min_pirce;
            _maxVolume = max_volume;
            
        }

        public override void BeginDataUpdate() {
            _priceTranslator.BeginDataUpdate();
            _volumeTranslator.BeginDataUpdate();
        }


        public LinearTranslator PriceTrnanslator {
            get {
                return _priceTranslator.CurrentTranslator;
            }
        }
        public LinearTranslator VolumeTranslator {
            get {
                return _volumeTranslator.CurrentTranslator;
            }
        }
        public LinearTranslator[] OscillatorTranslators {
            get {
                return _oscillators;
            }
        }
        public GraphScaleUnit PriceScaleUnit {
            get {
                return _priceScaleUnit;
            }
        }
        public GraphScaleUnit VolumeScaleUnit {
            get {
                return _volumeScaleUnit;
            }
        }
        public PriceMoveEffectT PriceMoveEffect {
            get {
                return _priceMoveEffect;
            }
        }

        public double MaxVolume {
            get {
                return _maxVolume;
            }
        }
        public double MinPrice {
            get {
                return _minPrice;
            }
        }
        public double MaxPrice {
            get {
                return _maxPrice;
            }
        }
    }
}
