/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/ItaControl.cs#17 $
 * $DateTime: 2008/04/17 18:21:41 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;

using Travis.LocationOperation;
using Poderosa;

using Bellagio.Drawing;
using Bellagio.Data;
using Bellagio.Forms;
using Bellagio.Environment;
using Bellagio.Values;

namespace Bellagio.Chart {
    //Ɗ{(O䓙܂)̕\
    public class ItaControl : StockInfoViewerControl {
        public delegate void SashineClickDelegate(SashineMotion m);

        private ItaDocument _document;
        private ItaGraphics _itaGraphics;
        private ItaGraphicsSettings _itaGraphicsSettings;
        private RectOp _rectangleOperator;
        private DataThreadToMainThread _notifyDelegate;
        private DataChangeTag _motionCount;

        private SashineClickDelegate _sashineClick;
        
        public ItaControl(ItaDocument document) : base(document) {
            this.SetStyle(ControlStyles.AllPaintingInWmPaint|ControlStyles.OptimizedDoubleBuffer, true);
            //this.BorderStyle = BorderStyle.Fixed3D;
            this.BackColor = Color.Black;
            this.ForeColor = Color.White;

            _motionCount = new DataChangeTag();
            _notifyDelegate = new DataThreadToMainThread(RealTimeDataHandler);
            _document = document;
            _document.NotifyDelegate = _notifyDelegate;
            
            BellagioPlugin.Instance.SansaPlatform.AssureStart();
        }

        //TODO ItaGraphics̃ZbgłĂł邪ARXgN^Ŏ󂯂ControlŃoChق悢
        private void CreateRectangleOperator() {
            ItaGraphicsSettings gs = _itaGraphicsSettings;
            int ita_height = gs.pitch.V * 11 + gs.margin.V * 2; //㉺T{10{ő̍ //TODO GraphicsSettingsɂĂ
            _rectangleOperator = new RectangleOperatorBuilder()
                .HCenter(280).Shrink(5).SplitFixed(SplitDir.Top, ita_height)
                .Append(_itaGraphics.RectOp).CloseBranch()
                .Finish();

        }

        public ItaDocument Document {
            get {
                return _document;
            }
        }
        public ItaGraphics ItaGraphics {
            get {
                return _itaGraphics;
            }
            set {
                _itaGraphics = value;
                _itaGraphicsSettings = value.Settings;
                CreateRectangleOperator();
                //if(_document.DocumentStatus==BellagioDocumentStatus.Complete)
                //    _itaGraphics.StartItaMotion(_document.RealTimeIta);
            }
        }
        public ItaGraphicsSettings ItaDrawingSettings {
            get {
                return _itaGraphicsSettings;
            }
        }
        public SashineClickDelegate SashineClick {
            get {
                return _sashineClick;
            }
            set {
                _sashineClick = value;
            }
        }

        protected override void Dispose(bool disposing) {
            base.Dispose(disposing);
            if(disposing) {
                _itaGraphics.Dispose();
                _document.SetCurrentStock(null);
            }
        }

        public void SetCurrentStock(Stock stock) {
            if(_document.Stock==stock) return;

            _motionCount = new DataChangeTag();
            _document.SetCurrentStock(stock);
            if(_document.DocumentStatus==BellagioDocumentStatus.Complete)
                RealTimeDataHandler();
            else
                this.Invalidate();
        }
        public override void SetDisconnectedStatus() {
            _document.SetCurrentStock(null);
            base.SetDisconnectedStatus();
        }
        public override void PrepareResume() {
            if(_document.DocumentStatus==BellagioDocumentStatus.Complete) {
                _document.SuspendStock();
                BellagioRoot.DataSubscriberManager.PrepareResume(_document);
            }
            base.PrepareResume();
            this.Invalidate();
        }

        protected override void OnHandleCreated(EventArgs e) {
            base.OnHandleCreated(e);
            RealTimeDataHandler();
        }

        //A^CpB
        private void RealTimeDataHandler() {
            try {
                if(!this.IsHandleCreated) return;
                if(_document.DocumentStatus!=BellagioDocumentStatus.Complete) {
                    this.Invalidate();
                    return;
                }

                if(!_document.RealTimeIta.DataChangeTag.Equals(_motionCount)) {
                    RealtimeIta ita = _document.RealTimeIta;
                    _itaGraphics.StartItaMotion(ita);
                    _motionCount.Let(_document.RealTimeIta.DataChangeTag);

                    Invalidate();
                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        protected override void OnResize(EventArgs e) {
            base.OnResize(e);
            _rectangleOperator.Rect(this.ClientRectangle);
            this.Invalidate();
        }

        protected override void OnPaint(PaintEventArgs e) {
            base.OnPaint(e);
            try {
                Graphics g = e.Graphics;
                if(base.PaintIncompleteCases(e))
                    return;
                else {
                    Pen p = new Pen(Color.LightGray, 2);
                    g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
                    Rectangle r = _itaGraphics.Bound.Value;
                    RoundRectUtil.Draw(g, p, r, 5);
                    g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.Default;
                    p.Dispose();

                    _itaGraphics.Paint(g, e.ClipRectangle);

                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }


        protected override void OnMouseDown(MouseEventArgs e) {
            base.OnMouseDown(e);
            if(e.Button==MouseButtons.Left) {
                SashineMotion m = _itaGraphics.HitTest(e.Location);
                if(m!=null) {
                    _draggingPrice = m.Sashine.Price;
                    _dragStartPoint = e.Location;

                    if(_sashineClick!=null) _sashineClick(m);
                }
            }
        }
        protected override void OnMouseUp(MouseEventArgs e) {
            base.OnMouseUp(e);
            if(e.Button==MouseButtons.Left)
                _draggingPrice = -1; //Zbg
        }

        protected override void OnMouseMove(MouseEventArgs e) {
            base.OnMouseMove(e);
            if(e.Button==MouseButtons.Left && _draggingPrice!=-1 &&
                Math.Abs(e.X-_dragStartPoint.X)+Math.Abs(e.Y-_dragStartPoint.Y) < 6)
                FireStartDragPrice(_draggingPrice);
            if(_itaGraphics.CoverHoveredSashine)
                this.Invalidate();
        }


    }
}
