/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Chart/MultipleIndicatorEditor.cs#5 $
 * $DateTime$
 * Sindicator܂Ƃ߂Đݒ肷_CAO{bNX
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;

using Poderosa.UI;

using Bellagio.Drawing;
using Bellagio.Environment;
using Bellagio.Forms;

namespace Bellagio.Chart {
    //PChartSchemaɑΉāAŎgindicatorappearance/visible/parameter̒lҏWB
    //eIndicatoŕA
    // * ElementPAsharesAppearencew肪ꍇPsɂ܂Ƃ߂UI
    // * ElementŁAsharesAppearencewȂxvisibleݒłPsAÂElementƂɂPsUI
    //Ƃ\ɂȂB
    //ꂼ̓p[^ݒ܂ނAUI̓sŊeElementłR܂ł̃p[^ҏŴƂ

    public class MultipleIndicatorEditorSettings : DrawingSettingsBase {
        public int labelOrCBLeft;  //N_XW
        public int labelOrCBWidth; //xƃ`FbN{bNX̕
        public int styleBoxWidth; //X^C{bNX
        public int colorBoxWidth; //F{bNX
        public int widthBoxWidth;
        public int paramLabelWidth;
        public int paramBoxWidth; //p[^w{bNX̕iPj

        public MultipleIndicatorEditorSettings(string id)
            : base(id) {
            labelOrCBLeft = 8;
            labelOrCBWidth = 120;
            styleBoxWidth = 72;
            colorBoxWidth = 72;
            widthBoxWidth = 48;
            paramLabelWidth = 64;
            paramBoxWidth = 48;
        }

        protected override void CreateElements() {
            //͐lȂ̂PreferenceƐڑĂȂ蔲C
        }


        public int ParamLabelLeft {
            get {
                return labelOrCBLeft + labelOrCBWidth + styleBoxWidth + colorBoxWidth + widthBoxWidth + 40; //KxɃ}[Wm
            }
        }
    }

    public class MultipleIndicatorEditor : Form {
        //p[^ҏWvf x(Updown/x)ZbgɂȂ́@҂͐ݒs\ȃp[^̂Ƃ̂
        //p[^Elementł͂ȂIndicatorPʂɍ쐬
        private class ParameterEditElement : StringWithParameterParser.ISite {
            private MultipleIndicatorEditor _form;
            private ExtensionParameter _prefItem;
            private Label _label;
            private NumericUpDown _value;
            private Label _fixedValue;
            private string _originalValue; //\z̒l

            public ParameterEditElement(MultipleIndicatorEditor form, IndicatorSchemaParameterInfo pi, MultipleIndicatorEditorSettings settings, ref int x, int y) {
                _form = form;
                _label = FormUtil.CreateLabel(FormatParameterName(pi));
                _label.Location = new Point(x, y);
                _label.Size = new Size(settings.paramLabelWidth, LineComponentBase.LINE_HEIGHT);
                form.Controls.Add(_label);

                x += _label.Width+4;
                if(pi.IsAttachedToPreference) {
                    _prefItem = (ExtensionParameter)BellagioRoot.ExtensionKitPreference.Find(pi.PreferenceID);
                    _originalValue = _prefItem.Value;

                    NumericUpDown c = new NumericUpDown();
                    c.Minimum = 1;
                    c.Maximum = 1000;
                    c.Value = Decimal.Parse(_prefItem.Value);
                    c.Location = new Point(x, y);
                    c.Size = new Size(settings.paramBoxWidth, LineComponentBase.LINE_HEIGHT);
                    c.Tag = this;
                    c.ValueChanged += new EventHandler(OnParameterChanged);
                    form.Controls.Add(c);
                    _value = c;
                }
                else {
                    _fixedValue = FormUtil.CreateLabel(pi.RawValue);
                    _fixedValue.Location = new Point(x, y);
                    _fixedValue.Size = new Size(settings.paramBoxWidth, LineComponentBase.LINE_HEIGHT);
                    form.Controls.Add(_fixedValue);
                }

                x += settings.paramBoxWidth + 8;
            }
            private string FormatParameterName(IndicatorSchemaParameterInfo pi) {
                StringWithParameterParser p = new StringWithParameterParser(this);
                p.AddToStringMap(pi.LocalName, ""); //ϐ͏
                return p.Parse(pi.RawDescription);
            }
            string StringWithParameterParser.ISite.FindParameter(string name) {
                if(name=="unit") return _form.ChartUnitString;
                else return "";
            }

            public void RevertToOriginalValue() { //Preference̒lIWiɖ߂
                if(_value==null) return;

                _prefItem.Value = _originalValue;
            }
            public void ResetUI() { //ftHglɖ߂ UIω̃nhĂяo𖳎tÔƂŎs
                if(_value==null) return;

                _prefItem.Value = _prefItem.DefaultValue;
                _value.Value = Decimal.Parse(_prefItem.DefaultValue);
            }

            private void OnParameterChanged(object sender, EventArgs args) {
                if(_form.IsUIBlocking()) return;

                int value;
                if(!Int32.TryParse(_value.Value.ToString(), out value) || value<=0) {
                    BUtil.ShowWarningMessageBox("Pȏ̐͂Ă");
                    return;
                }
            
                _prefItem.Value = _value.Value.ToString();
                
                ChartPreferenceUpdateInfo info = _form.CreateChartPreferenceUpdateInfo();
                info.UpdatedParameters = true;
                info.UpdatedLabel = true;
                ExecReloadCommand(info);
            }


        }

        //s̗vf
        private abstract class LineComponentBase {
            public abstract void InitUI(MultipleIndicatorEditor form, MultipleIndicatorEditorSettings settings, int y);
            public virtual int GetLineCount() { //̗vfsUIō\Ă邩
                return 1;
            }
            public virtual int GetParameterCount() { //̗vfUIvf
                return 0;
            }

            public abstract void RevertToOriginalValue(); //Preference̒lIWiɖ߂
            public abstract void ResetUI(); //ftHglɖ߂ UIω̃nhĂяo𖳎tÔƂŎs

            public const int LINE_HEIGHT = 19;
            public const int LINE_MARGIN = 3;
        }
        private abstract class ElementLine : LineComponentBase {
            protected CheckBox _head;
            protected ComboBox _styleBox;
            protected ColorButton _colorButton;
            protected NumericUpDown _widthButton;
            
            protected DynamicPreferenceItemImpl _penPreference;
            protected string _originalValue; //_CAOJƂ̒lBLZƂɖ߂
            protected IndicatorSchema _indicator;
            protected int _elementIndex;
            protected MultipleIndicatorEditor _form;

            public ElementLine(IndicatorSchema schema, int index, DynamicPreferenceItemImpl penpref) {
                _indicator = schema;
                _elementIndex = index;
                _penPreference = penpref;
                _originalValue = penpref.Value;
            }
            public virtual void SetEnabled(bool value) {
                _styleBox.Enabled = value;
                _colorButton.Enabled = value;
                _widthButton.Enabled = value;
            }

            public override void InitUI(MultipleIndicatorEditor form, MultipleIndicatorEditorSettings settings, int y) {
                _form = form;

                int x = settings.labelOrCBLeft;
                EventHandler appearance_handler = new EventHandler(OnAppearanceChanged);
                
                BPenStyle ps = BPenStyle.Parse(_penPreference.Value);

                _head = new CheckBox();
                //`FbN{bNX̃eLXg͔hNXŎw
                _head.Location = new Point(x, y);
                _head.Size = new Size(settings.labelOrCBWidth, LINE_HEIGHT);
                _head.Checked = ps.visible;
                _head.CheckedChanged += new EventHandler(OnCheckedChanged);
                x += settings.labelOrCBWidth + 8;

                _styleBox = FormUtil.CreateComboBox("", "_");
                _styleBox.SelectedIndex = (int)ps.dash;
                _styleBox.Location = new Point(x, y);
                _styleBox.Size = new Size(settings.styleBoxWidth, LINE_HEIGHT);
                _styleBox.SelectedIndexChanged += appearance_handler;
                x += settings.styleBoxWidth + 8;

                _colorButton = new ColorButton();
                _colorButton.SelectedColor = ps.color;
                _colorButton.Location = new Point(x, y);
                _colorButton.Size = new Size(settings.colorBoxWidth, LINE_HEIGHT);
                _colorButton.ColorChanged += new ColorButton.NewColorEventHandler(ColorButtonChanged);
                x += settings.colorBoxWidth + 8;

                _widthButton = new NumericUpDown();
                _widthButton.Minimum = 1;
                _widthButton.Maximum = 5;
                _widthButton.TextAlign = HorizontalAlignment.Right;
                _widthButton.Value = ps.width;
                _widthButton.Location = new Point(x, y);
                _widthButton.Size = new Size(settings.widthBoxWidth, LINE_HEIGHT);
                _widthButton.ValueChanged += appearance_handler;
                x += settings.widthBoxWidth + 8;

                form.Controls.AddRange(new Control[] { _head, _styleBox, _colorButton, _widthButton });
            }

            private void ColorButtonChanged(object sender, Color newcolor) {
                ChangeElementAppearanceCore(); //ł̂
            }
            private void ChangeElementAppearanceCore() {
                BPenStyle ps = new BPenStyle(_colorButton.SelectedColor, (BPenStyle.DashStyle)_styleBox.SelectedIndex, (int)_widthButton.Value);
                ps.visible = _head.Checked;
                string sps = ps.ToString();
                _penPreference.Value = sps;
                ChartPreferenceUpdateInfo info = _form.CreateChartPreferenceUpdateInfo();
                info.UpdatedAppearance = true;
                info.AddIndicatorDefinition(_indicator.IndicatorDefinition);
                ExecReloadCommand(info);
            }

            private void OnCheckedChanged(object sender, EventArgs args) {
                this.SetEnabled(_head.Checked);
                OnAppearanceChanged(sender, args);
            }
            private void OnAppearanceChanged(object sender, EventArgs args) {
                if(_form.IsUIBlocking()) return;
                ChangeElementAppearanceCore();
            }
            public override void RevertToOriginalValue() {
                _penPreference.Value = _originalValue;
            }
            public override void ResetUI() {
                _penPreference.Value = _penPreference.DefaultValue;
                BPenStyle ps = BPenStyle.Parse(_penPreference.DefaultValue);
                _styleBox.SelectedIndex = (int)ps.dash;
                _colorButton.SelectedColor = ps.color;
                _widthButton.Value = ps.width;
                _head.Checked = ps.visible;
            }

        }

        //PsłPIndicatorɑΉ
        private class SingleElementLine : ElementLine {
            private List<ParameterEditElement> _parameterEditor;
        
            public SingleElementLine(IndicatorSchema ind) : base(ind, 0, ind.AppearancePreferences[0]) { //\Ƃčŏ̗vfŏ
                _indicator = ind;
                _parameterEditor = new List<ParameterEditElement>();
            }
            public override int GetParameterCount() {
                return _parameterEditor.Count;
            }

            public override void InitUI(MultipleIndicatorEditor form, MultipleIndicatorEditorSettings settings, int y) {
                base.InitUI(form, settings, y);
                _head.Text = _indicator.IndicatorDefinition.id.ParseMandatoryString();
                int x = settings.ParamLabelLeft;
                foreach(IndicatorSchemaParameterInfo pi in _indicator.ParemeterInfo) {
                    _parameterEditor.Add(new ParameterEditElement(form, pi, settings, ref x, y));
                }
            }

            public override void RevertToOriginalValue() {
                base.RevertToOriginalValue();
                foreach(ParameterEditElement pe in _parameterEditor) pe.RevertToOriginalValue();
            }
            public override void ResetUI() {
                base.ResetUI();
                foreach(ParameterEditElement pe in _parameterEditor) pe.ResetUI();
            }

        }

        //słPIndicatorɑΉ̂̐擪vf
        private class MultiElementHeadLine : LineComponentBase { 
            private IndicatorSchema _indicator;
            protected Label _head; //o
            private List<ParameterEditElement> _parameterEditor;
            protected List<MultiElementChildLine> _children;

            public MultiElementHeadLine(IndicatorSchema ind) {
                _indicator = ind;
                _children = new List<MultiElementChildLine>();
                _parameterEditor = new List<ParameterEditElement>();

                IndicatorDefinition def = _indicator.IndicatorDefinition;
                //łȂ
                Debug.Assert(def.element.Count > 1);
                Debug.Assert(_indicator.AppearancePreferences.Length > 1);

                for(int i=0; i<def.element.Count; i++) {
                    _children.Add(new MultiElementChildLine(_indicator, i, _indicator.AppearancePreferences[i]));
                }
            }
            public override int GetLineCount() {
                return 1 + _children.Count;
            }
            public override void InitUI(MultipleIndicatorEditor form, MultipleIndicatorEditorSettings settings, int y) {
                _head = FormUtil.CreateLabel(_indicator.IndicatorDefinition.id.ParseMandatoryString());

                _head.Location = new Point(settings.labelOrCBLeft, y);
                _head.Size = new Size(settings.labelOrCBWidth, LINE_HEIGHT);
                form.Controls.Add(_head);

                int x = settings.labelOrCBLeft + settings.labelOrCBWidth + 8; //ʒup[^̔zuJnBłȂƃtH[̃Xy[XLɎgȂ
                foreach(IndicatorSchemaParameterInfo pi in _indicator.ParemeterInfo) {
                    _parameterEditor.Add(new ParameterEditElement(form, pi, settings, ref x, y));
                }

                y += LINE_HEIGHT + LINE_MARGIN;
                foreach(MultiElementChildLine e in _children) {
                    e.InitUI(form, settings, y);
                    y += LINE_HEIGHT + LINE_MARGIN;
                }
            }
            public override void RevertToOriginalValue() {
                foreach(MultiElementChildLine e in _children) e.RevertToOriginalValue();
                foreach(ParameterEditElement pe in _parameterEditor) pe.RevertToOriginalValue();
            }
            public override void ResetUI() {
                foreach(MultiElementChildLine e in _children) e.ResetUI();
                foreach(ParameterEditElement pe in _parameterEditor) pe.ResetUI();
            }
        }

        //słPIndicatorɑΉ̂̌㑱vf
        private class MultiElementChildLine : ElementLine {
            private IndicatorDefinition.Element _indElement;
            public MultiElementChildLine(IndicatorSchema indi, int index, DynamicPreferenceItemImpl penpref)
                : base(indi, index, penpref) {
                _indElement = indi.IndicatorDefinition.element[index];
            }
            public override void InitUI(MultipleIndicatorEditor form, MultipleIndicatorEditorSettings settings, int y) {
                base.InitUI(form, settings, y);
                _head.Text = _indElement.id.ParseMandatoryString();

                this.SetEnabled(_head.Checked); //base.InitUÎƂłȂƂȂ
            }
        }

        private List<LineComponentBase> _components; //̂SingleElementLineMultiElementLine
        private ChartSchema _chartSchema;
        private MultipleIndicatorEditorSettings _settings;

        private Label _displayLabel;
        private Label _styleLabel;
        private Label _colorLabel;
        private Label _widthLabel;
        private Label _parameterLabel;
        private Button _okButton;
        private Button _cancelButton;
        private Button _resetButton;

        public MultipleIndicatorEditor(ChartSchema schema, MultipleIndicatorEditorSettings settings) {
            _settings = settings;
            FormUtil.AdjustStyleForModalDialog(this);
            this.Text = String.Format("{0}{1}`[g̐ݒ", schema.ChartScale==1? "" : schema.ChartScale.ToString(), schema.ChartUnitName);

            _chartSchema = schema;
            _components = new List<LineComponentBase>();
            foreach(IndicatorSchema s in schema.indicator) {
                IndicatorDefinition def = s.IndicatorDefinition;
                if(def.element.Count==1 || def.sharesAppearance.ParseOptionalBool(false))
                    _components.Add(new SingleElementLine(s));
                else
                    _components.Add(new MultiElementHeadLine(s));
            }

            this.SuspendLayout();
            int y = 4;
            int x = settings.labelOrCBLeft;
            _displayLabel = CreateLabel("\", ref x, settings.labelOrCBWidth, y, ContentAlignment.MiddleLeft);
            _styleLabel = CreateLabel("", ref x, settings.styleBoxWidth, y, ContentAlignment.MiddleCenter);
            _colorLabel = CreateLabel("F", ref x, settings.colorBoxWidth, y, ContentAlignment.MiddleCenter);
            _widthLabel = CreateLabel("", ref x, settings.widthBoxWidth, y, ContentAlignment.MiddleCenter);
            _parameterLabel = CreateLabel("p[^", ref x, 200, y, ContentAlignment.MiddleLeft);
            y += LineComponentBase.LINE_HEIGHT + LineComponentBase.LINE_MARGIN;

            int max_params = 0;
            foreach(LineComponentBase c in _components) {
                c.InitUI(this, _settings, y);
                y += (LineComponentBase.LINE_HEIGHT + LineComponentBase.LINE_MARGIN) * c.GetLineCount();
                max_params = Math.Max(max_params, c.GetParameterCount());
            }
            this.ClientSize = new Size(400 + max_params * (settings.paramLabelWidth + settings.paramBoxWidth + 8) , y+32);
            _okButton = FormUtil.CreateOKButton(new EventHandler(OnOK));
            this.AcceptButton = _okButton;
            _cancelButton = FormUtil.CreateCancelButton(new EventHandler(OnCancel));
            this.CancelButton = _cancelButton;
            _resetButton = FormUtil.CreateTextButton("WɃZbg(&R)", new EventHandler(OnReset));
            _okButton.Location = new Point(this.ClientSize.Width-168, y);
            _cancelButton.Location = new Point(this.ClientSize.Width-80, y);
            _resetButton.Location = new Point(8, y);
            _resetButton.Size = new Size(100, 24);
            this.Controls.Add(_okButton);
            this.Controls.Add(_cancelButton);
            this.Controls.Add(_resetButton);
            this.ResumeLayout();
        }

        private static void ExecReloadCommand(ChartPreferenceUpdateInfo info) {
            BellagioPlugin.Instance.Commands.ReloadPreference.InternalExecute(null, info);
        }

        private ChartPreferenceUpdateInfo CreateChartPreferenceUpdateInfo() {
            return new ChartPreferenceUpdateInfo(_chartSchema);
        }

        private void OnOK(object sender, EventArgs args) {
            BellagioPlugin.Instance.PoderosaPreference.Flush();
        }
        private void OnCancel(object sender, EventArgs args) {
            _uiBlocking = true;
            foreach(LineComponentBase c in _components) c.RevertToOriginalValue();
            _uiBlocking = false;

            ChartPreferenceUpdateInfo info = CreateChartPreferenceUpdateInfo();
            info.UpdatedParameters = true;
            info.UpdatedAppearance = true;
            info.UpdatedLabel = true;
            info.UpdatedAllIndicators = true;
            ExecReloadCommand(info);
        }
        private void OnReset(object sender, EventArgs args) {
            _uiBlocking = true;
            foreach(LineComponentBase c in _components) c.ResetUI();
            _uiBlocking = false;

            ChartPreferenceUpdateInfo info = CreateChartPreferenceUpdateInfo();
            info.UpdatedParameters = true;
            info.UpdatedAppearance = true;
            info.UpdatedLabel = true;
            info.UpdatedAllIndicators = true;
            ExecReloadCommand(info);
        }

        //p[^ҏWUIĂł
        private string ChartUnitString {
            get {
                return _chartSchema.ChartUnitName;
            }
        }

        //ʕҏW܂ƂߕҏWŕς镔
        private bool _uiBlocking;
        private bool IsUIBlocking() {
            return _uiBlocking;
        }

        private Label CreateLabel(string text, ref int x, int width, int y, ContentAlignment align) {
            Label l = new Label();
            l.Text = text;
            l.Location = new Point(x, y);
            l.Size = new Size(width, LineComponentBase.LINE_HEIGHT);
            l.TextAlign = align;
            x += width + 8; //Rg[}[W
            this.Controls.Add(l);
            return l;
        }
    }
}
