/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006-2008  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;

using Bellagio.Forms;
using Bellagio.Drawing;
using Bellagio.Data;
using Bellagio.Environment;

using Poderosa;


namespace Bellagio.Chart {
    public class TickControl : StockInfoViewerControl {
        private TickGraphics _drawing;
        private CurrentPriceInfoDocument _document;
        private int _tickCount;

        public TickControl(CurrentPriceInfoDocument doc)
            : base(doc) {
            _document = doc;
            /*
            _layoutParam = new TickLayoutParam(BellagioRoot.FixedPreferences.Chart.TickGraphicsSettings);
            _drawing = new TickGraphics(this, BellagioPlugin.Instance.SansaPlatform,
                BellagioRoot.FixedPreferences.Chart.TickGraphicsSettings,
                _layoutParam);
            */
            
            this.BackColor = Color.Black;
            this.ForeColor = Color.White;

            base.SetStyle(ControlStyles.Selectable, false);
            base.SetStyle(ControlStyles.AllPaintingInWmPaint|ControlStyles.OptimizedDoubleBuffer, true);

        }

        public TickGraphics TickGraphics {
            get {
                return _drawing;
            }
            set {
                _drawing = value;
            }
        }

        public void DocumentEvent() {
            if(_document.DocumentStatus==BellagioDocumentStatus.Complete) {
                IntraDayTrade dt = _document.IntraDayTrade;
                if(_tickCount!=dt.TimeAndSales.Count) {
                    _drawing.StartMotion(dt.TimeAndSales, dt.Stock, true);
                    _tickCount = dt.TimeAndSales.Count;
                }
            }
        }

        protected override void OnResize(EventArgs e) {
            base.OnResize(e);
            _drawing.RectOp.Rect(this.ClientRectangle);
            //TickGraphics̓TCYStartMotionKv
            if(_document.DocumentStatus==BellagioDocumentStatus.Complete)
                _drawing.StartMotion(_document.IntraDayTrade.TimeAndSales, _document.IntraDayTrade.Stock, false);
        }

        protected override void OnPaint(PaintEventArgs e) {
            base.OnPaint(e);
            try {
                Graphics g = e.Graphics;
                if(base.PaintIncompleteCases(e))
                    return;
                else {
                    _drawing.Paint(g, e.ClipRectangle);
                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }

        }

        protected override void OnMouseDown(MouseEventArgs e) {
            base.OnMouseDown(e);
            if(e.Button==MouseButtons.Left) {
                int price = _drawing.PriceHitTest(e.Location);
                if(price!=-1) {
                    _draggingPrice = price;
                    _dragStartPoint = e.Location;
                }
            }
        }
        protected override void OnMouseUp(MouseEventArgs e) {
            base.OnMouseUp(e);
            if(e.Button==MouseButtons.Left)
                _draggingPrice = -1; //Zbg
        }

        protected override void OnMouseMove(MouseEventArgs e) {
            base.OnMouseMove(e);
            if(e.Button==MouseButtons.Left && _draggingPrice!=-1 &&
                Math.Abs(e.X-_dragStartPoint.X)+Math.Abs(e.Y-_dragStartPoint.Y) < 6)
                FireStartDragPrice(_draggingPrice);
        }

    }
}
