/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Common/VersionInfo.cs#19 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 */
//#pragma warning disable 429
using System;
using System.Collections.Generic;
using System.Text;

namespace Bellagio {
    //TODO ̒`͊eExecutableAZuɈړ
    public static class BellagioVersionInfo {
        //݂̃GfBVƃo[WJeS
        public static BellagioEditions EDITION = BellagioEditions.None; //NɃZbg邱 
        public static BellagioVersionCategory VERSION_CATEGORY;

        public const string PLUGIN_VERSION = "1.0.0"; //PoderosavOC@\ɓ`evOC̃o[W

        //o[W
        public static string BELLAGIO_VERSION;

        //HTTPUSER AGENT
        public static string USER_AGENT_STRING;

        //vOC
        public const string AUTHOR_NAME = "Lagarto Technology, Inc.";

        //bZ[W{bNX̃eLXgɖߍޏꍇ̃eLXg
        public static string PUBLIC_PRODUCT_NAME;

        //AvP[VAʂ̃bZ[W{bNX̃LvV
        public static string APPLICATION_CAPTION;

        //GfBV̒񋟐
        public static string EDITION_PARTNER_NAME;

        //WXg̃f[^ۑpX
        public static string REGISTRY_PATH;

        //ApplicationDataȉ́At@CۑpX
        public static string USER_DATA_PATH;

        //NɃvOC@\̑OɌĂ
        public static void Init(BellagioEditions edition, BellagioVersionCategory vercat) {
            EDITION = edition;
            VERSION_CATEGORY = vercat;

            if(edition==BellagioEditions.HatchukunTX) {
                BELLAGIO_VERSION = VERSION_CATEGORY==BellagioVersionCategory.Beta? "1.0.beta5" : "1.alpha.34";
                PUBLIC_PRODUCT_NAME = "͂イNTX";
                APPLICATION_CAPTION = "͂イNTX";
                EDITION_PARTNER_NAME = "NbN،";
                USER_DATA_PATH = "CLICK-SEC\\HatchukunTX";
                REGISTRY_PATH = 
#if DEBUG
                    "Software\\CLICK-SEC\\HatchukunTX-Dev";
#else  
                    "Software\\CLICK-SEC\\HatchukunTX";
#endif
            }
            else if(edition==BellagioEditions.DataGetPersonal) {
                BELLAGIO_VERSION = "1.1.0";
                PUBLIC_PRODUCT_NAME = "Tactico - DataGet Edition";
                APPLICATION_CAPTION= "Tactico";
                EDITION_PARTNER_NAME = "Ѓf[^QbgAC[WVeB";
                USER_DATA_PATH = "Tactico Personal";
                REGISTRY_PATH = 
#if DEBUG
                    "Software\\LagartoTechnology\\TacticoPersonal-Dev";
#else
                    "Software\\LagartoTechnology\\TacticoPersonal";
#endif
            }

            //Editionŋ
            USER_AGENT_STRING = "Tactico/"+BELLAGIO_VERSION;
        }

    }

    public enum BellagioEditions {
        None, 
        HatchukunTX,
        DataGetPersonal
    }
    public enum BellagioVersionCategory {
        Alpha,
        Beta,
        Regular
    }

    public static class BellagioConstants {
        public const string BELLAGIO_PLUGIN_ID =  "jp.co.lagarto.tactico";
        public const string BOOT_PROCEDURE_EXTENSION = "jp.co.lagarto.tactico.bootProcedure";
        public const string DAILYDATA_PROVIDER_EXTENSION = "jp.co.lagarto.tactico.dailyDataProvider";
        public const string DATASOURCE_EXTENSION = "jp.co.lagarto.tactico.dataSource";
        public const string EDITION_SPECIFIC_INFO_EXTENSION = "jp.co.lagarto.tactico.editionSpecificInfo";
        public const string ADVANCED_TOOL_POINT = "bellagio.menu.advancedTool";
    }
}
