/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/DataSubscriberManager.cs#10 $
 * $DateTime: 2008/03/13 13:20:43 $
 * 
 * 񓯊Ƀf[^󂯁Af[^pXbhP{点
 * IDataSubscriberɂ́ÃA^CĎƁAsƂBReserveExecnQ̃\bhŎsׂSubscriber肵A[NXbhsB
 * 
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Diagnostics;
using System.Windows.Forms;

using Poderosa.Util.Collections;
using Poderosa;
using Travis.Collections;

using Timer=System.Windows.Forms.Timer;
using BTime=Bellagio.Values.BTime;

#if UNITTEST
using NUnit.Framework;
#endif

namespace Bellagio.Data {


    //DataSubscriberǗ
    //Producer-ConsumerfBƂɍXVāAKvȃTuXNCoɂĕ]NB
    //̓[Jf[^́uĐv邱Ƃ̂Œ
    public class DataSubscriberManager {
        
        private LinkedList<RealTimeSubscriberHost> _realTimeSubscribers; //f[^
        private LinkedList<PeriodicalSubscriberHost> _periodicalSubscribers;
        
        private List<SubscriberHost> _waitingSubscribers; //s̕Kv̂

        private bool _terminateFlag; //ŐI
        private Thread _workThread;
        private ManualResetEvent _processEvent;  //[J[N邽߂ɃZbg
        private ManualResetEvent _completeEvent; //[J[IZbg
        private Exception _lastSubscriberException;

        public bool IsStarted {
            get {
                return _workThread!=null;
            }
        }
        public bool IsTerminated {
            get {
                return !_workThread.IsAlive;
            }
        }
        public Exception LastSubscriberException {
            get {
                return _lastSubscriberException;
            }
        }

        public DataSubscriberManager() {
            _realTimeSubscribers = new LinkedList<RealTimeSubscriberHost>();
            _periodicalSubscribers = new LinkedList<PeriodicalSubscriberHost>();
            _waitingSubscribers = new List<SubscriberHost>();
            
        }
        public void AddRealtimeSubscriber(IRealTimeDataSubscriber subscriber, SubscribeRequest req) {
            Debug.Assert(subscriber!=null);
            Debug.Assert(FindEntry(subscriber)==null);
        
            lock(this) {
                //IntraDayTrade͑̂Őɏׂ擪ɒǉB{͏w肪ƂƂłƂ̂Ȃ
                RealTimeSubscriberHost h = new RealTimeSubscriberHost(subscriber, req);
                AsyncOpResult r = CheckAndStockBasedSubscriberCondition(h); //AddSubscriber̎_Ń`FbN͂
                //ȂA
                //CheckAndStockBasedSubscriberCondition - StockDataProvidern.Open - I - ReserveExec(R[X^bN)sꂽƂA
                //subscriber͂܂s\Ԃł͂Ȃ̂ŁAĂCheckAndStockBasedSubscriberConditionɍċA댯B
                //Ȃ̂ŁArealTimeSubscribers.AddLast͏CheckAndStockBasedSubscriberCondition肠ƂŎs

                if(r!=AsyncOpResult.Failed)
                    _realTimeSubscribers.AddLast(h);
            }
        }
        public void AddPeriodicalSubscriber(IPeriodicalDataSubscriber subscriber) {
            Debug.Assert(subscriber!=null);
            Debug.Assert(FindEntry(subscriber)==null);
            
            lock(this) {
                //IntraDayTrade͑̂Őɏׂ擪ɒǉB{͏w肪ƂƂłƂ̂Ȃ
                if(subscriber is IntraDayTrade)
                    _periodicalSubscribers.AddFirst(new PeriodicalSubscriberHost(subscriber));
                else
                    _periodicalSubscribers.AddLast(new PeriodicalSubscriberHost(subscriber));
            }
        }
        public bool RemoveSubscriber(IDataSubscriber ds) {
            lock(this) {
                foreach(RealTimeSubscriberHost e in _realTimeSubscribers) {
                    //Enumerator폜łȂȂĂЂǂB.NET̃RNVNX͖{ɃC˂
                    if(e.Subscriber==ds) {
                        RemoveRealTimeSubscriber(e);
                        return true;
                    }
                }
                foreach(PeriodicalSubscriberHost e in _periodicalSubscribers) {
                    if(e.Subscriber==ds) {
                        RemovePeriodicalSubscriber(e);
                        return true;
                    }
                }
                return false;
            }
        }
        private void RemoveSubscriber(SubscriberHost e) { //SubscriberHost̍폜
            if(e is RealTimeSubscriberHost)
                RemoveRealTimeSubscriber((RealTimeSubscriberHost)e);
            else if(e is PeriodicalSubscriberHost)
                RemovePeriodicalSubscriber((PeriodicalSubscriberHost)e);
        }
        private void RemoveRealTimeSubscriber(RealTimeSubscriberHost e) {
            e.CleanupConnection();
            _realTimeSubscribers.Remove(e);
        }
        private void RemovePeriodicalSubscriber(PeriodicalSubscriberHost e) {
            _periodicalSubscribers.Remove(e);
        }
        public void PrepareResume(IRealTimeDataSubscriber ds) {
            lock(this) {
                foreach(RealTimeSubscriberHost e in _realTimeSubscribers) {
                    //Enumerator폜łȂȂĂЂǂB.NET̃RNVNX͖{ɃC˂
                    if(e.Subscriber==ds) {
                        e.Reset();
                        return;
                    }
                }
            }
        }

        public void Start() {
            Debug.Assert(_workThread==null); //dɑ点̂߂
            _processEvent = new ManualResetEvent(false);
            _completeEvent = new ManualResetEvent(true);
            _terminateFlag = false;
            _workThread = new Thread(new ThreadStart(DataThreadEntryPoint));
            _workThread.Name = "Bellagio DataThread";
            _workThread.IsBackground = true;
            _workThread.Start();
        }

        public void Terminate() {
            _terminateFlag = true;
            _completeEvent.Reset();
            _processEvent.Set(); //ł܂Ȃ[NXbh͏I

            _completeEvent.WaitOne(); //I҂
            //ׂƂADoEventsEndInvoke҂ĂXbhNʂɂ͂ȂȂBbZ[WL[̂̂Ⴄ̂AƂʂ̗R͂킩ȂB
            //Ȃ̂ŏIEndInvoke͑҂ȂBIɃfbhbNɂȂ͂܂Ȃ͂B

            //while(!_workThread.Join(10)) 
            //    Application.DoEvents();

            _processEvent.Close();
            _completeEvent.Close();
        }

        //sĂ邱Ƃǂ𒲂ׂB
        private AsyncOpResult CheckAndStockBasedSubscriberCondition(StockBasedSubscriberHost entry) {
            Debug.Assert(!entry.IsReadyToExecute);
            AsyncOpResult result = entry.CheckCondition();
            if(result!=AsyncOpResult.Async) {
                entry.CallSubscribeResult(); //MłA܂͎smʒm
                if(entry.Subscriber.NotifyDelegate!=null)
                    ExecNotifyDelegate(entry.Subscriber.NotifyDelegate);
            }
            return result;
        }


        //ڎw肵Ďs\
        public void ReserveExec(IDataSubscriber subscriber) {
            Debug.Assert(this.IsStarted);
            lock(this) {
                SubscriberHost e = FindEntry(subscriber);
                Debug.Assert(e!=null);

                if(AddWaitingSubscriber(e, AsyncOpResult.Succeeded)) {
                    _completeEvent.Reset();
                    _processEvent.Set();
                }
            }
        }
        //삳Subscriber𔻒肵ăLbN
        public void ReserveExecByStock(Stock stock, SubscribeDataKind datakind) {
            Debug.Assert(this.IsStarted);
            AsyncOpResult result;
            lock(this) {
                bool added = false;
                foreach(RealTimeSubscriberHost entry in _realTimeSubscribers) {
                    if(entry.Status==PrimaryDataStatus.Error) continue;

                    if(!entry.IsReadyToExecute) {
                        if((result = entry.CheckCondition())!=AsyncOpResult.Async)
                            added = AddWaitingSubscriber(entry, result);
                    }
                    else {
                        if(entry.ProcessRequired(stock, datakind))
                            added = AddWaitingSubscriber(entry, AsyncOpResult.Succeeded);
                    }
                }

                if(added) {
                    _completeEvent.Reset();
                    _processEvent.Set();
                }
            }
        }
        public void ReserveErrorByStock(Stock stock, SubscribeDataKind datakind, string errormessage) {
            Debug.Assert(this.IsStarted);
            lock(this) {
                bool added = false;
                foreach(RealTimeSubscriberHost entry in _realTimeSubscribers) {
                    if(entry.Status==PrimaryDataStatus.Error) continue;

                    if(entry.ProcessRequired(stock, datakind)) {
                        added = AddErrorSubscriber(entry, errormessage);
                    }
                }

                if(added) {
                    _completeEvent.Reset();
                    _processEvent.Set();
                }
            }
        }

        //Ԕł̎s TimeManagerĂ
        public void ReserveExecByTime(BTime current) {
            Debug.Assert(this.IsStarted);
            lock(this) {
                bool added = false;
                foreach(PeriodicalSubscriberHost entry in _periodicalSubscribers) {
                    if(entry.ProcessRequired(current)) {
                        added = AddWaitingSubscriber(entry, AsyncOpResult.Succeeded);
                    }
                }
                if(added) {
                    _completeEvent.Reset();
                    _processEvent.Set();
                }
            }
        }

        public void CancelWaitingSubscribers() {
            lock(this) {
                _waitingSubscribers.Clear();
            }
        }

        //sҋ@̃XgɒǉBVKǉ̂Ƃtrue, ɒǉĂƂfalseԂ
        private bool AddWaitingSubscriber(SubscriberHost entry, AsyncOpResult result) {
            Debug.Assert(result==AsyncOpResult.Succeeded || result==AsyncOpResult.Failed); //ʂ̂킩̂łȂƂȂ
            bool added = false;
            if(!_waitingSubscribers.Contains(entry)) {
                _waitingSubscribers.Add(entry);
                added = true;
            }
            entry.ReserveTime = BellagioRoot.TimeManager.GetCurrentTimeMillis();
            return added;
        }
        private bool AddErrorSubscriber(RealTimeSubscriberHost entry, string message) {
            bool added = false;
            if(!_waitingSubscribers.Contains(entry)) {
                _waitingSubscribers.Add(entry);
                entry.SetErrorStatus(message);
                entry.CleanupConnection();
                added = true;
            }
            entry.ReserveTime = BellagioRoot.TimeManager.GetCurrentTimeMillis();
            return added;
        }

        //f[^XbhKvȂ炻҂BłȂΑ^[
        //UnitTestłgȂB̎ƁAKvȏɑ҂Ă܂Ƃ肤
        public void WaitDataProcessComplete() {
            Debug.Assert(_workThread!=null);

            lock(this) {
                _completeEvent.Reset();
                _processEvent.Set();
            }
            _completeEvent.WaitOne();

            //Q񂳂ȂƂȂBȂȂÅ֐ɓĂ_DataThread͊ŁAs҂Subscriberҋ@ɓĂƂԂ邩łB
            lock(this) {
                _completeEvent.Reset();
                _processEvent.Set();
            }
            _completeEvent.WaitOne();
        }

        private SubscriberHost FindEntry(IDataSubscriber ds) {
            foreach(SubscriberHost e in _realTimeSubscribers) {
                if(e.Subscriber==ds) return e;
            }
            foreach(SubscriberHost e in _periodicalSubscribers) {
                if(e.Subscriber==ds) return e;
            }
            return null;

        }

        private void ExecNotifyDelegate(DataThreadToMainThread notifier) {
            Control c = GetMainThreadControl();
            if(c!=null && GetMainThreadControl().IsHandleCreated) {
                if(c.InvokeRequired)
                    c.Invoke(notifier); //IłƂɂ
                else
                    notifier();
            }
        }

        //f[^Xbh̃Gg|Cg
        [STAThread]
        private void DataThreadEntryPoint() {
            LinkedList<IAsyncResult> invokes = new LinkedList<IAsyncResult>();
            List<SubscriberHost> local_subscribers = new List<SubscriberHost>();
            BTime current = new BTime(0);
            try {
                while(true) {
                    //v̂҂
                    _processEvent.WaitOne(100, false); //100~b͌Œ
                    if(!_terminateFlag) {

                        //bNłPvZXƂ̕Kvȏ
                        lock(this) {
                            current.Let(BellagioRoot.TimeManager.Current);
                            local_subscribers.Clear();
                            local_subscribers.AddRange(_waitingSubscribers); //[JRs[
                            _waitingSubscribers.Clear();

                            //Ԉ`FbN
                            CheckThinning(local_subscribers);

                            _processEvent.Reset();
                        }

                        foreach(SubscriberHost entry in local_subscribers) {
                            try {
                                bool terminate = entry.ExecuteInDataThread(current); //̒SubscribeCompleteƓɖ{̂sAƂP[X
                                DataThreadToMainThread notifier = entry.Subscriber.NotifyDelegate;
                                if(notifier!=null && GetMainThreadControl()!=null && GetMainThreadControl().IsHandleCreated)
                                    invokes.AddLast(GetMainThreadControl().BeginInvoke(notifier));

                                if(terminate)
                                    RemoveSubscriber(entry);

                                if(_terminateFlag) break;
                            }
                            catch(Exception ex) {
                                _lastSubscriberException = ex;
                                HandleException(entry, ex);
                            }
                        }
                    }

                    _completeEvent.Set(); //VOioBEndInvokeOłȂƃfbhbN댯
                    if(_terminateFlag) {
                        break; //Cwhile[v𔲂
                    }

                    //Wait
                    if(!_terminateFlag && invokes.Count>0) {
                        //̏ɂ
                        //  펞͂ŖEndInvokeĂ܂ȂBubN邱Ƃ邾낤ÂƂ̓[v̐擪ɖ߂ăVOi҂łB
                        //  AvIɖ肪BEndInvokeƂɃCXbhIłƁAubN܂܋AĂȂ̂łB
                        //  ̃ubN̓CXbhApplication.DoEventsĂƂ͌ȂiSȂȂj
                        //  āAIsCompleted̂ɂĂ̂EndInvoke邱ƂŃubNBIɂEndInvokeĂȂIAsyncResultc邪AǂAv͏Îō\ȂB
                        Control c = GetMainThreadControl();
                        LinkedListUtil.ActionWithRemove<IAsyncResult>(invokes, delegate(IAsyncResult ar) {
                            if(ar.IsCompleted) {
                                SafeEndInvoke(c, ar); //IEndInvokeƃCXbhł邱Ƃ
                                return true;
                            }
                            else
                                return false;
                        });
                    }
           
                }
            }
            catch(Exception ex) {
                if(BUtil.UnderApplication)
                    RuntimeUtil.ReportException(ex);
                else
                    Debug.WriteLine(ex.StackTrace);
            }
            finally {
                if(!_terminateFlag)
                    _completeEvent.Set(); //ُIłꂾ͂Ă
            }

        }
        private void CheckThinning(List<SubscriberHost> local_subscribers) {
            //ԈɂsXLbv͋Hł邩Axlocal_subscriberɃRs[ĂXLbv_waitingSubscriberɏ߂
            int current_millis = BellagioRoot.TimeManager.GetCurrentTimeMillis();
            bool skip_exists = false;

            foreach(SubscriberHost entry in local_subscribers) {
                IRealTimeDataSubscriber rs = entry.Subscriber as IRealTimeDataSubscriber;
                if(rs!=null && entry.ReserveTime+rs.ThinningTime > current_millis) { //ԈȂThinningTimeOԂ̂ł邱Ƃ͂Ȃ
                    _waitingSubscribers.Add(entry);
                    skip_exists = true;
                }
            }

            //̃[v̒RemovełȂ̂ɂ
            if(skip_exists) {
                foreach(SubscriberHost entry in _waitingSubscribers)
                    local_subscribers.Remove(entry);
            }
        }

        private void HandleException(SubscriberHost ds, Exception ex) {
            if(ds.LastException!=null) {
                Debug.WriteLine(ds.LastException.Message + " (in IDataSubscriber)");
                Debug.WriteLine(ds.LastException.StackTrace);
            }
            if(BUtil.UnderApplication)
                RuntimeUtil.ReportException(ex);
        }

        private Control GetMainThreadControl() {
            return BellagioRoot.MainThreadControl;
        }
#if UNITTEST
        public int SubscriberCount {
            get {
                return _periodicalSubscribers.Count + _realTimeSubscribers.Count;
            }
        }
#endif
        private static void SafeEndInvoke(Control c, IAsyncResult ar) {
            try {
                c.EndInvoke(ar);
            }
            catch(ObjectDisposedException) { //ObjectDisposedException݈̂Ԃ
            }
        }
    }

    public class TimeManager {
        public delegate void Tick(BTime time);
        private Timer _timer;
        private BTime _current;
        private int _step;
        private List<Tick> _listeners;
        private Tick _lastListener; //ʏ̂ƂɎsBDataSubscriberӂ

        public TimeManager() {
            _listeners = new List<Tick>();
            _timer = new Timer();
            _current = new BTime(0);
        }
        public BTime Current {
            get {
                return _current;
            }
        }
        public void SetLastListener(Tick t) {
            _lastListener = t;
        }
        //start̎stepbƂ̃Cxg𔭐Bratio͎ێԂɑ΂{ŁAPȂʏAQȂQ{
        public void StartLocalDataMode(BTime start, int step, double ratio) {
            _current = new BTime(start);
            _timer.Interval = (int)(step*1000/ratio);
            _timer.Tick += new EventHandler(OnLocalTick);
            _step = step;
            _timer.Start();
        }

        //GMOŎg^Cṽ^C}[
        //܂[JPC̎ŏAMINUTEʒm҂ď㏑(ManualSetTimeł悢)B܂AꂾƂPƂɂʒmȂ̂ŁAPbƂɒʒm𔭂悤ɂ
        public void InitMinutelyTickMode() {
            _timer.Interval = 1000;
            _timer.Tick += new EventHandler(OnSecondTick);
            _timer.Enabled = false;
        }
        internal void OnExternalMinutelyTick(BTime time) {
            if(BUtil.IsExecutingInMainThread)
                OnExternalMinutelyTickMain(time);
            else {
                Control c = BellagioRoot.MainThreadControl;
                if(!c.IsDisposed) c.Invoke(new ExternalMinutelyTickDelegate(OnExternalMinutelyTickMain), time);
            }
        }
        private delegate void ExternalMinutelyTickDelegate(BTime t);
        private void OnExternalMinutelyTickMain(BTime time) {
            if(_timer.Enabled) _timer.Stop();

            ManualSetTime(time);
            if(_timer.Enabled) _timer.Stop();
            _timer.Start(); //
        }
        private void OnSecondTick(object sender, EventArgs args) {
            try {
                //PbiށBObʒmƑOサđԂ߂邱Ƃ肤
                BTime time = new BTime(_current.AsInt() + 1);
                ManualSetTime(time);
                BellagioRoot.DataSourceHost.DoSecondlyTask(time);

            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }



        //DataSubscriberg~bPʂ̎B̃eXĝƂɂ͎蓮Zbgł悤ɂ
        public int GetCurrentTimeMillis() {
#if UNITTEST
            if(_unitTestCurrentTimeMillis!=0)
                return _unitTestCurrentTimeMillis;
            else
#endif
                return (int)(DateTime.Now.Ticks / 10000L); //100nsPʂŕԂ
        }
#if UNITTEST
        public int _unitTestCurrentTimeMillis;
#endif

        public void AddTimeManagerListener(Tick tick) {
            _listeners.Add(tick);
        }
        public void RemoveTimeManagerListener(Tick tick) {
            _listeners.Remove(tick);
        }
        public int TimerListenerCount {
            get {
                return _listeners.Count + (_lastListener==null? 0 : 1);
            }
        }
        public void StopTimer() {
            _timer.Stop();
        }
        private void OnLocalTick(object sender, EventArgs args) {
            try {
                //x݋XLbv
                int it = _current.AsInt();
                if(it > 3600*11 + 60*5 && it < 3600*11 + 60*10) //11:05`10̊Ԃɗ80Wv
                    _current.LetInt(it + 60*80);
                NotifyTimeListeners(_current.AsInt() + _step);
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
                throw ex;
            }
        }
        //UnitTestŁAO狭Ɏw肵ăeXg
        public void ManualSetTime(BTime time) {
            Debug.WriteIf(BDebugOpts.TRACE_TIME, String.Format("ManualSetTime {0}", BTime.FormatHHMMSS(time)));
            NotifyTimeListeners(time.AsInt());
        }

        //XV`B̓UpdateStock͋NȂȂADataSubscriber͓삷Kv̂ł̒lockƃVOiZbg͕Kvł
        private void NotifyTimeListeners(int newtime) {
            //PseudoStockIɍXV𔭍sĂԂɃA^Cf[^XbhĂ͍̂łŃbN
            lock(BellagioRoot.DataSubscriberManager) {
                _current.LetInt(newtime);

                //񋓒ɃRNVύX肤̂
                if(_listeners.Count > 0) {
                    Tick[] ticks = _listeners.ToArray();
                    foreach(Tick t in ticks) t(_current);
                }

                if(_lastListener!=null) _lastListener(_current); //DataSubscriber͍ŌɌĂ
            }
        }
    }

#if UNITTEST

    [TestFixture]
    public class DataSubscriberTests {
        private UnitTestSimpleDataSource _unitTestDataSource;

        [TestFixtureSetUp]
        public void Setup() {
            BellagioEnvironmentParam p = new BellagioEnvironmentParam();
            p.SetupForUnitTest();
            p.RUN_DATA_SUBSCRIBER_ENGINE = true;
            p.UNITTEST_STOCK_COUNT = 3;

            _unitTestDataSource = new UnitTestSimpleDataSource();

            BellagioRoot.Init(p);
            BellagioRoot.BootForTest();

            BellagioRoot.IntraDayTradeProvider.SetTickDataSource(_unitTestDataSource);
            BellagioRoot.ItaProvider.SetItaDataSource(_unitTestDataSource);
        }
        [TestFixtureTearDown]
        public void TearDown() {
            BellagioRoot.Terminate();
        }

        private void CompleteStockTicks(Stock stock) {
            _unitTestDataSource.TickHost.OnInitialPriceInfo(stock, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        }

        private class OneTime : IStockBasedDataSubscriber {
            private int _subscribeComplete;
            private int _subscribeFailed;
            private string _errorMessage;
            private Stock _stock;
            private SubscribeDataKind _dataKind;

            public OneTime(string code) {
                _stock = BellagioRoot.GlobalStockCollection.FindExact(code).Primary;
                _dataKind = SubscribeDataKind.Ticks;
            }

            public Stock Stock {
                get {
                    return _stock;
                }
            }


            void IStockBasedDataSubscriber.SubscribeComplete() {
                _subscribeComplete++;
            }
            void IStockBasedDataSubscriber.SubscribeFailed(string reason) {
                _subscribeFailed++;
                _errorMessage = reason;
            }

            public DataThreadToMainThread NotifyDelegate {
                get { return null; }
            }

            public int SubscribeCompleteCount {
                get {
                    return _subscribeComplete;
                }
            }
            public int SubscribeFailedCount {
                get {
                    return _subscribeFailed;
                }
            }
            public string ErrorMessage {
                get {
                    return _errorMessage;
                }
            }

            public void SetDataKind(SubscribeDataKind dk) {
                _dataKind = dk;
            }
        }
        private class RealTime : OneTime, IRealTimeDataSubscriber {
            private BTime _exepectedTime;
            private int _exepectedCount;
            private int _called;
            private int _thinningTime;

            public RealTime(string code)  : base(code) {
                _thinningTime = 0;
                _exepectedTime = new BTime(0);
            }

            public void Expect(BTime time, int count) {
                _exepectedTime = time;
                _exepectedCount = count;
            }

            public void RealTimeProcess(DataProcessArg arg) {
                //if(_exepectedTime.AsInt()!= arg.LocalTime.AsInt()) Debugger.Break();
                if(_exepectedCount!= arg.ProcessCount) Debugger.Break();
                
                Assert.AreEqual(1, this.SubscribeCompleteCount); //ڑłȂΎsȂ
                Assert.AreEqual(0, this.SubscribeFailedCount);
                Assert.AreEqual(_exepectedTime.AsInt(), arg.LocalTime.AsInt());
                Assert.AreEqual(_exepectedCount, arg.ProcessCount);
                _called++;
            }
            public int CalledCount {
                get {
                    return _called;
                }
            }

            public int ThinningTime {
                get {
                    return _thinningTime;
                }
            }
            public void SetThinningTime(int t) {
                _thinningTime = t;
            }
        }



        //ƎƂ둽ʂ邩Ȃ̂
        private class Periodical : IPeriodicalDataSubscriber {
            private BTime _exepectedTime;
            private int _exepectedCount;
            private int _called;

            public void Expect(BTime time, int count) {
                _exepectedTime = time;
                _exepectedCount = count;
            }

            public int IntervalSec {
                get { return 60; }
            }

            public void PeriodicalProcess(DataProcessArg arg) {
                Assert.AreEqual(_exepectedTime.AsInt(), arg.LocalTime.AsInt());
                Assert.AreEqual(_exepectedCount, arg.ProcessCount);
                _called++;
            }
            public int CalledCount {
                get {
                    return _called;
                }
            }

            public DataThreadToMainThread NotifyDelegate {
                get { return null; }
            }
        }

        private void SetTime(BTime t) {
            BellagioRoot.TimeManager.ManualSetTime(t); 
            BellagioRoot.DataSubscriberManager.ReserveExecByTime(t);
            BellagioRoot.DataSubscriberManager.WaitDataProcessComplete();
        }

        [Test]
        public void AddRemove() {
            _unitTestDataSource.ItaOpener = null;
            _unitTestDataSource.TickOpener = null;

            RealTime rt = new RealTime("1");
            Periodical pe = new Periodical();
            DataSubscriberManager dm = BellagioRoot.DataSubscriberManager;
            dm.AddRealtimeSubscriber(rt, new SubscribeRequest(rt.Stock, SubscribeDataKind.Ticks));
            dm.AddPeriodicalSubscriber(pe);
            Assert.AreEqual(3, dm.SubscriberCount); //PeriodicalȂƂēo^
            dm.RemoveSubscriber(rt);
            dm.RemoveSubscriber(pe);
            Assert.AreEqual(0, dm.SubscriberCount);
        }

        private AsyncOpResult _openValueResult_DataProviderConnection;
        private string _openValueMessage_DataProviderConnection;
        [Test]
        public void RealTimeConnection() {
            //RealTimeSubscriberAddSubscriberƂAf[^voC_Ƃ̊֌ẂA
            //I or 񓯊I@́@ or s@ŌvSʂłB̂ꂼłׂʒm񐔂ȂĂ邱ƂmF
            _unitTestDataSource.TickOpener = delegate(Stock stock, ref string message) {
                if(_openValueResult_DataProviderConnection==AsyncOpResult.Failed)
                    message = _openValueMessage_DataProviderConnection;
                else if(_openValueResult_DataProviderConnection==AsyncOpResult.Succeeded)
                    CompleteStockTicks(stock);
                return _openValueResult_DataProviderConnection;
            };

            DataSubscriberManager dm = BellagioRoot.DataSubscriberManager;
            ITickDataHost tick_host = BellagioRoot.IntraDayTradeProvider;
            SetTime(new BTime(0));

            //I
            BellagioRoot.IntraDayTradeProvider.CloseAll();
            _openValueResult_DataProviderConnection = AsyncOpResult.Succeeded;
            RealTime rt1 = new RealTime("1");
            Assert.AreEqual(0, rt1.SubscribeCompleteCount);
            Assert.AreEqual(0, rt1.SubscribeFailedCount);
            dm.AddRealtimeSubscriber(rt1, new SubscribeRequest(rt1.Stock, SubscribeDataKind.Ticks));
            Assert.AreEqual(1, rt1.SubscribeCompleteCount);
            Assert.AreEqual(0, rt1.SubscribeFailedCount);
            BellagioRoot.IntraDayTradeProvider.AssertStockEntry(rt1.Stock, 1, PrimaryDataStatus.OK);

            //Is
            BellagioRoot.IntraDayTradeProvider.CloseAll();
            _openValueResult_DataProviderConnection = AsyncOpResult.Failed;
            _openValueMessage_DataProviderConnection = "OPEN SYNC FAILED";
            RealTime rt2 = new RealTime("1");
            dm.AddRealtimeSubscriber(rt2, new SubscribeRequest(rt2.Stock, SubscribeDataKind.Ticks));
            Assert.AreEqual(0, rt2.SubscribeCompleteCount);
            Assert.AreEqual(1, rt2.SubscribeFailedCount);
            Assert.AreEqual("OPEN SYNC FAILED", rt2.ErrorMessage);
            BellagioRoot.IntraDayTradeProvider.AssertStockEntryIsNull(rt2.Stock);

            //񓯊I
            BellagioRoot.IntraDayTradeProvider.CloseAll();
            _openValueResult_DataProviderConnection = AsyncOpResult.Async;
            RealTime rt3 = new RealTime("1");
            dm.AddRealtimeSubscriber(rt3, new SubscribeRequest(rt3.Stock, SubscribeDataKind.Ticks));
            Assert.AreEqual(0, rt3.SubscribeCompleteCount);
            Assert.AreEqual(0, rt3.SubscribeFailedCount);
            BellagioRoot.IntraDayTradeProvider.AssertStockEntry(rt3.Stock, 1, PrimaryDataStatus.Preparing); 
            CompleteStockTicks(rt3.Stock);
            dm.WaitDataProcessComplete();
            Assert.AreEqual(1, rt3.SubscribeCompleteCount);
            Assert.AreEqual(0, rt3.SubscribeFailedCount);
            BellagioRoot.IntraDayTradeProvider.AssertStockEntry(rt3.Stock, 1, PrimaryDataStatus.OK);

            //񓯊Is
            BellagioRoot.IntraDayTradeProvider.CloseAll();
            _openValueResult_DataProviderConnection = AsyncOpResult.Async;
            RealTime rt4 = new RealTime("1");
            dm.AddRealtimeSubscriber(rt4, new SubscribeRequest(rt4.Stock, SubscribeDataKind.Ticks));
            Assert.AreEqual(0, rt4.SubscribeCompleteCount);
            Assert.AreEqual(0, rt4.SubscribeFailedCount);
            BellagioRoot.IntraDayTradeProvider.AssertStockEntry(rt4.Stock, 1, PrimaryDataStatus.Preparing);
            tick_host.OnConnectFailed(rt4.Stock, "OPEN ASYNC FAILED");
            dm.WaitDataProcessComplete();
            _openValueResult_DataProviderConnection = AsyncOpResult.Failed;
            Assert.AreEqual(0, rt4.SubscribeCompleteCount);
            Assert.AreEqual(1, rt4.SubscribeFailedCount);
            Assert.AreEqual("OPEN ASYNC FAILED", rt4.ErrorMessage);
            BellagioRoot.IntraDayTradeProvider.AssertStockEntryIsNull(rt4.Stock);

            dm.RemoveSubscriber(BellagioRoot.IntraDayTradeProvider.Lookup(rt4.Stock));
            dm.RemoveSubscriber(rt1);
            dm.RemoveSubscriber(rt2);
            dm.RemoveSubscriber(rt3);
            dm.RemoveSubscriber(rt4);
            Assert.AreEqual(0, dm.SubscriberCount);
            Assert.IsNull(dm.LastSubscriberException);

        }
        [Test]
        public void MultipleRealTimeConnection() {
            //ɑ΂镡Subscriber̐ڑ̏
            _unitTestDataSource.TickOpener = delegate(Stock stock, ref string message) {
                if(_openValueResult_DataProviderConnection==AsyncOpResult.Failed)
                    message = _openValueMessage_DataProviderConnection;
                else if(_openValueResult_DataProviderConnection==AsyncOpResult.Succeeded)
                    CompleteStockTicks(stock);
                return _openValueResult_DataProviderConnection;

            };

            DataSubscriberManager dm = BellagioRoot.DataSubscriberManager;
            ITickDataHost tick_host = BellagioRoot.IntraDayTradeProvider;

            //IA㑱Subscriber
            BellagioRoot.IntraDayTradeProvider.CloseAll();
            _openValueResult_DataProviderConnection = AsyncOpResult.Succeeded;
            RealTime rt11 = new RealTime("1");
            dm.AddRealtimeSubscriber(rt11, new SubscribeRequest(rt11.Stock, SubscribeDataKind.Ticks));
            Assert.AreEqual(1, rt11.SubscribeCompleteCount);
            Assert.AreEqual(0, rt11.SubscribeFailedCount);
            BellagioRoot.IntraDayTradeProvider.AssertStockEntry(rt11.Stock, 1, PrimaryDataStatus.OK);
            RealTime rt12 = new RealTime("1");
            dm.AddRealtimeSubscriber(rt12, new SubscribeRequest(rt12.Stock, SubscribeDataKind.Ticks));
            Assert.AreEqual(1, rt12.SubscribeCompleteCount);
            Assert.AreEqual(0, rt12.SubscribeFailedCount);
            BellagioRoot.IntraDayTradeProvider.AssertStockEntry(rt12.Stock, 2, PrimaryDataStatus.OK);
            dm.RemoveSubscriber(rt12);
            BellagioRoot.IntraDayTradeProvider.AssertStockEntry(rt12.Stock, 1, PrimaryDataStatus.OK);

            //QɐڑǍ񓯊ɐ
            BellagioRoot.IntraDayTradeProvider.CloseAll();
            _openValueResult_DataProviderConnection = AsyncOpResult.Async;
            RealTime rt21 = new RealTime("1");
            dm.AddRealtimeSubscriber(rt21, new SubscribeRequest(rt21.Stock, SubscribeDataKind.Ticks));
            RealTime rt22 = new RealTime("1");
            dm.AddRealtimeSubscriber(rt22, new SubscribeRequest(rt22.Stock, SubscribeDataKind.Ticks));
            BellagioRoot.IntraDayTradeProvider.AssertStockEntry(rt21.Stock, 2, PrimaryDataStatus.Preparing);
            CompleteStockTicks(rt21.Stock);
            dm.WaitDataProcessComplete();
            Assert.AreEqual(1, rt21.SubscribeCompleteCount);
            Assert.AreEqual(0, rt21.SubscribeFailedCount);
            Assert.AreEqual(1, rt22.SubscribeCompleteCount);
            Assert.AreEqual(0, rt22.SubscribeFailedCount);
            BellagioRoot.IntraDayTradeProvider.AssertStockEntry(rt21.Stock, 2, PrimaryDataStatus.OK);

            //QɐڑǍ񓯊Ɏs
            BellagioRoot.IntraDayTradeProvider.CloseAll();
            _openValueResult_DataProviderConnection = AsyncOpResult.Async;
            RealTime rt31 = new RealTime("1");
            dm.AddRealtimeSubscriber(rt31, new SubscribeRequest(rt31.Stock, SubscribeDataKind.Ticks));
            RealTime rt32 = new RealTime("1");
            dm.AddRealtimeSubscriber(rt32, new SubscribeRequest(rt32.Stock, SubscribeDataKind.Ticks));
            tick_host.OnConnectFailed(rt31.Stock, "MULTIPLE ASYNC FAIL");
            dm.WaitDataProcessComplete();
            Assert.AreEqual(0, rt31.SubscribeCompleteCount);
            Assert.AreEqual(1, rt31.SubscribeFailedCount);
            Assert.AreEqual(0, rt32.SubscribeCompleteCount);
            Assert.AreEqual(1, rt32.SubscribeFailedCount);
            BellagioRoot.IntraDayTradeProvider.AssertStockEntryIsNull(rt31.Stock);

            dm.RemoveSubscriber(BellagioRoot.IntraDayTradeProvider.Lookup(rt31.Stock));
            dm.RemoveSubscriber(rt11);
            dm.RemoveSubscriber(rt21);
            dm.RemoveSubscriber(rt22);
            dm.RemoveSubscriber(rt31);
            dm.RemoveSubscriber(rt32);
            Assert.AreEqual(0, dm.SubscriberCount);
            Assert.IsNull(dm.LastSubscriberException);
        }

        //TODO ̖xɐq˂ꍇ̎菇BGMOł͓ʎgȂB
        //ȂAЂƂSubscriberڑAIɐɎsɏo킵P[X~ςłĂȂB

        private AsyncOpResult _openValueResult_Ita;
        [Test]
        public void TickAndItaConnection() {
            //TICKƔ̗KvȂƂAɑď߂ĎsɂȂ邩ǂ
            _unitTestDataSource.TickOpener = delegate(Stock stock, ref string message) {
                if(_openValueResult_DataProviderConnection==AsyncOpResult.Failed)
                    message = _openValueMessage_DataProviderConnection;
                else if(_openValueResult_DataProviderConnection==AsyncOpResult.Succeeded)
                    CompleteStockTicks(stock);
                return _openValueResult_DataProviderConnection;
            };
            _unitTestDataSource.ItaOpener = delegate(Stock stock, ref string message) {
                Debug.Assert(_openValueResult_Ita==AsyncOpResult.Async); //܂͔ɂĂ͔񓯊̓ĂȂ
                return _openValueResult_Ita;
            };

            DataSubscriberManager dm = BellagioRoot.DataSubscriberManager;
            SetTime(new BTime(0));
            ITickDataHost tick_host = BellagioRoot.IntraDayTradeProvider;
            IItaDataHost ita_host = BellagioRoot.ItaProvider;

            //
            BellagioRoot.IntraDayTradeProvider.ClearAll();
            BellagioRoot.ItaProvider.ClearAll();
            _openValueResult_DataProviderConnection = AsyncOpResult.Async;
            _openValueResult_Ita = AsyncOpResult.Async;
            RealTime rt1 = new RealTime("1");
            rt1.SetDataKind(SubscribeDataKind.Ticks|SubscribeDataKind.Ita);
            dm.AddRealtimeSubscriber(rt1, new SubscribeRequest(rt1.Stock, SubscribeDataKind.Ita, SubscribeDataKind.Ticks));
            BellagioRoot.ItaProvider.AssertStockEntry(rt1.Stock, 1, PrimaryDataStatus.Preparing);
            ita_host.SetItaAll(rt1.Stock, new Ita(5, AskBid.Ask), new Ita(5, AskBid.Bid));
            dm.WaitDataProcessComplete();
            BellagioRoot.ItaProvider.AssertStockEntry(rt1.Stock, 1, PrimaryDataStatus.OK); 

            Assert.AreEqual(0, rt1.SubscribeCompleteCount);
            Assert.AreEqual(0, rt1.SubscribeFailedCount);

            CompleteStockTicks(rt1.Stock);
            dm.WaitDataProcessComplete();
            BellagioRoot.IntraDayTradeProvider.AssertStockEntry(rt1.Stock, 1, PrimaryDataStatus.OK);
            Assert.AreEqual(1, rt1.SubscribeCompleteCount); //ŊSɂȂ
            Assert.AreEqual(0, rt1.SubscribeFailedCount);

            //߂
            dm.RemoveSubscriber(rt1);
            dm.WaitDataProcessComplete();
            BellagioRoot.IntraDayTradeProvider.AssertStockEntryIsNull(rt1.Stock);
            BellagioRoot.ItaProvider.AssertStockEntryIsNull(rt1.Stock);
            
            //TODO Е̂ݐ̂̂ЂƂsƁAQƃJEgÕf[^cĂ܂
            dm.RemoveSubscriber(BellagioRoot.IntraDayTradeProvider.Lookup(rt1.Stock));
            dm.RemoveSubscriber(rt1);
            Assert.AreEqual(0, dm.SubscriberCount);
            Assert.IsNull(dm.LastSubscriberException);
        }

        [Test]
        public void PeriodicalCall() {
            _unitTestDataSource.ItaOpener = null;
            _unitTestDataSource.TickOpener = null;

            Periodical pe = new Periodical();
            DataSubscriberManager dm = BellagioRoot.DataSubscriberManager;
            dm.AddPeriodicalSubscriber(pe);
            Assert.AreEqual(0, pe.CalledCount);

            BTime t = new BTime(9, 0, 0);
            pe.Expect(t, 0);
            SetTime(t);

            Assert.AreEqual(1, pe.CalledCount); //s
            t = new BTime(9, 0, 30);
            SetTime(t);
            Assert.AreEqual(1, pe.CalledCount); //ł͎sꂸ
            t = new BTime(9, 1, 0);
            pe.Expect(t, 1);
            SetTime(t);
            Assert.AreEqual(2, pe.CalledCount); //XP̂Q
            t = new BTime(9, 2, 10);
            pe.Expect(t, 2);
            SetTime(t);
            Assert.AreEqual(3, pe.CalledCount); //XQ̂RځB10bI[o[ł\Ȃ
            t = new BTime(9, 3, 5);
            pe.Expect(t, 3);
            SetTime(t);
            Assert.AreEqual(4, pe.CalledCount); //XR̂SځB

            dm.RemoveSubscriber(pe);
            Assert.AreEqual(0, dm.SubscriberCount);
            Assert.IsNull(dm.LastSubscriberException);
        }

        [Test]
        public void RealTimeCall() {
            _unitTestDataSource.TickOpener = null;
            _unitTestDataSource.ItaOpener = null;

            Stock st1 = BellagioRoot.GlobalStockCollection.FindExact("1").Primary;
            Stock st2 = BellagioRoot.GlobalStockCollection.FindExact("2").Primary;
            RealTime rt1 = new RealTime("1");

            DataSubscriberManager dm = BellagioRoot.DataSubscriberManager;
            dm.AddRealtimeSubscriber(rt1, new SubscribeRequest(rt1.Stock, SubscribeDataKind.Ticks));
            Assert.AreEqual(0, rt1.CalledCount);

            BTime t = new BTime(9, 0, 0);
            rt1.Expect(t, 0);
            SetTime(t);
            Assert.AreEqual(1, rt1.CalledCount); //OneTimeł邱Ƃɂs

            rt1.Expect(t, 1);
            dm.ReserveExecByStock(st1, SubscribeDataKind.Ticks);
            dm.WaitDataProcessComplete();
            Assert.AreEqual(2, rt1.CalledCount);

            rt1.Expect(t, 2);
            //QReserveExecĂs͂P
            lock(dm) {
                dm.ReserveExecByStock(st1, SubscribeDataKind.Ticks);
                dm.ReserveExecByStock(st1, SubscribeDataKind.Ticks);
            }
            dm.WaitDataProcessComplete();
            Assert.AreEqual(3, rt1.CalledCount);

            //Ⴄ͉eȂ
            dm.ReserveExecByStock(st2, SubscribeDataKind.Ticks);
            dm.WaitDataProcessComplete();
            Assert.AreEqual(3, rt1.CalledCount);

            dm.RemoveSubscriber(BellagioRoot.IntraDayTradeProvider.Lookup(rt1.Stock));
            dm.RemoveSubscriber(rt1);
            Assert.AreEqual(0, dm.SubscriberCount);
            Assert.IsNull(dm.LastSubscriberException);
        }

        [Test]
        public void Thinning() {
            _unitTestDataSource.ItaOpener = null;
            _unitTestDataSource.TickOpener = null;

            RealTime rt1 = new RealTime("1");
            rt1.SetThinningTime(500);
            BellagioRoot.TimeManager._unitTestCurrentTimeMillis = 1000;
            DataSubscriberManager dm = BellagioRoot.DataSubscriberManager;
            dm.AddRealtimeSubscriber(rt1, new SubscribeRequest( rt1.Stock, SubscribeDataKind.Ticks));
            Assert.AreEqual(0, rt1.CalledCount);
            BTime t = new BTime(9, 0, 0);
            BellagioRoot.TimeManager.ManualSetTime(t);
            
            dm.ReserveExec(rt1);
            dm.WaitDataProcessComplete();
            Assert.AreEqual(0, rt1.CalledCount); //܂sĂȂ
            rt1.Expect(t, 0);
            BellagioRoot.TimeManager._unitTestCurrentTimeMillis = 1500;
            dm.WaitDataProcessComplete();
            Assert.AreEqual(1, rt1.CalledCount); //Ŏs

            dm.ReserveExec(rt1);
            dm.WaitDataProcessComplete();
            Assert.AreEqual(1, rt1.CalledCount); //܂P

            BellagioRoot.TimeManager._unitTestCurrentTimeMillis = 0; //[h߂
            dm.RemoveSubscriber(BellagioRoot.IntraDayTradeProvider.Lookup(rt1.Stock));
            dm.RemoveSubscriber(rt1);

            dm.CancelWaitingSubscribers();
            Assert.AreEqual(0, dm.SubscriberCount);
            Assert.IsNull(dm.LastSubscriberException);
        }


    }

    //̑̃jbgeXgpPf[^\[X
    public class UnitTestSimpleDataSource : ITickDataSource, IItaDataSource {
        public delegate AsyncOpResult OpenDelegate(Stock stock, ref string message);
        private ITickDataHost _tickHost;

        private OpenDelegate _tickOpener;
        private OpenDelegate _itaOpener;

        public UnitTestSimpleDataSource() {
        }
        public OpenDelegate TickOpener {
            get {
                return _tickOpener;
            }
            set {
                _tickOpener = value;
            }
        }
        public OpenDelegate ItaOpener {
            get {
                return _itaOpener;
            }
            set {
                _itaOpener = value;
            }
        }
        public ITickDataHost TickHost {
            get {
                return _tickHost;
            }
        }

        void IPrimaryStreamDataBase.Prepare(IPrimaryStreamDataHostBase site) {
            if(_tickHost==null) //1xZbgȂ
                _tickHost = site as ITickDataHost;
        }

        void IPrimaryStreamDataBase.Terminate() {
        }
        AsyncOpResult IItaDataSource.OpenItaData(Stock stock, ref string message) {
            return _itaOpener==null? AsyncOpResult.Succeeded : _itaOpener(stock, ref message);
        }

        void IItaDataSource.CloseItaData(Stock stock) {
        }

        AsyncOpResult ITickDataSource.OpenTickData(Stock stock, ref string message) {
            if(_tickOpener==null) {
                _tickHost.OnInitialPriceInfo(stock, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
                return AsyncOpResult.Succeeded;
            }
            else {
                return _tickOpener(stock, ref message);
            }
        }

        void ITickDataSource.CloseTickData(Stock stock) {
        }
        Poderosa.IAdaptable Poderosa.IAdaptable.GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }

    }

#endif
}
