/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/StockDataProviderBase.cs#10 $
 * $DateTime: 2008/05/14 13:05:12 $
 * L[ɂf[^W߁AILbV̋@\񋟂BDataSubscriberPrimaryDatåԂ̃CɓB
 * ݂́AETickE̂ȐɂĔhNXŒ񋟂
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

#if UNITTEST
using NUnit.Framework;
#endif

namespace Bellagio.Data {
    public enum AsyncOpResult { 
        Succeeded, Failed, Async
    }

    public abstract class StockDataProviderBaseT<PD, INIT> where PD : StockPrimaryData where INIT : IStockPrimaryDataInitializer {
        public delegate void ResultNotifierDeleagate(Stock stock, AsyncOpResult result, string msg);

        protected class StockTag {
            public Stock stock;
            public int count; //SubscriberƂPAIƂPB0ɂȂPrimaryDataɏIʒm
            public PD value;
            public INIT initializer; //PDɑΉ鏉葱IuWFNg
        }
        protected Dictionary<Stock, StockTag> _data;
        private ResultNotifierDeleagate _notifier;

        public StockDataProviderBaseT() {
            _data = new Dictionary<Stock, StockTag>();
        }
        //f[^΂ԂAȂnullԂ
        public PD Lookup(Stock stock) {
            lock(this) {
                StockTag e = GetTagOrNull(stock);
                return (e!=null && e.value.DataChangeTag.IsOK)? e.value : null;
            }
        }

        //Subscribeʒʒmnh̓o^@NG
        public ResultNotifierDeleagate ResultNotifier {
            get {
                Debug.Assert(_notifier==null);
                return _notifier;
            }
            set {
                _notifier = value;
            }
        }

        //f[^΂ԂAȂnullԂB
        //ȂΎ擾JnB񓯊Ɏ擾ꍇAʂ͔񓯊DataSubscriberɓ`
        public virtual AsyncOpResult Open(Stock stock, ref PD value, ref string message) {
            Debug.Assert(stock!=null);
            lock(this) {
                StockTag e = GetTagOrNull(stock);
                if(e!=null) {
                    Debug.Assert(e.value!=null);
                    PrimaryDataStatus st = e.value.DataStatus;
                    if(st==PrimaryDataStatus.OK) {
                        value = e.value;
                        e.count++;
                        return AsyncOpResult.Succeeded;
                    }
                    else if(st==PrimaryDataStatus.Preparing) { //ł邩炻̂
                        e.count++;
                        return AsyncOpResult.Async;
                    }
                }

                //ȊO͐VK쐬Kv
                value = CreateValue(stock);
                Debug.Assert(value.DataChangeTag.Status==PrimaryDataStatus.Initial);
                e = new StockTag();
                e.stock = stock;
                e.initializer = CreateInitializer(value);
                e.value = value;
                _data.Add(stock, e); //OpenValuêȂœIɏP[X(ƂUnittest)lĂŃ}bv͍

                AsyncOpResult result = OpenValue(e.initializer, ref message);
                if(result==AsyncOpResult.Failed) {
                    _data.Remove(stock);
                    e.value.DataChangeTag.SetErrorStatus(message);
                }
                else if(result==AsyncOpResult.Async) { //initializerԂ݂Ă
                    e.value.DataChangeTag.SetStatus(PrimaryDataStatus.Preparing);
                    e.count++;
                }
                else {
                    Debug.Assert(result==AsyncOpResult.Succeeded);
                    e.count++;
                }
                

                return result;
            }
        }

        //JEgP₵āA[X܂ŉ邱Ƃh
        public void AddRef(Stock stock) {
            lock(this) {
                StockTag e = GetTagOrNull(stock);
                Debug.Assert(e!=null); //쐬ς݂łȂƂȂ
                Debug.Assert(e.value!=null);
                Debug.Assert(e.count >= 0);
                e.count++;
            }
        }

        //I[vStockXgԂAPreparingɂ
        public List<PD> PrepareResume() {
            return null;
            /*
            List<PD> r = new List<PD>();
            lock(this) {
                foreach(KeyValuePair<Stock, StockTag> p in _data) {
                    if(p.Value.status==EntryStatus.OK || p.Value.status==EntryStatus.Preparing) {
                        r.Add(p.Value.value);
                        p.Value.status = EntryStatus.Preparing;
                    }
                }
            }

            return r;
            */
        }
        //ResumeJn
        public AsyncOpResult Resume(PD value, ref string msg) {
            return AsyncOpResult.Failed;
        }



        //\[Xԋp
        public void Release(Stock stock) {
            lock(this) {
                StockTag e = GetTagOrNull(stock);
                //{̞͂B͂悭ȂBAsReleaseOシ邱Ƃ͂肤
                if(e==null) return;
                Debug.Assert(e.count > 0);
                e.count--;
                //TODO QƃJEgOɂȂƂđ؂ƍĐڑȂǂŎԂ邩Ȃ
                if(e.count==0) {
                    CloseValue(stock, e.value);
                    _data.Remove(stock);
                }
            }
        }

        protected StockTag GetTagOrNull(Stock stock) {
            //GetOrOpen烊^[Oɔ񓯊Ƀf[^ꍇłAMapInitialDatałʂ̂ŃubNB]GetOrOpen̊f[^Ȃ͕̂ۏ؂ĂB
            lock(this) {
                StockTag e;
                if(_data.TryGetValue(stock, out e))
                    return e;
                else
                    return null;
            }
        }


#if UNITTEST
        //eXgł̂ݎgpBEntry̓ԂmF
        public void AssertStockEntry(Stock stock, int refcount, PrimaryDataStatus status) {
            StockTag e = GetTagOrNull(stock);
            Assert.IsNotNull(e);
            Assert.AreEqual(refcount, e.count);
            Assert.AreEqual(status, e.value.DataStatus);
        }
        public void AssertStockEntryIsNull(Stock stock) {
            StockTag e = GetTagOrNull(stock);
            Assert.IsNull(e);
        }
#endif
        public void ClearAll() {
            _data.Clear();
        }

        //DataProvidervf쐬
        protected abstract PD CreateValue(Stock stock);
        protected abstract INIT CreateInitializer(PD value);

        //f[^쐬BʂƂĂ͎̂RN肤
        //
        //s(errorɃbZ[W)
        //񓯊Jn
        protected abstract AsyncOpResult OpenValue(INIT initializer, ref string error);
        protected abstract void CloseValue(Stock stock, PD value);

        //񓯊Ƀf[^擾鑀삪Ƃʒm
        protected void CompleteLoading(Stock stock) {
            StockTag e = GetTagOrNull(stock);
            Debug.Assert(e!=null && e.value.DataChangeTag.IsInitialOrPreparing);
            e.value.DataChangeTag.SetStatus(PrimaryDataStatus.OK);
            if(_notifier!=null) _notifier(stock, AsyncOpResult.Succeeded, null);
            e.value.FireDataUpdateEvent();
        }
        protected void FailLoading(Stock stock, string msg) {
            StockTag e = GetTagOrNull(stock);
            Debug.Assert(e!=null && e.value.DataChangeTag.IsInitialOrPreparing);
            if(_notifier!=null) _notifier(stock, AsyncOpResult.Failed, msg);
            e.value.DataChangeTag.SetErrorStatus(msg);
            _data.Remove(stock);
            e.value.FireErrorEventToSubscriberManager(msg);
        }
    }
}
