/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Environment/GeneralOptionPanel.cs#5 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * Sʐݒ̃IvVpl
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;

using Bellagio.Forms;
using Travis.LocationOperation;
using Poderosa.Usability;
using Poderosa.Preferences;

namespace Bellagio.Environment {
    public class GeneralOptionPanelExtension : IOptionPanelExtension {
        private GeneralOptionPanel _panel;

        public string Caption {
            get {
                return "S";
            }
        }

        public System.Drawing.Image Icon {
            get {
                //ڑACRƂ
                return BellagioRoot.CommonIcons.LargeSessions.GetBitmap(
                    BellagioVersionInfo.EDITION==BellagioEditions.HatchukunTX? 9 : 6
                    );
            }
        }

        public string[] PreferenceFolderIDsToEdit {
            get {
                return new string[] { "tactico.common" };
            }
        }

        public Panel ContentPanel {
            get {
                return _panel;
            }
        }

        public void InitiUI(IPreferenceFolder[] values) {
            if(_panel==null) _panel = new GeneralOptionPanel();
            _panel.InitUI(values[0]);
        }

        public bool Commit(IPreferenceFolder[] values) {
            return _panel.Commit(values[0]);
        }

        public void Dispose() {
            if(_panel!=null) _panel.Dispose();
        }

    }

    public class GeneralOptionPanel : Panel {
        private CheckBox _askClose;
        private CheckBox _openBookmarkWithNewTab;

        public GeneralOptionPanel() {
            _askClose = new CheckBox();
            _askClose.Text = String.Format("{0}IɊmFbZ[W\(&A)", BellagioVersionInfo.APPLICATION_CAPTION);
            _askClose.Size = new Size(400, 19);
            _askClose.Location = new Point(8, 8);

            _openBookmarkWithNewTab = new CheckBox();
            _openBookmarkWithNewTab.Text = "ubN}[N`[gJƂV^ug(&B)";
            _openBookmarkWithNewTab.Size = new Size(400, 19);
            _openBookmarkWithNewTab.Location = new Point(8, 32);

            this.Controls.Add(_askClose);
            this.Controls.Add(_openBookmarkWithNewTab);
        }

        public void InitUI(IPreferenceFolder f) {
            FixedPreferences fp = BellagioRoot.FixedPreferences;
            _askClose.Checked = f.ChildAt(fp.AskQuitItem.Index).AsItem().AsBool().Value;
            _openBookmarkWithNewTab.Checked = f.ChildAt(fp.OpenBookMarkWithNewTabItem.Index).AsItem().AsBool().Value;
        }

        public bool Commit(IPreferenceFolder f) {
            FixedPreferences fp = BellagioRoot.FixedPreferences;
            f.ChildAt(fp.AskQuitItem.Index).AsItem().AsBool().Value = _askClose.Checked;
            f.ChildAt(fp.OpenBookMarkWithNewTabItem.Index).AsItem().AsBool().Value = _openBookmarkWithNewTab.Checked;
            
            return true;
        }
    }

}
