﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

using Poderosa;
using Poderosa.Plugins;
using Poderosa.Commands;

using Bellagio.Environment;

//外部データ取得のメニューとコマンド

namespace Bellagio.ExternalData {
    public class ExternalDataCommands {
        private IGeneralCommand _showDataStatusDialogCommand;

        public void Init(ICoreServices cs, IExtensionPoint toolmenu) {
            _showDataStatusDialogCommand = new GeneralCommandImpl("tactico.externalData.showStatusDialog", "スクリーニング用外部データの状態表示", cs.CommandManager.CommandCategories.Dialogs, new ExecuteDelegate(ShowDataStatusDialog));

            cs.CommandManager.Register(_showDataStatusDialogCommand);

            toolmenu.RegisterExtension(new PoderosaMenuGroupImpl(new IPoderosaMenu[] {
                new PoderosaMenuItemImpl(_showDataStatusDialogCommand, "外部データ(&E)...")}));
        }

        private static CommandResult ShowDataStatusDialog(ICommandTarget target) {
            ExternalDataStats stats = new ExternalDataStats();
            stats.ShowDialog();
            stats.Dispose();
            return CommandResult.Succeeded;
        }
    }
}
