/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/DragDropSupport.cs#3 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

using System.Runtime.InteropServices;

using Bellagio.Data;

namespace Bellagio.Ordering {
    //ŃhbOhbvIuWFNg
    public class OrderDraggingInfo {
        public enum CursorStatusT {
            None,
            Ordering,
            Reserving

        }
        private Form _sourceForm; //tH[łDrag&DropłȂ悤
        private Stock _stock;
        private int _sashine; //ʂ͎wlȊOhbO邱Ƃ͍lȂ

        //hbÕC[W@ŏnullŒx쐬
        //
        // WinXPł́AcƂ48sNZ𒴂TCYł͂Ȃ͗lłB
        private Bitmap _dragImage;
        private IntPtr _dragImageHIcon;
        private Bitmap _orderImage;
        private IntPtr _orderImageHIcon;
        private Bitmap _reserveImage;
        private IntPtr _reserveImageHIcon;

        private CursorStatusT _cursorStatus;

        //Win32
        [DllImport("user32.dll", CharSet=CharSet.Auto)]
        extern static bool DestroyIcon(IntPtr handle);

        public OrderDraggingInfo(Form owner, Stock stock, int sashine) {
            _sourceForm = owner;
            _stock = stock;
            _sashine = sashine;
            _cursorStatus = CursorStatusT.None;
        }

        public int Sashine {
            get {
                return _sashine;
            }
        }
        public Stock Stock {
            get {
                return _stock;
            }
        }
        public Form SourceForm {
            get {
                return _sourceForm;
            }
        }
        public CursorStatusT CursorStatus {
            get {
                return _cursorStatus;
            }
            set {
                _cursorStatus = value;
            }
        }

        public void Dispose() {
            if(_dragImage!=null) {
                _dragImage.Dispose();
                DestroyIcon(_dragImageHIcon);
            }
            if(_orderImage!=null) {
                _orderImage.Dispose();
                DestroyIcon(_orderImageHIcon);
            }
            if(_reserveImage!=null) {
                _reserveImage.Dispose();
                DestroyIcon(_reserveImageHIcon);
            }
        }

        public Image GetDragImage(Control target) {
            if(_dragImage==null) {
                _dragImage = CreateDragDropImage(target, CursorStatusT.None, _sashine);
                /*
                const int cursor_area_width = 16;
                Font font = new Font(FontFamily.GenericSansSerif, 11.0F);
                Graphics g = target.CreateGraphics();
                string sashine_text = String.Format("wl {0:N0}~", _sashine);
                SizeF szf = g.MeasureString(sashine_text, font);
                _dragImage = new Bitmap((int)szf.Width + 4 + cursor_area_width, (int)szf.Height + 4, System.Drawing.Imaging.PixelFormat.Format32bppArgb);
                g.Dispose();

                g = Graphics.FromImage(_dragImage);
                Cursor cs = Cursors.Default;
                cs.Draw(g, new Rectangle(0, 0, cs.Size.Width, cs.Size.Height));
                Rectangle text_rect = new Rectangle(cursor_area_width, 0, _dragImage.Width-16, _dragImage.Height);
                g.FillRectangle(Brushes.Black, text_rect);
                g.DrawRectangle(Pens.DarkGreen, text_rect.X, text_rect.Y, text_rect.Width-1, text_rect.Height-1);
                g.DrawString(sashine_text, font, Brushes.Gold, cursor_area_width+2, 2);
                g.Dispose();
                font.Dispose();
                */
                _dragImageHIcon = _dragImage.GetHicon();
            }

            return _dragImage;
        }
        public Image GetOrderDropImage(Control target) {
            if(_orderImage==null) {
                _orderImage = CreateDragDropImage(target, CursorStatusT.Ordering, _sashine);// CreateDropImage(target, String.Format(" {0:N0}~", _sashine));
                _orderImageHIcon = _orderImage.GetHicon();
            }
            return _orderImage;
        }
        public Image GetReserveDropImage(Control target) {
            if(_reserveImage==null) {
                _reserveImage = CreateDragDropImage(target, CursorStatusT.Reserving, _sashine); //CreateDropImage(target, String.Format("\ {0:N0}~", _sashine));
                _reserveImageHIcon = _reserveImage.GetHicon();
            }
            return _reserveImage;
        }
        private Bitmap CreateDragDropImage(Control target, CursorStatusT status, int sashine) {
            Font font = SystemFonts.DefaultFont;
            string price_string; //̂ŏa
            if(sashine < 10000)
                price_string = String.Format("{0:N0}~", sashine);
            else
                price_string = sashine.ToString();

            Graphics g = target.CreateGraphics();
            SizeF szf = g.MeasureString(price_string, font);
            Bitmap bmp = new Bitmap(Math.Min(48, (int)szf.Width + 4), 32, System.Drawing.Imaging.PixelFormat.Format32bppArgb);
            g.Dispose();

            g = Graphics.FromImage(bmp);
            Rectangle text_rect = new Rectangle(0, 0, bmp.Width, bmp.Height);
            g.FillRectangle(Brushes.Black, text_rect);
            g.DrawRectangle(Pens.DarkGreen, text_rect.X, text_rect.Y, text_rect.Width-1, text_rect.Height-1);
            g.DrawString(status==CursorStatusT.None? "wl" : status==CursorStatusT.Ordering? "" : "\", font,
                status==CursorStatusT.None? Brushes.Gold : Brushes.Red, 2, 3);
            g.DrawString(price_string, font, Brushes.Gold, 2, 16);
            g.Dispose();

            return bmp;
        }

        public IntPtr DraggingHIcon {
            get {
                Debug.Assert(_dragImageHIcon!=IntPtr.Zero);
                return _dragImageHIcon;
            }
        }
        public IntPtr OrderingHIcon {
            get {
                Debug.Assert(_orderImageHIcon!=IntPtr.Zero);
                return _orderImageHIcon;
            }
        }
        public IntPtr ReservingHIcon {
            get {
                Debug.Assert(_reserveImageHIcon!=IntPtr.Zero);
                return _reserveImageHIcon;
            }
        }
        public IntPtr GetCurrentHIcon() {
            if(_cursorStatus==CursorStatusT.Reserving)
                return this.ReservingHIcon;
            else if(_cursorStatus==CursorStatusT.Ordering)
                return this.OrderingHIcon;
            else
                return this.DraggingHIcon;
        }

        //ɂ͂P̃CX^XhbOłȂ
        private static OrderDraggingInfo _draggingInfo;
        public static OrderDraggingInfo StartDrag(Form owner, Stock stock, int sashine) {
            if(_draggingInfo!=null) _draggingInfo.Dispose();
            _draggingInfo = new OrderDraggingInfo(owner, stock, sashine);
            return _draggingInfo;
        }
        public static void ClearCurrentDragging() {
            if(_draggingInfo!=null) _draggingInfo.Dispose();
            _draggingInfo = null;
        }
        public static OrderDraggingInfo CurrentDraggingInfo {
            get {
                return _draggingInfo;
            }
        }
    }
}
