/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/OrderForm.cs#25 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * tH[
 */
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Resources;
using System.Diagnostics;

using Travis.LocationOperation;
using Poderosa;

using Bellagio.Common;
using Bellagio.Data;
using Bellagio.Forms;
using Bellagio.Chart;
using Bellagio.Environment;
using Bellagio.Values;
using Bellagio.Drawing;

using Poderosa.Sessions;
using Poderosa.Forms;
using Poderosa.Commands;

namespace Bellagio.Ordering {
    public class OrderForm : Form {

        private OrderFormParameter _parameter; //tH[̓߂
        private OrderControl _orderPanel; //Cpl
        private Size _defaultMinimumSize;

        private Color _backColor;
        private Color _foreColor;

        private ToolTip _toolTip;

        //Piځ@E`[g\XCb`
        private CheckBox _itaButton;
        private CheckBox _minutelyChartButton;
        private CheckBox _dailyChartButton;
        private Label _separator1;


        //POiځ@ۗELZE
        private RibbonMenuButton _reserveButton;
        private RibbonMenuButton _cancelButton;
        private RibbonMenuButton _orderButton;

        //zu
        private RectangleOperator _regularMainRectOp;         //gbvx(ʏ)
        private RectangleOperator _gridMainRectOp;          //gbvx(ԍς̏ڍׂ̃Obhgp)
        private RectangleOperator _toolButtonRectOp;
        private BRect _toolButtonRect;
        private RectangleOperator _orderButtonRectOp;
        private BRect _orderButtonRect;                 //E~{^

        //ƃ`[g̃Rg[
        private ChartControl _dailyChart;
        private ChartControl _minutelyChart;
        private ItaControl _itaControl;

        private AbstractStockProfile _stockProfile;


        public OrderForm() {
            StaticInit();

            this.Icon = BellagioRoot.CommonIcons.AppIcon16;
            this.ShowInTaskbar = false;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.StartPosition = FormStartPosition.Manual;
            //this.Font = new Font("lr SVbN", 9F);
            //TODO DisposeAݒ肪ʉĂ̂ŉƂ

            _orderButtonRect = new BRect();
            _toolButtonRect = new BRect();

            this.FormBorderStyle = FormBorderStyle.Sizable;
            _backColor = Color.Black;
            _foreColor = Color.White;
            
            _orderPanel = new OrderControl(null);
            _orderPanel.OrderContentChanged += delegate() { }; //󕶂ł
            //_orderPanel.StockChanged += new OrderControl.StockChangedDelegate(SetCurrentStock);
            _orderPanel.SuspendLayout();

            //MouseEventHandler chart_or_ita_click = new MouseEventHandler(OnChartOrItaButtonClick);
            EventHandler chart_or_ita_click = new EventHandler(OnChartOrItaButtonClick);

            //摜index̓n[hR[fBOȂ̂Œ
            _itaButton = FormUtil.CreateImageAndTextToggleButton(LargeBitmap(5), ">> ", chart_or_ita_click);
            _minutelyChartButton = FormUtil.CreateImageAndTextToggleButton(LargeBitmap(4), ">> ", chart_or_ita_click);
            _dailyChartButton = FormUtil.CreateImageAndTextToggleButton(LargeBitmap(3), ">> ", chart_or_ita_click);
            _separator1 = FormUtil.CreateSeparatorAsLabel();

            _reserveButton = FormUtil.CreateRibbonCommandButton("\", LargeBitmap(2), new MouseEventHandler(OnReserveButtonClick));
            _cancelButton = FormUtil.CreateRibbonCommandButton("", LargeBitmap(1), new MouseEventHandler(OnCancelButtonClick));
            _cancelButton.DialogResult = DialogResult.Cancel;
            _orderButton = FormUtil.CreateRibbonCommandButton("", LargeBitmap(0), new MouseEventHandler(OnOrderButtonClick));
            _orderButton.DialogResult = DialogResult.OK;

            this.Controls.AddRange(new Control[] {
                _reserveButton, _orderButton, _cancelButton,
                _orderPanel,
                _itaButton, _minutelyChartButton, _dailyChartButton, _separator1,
            });


            //zu ϐ͕poȂ̂ŒZĂ
            int toolbutton_w = 88; //`[gE\p{^
            int toolbutton_h = 40;
            int m = 8; //W̃Rg[ԃ}[W
            const int cmd_w = 52; //R}h{^TCY
            const int cmd_h = 52;
            //int rib_w = 52; //摜t{̃TCY
            //int rib_h = 48;

            //ZNVƂRectOp
            _toolButtonRectOp = new RectangleOperatorBuilder()
                .SplitFixed(SplitDir.Top, toolbutton_h+4)
                    .CornerOffset(RectCorner.TopRight, -(toolbutton_w + 4), 4, toolbutton_w, toolbutton_h).ProbeControl(_dailyChartButton)
                    .LocateSide(SplitDir.Left, m, toolbutton_w, toolbutton_h).ProbeControl(_minutelyChartButton)
                    .LocateSide(SplitDir.Left, m, toolbutton_w, toolbutton_h).ProbeControl(_itaButton)
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, 8)
                    .Shrink(3).ProbeControl(_separator1).CloseBranch()
                .Finish();
            _orderButtonRectOp = new RectangleOperatorBuilder()
                .SplitFixed(SplitDir.Bottom, cmd_h+8)
                    .SplitFixed(SplitDir.Left, cmd_w+m)
                        .CornerOffset(RectCorner.TopLeft, m, 4, cmd_w, cmd_h).ProbeControlManualVisible(_reserveButton)
                        .CloseBranch()
                    .CornerOffset(RectCorner.TopRight, -cmd_w-m, 4, cmd_w, cmd_h).ProbeControl(_cancelButton)
                    .LocateSide(SplitDir.Left, m, cmd_w, cmd_h).ProbeControl(_orderButton)
                    .CloseBranch()
                .Finish();

            const int toolH = 52;
            const int orderButtonH = cmd_h + 8;
            _defaultMinimumSize = new Size(_orderPanel.Width + (this.Width-this.ClientSize.Width), _orderPanel.Height + toolH + orderButtonH + (this.Height-this.ClientSize.Height));

            //[gRectOṕAԍώƒʏňقȂ̂QޗpӂĂ
            _regularMainRectOp = new RectangleOperatorBuilder()
                .SplitFixed(SplitDir.Left, 360)
                    .SplitFixed(SplitDir.Top, toolH).ProbeBRect(_toolButtonRect).CloseBranch()
                    .SplitFixed(SplitDir.Top, _orderPanel.AdditionalPanelHeight).ProbeControl(_orderPanel).CloseBranch()
                    .ProbeBRect(_orderButtonRect)
                .CloseBranch()
                .Finish();
            _gridMainRectOp = new RectangleOperatorBuilder()
                .SplitFixed(SplitDir.Left, 360)
                    .SplitFixed(SplitDir.Top, toolH).ProbeBRect(_toolButtonRect).CloseBranch() //͓
                    .SplitFixed(SplitDir.Bottom, orderButtonH).ProbeBRect(_orderButtonRect).CloseBranch()
                    .ProbeControl(_orderPanel)
                .CloseBranch()
                .Finish();

            this.CancelButton = _cancelButton;
            this.AcceptButton = _orderButton;

            _orderPanel.ResumeLayout();

            _toolTip = new ToolTip();
            InitToolTipText();
        }

        public ChartControl RealtimeChart {
            get {
                return _minutelyChart;
            }
        }
        public ItaControl ItaControl {
            get {
                return _itaControl;
            }
        }

        protected override void OnResize(EventArgs e) {
            base.OnResize(e);
            ManualResize();
        }
        private void ManualResize() {
            this.SuspendLayout();
            LayoutCharts();
            if(_orderPanel.IsGridVisible)
                _gridMainRectOp.Rect(this.ClientRectangle);
            else
                _regularMainRectOp.Rect(this.ClientRectangle);

            _toolButtonRectOp.Rect(_toolButtonRect.Value);
            _orderButtonRectOp.Rect(_orderButtonRect.Value);
            //OrderPanel͎̃TCYCxgɂ

            this.ResumeLayout();
        }

        //L[{[hnh
        protected override bool ProcessDialogKey(Keys keyData) {
            Keys k = keyData & Keys.KeyCode;
            
            if(k==Keys.F6 && _itaButton.Enabled) ToggleChartOrItaButton(_itaButton);
            if(k==Keys.F7 && _minutelyChartButton.Enabled) ToggleChartOrItaButton(_minutelyChartButton);
            if(k==Keys.F8 && _dailyChartButton.Enabled) ToggleChartOrItaButton(_dailyChartButton);
            if(k==Keys.F9 && _reserveButton.Visible) OnReserveButtonClick(null, null);
            if(keyData==(Keys.Control|Keys.R) && _reserveButton.Enabled) OnReserveButtonClick(_reserveButton, null);
            
            if(k==Keys.Escape) {
                InternalHide();
                return true;
            }
            if(k==Keys.Enter) {
                OnOrderButtonClick(null, null); //ڍׂĂƂ͍
                return true;
            }

            return base.ProcessDialogKey(keyData);
        }

        //\[Xj͂Ȃ悤OnFormClosingɂHideBJƂ邩Ȃ
        protected override void OnFormClosing(FormClosingEventArgs e) {
            base.OnFormClosing(e);
            if(!BellagioPlugin.Instance.PoderosaApplication.IsExitingApplication) {
                e.Cancel = true;
                InternalHide();
            }
        }
        private void InternalHide() {
            this.Hide();
            HideAllChartAndItaControls();
            IPoderosaMainWindow w = BellagioPlugin.Instance.ActivePoderosaWindow;
            if(w!=null) w.AsForm().Activate();
        }

        protected override void  OnVisibleChanged(EventArgs e) {
 	        base.OnVisibleChanged(e);
            //if(_codeBox.EnabledEx) _codeBox.Focus(); //͂łƂ͗D

            if(this.Visible) Invalidate(true);
#if false
            if(this.Visible) {
                 //ANeBuȂΖZbg
                 IPoderosaDocument active_document = BellagioPlugin.Instance.ActivePoderosaWindow.DocumentTabFeature.ActiveDocument;
                 if(active_document!=null) {
                     ChartSessionBase sb = active_document.OwnerSession as ChartSessionBase;
                     if(sb!=null) {
                         AbstractStock stock = sb.CurrentStock;
                         if(stock!=null) {
                             _codeBox.SetTextEx(CodeDropDownDataProvider.DefaultFormat(stock));
                             SetCurrentStock(stock);
                         }
                     }
                 }
             }
#endif
        }

        //ɂ킹āi邢͌ɁjARg[̓eZbg
        public CommandResult InitContent(OrderFormParameter info) {
            try {
                if(HasLoadingStatusInfo()) return CommandResult.Ignored; //{͂悭ȂA[h܂̂Ƃɑł̃ZbgƂւʓ|Ȃ̂ŋ

                _parameter = info;
                IOrderItemFormatter formatter = BellagioRoot.OrderDataProvider.OrderItemFormatter;

                AbstractStockProfile prof = info.StockProfile;
                _stockProfile = prof;

                //ŏ͔E`[g{^Checkedƕ\ݒ肪vĂȂ̂ő
                OnChartOrItaButtonClickInternal(_dailyChartButton, _dailyChartButton.Checked);
                OnChartOrItaButtonClickInternal(_minutelyChartButton, _minutelyChartButton.Checked);
                OnChartOrItaButtonClickInternal(_itaButton, _itaButton.Checked);
                LayoutCharts();

                int oph = _orderPanel.Height;
                _orderPanel.InitContent(info);
                if(oph!=_orderPanel.Height)
                    this.Height += _orderPanel.Height - oph; //ωĂ炻̍
                else
                    ManualResize(); //łȂĂCAEg͏ɍs
                this.MinimumSize = _orderPanel.IsGridVisible? new Size(_defaultMinimumSize.Width, _defaultMinimumSize.Height + 72) : _defaultMinimumSize;


                if(_parameter.OrderCategory==OrderFormParameter.Category.NewPosition) {
                    this.Text = "VK";
                    _reserveButton.Visible = true;
                    _orderButton.Text = "";
                }
                else {
                    bool change= _parameter.OrderCategory==OrderFormParameter.Category.Change;
                    bool close = !change;

                    TradeOrderItem order = _parameter.CurrentOrder;
                    TradePositionItem position = _parameter.CurrentPosition;

                    string order_base_str = change? "ύX" : position.DealType==OrderDealType.Genbutsu? "p" : "ԍϒ";
                    this.Text = String.Format("{0} - {1} {2}", order_base_str, prof.Code, prof.Name); //敨ƃtH[}bg
                    if(close && OrderingUtil.IsShinnyo(position.DealType) && _parameter.CloseType==OrderFormParameter.ClosePositionType.SpecifiedElement) this.Text += " (ʕʌ)";

                    _reserveButton.Visible = close || order.OrderStatus==OrderStatus.Preparing; //ҋ@̂Ƃ̂ݍė\
                    _orderButton.Text = "";
                }

                return CommandResult.Succeeded;
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
                return CommandResult.Failed;
            }
        }

        private void OnChartOrItaButtonClick(object sender, EventArgs args) {
            CheckBox b = (CheckBox)sender;
            this.SuspendLayout();
            bool v = b.Checked; //CheckBoxgRibbonMenuButtong ! 邩ǂς
            OnChartOrItaButtonClickInternal(b, v);
            LayoutCharts();
            this.ResumeLayout();
        }
        private void ToggleChartOrItaButton(CheckBox sender) {
            this.SuspendLayout();
            bool v = !sender.Checked;
            OnChartOrItaButtonClickInternal(sender, v);
            LayoutCharts();
            this.ResumeLayout();
        }

        private void OnChartOrItaButtonClickInternal(CheckBox sender, bool value) { //valuecheckedvpeBݒ肷ׂl
            try {
                CheckBox b = sender;
                //łɃRg[쐬ς݂̂Ƃ͉ȂB܂[ĥƂ͋ۂ

                if(b==_dailyChartButton) {
                    if(_dailyChart!=null && _dailyChart.Document.DocumentStatus==BellagioDocumentStatus.Loading) return;
                    _dailyChartButton.Checked = value;
                    if(value) {
                        if(_dailyChart==null) {
                            _dailyChart = CreateChartControl(CreateDailyChartDocument(), "ij");
                            this.Controls.Add(_dailyChart);
                        }
                    }
                    else if(_dailyChart!=null) {
                        this.Controls.Remove(_dailyChart);
                        _dailyChart.Dispose();
                        _dailyChart = null;
                    }
                }
                else if(b==_minutelyChartButton) {
                    if(_minutelyChart!=null && _minutelyChart.Document.DocumentStatus==BellagioDocumentStatus.Loading) return;
                    _minutelyChartButton.Checked = value;
                    if(value) {
                        if(_minutelyChart==null) {
                            _minutelyChart = CreateChartControl(CreateMinutelyChartDocument(), "ij");
                            this.Controls.Add(_minutelyChart);
                        }
                    }
                    else if(_minutelyChart!=null) {
                        this.Controls.Remove(_minutelyChart);
                        _minutelyChart.Dispose();
                        _minutelyChart = null;
                    }
                }
                else if(b==_itaButton) {
                    if(_itaControl!=null && _itaControl.Document.DocumentStatus==BellagioDocumentStatus.Loading) return;
                    _itaButton.Checked = value;
                    if(value) {
                        if(_itaControl==null) {
                            _itaControl = CreateItaControl(CreateItaDocument());
                            this.Controls.Add(_itaControl);
                        }
                    }
                    else if(_itaControl!=null) {
                        this.Controls.Remove(_itaControl);
                        _itaControl.Dispose();
                        _itaControl = null;
                    }
                }

                //nom
                if(this.ClientSize.Width - _orderPanel.Width < 32 && (_dailyChartButton.Checked || _minutelyChartButton.Checked || _itaButton.Checked)) {
                    this.ClientSize = new Size(_orderPanel.Width*2, this.ClientSize.Height);
                }

            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        //tH[OSubscriben\[XB̂ƂAe{^CheckedƏԂvȂ̂ŁAInitContentŕAKv
        private void HideAllChartAndItaControls() {
            if(_dailyChart!=null) {
                this.Controls.Remove(_dailyChart);
                _dailyChart.Dispose();
                _dailyChart = null;
            }
            if(_minutelyChart!=null) {
                this.Controls.Remove(_minutelyChart);
                _minutelyChart.Dispose();
                _minutelyChart = null;
            }
            if(_itaControl!=null) {
                this.Controls.Remove(_itaControl);
                _itaControl.Dispose();
                _itaControl = null;
            }
        }
        private bool HasLoadingStatusInfo() {
            if(_dailyChart!=null && _dailyChart.Document.DocumentStatus==BellagioDocumentStatus.Loading) return true;
            if(_minutelyChart!=null && _minutelyChart.Document.DocumentStatus==BellagioDocumentStatus.Loading) return true;
            if(_itaControl!=null && _itaControl.Document.DocumentStatus==BellagioDocumentStatus.Loading) return true;

            return false;
        }

        
        public void SetCurrentStockExternal(AbstractStockProfile prof) {
            _orderPanel.SetCurrentStockExternal(prof.Primary);
            SetCurrentStock(prof);
        }
        private void SetCurrentStock(AbstractStockProfile prof) {
            _stockProfile = prof;
            Stock stock = prof==null? null : prof.Primary;

            //_currentPriceButton.Enabled = prof!=null;
            //_prevClosePriceButton.Enabled = prof!=null;

            //s͗DɁAʂZbg
            IOrderItemFormatter formatter = BellagioRoot.OrderDataProvider.OrderItemFormatter;

            bool connected = BellagioRoot.DataSourceHost.IsConnected;

            if(_dailyChart!=null) {
                if(connected)
                    _dailyChart.SetCurrentStock(stock);
                else
                    _dailyChart.SetDisconnectedStatus();
            }
            if(_minutelyChart!=null) {
                if(connected)
                    _minutelyChart.SetCurrentStock(stock);
                else
                    _minutelyChart.SetDisconnectedStatus();
            }
            if(_itaControl!=null) {
                if(connected) 
                    _itaControl.SetCurrentStock(stock);
                else
                    _itaControl.SetDisconnectedStatus();
            }


        }


        private void OnCancelButtonClick(object sender, MouseEventArgs args) {
            if(args!=null && args.Button!=MouseButtons.Left) return;

            InternalHide();
        }
        private void OnReserveButtonClick(object sender, MouseEventArgs args) {
            if(args!=null && args.Button!=MouseButtons.Left) return;
            if(_orderPanel.ReserveOrderUI())
                InternalHide();

        }
        private void OnOrderButtonClick(object sender, MouseEventArgs args) {
            if(args!=null && args.Button!=MouseButtons.Left) return;
            if(_orderPanel.SendOrderUI()) InternalHide();

        }

        private void LayoutCharts() {
            int count = 0;
            if(_dailyChart!=null) count++;
            if(_minutelyChart!=null) count++;
            if(_itaControl!=null) count++;

            if(count==0) return;

            int y = 0;
            Rectangle r = new Rectangle(_orderPanel.Width, 0, this.ClientSize.Width - _orderPanel.Width, this.ClientSize.Height);
            int h = r.Height/count;
            if(_dailyChart!=null) {
                _dailyChart.Bounds = new Rectangle(r.Left, y, r.Width, h);
                y += h;
            }
            if(_minutelyChart!=null) {
                _minutelyChart.Bounds = new Rectangle(r.Left, y, r.Width, h);
                y += h;
            }
            if(_itaControl!=null) {
                _itaControl.Bounds = new Rectangle(r.Left, y, r.Width, h);
                y += h;
            }
        }

        private ChartControl CreateChartControl(ChartDocumentBase document, string additional_caption) {
            ChartDrawingSettings settings = BellagioRoot.FixedPreferences.Chart.ChartDrawingSettings;
            
            //hLgIV[^B
            document.SetOscillatorVisible(false);

            ChartControl c = new ChartControl(document, settings, new LocalChartControlCustomize(additional_caption));
            c.ChartDrawing.ChartLocalSettings.drawHeader = false;

            c.MouseDown += delegate(object sender, MouseEventArgs args) {
                ChartControl cc = (ChartControl)sender;
                if(args.Button==MouseButtons.Left && cc.Document.DocumentStatus==BellagioDocumentStatus.Complete) {
                    int p = cc.ChartDrawing.GetCurrentMouseTrackingPrice();
                    if(p > 0) {
                        _orderPanel.SetSashineExternal(MarketUtil.AdjustNearestYobine(p));
                    }
                }
            };
            if(!BellagioRoot.DataSourceHost.IsConnected && document is RealTimeChartDocument) c.SetDisconnectedStatus();
            return c;
        }
        private ItaControl CreateItaControl(ItaDocument document) {
            ItaGraphicsSettings settings = BellagioRoot.FixedPreferences.Chart.ItaGraphicsSettings;
            ItaControl c = new ItaControl(document);
            c.ItaGraphics = new ItaGraphics(c, BellagioPlugin.Instance.SansaPlatform, settings, new ItaLayoutParam(settings));
            c.SashineClick = new ItaControl.SashineClickDelegate(OnItaSashineClick);
            c.ItaGraphics.CoverHoveredSashine = true;
            if(!BellagioRoot.DataSourceHost.IsConnected) c.SetDisconnectedStatus();
            return c;
        }
        private void OnItaSashineClick(SashineMotion m) {
            _orderPanel.SetSashineExternal(m.Sashine.Price);
        }


        private StaticChartDocument CreateDailyChartDocument() {
            ChartSchema schema = BellagioRoot.SchemaRoot.FindStaticChartSchema("tactico.daily-default");
            Debug.Assert(schema!=null);
            StaticChartDocument doc = new StaticChartDocument(Bellagio.Values.Quote.QuoteUnit.Daily);
            doc.ShowMessageBoxOnSubscribeFailure = false;
            doc.ConstructWithSchema(schema);
            doc.SetCurrentStock(GetPrimaryStock());
            return doc;
        }
        private RealTimeChartDocument CreateMinutelyChartDocument() {
            ChartSchema schema = BellagioRoot.SchemaRoot.FindRealTimeChartSchema("tactico.minutely-default");
            Debug.Assert(schema!=null);
            RealTimeChartDocument doc = new RealTimeChartDocument(1);
            doc.ShowMessageBoxOnSubscribeFailure = false;
            doc.SubscribeDataKind = SubscribeDataKind.Ticks;
            doc.ConstructWithSchema(schema);
            if(BellagioRoot.DataSourceHost.IsConnected)
                doc.SetCurrentStock(GetPrimaryStock());
            return doc;
        }
        private ItaDocument CreateItaDocument() {
            ItaDocument doc = new ItaDocument(null);
            doc.ShowMessageBoxOnSubscribeFailure = false;
            if(BellagioRoot.DataSourceHost.IsConnected)
                doc.SetCurrentStock(GetPrimaryStock()); //NotifyDelegate̐ڑ邽߁Anullō쐬ĂSetCurrentStockĂԂׂ
            return doc;
        }


        private Stock GetPrimaryStock() {
            return _stockProfile==null? null : _stockProfile.Primary;
        }




        private class LocalChartControlCustomize : ChartControl.IChartControlCustomize {
            private string _additionalCaption;
            public LocalChartControlCustomize(string ac) {
                _additionalCaption = ac;
            }
            public void AdjustRectangleOperator(RectangleOperatorBuilder bld) {
            }

            public string FormatHeaderText(Stock stock) {
                return String.Format("{0} {1}  {2}", stock.Profile.Code, stock.Profile.Name, _additionalCaption);
            }

            public void CustomPaint(PaintEventArgs args) {
            }
        }




        //resource
        //private static Bitmap _titleImage;

        private static void StaticInit() {
            /*
            if(_titleImage!=null) return;
            ResourceManager rm = new ResourceManager("Bellagio.Ordering.Icons", typeof(OrderForm).Assembly);
            _titleImage = (Bitmap)rm.GetObject("sinkiChumon");
            */
        }
        private static Bitmap LargeBitmap(int index) {
            return OrderingPlugin.OrderingIcons.GetBitmap(index);
        }

        private void InitToolTipText() {
            _toolTip.SetToolTip(_itaButton, "݂̖̔\ - V[gJbg F6");
            _toolTip.SetToolTip(_minutelyChartButton, "݂̖̕`[g\ - V[gJbg F7");
            _toolTip.SetToolTip(_dailyChartButton, "݂̖̓`[g\ - V[gJbg F8");
            _toolTip.SetToolTip(_reserveButton, "ɂ͑MA̓͏Ԃێ - V[gJbg F9");
            _orderPanel.InitToolTipText(_toolTip);
        }

    }


    //悤ƂĂɌŗL̏
    public class OrderFormParameter {
        public enum Category {
            NewPosition, //VK
            ClosePosition, //ϒ
            Change //
        }
        public enum ClosePositionType {
            MultiplePosition,           //ċʎw܂UI
            SpecifiedElement, //̌ʂ݂̂̌ϒ
            GenhikiGenwatasi, ///nBǂł邩PositionItem/茚Ă̂ǂł邩ɂ
        }

        private Category _category;
        private AbstractStockProfile _stockProfile; //VK̂Ƃ̂ݗL, null
        private TradePositionItem _position; //ϒ̂Ƃ̂ݗL, nulls
        private TradeOrderItem _targetOrder; //̂Ƃ̂ݗL, nulls
        private TradePositionItem.Element _positionElement;
        private ClosePositionType _closeType;

        //쐬͊estatic\bhg
        private OrderFormParameter(Category c) {
            _category = c;
        }

        public Category OrderCategory {
            get {
                return _category;
            }
        }
        public ClosePositionType CloseType {
            get {
                return _closeType;
            }
        }
        public TradePositionItem CurrentPosition {
            get {
                return _position;
            }
        }
        public TradePositionItem.Element PositionElement {
            get {
                return _positionElement;
            }
        }
        public TradeOrderItem CurrentOrder {
            get {
                return _targetOrder;
            }
        }
        public int MaximumVolume {
            get {
                Debug.Assert(_category!=Category.NewPosition);
                return _category==Category.Change? _targetOrder.Volume :
                    _positionElement!=null? (_positionElement.Volume - _positionElement.OrderingVolume) : 
                    _position.TotalVolume - _position.TotalOrderingVolume;
            }
        }

        public AbstractStockProfile StockProfile {
            get {
                switch(_category) {
                    case Category.NewPosition:
                        return _stockProfile;
                    case Category.ClosePosition:
                        return _position.Stock.Profile;
                    case Category.Change:
                        return _targetOrder.Stock.Profile;
                }
                Debug.Assert(false);
                return null;
            }
        }
        //w\Ȏ񋓁Bł͒oĂsAMpԍςł͌ĂĂs
        public StockExchange[] GetStockExchangeList() {
            switch(_category) {
                case Category.NewPosition:
                    return _stockProfile==null? new StockExchange[0] : _stockProfile.GetStockExhcnageArray();
                case Category.ClosePosition:
                    return OrderingUtil.IsShinnyo(_position.DealType)? new StockExchange[] { _position.Stock.Market } : _position.Stock.Profile.GetStockExhcnageArray();
                case Category.Change:
                    return new StockExchange[] { _targetOrder.Stock.Market };
            }
            Debug.Assert(false);
            return null;
        }
        public bool CanChangeVolume {
            get {
                return _category!=Category.Change;
            }
        }

        public static OrderFormParameter ForNewPosition() {
            OrderFormParameter p = new OrderFormParameter(Category.NewPosition);
            p._stockProfile = null;
            p._positionElement = null;
            return p;
        }
        public static OrderFormParameter ForNewPosition(AbstractStockProfile stock) {
            OrderFormParameter p = new OrderFormParameter(Category.NewPosition);
            p._stockProfile = stock;
            p._positionElement = null;
            return p;
        }
        public static OrderFormParameter ForNewPosition(TradeOrderItem item) { //ۗēx\z悤ȃP[X
            OrderFormParameter p = new OrderFormParameter(Category.NewPosition);
            p._stockProfile = item.Stock.Profile;
            p._positionElement = null;
            p._targetOrder = item;
            return p;
        }
        public static OrderFormParameter ForClosePosition(TradePositionItem position, ClosePositionType closetype, TradePositionItem.Element element) {
            OrderFormParameter p = new OrderFormParameter(Category.ClosePosition);
            p._position = position;
            p._closeType = closetype;
            p._positionElement = element;
            return p;
        }
        public static OrderFormParameter ForClosePosition(TradeOrderItem order) { //ۗēx\z悤ȃP[X
            OrderFormParameter p = new OrderFormParameter(Category.ClosePosition);
            p._targetOrder = order;
            p._position = order.TargetPosition;
            if(order.IsClosePositionDetailAvailable) {
                p._positionElement = null;
                p._closeType = ClosePositionType.MultiplePosition;
            }
            else {
                p._positionElement = order.TargetPositionElement;
                p._closeType = ClosePositionType.SpecifiedElement;
            }
            return p;
        }
        public static OrderFormParameter ForChangeOrder(TradeOrderItem order) {
            OrderFormParameter p = new OrderFormParameter(Category.Change);
            p._targetOrder = order;
            p._position = order.TargetPosition;
            //ύXCloseƂ͌Ȃp͂Ȃ
            if(order.IsClosePositionDetailAvailable) {
                p._positionElement = null;
                p._closeType = ClosePositionType.MultiplePosition;
            }
            else {
                p._positionElement = order.TargetPositionElement;
                p._closeType = ClosePositionType.SpecifiedElement;
            }
            return p;
        }
    }

}