/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/PowerInfoDrawing.cs#3 $
 * $DateTime: 2008/01/30 09:33:27 $
 * 
 * ʒm̕`
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Text;
using System.Diagnostics;

using Poderosa;

using Bellagio.Values;
using Bellagio.Drawing;

using Travis;
using Travis.LocationOperation;

namespace Bellagio.Ordering {
    public class PowerInfoDrawingSettings : DrawingSettingsBase {
        public DSInt labelAreaWidth; //x
        public DSInt itemHeight; //Pڂ̍

        public DSFont labelFont; //xtHg
        public DSFont valueFont; //ltHg

        public DSPenStyle frameColor; //g̐F
        public DSPenStyle delimiterColor; //tB[h؂̐F
        public DSBrush labelColor; //W̃xF
        public DSBrush valueColor; //l̐F

        public PowerInfoDrawingSettings(string id)
            : base(id) {
        }
        protected override void CreateElements() {
            labelAreaWidth = DefineInt("labelAreaWidth", 144);
            itemHeight = DefineInt("itemHeight", 27);

            frameColor = DefinePenStyle("frameColor", Color.DarkOliveGreen, BPenStyle.DashStyle.Dot, 1);
            delimiterColor = DefinePenStyle("delimiterColor", Color.DarkOliveGreen, BPenStyle.DashStyle.Dot, 1);
            labelColor = DefineBrush("labelColor", Color.White);
            valueColor = DefineBrush("valueColor", Color.LightCyan);

            labelFont = DefineFont("labelFont", DSFont.GenericFontName, 10.5F);
            valueFont = DefineFont("labelFont", DSFont.GenericFontName, 11F);

        }
    }

    public class PowerInfoDrawing {
        private PowerInfoDrawingSettings _settings;
        //擾null̂Ƃ
        private DerivativeBuyingPowerInfo _derivativeInfo;
        private StockBuyingPowerInfo _stockInfo;
        private bool _showMarginInfo; //Mp̏\邩ǂ
        private bool _showDerivativeInfo; //敨̏\邩ǂ

        public PowerInfoDrawing(PowerInfoDrawingSettings settings) {
            _settings = settings;
        }
        public void SetVisibiliy(bool margin, bool derivative) {
            _showMarginInfo = margin;
            _showDerivativeInfo = derivative;
        }
        public StockBuyingPowerInfo StockInfo {
            get {
                return _stockInfo;
            }
            set {
                _stockInfo = value;
            }
        }
        public DerivativeBuyingPowerInfo DerivativeInfo {
            get {
                return _derivativeInfo;
            }
            set {
                _derivativeInfo = value;
            }
        }

        public void Draw(Graphics g, Rectangle rect) {
            try {
                int item_count = GetItemCount();
                //g
                Pen delimiter_pen = _settings.delimiterColor.P;
                Pen frame_pen = _settings.frameColor.P;
                int item_height = _settings.itemHeight.V;
                RoundRectUtil.Draw(g, frame_pen, new Rectangle(2, 2, rect.Width-6, item_count * item_height), 4);

                Rectangle rh = new Rectangle(2, 2, _settings.labelAreaWidth.V, item_height);
                Rectangle rb = new Rectangle(2+_settings.labelAreaWidth.V+2, 2, rect.Width-4-_settings.labelAreaWidth.V-6, item_height);
                int delim_width = rect.Width - 4;
                //eڂ̕`

                //
                DrawHDelimiter(g, rh.Left, rh.Bottom, delim_width);
                DrawStringUtil.MiddleLeft(g, " ", _settings.labelFont.F, _settings.labelColor.B, rh);
                NextRow(ref rh, ref rb);

                if(_showMarginInfo || _showDerivativeInfo)
                    DrawHDelimiter(g, rh.Left, rh.Bottom, delim_width);
                DrawVDelimiter(g, rh.Right, rh.Top, item_height);
                DrawStringUtil.MiddleLeft(g, "  t]", _settings.labelFont.F, _settings.labelColor.B, rh);
                DrawStringUtil.MiddleRight(g, GenbutsuString(), _settings.labelFont.F, _settings.valueColor.B, rb);
                NextRow(ref rh, ref rb);

                //Mp
                if(_showMarginInfo) {
                    DrawHDelimiter(g, rh.Left, rh.Bottom, delim_width);
                    DrawVDelimiter(g, rh.Right, rh.Top, item_height);
                    DrawStringUtil.MiddleLeft(g, "  Mp]", _settings.labelFont.F, _settings.labelColor.B, rh);
                    DrawStringUtil.MiddleRight(g, MarginString(), _settings.labelFont.F, _settings.valueColor.B, rb);
                    NextRow(ref rh, ref rb);

                    if(_showDerivativeInfo)
                        DrawHDelimiter(g, rh.Left, rh.Bottom, delim_width);
                    DrawVDelimiter(g, rh.Right, rh.Top, item_height);
                    DrawStringUtil.MiddleLeft(g, "  ۏ؋ێ", _settings.labelFont.F, _settings.labelColor.B, rh);
                    DrawStringUtil.MiddleRight(g, MarginRatioString(), _settings.labelFont.F, _settings.valueColor.B, rb);
                    NextRow(ref rh, ref rb);
                }

                //敨
                if(_showDerivativeInfo) {
                    DrawHDelimiter(g, rh.Left, rh.Bottom, delim_width);
                    DrawStringUtil.MiddleLeft(g, " 敨OP", _settings.labelFont.F, _settings.labelColor.B, rh);
                    NextRow(ref rh, ref rb);

                    DrawHDelimiter(g, rh.Left, rh.Bottom, delim_width);
                    DrawVDelimiter(g, rh.Right, rh.Top, item_height);
                    DrawStringUtil.MiddleLeft(g, "  敨\", _settings.labelFont.F, _settings.labelColor.B, rh);
                    DrawStringUtil.MiddleRight(g, KaitateString(), _settings.labelFont.F, _settings.valueColor.B, rb);
                    NextRow(ref rh, ref rb);

                    DrawHDelimiter(g, rh.Left, rh.Bottom, delim_width);
                    DrawVDelimiter(g, rh.Right, rh.Top, item_height);
                    DrawStringUtil.MiddleLeft(g, "  敨\", _settings.labelFont.F, _settings.labelColor.B, rh);
                    DrawStringUtil.MiddleRight(g, UritateString(), _settings.labelFont.F, _settings.valueColor.B, rb);
                    NextRow(ref rh, ref rb);

                    DrawHDelimiter(g, rh.Left, rh.Bottom, delim_width);
                    DrawVDelimiter(g, rh.Right, rh.Top, item_height);
                    DrawStringUtil.MiddleLeft(g, "  ؋", _settings.labelFont.F, _settings.labelColor.B, rh);
                    DrawStringUtil.MiddleRight(g, FutureShokokinString(), _settings.labelFont.F, _settings.valueColor.B, rb);
                    NextRow(ref rh, ref rb);

                    DrawHDelimiter(g, rh.Left, rh.Bottom, delim_width);
                    DrawVDelimiter(g, rh.Right, rh.Top, item_height);
                    DrawStringUtil.MiddleLeft(g, "  ؋]", _settings.labelFont.F, _settings.labelColor.B, rh);
                    DrawStringUtil.MiddleRight(g, FutureYoryokuString(), _settings.labelFont.F, _settings.valueColor.B, rb);
                    NextRow(ref rh, ref rb);

                    DrawVDelimiter(g, rh.Right, rh.Top, item_height);
                    DrawStringUtil.MiddleLeft(g, "  ؋sz", _settings.labelFont.F, _settings.labelColor.B, rh);
                    DrawStringUtil.MiddleRight(g, FusokugakuString(), _settings.labelFont.F, _settings.valueColor.B, rb);
                    NextRow(ref rh, ref rb);

                }

            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }

        public int GetItemCount() {
            int c = 2;
            if(_showMarginInfo) c += 2;
            if(_showDerivativeInfo) c += 6;
            return c;
        }


        private const string LOADING_STRING = "(擾)";

        private string GenbutsuString() {
            if(_stockInfo==null)
                return LOADING_STRING;
            else
                return String.Format("{0:N0}~", _stockInfo.Genbutsu);
        }
        private string MarginString() {
            if(_stockInfo==null)
                return LOADING_STRING;
            else
                return String.Format("{0:N0}~", _stockInfo.Credit);
        }
        private string MarginRatioString() {
            if(_stockInfo==null)
                return LOADING_STRING;
            else if(_stockInfo.CreditRate==0)
                return "--%";
            else
                return String.Format("{0:F2}%" , _stockInfo.CreditRate);
        }
        private string KaitateString() {
            if(_derivativeInfo==null)
                return LOADING_STRING;
            else
                return String.Format("{0:N0} (mini {1:N0})", _derivativeInfo.maxVolumeLargeLong, _derivativeInfo.maxVolumeMiniLong);
        }
        private string UritateString() {
            if(_derivativeInfo==null)
                return LOADING_STRING;
            else
                return String.Format("{0:N0} (mini {1:N0})", _derivativeInfo.maxVolumeLargeShort, _derivativeInfo.maxVolumeMiniShort);
        }
        private string FutureYoryokuString() {
            if(_derivativeInfo==null)
                return LOADING_STRING;
            else
                return String.Format("{0:N0}~", _derivativeInfo.MarginYoryoku);
        }
        private string FusokugakuString() {
            if(_derivativeInfo==null)
                return LOADING_STRING;
            else
                return String.Format("{0:N0}~", _derivativeInfo.MarginDeficiency);
        }
        private string FutureShokokinString() {
            if(_derivativeInfo==null)
                return LOADING_STRING;
            else
                return String.Format("{0:N0}~", _derivativeInfo.TotalMargin);
        }


        //Kȃ}[WĐ
        private void DrawHDelimiter(Graphics g, int x, int y, int width) {
            const int margin = 4;
            Pen p = _settings.delimiterColor.P;
            g.DrawLine(p, x+margin, y, x+width-margin, y);
        }
        private void DrawVDelimiter(Graphics g, int x, int y, int height) {
            const int margin = 4;
            Pen p = _settings.delimiterColor.P;
            g.DrawLine(p, x, y+margin, x, y+height-margin);
        }
        private void NextRow(ref Rectangle rh, ref Rectangle rb) {
            rh.Y += _settings.itemHeight.V;
            rb.Y += _settings.itemHeight.V;
        }


    }
}
