/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/TabStyleOrderForm.cs#5 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * QtH[
 * eڂ^uɔzuARpNgɂ܂Ƃ߂ĕtH[oATCYȂƂƂƂ
 */
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Resources;
using System.Diagnostics;

using Travis;
using Travis.LocationOperation;
using Poderosa;

using Bellagio.Common;
using Bellagio.Data;
using Bellagio.Forms;
using Bellagio.Chart;
using Bellagio.Environment;
using Bellagio.Values;
using Bellagio.Drawing;

using Poderosa.Sessions;
using Poderosa.Forms;
using Poderosa.Commands;

namespace Bellagio.Ordering {
    public class TabStyleOrderForm : BellagioDefaultForm, OrderControl.IOrderControlHost {
        /*
        UI̔zu͂ނˈȉ̂Ƃ
        
        [  Code Box   ]
        [CurrentPrice ]
        [Tab][        ]
        [Tab][ Main   ]
        [Tab][        ]
        [e   ]

        ^u̗vf́AlEEEE݁ÊU
        */

        private OrderFormParameter _parameter;

        private CodeInputBox _codeBox;
        private ComboBox _marketBox;
        private HoveringLabel _formToggleButton;
        private bool _formShrinked; //k\ǂ
        private CurrentPriceInfoControl _headCurrentPrice; //lEEOEŝ݂\
        private SliderTab _tab;
        private CurrentPriceInfoControl _currentPriceControl;
        private ChartControl _dailyChartControl;
        private ChartControl _realtimeChartControl;
        private ItaControl _itaControl;
        private TickControl _tickControl;
        private const int MINIMUM_CLIENT_WIDTH = 296;
        private const int MINIMUM_CLIENT_HEIGHT = 160;
        private const int DEFAULT_CLIENT_HEIGHT = 428;
        private OrderControl _orderControl;
        private Label _orderDisplayLabel;
        private Label _showConfirmBoxLabel;
        private RibbonMenuButton _orderButton;
        private RibbonMenuButton _reserveButton;

        private RectOp _rectOp;
        private RectOp _tabAndMainRectOp;
        private BRect _mainControlRect;
        private BRect _tabAndMainRect;

        private Stock _stock;
        //Stockɉč쐬hLgB^uANeBuɂȂ_Œx쐬̘̂͌b
        private CurrentPriceInfoDocument _currentPriceDocument;
        private RealTimeChartDocument _realtimeChartDocument;
        private ItaDocument _itaDocument;
        private StaticChartDocument _dailyChartDocument;

        //Iɕςp[^
        private ItaLayoutParam _itaLayout;
        private TickLayoutParam _tickLayout;
        private ItaGraphics _itaGraphics;
        private TickGraphics _tickGraphics;


        private TradeOrderItem _currentTradeItem;
        private const string PRICEDRAG_STRING = "bellagio-pricedrag";

        public TabStyleOrderForm(OrderFormParameter parameter) {
            _parameter = parameter;
            this.AllowDrop = true;

            IOrderItemFormatter formatter = BellagioRoot.OrderDataProvider.OrderItemFormatter;
            AbstractStockProfile prof = parameter.StockProfile;
            _stock = prof==null? null  : prof.Primary;

            ChartPreferences cp = BellagioRoot.FixedPreferences.Chart;
            IconList il = BellagioRoot.CommonIcons.ControlBoxes;

            //CurrentPriceInfoDocumentȊÓANotifyDelegate̐ڑ͊eRg[sĂB̕s͋CɂȂ邪`[głȂDocument̐͋CɂȂĂȂ
            _currentPriceDocument = new CurrentPriceInfoDocument();
            _currentPriceDocument.NotifyDelegate = new DataThreadToMainThread(CurrentPriceDocEvent);
            _realtimeChartDocument = CreateMinutelyChartDocument(minutelychart_schema_names[0]);
            _itaDocument = new ItaDocument(_stock);
            _itaDocument.ShowMessageBoxOnSubscribeFailure = false;
            _dailyChartDocument = CreateDailyChartDocument(staticchart_schema_names[0]);

            _codeBox = new CodeInputBox();
            ChartDrawingSettings ds = BellagioRoot.FixedPreferences.Chart.ChartDrawingSettings;
            _codeBox.FontEx = new Font(ds.stockBoxFont.SmartFont.name, 9.0F); //TCŶFIX
            _codeBox.CodeColor = ds.stockCodeColor.col;
            _codeBox.NameColor = ds.stockNameColor.col;
            _codeBox.BackColor = Color.Black;
            _codeBox.DataProvider = new CodeDropDownDataProvider();
            _codeBox.StockChanged += new EventHandler(OnStockChanged);
            _codeBox.MouseUp += new MouseEventHandler(OnCodeBoxMouseUp);
            _marketBox = FormUtil.CreateComboBox();
            _marketBox.BackColor = Color.Black;
            _marketBox.ForeColor = ds.stockNameColor.col;
            _marketBox.SelectedIndexChanged += new EventHandler(OnMarketChanged);
            _formToggleButton = new HoveringLabel(il.GetBitmap(0, 2), il.GetBitmap(1, 2));
            _formToggleButton.Click += new EventHandler(OnFormToggleButtonClick);
            _formShrinked = false;

            _tab = new SliderTab();
            _tab.ItemPitch = 49;
            _tab.AddItem("");
            _tab.AddItem("l");
            _tab.AddItem("");
            _tab.AddItem("");
            _tab.AddItem("");
            _tab.AddItem("");
            _tab.SelectedIndex = 0;
            _tab.SelectedIndexChanged += new EventHandler(OnSelectedTabChanged);

            _headCurrentPrice = new CurrentPriceInfoControl(_currentPriceDocument, CurrentPriceInfoGraphics.LayoutT.PriceOnly);
            _headCurrentPrice.StartDragPrice += new StockInfoViewerControl.DragPriceHandler(OnStartDragPrice);
            _currentPriceControl = new CurrentPriceInfoControl(_currentPriceDocument, CurrentPriceInfoGraphics.LayoutT.VolumeAndCredit);
            _currentPriceControl.HandleCreated += delegate(object sender, EventArgs args) {
                this.CurrentPriceDocEvent();
            };
            _dailyChartControl = new ChartControl(_dailyChartDocument, cp.ChartDrawingSettings, new LocalChartControlCustomize());
            _dailyChartControl.ChartDrawing.ChartLocalSettings.enableFigureDrawing = false;
            _dailyChartControl.StartDragPrice += new ChartControl.DragPriceHandler(OnStartDragPrice);
            _dailyChartControl.MouseDown += new MouseEventHandler(OnDailyChartContextMenu);
            _realtimeChartControl = new ChartControl(_realtimeChartDocument, cp.ChartDrawingSettings, new LocalChartControlCustomize());
            _realtimeChartControl.ChartDrawing.ChartLocalSettings.enableFigureDrawing = false;
            //_realtimeChartControl.MouseDown += new MouseEventHandler(OnChartSashineClick);
            _realtimeChartControl.MouseDown += new MouseEventHandler(OnMinutelyChartContextMenu);
            _realtimeChartControl.StartDragPrice += new ChartControl.DragPriceHandler(OnStartDragPrice);
            _itaControl = new ItaControl(_itaDocument);
            //_itaControl.SashineClick = new ItaControl.SashineClickDelegate(OnItaSashineClick);
            _itaControl.MouseDown += new MouseEventHandler(OnItaControlMouseDown);
            _itaControl.StartDragPrice += new StockInfoViewerControl.DragPriceHandler(OnStartDragPrice);
            _tickControl = new TickControl(_currentPriceDocument);
            _tickControl.MouseDown += new MouseEventHandler(OnTickControlMouseDown);
            _tickControl.StartDragPrice += new ChartControl.DragPriceHandler(OnStartDragPrice);
            _headCurrentPrice.Visible = true;
            _currentPriceControl.Visible = false;
            _dailyChartControl.Visible = false;
            _realtimeChartControl.Visible = false;
            _itaControl.Visible = false;
            _tickControl.Visible = false;
            _showConfirmBoxLabel = FormUtil.CreateLabel("");
            _showConfirmBoxLabel.BorderStyle = BorderStyle.FixedSingle;
            _showConfirmBoxLabel.TextAlign = ContentAlignment.MiddleLeft;

            _itaLayout = new ItaLayoutParam(cp.ItaGraphicsSettings);
            _tickLayout = new TickLayoutParam(cp.TickGraphicsSettings);
            _itaGraphics = new ItaGraphics(_itaControl, BellagioPlugin.Instance.SansaPlatform, cp.ItaGraphicsSettings, _itaLayout);
            _tickGraphics = new TickGraphics(_tickControl, BellagioPlugin.Instance.SansaPlatform, cp.TickGraphicsSettings, _tickLayout);
            _itaControl.ItaGraphics = _itaGraphics;
            _tickControl.TickGraphics = _tickGraphics;
            _itaGraphics.CoverHoveredSashine = true;

            _orderControl = new OrderControl(this);
            _orderControl.OrderContentChanged += new VoidVoidDelegate(OnOrderContentChanged);
            _orderControl.OmitOrderConfirmChanged += new VoidVoidDelegate(AdjustOrderConfirmLabel);
            _orderControl.InitContent(_parameter);
            _orderControl.Visible = true;
            _currentTradeItem = _parameter==null? null : _parameter.CurrentOrder;

            _orderDisplayLabel = new Label();
            _orderDisplayLabel.BorderStyle = BorderStyle.FixedSingle;
            _orderDisplayLabel.Paint += new PaintEventHandler(PaintOrderDisplayLabel);
            _reserveButton = FormUtil.CreateRibbonCommandButton("\", LargeBitmap(2), new MouseEventHandler(OnReserveButtonClick));
            _orderButton = FormUtil.CreateRibbonCommandButton("", LargeBitmap(0), new MouseEventHandler(OnOrderButtonClick));
            _orderButton.DialogResult = DialogResult.OK;
            _reserveButton.AllowDrop = true;
            _reserveButton.DragEnter += new DragEventHandler(OnReserveButtonDragEnter);
            _reserveButton.DragDrop += new DragEventHandler(OnReserveButtonDragDrop);
            _reserveButton.DragLeave += new EventHandler(OnOrderOrReserveButtonDragLeave);
            _orderButton.AllowDrop = true;
            _orderButton.DragEnter += new DragEventHandler(OnOrderButtonDragEnter);
            _orderButton.DragDrop += new DragEventHandler(OnOrderButtonDragDrop);
            _orderButton.DragLeave += new EventHandler(OnOrderOrReserveButtonDragLeave); //nhp

            _mainControlRect = new BRect();
            _tabAndMainRect = new BRect();
            const int tab_height = 24;
            const int cmd_w = 52; //R}h{^TCY
            const int cmd_h = 52;
            
            _rectOp = new RectangleOperatorBuilder()
                .Shrink(2)
                .SplitTop(24)
                    .SplitFixed(SplitDir.Right, 82)
                        .PlaceControl(ContentAlignment.TopLeft, _marketBox, 64, 19)
                        .CornerOffset(RectCorner.TopRight, 2, 2, 16, 16).ProbeControl(_formToggleButton)
                        .CloseBranch()
                    .ProbeControl(_codeBox)
                    .CloseBranch()
                .SplitFixed(SplitDir.Top, 48).Shrink(2).ProbeControl(_headCurrentPrice).CloseBranch()
                .SplitFixed(SplitDir.Bottom, 84)
                    .Shrink(2).ProbeControl(_orderDisplayLabel)
                    .SetMargin(4)
                    .PlaceControl(ContentAlignment.BottomRight, _reserveButton, cmd_w, cmd_h)
                    .LeftControl(_orderButton, cmd_w, cmd_h)
                    .CornerOffset(RectCorner.TopLeft, cmd_w/2, -21, cmd_w+4, 19).ProbeControl(_showConfirmBoxLabel)
                .CloseBranch()
                .ProbeBRect(_tabAndMainRect)
                .Finish();
            _tabAndMainRectOp = new RectangleOperatorBuilder()
                .SplitFixed(SplitDir.Top, tab_height).ProbeControl(_tab).CloseBranch()
                .ProbeBRect(_mainControlRect)
                .Finish();

            if(_parameter.OrderCategory==OrderFormParameter.Category.NewPosition) {
                this.Text = "VK";
                TradeOrderItem item = _parameter.CurrentOrder; //ۗ𕜊Ă邱Ƃ邽
                _currentTradeItem = item;
                _codeBox.EnabledEx = true;
                FormUtil.SetComboBoxCandidates(_marketBox, OrderingUtil.FormatArray<StockExchange>(delegate(StockExchange ex) { return formatter.FormatStockExchange(ex); }, _parameter.GetStockExchangeList()));
                _marketBox.Enabled = prof!=null;
                if(_marketBox.Enabled)
                    _marketBox.SelectedIndex = prof!=null && item!=null && prof.Primary.Market!=item.Stock.Market? 1 : 0;
            }
            else {
                TradePositionItem position = _parameter.CurrentPosition;
                TradeOrderItem order = _parameter.CurrentOrder;
                _currentTradeItem = order;

                bool change = _parameter.OrderCategory==OrderFormParameter.Category.Change; //or
                bool close = !change;
                _codeBox.EnabledEx = false;
                FormUtil.SetComboBoxCandidates(_marketBox, OrderingUtil.FormatArray<StockExchange>(delegate(StockExchange ex) { return formatter.FormatStockExchange(ex); }, _parameter.GetStockExchangeList()));
                _marketBox.Enabled = change? false : position.DealType==OrderDealType.Genbutsu;
                _marketBox.SelectedIndex = (_marketBox.Enabled && order!=null && order.Stock.Profile.Primary!=order.Stock)? 1 : 0;

                string order_base_str = change? "ύX" : position.DealType==OrderDealType.Genbutsu? "p" : "ԍϒ";
                this.Text = String.Format("{0} - {1} {2}", order_base_str, prof.Code, prof.Name); //敨ƃtH[}bg
                if(close && OrderingUtil.IsShinnyo(position.DealType) && _parameter.CloseType==OrderFormParameter.ClosePositionType.SpecifiedElement) this.Text += " (ʕʌ)";
            }

            this.ClientSize = new Size(MINIMUM_CLIENT_WIDTH, DEFAULT_CLIENT_HEIGHT + _orderControl.AdditionalPanelHeight); 
            _orderControl.Width = this.ClientSize.Width;
            this.MinimumSize = new Size(this.Size.Width, this.Size.Height - (DEFAULT_CLIENT_HEIGHT + _orderControl.AdditionalPanelHeight - MINIMUM_CLIENT_HEIGHT));

            this.Controls.AddRange(new Control[] {
                _codeBox, _marketBox, _formToggleButton, _tab,
                _headCurrentPrice,
                _orderControl, _currentPriceControl, _dailyChartControl, _realtimeChartControl, _itaControl, _tickControl,
                 _orderButton, _reserveButton, _showConfirmBoxLabel, _orderDisplayLabel,
            });
            if(prof!=null) {
                _codeBox.SetTextExternal(CodeDropDownDataProvider.DefaultFormat(prof));
                SetCurrentStock(prof.Primary);
            }
            AdjustOrderConfirmLabel();
        }

        Stock OrderControl.IOrderControlHost.CurrentStockForOrder {
            get {
                Stock s;
                if(_stock!=null) {
                    //E`[gƂ͎sł
                    if(_parameter.OrderCategory==OrderFormParameter.Category.NewPosition)
                        s = _stock;
                    else if(_parameter.OrderCategory==OrderFormParameter.Category.ClosePosition) {
                        if(_parameter.CurrentPosition.DealType==OrderDealType.Genbutsu)
                            s = _stock;
                        else
                            s = _parameter.CurrentPosition.Stock;
                    }
                    else //(_parameter.OrderCategory==OrderFormParameter.Category.Change)
                        s = _parameter.CurrentOrder.Stock;
                    Debug.WriteLine("IHost.GetCurrentStockForOrder " + s.Market.ToString());
                    return s;
                }
                else
                    return null;
            }
        }
        AbstractStockProfile OrderControl.IOrderControlHost.CurrentStockProfile {
            get {
                return _stock==null? null : _stock.Profile;
            }
        }

        protected override void Dispose(bool disposing) {
            base.Dispose(disposing);
            if(disposing) {
                _currentPriceDocument.Dispose();

                _realtimeChartDocument.Dispose();
                _itaDocument.Dispose();
                _dailyChartDocument.Dispose();
            }
        }

        protected override void OnResize(EventArgs e) {
            base.OnResize(e);
            _rectOp.Rect(this.ClientRectangle);
            if(!_formShrinked) {
                _tabAndMainRectOp.Rect(_tabAndMainRect.Value);
                ResizeMainControl(_tab.SelectedIndex, false);
            }
            this.Invalidate();
        }

        protected override bool ProcessDialogKey(Keys keyData) {
            //Debug.WriteLine("PDK " + keyData.ToString());
            if(Keys.F3<=keyData && keyData<=Keys.F8) {
                int pi = _tab.SelectedIndex;
                _tab.SelectedIndex = keyData - Keys.F3;
                _tab.Invalidate();

                if(pi!=_tab.SelectedIndex) this.OnSelectedTabChanged(_tab, null);
            }
            else if(keyData==Keys.F9) {
                _orderControl.PerformNariyukiClick();
                return true;
            }
            else if(keyData==Keys.F2 && _codeBox.EnabledEx) {
                _codeBox.SelectAllEx();
                return true;
            }
            else if(keyData==Keys.Escape) {
                this.Close();
                return true;
            }
            return base.ProcessDialogKey(keyData);
        }

        private void OnStockChanged(object sender, EventArgs args) {
            //ɏ铮ƂăReLXgj[̃Zbg
            AbstractStockProfile prof = BellagioRoot.GlobalStockCollection.FindExact(_codeBox.CurrentItem.Code);
            _marketBox.Enabled = true;
            FormUtil.SetComboBoxCandidates(_marketBox, OrderingUtil.FormatArray<StockExchange>(delegate(StockExchange ex) { return BellagioRoot.OrderDataProvider.OrderItemFormatter.FormatStockExchange(ex); }, prof==null? new StockExchange[0] : prof.GetStockExhcnageArray()));

            SetCurrentStock(prof.Primary);
        }
        private void OnMarketChanged(object sender, EventArgs args) {
            
            AbstractStockProfile prof = null;
            if(_codeBox.EnabledEx) {
                ICodeDropDownItem current = _codeBox.CurrentItem;
                prof = current==null? null : BellagioRoot.GlobalStockCollection.FindExact(current.Code);
            }
            else {
                if(_parameter.OrderCategory==OrderFormParameter.Category.Change)
                    prof = _parameter.CurrentOrder.Stock.Profile;
                if(_parameter.CurrentPosition!=null)
                    prof = _parameter.CurrentPosition.Stock.Profile;
            }

            if(prof!=null)
                SetCurrentStock(_marketBox.SelectedIndex==1? prof.Secondary : prof.Primary);
        }
        private void OnSelectedTabChanged(object sender, EventArgs args) {
            this.SuspendLayout();
            
            Control prev = GetCurrentMainControl();
            if(prev!=null) prev.Visible = false;

            Control c = GetMainControl(_tab.SelectedIndex);
            //VisibleZbgBVisibletrueɂȂ܂HandleCreatex邱Ƃ̂ŁAResizeMainControl͂̂ƂłȂƂȂ
            c.Visible = true;
            ResizeMainControl(_tab.SelectedIndex, true); 
            //Tick\ɃCxgsKv
            if(c==_tickControl) CurrentPriceDocEvent();

            this.ResumeLayout();
        }
        private void ResizeMainControl(int index, bool resize_event_forced) {
            Rectangle rc = _mainControlRect.Value;
            if(index==0) { //̂Ƃ͏Ƀ}[WAŒ
                rc.Y += 4;
                rc.Height -= 4;
                rc.Width = MINIMUM_CLIENT_WIDTH;
                _orderControl.Bounds = rc;
            }
            else {
                Control c = GetMainControl(index);
                if(resize_event_forced)
                    c.Bounds = Rectangle.Empty; //xăTCYCxgK悤ɂȂƖʓ|
                c.Bounds = rc;
            }
        }

        private void SetCurrentStock(Stock stock) {
            try {
                //TuXNCuŃG[N邱ƂlAɔɂĕύX݂
                try {
                    _itaControl.SetCurrentStock(stock);
                }
                catch(BellagioException ) {
                    _codeBox.SetTextExternal(_codeBox.LastCorrectText);
                    return;
                }

                Debug.WriteLine("SetCurrentStock " + stock.Market.ToString());
                _stock = stock;
                _currentPriceDocument.SetCurrentStock(stock); //ύX菇Ă̂炵
                _realtimeChartControl.SetCurrentStock(stock);
                //敨̓́AɂĂ܂
                Stock daily_stock = stock;
                if(stock.Profile.IsDerivative) {
                    DerivativeStockProfile.BrandT bt = ((DerivativeStockProfile)stock.Profile).Brand;
                    daily_stock = BellagioRoot.GlobalStockCollection.FindDerivativeStockProfile(bt==DerivativeStockProfile.BrandT.NikkeiFuture? "NFX" : "NMX", false).Primary;
                }
                _dailyChartControl.SetCurrentStock(daily_stock);
                if(_parameter.OrderCategory==OrderFormParameter.Category.NewPosition)
                    _orderControl.SetCurrentStockExternal(stock);
                OnOrderContentChanged();
                _orderDisplayLabel.Invalidate();
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }

        private void AdjustOrderConfirmLabel() {
            bool omit = _orderControl.OmitConfirmDialogBox;
            if(omit) {
                _showConfirmBoxLabel.Text = "mFȗ";
                _showConfirmBoxLabel.ForeColor = Color.Black;
                _showConfirmBoxLabel.BackColor = Color.Orange;
            }
            else {
                _showConfirmBoxLabel.Text = "mF\";
                _showConfirmBoxLabel.ForeColor = Color.Black;
                _showConfirmBoxLabel.BackColor = SystemColors.Control;
            }
        }

        private void CurrentPriceDocEvent() {
            try {
                if(_currentPriceDocument.DocumentStatus==BellagioDocumentStatus.Complete) {
                    IntraDayTrade dt = _currentPriceDocument.IntraDayTrade;
                    _headCurrentPrice.Drawing.StartMotion(dt.CurrentPriceInfo);
                    if(_currentPriceControl.Visible)
                        _currentPriceControl.Drawing.StartMotion(dt.CurrentPriceInfo);
                    if(_tickControl.Visible)
                        _tickControl.DocumentEvent();
                }
                else {
                    _headCurrentPrice.Invalidate();
                    _currentPriceControl.Invalidate();
                    _tickControl.Invalidate();
                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }

        private void OnOrderContentChanged() {
            _currentTradeItem = _orderControl.CreateTradeOrderItemSilent();
            if(_orderDisplayLabel!=null)
                _orderDisplayLabel.Invalidate();
        }
        private void OnItaSashineClick(SashineMotion m) {
            _orderControl.SetSashineExternal(m.Sashine.Price);
            OnOrderContentChanged();
        }
        private void OnChartSashineClick(object sender, MouseEventArgs args) {
            ChartControl cc = (ChartControl)sender;
            if(args.Button==MouseButtons.Left && _realtimeChartDocument.DocumentStatus==BellagioDocumentStatus.Complete) {
                int p = cc.ChartDrawing.GetCurrentMouseTrackingPrice();
                if(p > 0) {
                    _orderControl.SetSashineExternal(MarketUtil.AdjustNearestYobine(_stock, p));
                    OnOrderContentChanged();
                }
            }
        }
        private void OnFormToggleButtonClick(object sender, EventArgs args) {
            _formShrinked = !_formShrinked;
            //this.SuspendLayout();
            IconList ic = BellagioRoot.CommonIcons.ControlBoxes;
            if(_formShrinked) {
                this.FormBorderStyle = FormBorderStyle.FixedDialog;
                this.ClientSize = new Size(MINIMUM_CLIENT_WIDTH, MINIMUM_CLIENT_HEIGHT);
                _formToggleButton.SetImages(ic.GetBitmap(0, 1), ic.GetBitmap(1, 1));
                Control c = GetCurrentMainControl();
                c.Visible = false;
                _tab.Visible = false;
                this.Invalidate(true);
                this.Refresh(); //InvalidateĂςȗ̈悪ce
            }
            else {
                _tab.Visible = true;
                OnSelectedTabChanged(_tab, null);
                this.FormBorderStyle = FormBorderStyle.Sizable;
                this.ClientSize = new Size(MINIMUM_CLIENT_WIDTH, DEFAULT_CLIENT_HEIGHT + _orderControl.AdditionalPanelHeight);
                _formToggleButton.SetImages(ic.GetBitmap(0, 2), ic.GetBitmap(1, 2));
            }
            //this.ResumeLayout();
        }
        private void OnCodeBoxMouseUp(object sender, MouseEventArgs e) {
            if(e.Button==MouseButtons.Right && _currentPriceDocument.DocumentStatus!=BellagioDocumentStatus.Loading) {
                if(!_codeBox.EnabledEx) return;

                ContextMenuStrip cm = new ContextMenuStrip();
                IPoderosaMenuGroup[] menus = new IPoderosaMenuGroup[] {
                    new Bellagio.Chart.ChartMenuGroups.FutureMenuGroup(new SetStockCommand(this), false) };
                Poderosa.Forms.PublicMenuUtil.BuildContextMenu(cm, menus, null);

                try {
                    cm.Show((Control)sender, e.Location);
                }
                catch(Exception ex) {
                    RuntimeUtil.ReportException(ex);
                }

            }
        }
        private class SetStockCommand : PoderosaCommandImpl {
            private TabStyleOrderForm _form;
            public SetStockCommand(TabStyleOrderForm f) {
                _form = f;
            }
            public override CommandResult InternalExecute(ICommandTarget target, params IAdaptable[] args) {
                AbstractStockProfile prof = (AbstractStockProfile)args[0].GetAdapter(typeof(AbstractStockProfile));
                _form._codeBox.SetTextExternal(CodeDropDownDataProvider.DefaultFormat(prof));

                _form._marketBox.Enabled = true;
                FormUtil.SetComboBoxCandidates(_form._marketBox, OrderingUtil.FormatArray<StockExchange>(delegate(StockExchange ex) { return BellagioRoot.OrderDataProvider.OrderItemFormatter.FormatStockExchange(ex); }, prof==null? new StockExchange[0] : prof.GetStockExhcnageArray()));
                _form.SetCurrentStock(prof.Primary);
                
                return CommandResult.Succeeded;
            }
        }



        private void PaintOrderDisplayLabel(object sender, PaintEventArgs args) {
            try {
                OrderConfirmDrawingSettings settings = BellagioRoot.FixedPreferences.Ordering.OrderConfirmDrawingSettings;
                Graphics g = args.Graphics;
                int x1 = 8, x2 = 88;
                int y1 = 14, y2 = 30, y3 = 46, y4 = 62;

                IOrderItemFormatter fmt = BellagioRoot.OrderDataProvider.OrderItemFormatter;
                Font f = this.Font;
                Brush b = SystemBrushes.WindowText;
                TradeOrderItem i = _currentTradeItem;

                int x = x1;
                DrawStringUtil.MiddleLeft(g, " : ", f, b, ref x, y1);
                if(i!=null)
                    DrawStringUtil.MiddleLeft(g, FormatTradeType(), f, b/*i.IsBuying? settings.buyColor.B : settings.sellColor.B*/, ref x, y1);
                DrawStringUtil.MiddleLeft(g, String.Format(" : {0}{1}", i==null? "" : i.Volume.ToString("N0"), i==null||i.Stock==null? "" : i.Stock.Profile.VolumeUnitString), f, b, x1, y2);
                StringBuilder bld = new StringBuilder();
                if(i!=null) {
                    bld.Append(fmt.FormatOrderCondition(i.Condition));
                    if(OrderingUtil.IsSashineRequired(i.Condition)) 
                        bld.Append(i.AdjustPriceI(i.Sashine).ToString("N0")).Append("~");
                }
                DrawStringUtil.MiddleLeft(g, " : "+bld.ToString(), f, b, x1, y3);

                string kigen = i==null? "" : i.LimitDate==OrderLimitDate.Week? "T" : "";
                DrawStringUtil.MiddleLeft(g, " : "+kigen, f, b, x1, y4);
                string kouza = i==null? "" : (i.Stock!=null && i.Stock.Profile.IsDerivative)? "--" : fmt.FormatOrderKouza(i.Kouza);
                DrawStringUtil.MiddleLeft(g, " : "+kouza, f, b, x2, y4);
                
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        private string FormatTradeType() {
            if(_currentTradeItem==null) return "";

            StringBuilder bld = new StringBuilder();
            OrderDealType dt = _currentTradeItem.DealType;

            IOrderItemFormatter fmt = BellagioRoot.OrderDataProvider.OrderItemFormatter;
            if(dt==OrderDealType.Genbutsu)
                bld.Append("").Append(fmt.FormatTradeDescription(dt, _currentTradeItem.LongShort, _currentTradeItem.NewOrClose));
            else {
                if(OrderingUtil.IsShinnyo(dt))
                    bld.Append("Mp");
                bld.Append(fmt.FormatTradeDescription(dt, _currentTradeItem.LongShort, _currentTradeItem.NewOrClose));
                if(OrderingUtil.IsShinnyo(dt))
                    bld.Append(" (").Append(fmt.FormatShinnyoKubun(dt)).Append(")");
            }

            if(_parameter.OrderCategory==OrderFormParameter.Category.Change)
                bld.Append(" ύX");

            return bld.ToString();
        }


        private readonly static string[] staticchart_schema_names = new string[] {
            "tactico.daily-default", "tactico.weekly-default", "tactico.monthly-default"
        };
        private StaticChartDocument CreateDailyChartDocument(string schemaname) {
            ChartSchema schema = BellagioRoot.SchemaRoot.FindStaticChartSchema(schemaname);
            Debug.Assert(schema!=null);
            StaticChartDocument doc = new StaticChartDocument(schema.ChartUnit);
            doc.ShowMessageBoxOnSubscribeFailure = false;
            doc.ConstructWithSchema(schema);
            doc.SetOscillatorVisible(false);
            return doc;
        }
        private readonly static string[] minutelychart_schema_names = new string[] {
            "tactico.minutely-default", "tactico.3minutely-default", "tactico.5minutely-default"
        };
        private RealTimeChartDocument CreateMinutelyChartDocument(string schemaname) {
            ChartSchema schema = BellagioRoot.SchemaRoot.FindRealTimeChartSchema(schemaname);
            Debug.Assert(schema!=null);
            RealTimeChartDocument doc = new RealTimeChartDocument(schema.ChartScale);
            doc.ShowMessageBoxOnSubscribeFailure = false;
            doc.SubscribeDataKind = SubscribeDataKind.Ticks;
            doc.ConstructWithSchema(schema);
            doc.SetOscillatorVisible(false);
            return doc;
        }

        private Control GetCurrentMainControl() {
            if(_currentPriceControl.Visible) return _currentPriceControl;
            if(_dailyChartControl.Visible) return _dailyChartControl;
            if(_realtimeChartControl.Visible) return _realtimeChartControl;
            if(_itaControl.Visible) return _itaControl;
            if(_tickControl.Visible) return _tickControl;
            if(_orderControl.Visible) return _orderControl;
            return null;
        }
        private Control GetMainControl(int index) {
            if(index==0) return _orderControl;
            if(index==1) return _currentPriceControl;
            if(index==2) return _dailyChartControl;
            if(index==3) return _realtimeChartControl;
            if(index==4) return _itaControl;
            if(index==5) return _tickControl;
            return null;
        }
        private void OnReserveButtonClick(object sender, MouseEventArgs args) {
            if(args!=null && args.Button!=MouseButtons.Left) return;
            long now = DateTime.Now.Ticks / 10000; //msP
            if(now < _lastClickTime+1000) {
                Debug.WriteLine("suppress click");
                return;
            }
            PerformReserve();
        }
        private void PerformReserve() {
            if(_orderControl.ReserveOrderUI()) {
                if(BellagioRoot.FixedPreferences.Ordering.CloseFormOnOrder)
                    Close();
            }
        }
        private long _lastClickTime = 0;
        private void OnOrderButtonClick(object sender, MouseEventArgs args) {
            if(args!=null && args.Button!=MouseButtons.Left) return;
            //EnabledŃRg[ĂӖȂ
            long now = DateTime.Now.Ticks / 10000; //msP
            if(now < _lastClickTime+1000) {
                Debug.WriteLine("suppress click");
                return;
            }
            _lastClickTime = now;
            PerformOrder();
        }
        private void PerformOrder() {
            _orderButton.Enabled = false;
            _reserveButton.Enabled = false;
            if(_orderControl.SendOrderUI()) {
                //|WV̂Ƃ͐ݒɂ炸
                if(BellagioRoot.FixedPreferences.Ordering.CloseFormOnOrder || _parameter.OrderCategory==OrderFormParameter.Category.ClosePosition)
                    Close();
            }
            _orderButton.Enabled = true;
            _reserveButton.Enabled = true;
        }

        //ReLXgj[
        private ToolStripMenuItem CreateStripMenuItem(string text, bool checked_, EventHandler click) {
            ToolStripMenuItem mi = new ToolStripMenuItem();
            mi.Text = text;
            mi.Checked = checked_;
            mi.Click += click;
            return mi;
        }
        private ContextMenuStrip CreateTickControlContextMenu() {
            ContextMenuStrip cm = new ContextMenuStrip();

            cm.Items.Add(new TickStyleMenuHandler(this, "Xg^(&L)", TickGraphicsSettings.LayoutStyle.List).AsMenuItem());
            cm.Items.Add(new TickStyleMenuHandler(this, "Ot^(&G)", TickGraphicsSettings.LayoutStyle.Graph).AsMenuItem());

            return cm;
        }
        private class TickStyleMenuHandler {
            private string _text;
            private TickGraphicsSettings.LayoutStyle _style;
            private TabStyleOrderForm _this;
            public TickStyleMenuHandler(TabStyleOrderForm p, string text, TickGraphicsSettings.LayoutStyle l) {
                _this = p;
                _text = text;
                _style = l;
            }
            public ToolStripMenuItem AsMenuItem() {
                return _this.CreateStripMenuItem(_text, _this._tickLayout.LayoutStyle==_style, new EventHandler(Perform));
            }
            private void Perform(object sender, EventArgs args) {
                _this._tickLayout.LayoutStyle = _style;
                _this._tickControl.Invalidate();
            }
        }

        private void OnTickControlMouseDown(object sender, MouseEventArgs args) {
            if(args.Button==MouseButtons.Right && _realtimeChartDocument.DocumentStatus==BellagioDocumentStatus.Complete) {
                ContextMenuStrip cm = CreateTickControlContextMenu();
                cm.Show(_tickControl, args.Location);
            }
        }

        private ContextMenuStrip CreateItaControlContextMenu() {
            ContextMenuStrip cm = new ContextMenuStrip();

            cm.Items.Add(new ItaStyleMenuHandler(this, "X^C&1", ItaGraphicsSettings.LayoutStyle.Legacy).AsMenuItem());
            cm.Items.Add(new ItaStyleMenuHandler(this, "X^C&2", ItaGraphicsSettings.LayoutStyle.Plain).AsMenuItem());
            cm.Items.Add(new ItaStyleMenuHandler(this, "X^C&3", ItaGraphicsSettings.LayoutStyle.FixPricetoLeft).AsMenuItem());

            return cm;
        }

        private class ItaStyleMenuHandler {
            private string _text;
            private ItaGraphicsSettings.LayoutStyle _style;
            private TabStyleOrderForm _this;
            public ItaStyleMenuHandler(TabStyleOrderForm p, string text, ItaGraphicsSettings.LayoutStyle l) {
                _this = p;
                _text = text;
                _style = l;
            }
            public ToolStripMenuItem AsMenuItem() {
                return _this.CreateStripMenuItem(_text, _this._itaLayout.LayoutStyle==_style, new EventHandler(Perform));
            }
            private void Perform(object sender, EventArgs args) {
                _this._itaLayout.LayoutStyle = _style;
                _this._itaControl.Invalidate();
            }
        }

        private void OnItaControlMouseDown(object sender, MouseEventArgs args) {
            if(args.Button==MouseButtons.Right && _realtimeChartDocument.DocumentStatus==BellagioDocumentStatus.Complete) {
                ContextMenuStrip cm = CreateItaControlContextMenu();
                cm.Show(_itaControl, args.Location);
            }
        }

        //n`[g

        private ContextMenuStrip CreateDailyChartControlContextMenu() {
            ContextMenuStrip cm = new ContextMenuStrip();

            cm.Items.Add(new StaticChartSchemaMenuHandler(this, "(&D)", Quote.QuoteUnit.Daily, staticchart_schema_names[0]).AsMenuItem());
            cm.Items.Add(new StaticChartSchemaMenuHandler(this, "T(&W)", Quote.QuoteUnit.Weekly, staticchart_schema_names[1]).AsMenuItem());
            cm.Items.Add(new StaticChartSchemaMenuHandler(this, "(&M)", Quote.QuoteUnit.Monthly, staticchart_schema_names[2]).AsMenuItem());

            return cm;
        }

        private class StaticChartSchemaMenuHandler {
            private string _text;
            private string _schema;
            private Quote.QuoteUnit _unit;
            private TabStyleOrderForm _this;
            public StaticChartSchemaMenuHandler(TabStyleOrderForm p, string text, Quote.QuoteUnit unit, string schema) {
                _this = p;
                _text = text;
                _unit = unit;
                _schema = schema;
            }
            public ToolStripMenuItem AsMenuItem() {
                return _this.CreateStripMenuItem(_text, _this._dailyChartDocument.Quote.Unit==_unit, new EventHandler(Perform));
            }
            private void Perform(object sender, EventArgs args) {
                StaticChartDocument doc = _this.CreateDailyChartDocument(_schema);

                _this._dailyChartDocument = doc;
                _this._dailyChartControl.ReplaceDocument(doc);
            }
        }

        private void OnDailyChartContextMenu(object sender, MouseEventArgs args) {
            if(args.Button==MouseButtons.Right && _dailyChartDocument.DocumentStatus==BellagioDocumentStatus.Complete) {
                ContextMenuStrip cm = CreateDailyChartControlContextMenu();
                cm.Show(_dailyChartControl, args.Location);
            }
        }

        //n`[g

        private ContextMenuStrip CreateMinutelyChartControlContextMenu() {
            ContextMenuStrip cm = new ContextMenuStrip();

            cm.Items.Add(new MinutelyChartSchemaMenuHandler(this, "", 1, minutelychart_schema_names[0]).AsMenuItem());
            cm.Items.Add(new MinutelyChartSchemaMenuHandler(this, "&3", 3, minutelychart_schema_names[1]).AsMenuItem());
            cm.Items.Add(new MinutelyChartSchemaMenuHandler(this, "&5", 5, minutelychart_schema_names[2]).AsMenuItem());

            return cm;
        }

        private class MinutelyChartSchemaMenuHandler {
            private string _text;
            private string _schema;
            private int _scale;
            private TabStyleOrderForm _this;
            public MinutelyChartSchemaMenuHandler(TabStyleOrderForm p, string text, int scale, string schema) {
                _this = p;
                _text = text;
                _scale = scale;
                _schema = schema;
            }
            public ToolStripMenuItem AsMenuItem() {
                return _this.CreateStripMenuItem(_text, _this._realtimeChartDocument.Scale==_scale, new EventHandler(Perform));
            }
            private void Perform(object sender, EventArgs args) {
                RealTimeChartDocument doc = _this.CreateMinutelyChartDocument(_schema);

                _this._realtimeChartDocument = doc;
                _this._realtimeChartControl.ReplaceDocument(doc);
            }
        }

        private void OnMinutelyChartContextMenu(object sender, MouseEventArgs args) {

            if(args.Button==MouseButtons.Right && _realtimeChartDocument.DocumentStatus==BellagioDocumentStatus.Complete) {
                ContextMenuStrip cm = CreateMinutelyChartControlContextMenu();
                cm.Show(_realtimeChartControl, args.Location);
            }
        }


        //hbOhbv֌W

        private void OnStartDragPrice(int price) {
            //Ăђl
            price = MarketUtil.AdjustNearestYobine(_stock, price);
            OrderDraggingInfo.StartDrag(this, _stock, price);
            this.DoDragDrop(PRICEDRAG_STRING, DragDropEffects.All);
        }

        //private int _tempCount;
        protected override void OnGiveFeedback(GiveFeedbackEventArgs gfbevent) {
            base.OnGiveFeedback(gfbevent);
            try {
                OrderDraggingInfo di = OrderDraggingInfo.CurrentDraggingInfo;
                if(di!=null /*&& di.CursorStatus==OrderDraggingInfo.CursorStatusT.None*/) {
                    Debug.WriteLine("GFB " + gfbevent.Effect.ToString());
                    //this.Text = String.Format("GFB {0} {1}", gfbevent.Effect, _tempCount++);
                    di.GetDragImage(this); //ŃC[W쐬
                    gfbevent.UseDefaultCursors = false;
                    //this.Cursor = new Cursor(di.GetCurrentHIcon());
                    Cursor.Current = new Cursor(di.GetCurrentHIcon());
                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        protected override void OnQueryContinueDrag(QueryContinueDragEventArgs qcdevent) {
            base.OnQueryContinueDrag(qcdevent);
            if(qcdevent.Action==DragAction.Cancel) {
                OrderDraggingInfo.ClearCurrentDragging();
            }
        }

        private void OnReserveButtonDragEnter(object sender, DragEventArgs e) {
            try {
                OrderDraggingInfo di = OrderDraggingInfo.CurrentDraggingInfo;
                if(di!=null && IsPriceDragData(e.Data, di)) {
                    Debug.WriteLine("ReserveButton DragEnter");
                    di.GetReserveDropImage(this); //ŃC[W쐬
                    e.Effect = DragDropEffects.Move;
                    //ŃJ[\ύXĂBhbO\[XGiveFeedbackŎsKv
                    di.CursorStatus = OrderDraggingInfo.CursorStatusT.Reserving;
                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        private void OnOrderOrReserveButtonDragLeave(object sender, EventArgs e) {
            OrderDraggingInfo di = OrderDraggingInfo.CurrentDraggingInfo;
            if(di!=null) 
                di.CursorStatus = OrderDraggingInfo.CursorStatusT.None;
        }
        private void OnReserveButtonDragDrop(object sender, DragEventArgs e) {
            OrderDraggingInfo di = OrderDraggingInfo.CurrentDraggingInfo;
            if(di!=null && IsPriceDragData(e.Data, di)) {
                Debug.WriteLine("DROP!");
                if(!CheckAskPriceDragDropOrder(di.Sashine, "\")) return;
                SetSashineByDrop(di.Sashine);
                PerformReserve();
            }
        }
        private void OnOrderButtonDragEnter(object sender, DragEventArgs e) {
            try {
                OrderDraggingInfo di = OrderDraggingInfo.CurrentDraggingInfo;
                if(di!=null && IsPriceDragData(e.Data, di)) {
                    di.GetOrderDropImage(this); //ŃC[W쐬
                    e.Effect = DragDropEffects.Move;
                    //ŃJ[\ύXĂBhbO\[XGiveFeedbackŎsKv
                    di.CursorStatus = OrderDraggingInfo.CursorStatusT.Ordering;
                }
            }
            catch(Exception ex) {
                RuntimeUtil.ReportException(ex);
            }
        }
        private bool IsPriceDragData(IDataObject d, OrderDraggingInfo info) {
            string ds = d.GetData(typeof(string)) as string;
            return ds!=null && ds==PRICEDRAG_STRING && info.Stock==_stock && info.SourceForm==this;
        }
        private void OnOrderButtonDragDrop(object sender, DragEventArgs e) {
            OrderDraggingInfo di = OrderDraggingInfo.CurrentDraggingInfo;
            if(di!=null && IsPriceDragData(e.Data, di)) {
                if(!CheckAskPriceDragDropOrder(di.Sashine, "")) return;
                SetSashineByDrop(di.Sashine);
                PerformOrder();
            }
        }
        private void SetSashineByDrop(int price) {
            _orderControl.SetSashineExternal(price);
            OnOrderContentChanged();
            OrderDraggingInfo.ClearCurrentDragging();
        }

        //KvɉAbZ[W{bNXoď̑sq˂B
        private bool CheckAskPriceDragDropOrder(int price, string action_name) {
            if(BellagioRoot.FixedPreferences.Ordering.AskPriceDragDropOrder) {
                WarningWithDisableOption dlg = new WarningWithDisableOption(BellagioVersionInfo.APPLICATION_CAPTION,
                    String.Format("i{0:N0}~ɂ{1}܂B", price, action_name), "̃bZ[Wɕ\", MessageBoxButtons.OKCancel);
                dlg.CheckBoxChecked = true;
                bool ok = dlg.ShowDialog(this)==DialogResult.OK;
                if(ok) BellagioRoot.FixedPreferences.Ordering.AskPriceDragDropOrder = dlg.CheckBoxChecked;
                dlg.Dispose();
                return ok;
            }
            else
                return true;
        }

        private class LocalChartControlCustomize : ChartControl.IChartControlCustomize {
            public LocalChartControlCustomize() {
                
            }
            public void AdjustRectangleOperator(RectangleOperatorBuilder bld) {
            }

            public string FormatHeaderText(Stock stock) {
                return "";
            }

            public void CustomPaint(PaintEventArgs args) {
            }
        }
        private static Bitmap LargeBitmap(int index) {
            return OrderingPlugin.OrderingIcons.GetBitmap(index);
        }

    }

    //悤ƂĂɌŗL̏
    public class OrderFormParameter {
        public enum Category {
            NewPosition, //VK
            ClosePosition, //ϒ
            Change //
        }
        public enum ClosePositionType {
            MultiplePosition,           //ċʎw܂UI
            SpecifiedElement, //̌ʂ݂̂̌ϒ
            GenhikiGenwatasi, ///nBǂł邩PositionItem/茚Ă̂ǂł邩ɂ
        }

        private Category _category;
        private AbstractStockProfile _stockProfile; //VK̂Ƃ̂ݗL, null
        private TradePositionItem _position; //ϒ̂Ƃ̂ݗL, nulls
        private TradeOrderItem _targetOrder; //̂Ƃ̂ݗL, nulls
        private TradePositionItem.Element _positionElement;
        private ClosePositionType _closeType;

        //쐬͊estatic\bhg
        private OrderFormParameter(Category c) {
            _category = c;
        }

        public Category OrderCategory {
            get {
                return _category;
            }
        }
        public ClosePositionType CloseType {
            get {
                return _closeType;
            }
        }
        public TradePositionItem CurrentPosition {
            get {
                return _position;
            }
        }
        public TradePositionItem.Element PositionElement {
            get {
                return _positionElement;
            }
        }
        public TradeOrderItem CurrentOrder {
            get {
                return _targetOrder;
            }
        }
        public int MaximumVolume {
            get {
                Debug.Assert(_category!=Category.NewPosition);
                return _category==Category.Change? _targetOrder.Volume :
                    _positionElement!=null? (_positionElement.Volume - _positionElement.OrderingVolume) : 
                    _position.TotalVolume - _position.TotalOrderingVolume;
            }
        }

        public AbstractStockProfile StockProfile {
            get {
                switch(_category) {
                    case Category.NewPosition:
                        return _stockProfile;
                    case Category.ClosePosition:
                        return _position.Stock.Profile;
                    case Category.Change:
                        return _targetOrder.Stock.Profile;
                }
                Debug.Assert(false);
                return null;
            }
        }
        //w\Ȏ񋓁Bł͒oĂsAMpԍςł͌ĂĂs
        public StockExchange[] GetStockExchangeList() {
            switch(_category) {
                case Category.NewPosition:
                    return _stockProfile==null? new StockExchange[0] : _stockProfile.GetStockExhcnageArray();
                case Category.ClosePosition:
                    return OrderingUtil.IsShinnyo(_position.DealType)? new StockExchange[] { _position.Stock.Market } : _position.Stock.Profile.GetStockExhcnageArray();
                case Category.Change:
                    return new StockExchange[] { _targetOrder.Stock.Market };
            }
            Debug.Assert(false);
            return null;
        }
        public bool CanChangeVolume {
            get {
                return _category!=Category.Change;
            }
        }

        public static OrderFormParameter ForNewPosition() {
            OrderFormParameter p = new OrderFormParameter(Category.NewPosition);
            p._stockProfile = null;
            p._positionElement = null;
            return p;
        }
        public static OrderFormParameter ForNewPosition(AbstractStockProfile stock) {
            OrderFormParameter p = new OrderFormParameter(Category.NewPosition);
            p._stockProfile = stock;
            p._positionElement = null;
            return p;
        }
        public static OrderFormParameter ForNewPosition(TradeOrderItem item) { //ۗēx\z悤ȃP[X
            OrderFormParameter p = new OrderFormParameter(Category.NewPosition);
            p._stockProfile = item.Stock.Profile;
            p._positionElement = null;
            p._targetOrder = item;
            return p;
        }
        public static OrderFormParameter ForClosePosition(TradePositionItem position, ClosePositionType closetype, TradePositionItem.Element element) {
            OrderFormParameter p = new OrderFormParameter(Category.ClosePosition);
            p._position = position;
            p._closeType = closetype;
            p._positionElement = element;
            return p;
        }
        public static OrderFormParameter ForClosePosition(TradeOrderItem order) { //ۗēx\z悤ȃP[X
            OrderFormParameter p = new OrderFormParameter(Category.ClosePosition);
            p._targetOrder = order;
            p._position = order.TargetPosition;
            if(order.IsClosePositionDetailAvailable) {
                p._positionElement = null;
                p._closeType = ClosePositionType.MultiplePosition;
            }
            else {
                p._positionElement = order.TargetPositionElement;
                p._closeType = ClosePositionType.SpecifiedElement;
            }
            return p;
        }
        public static OrderFormParameter ForChangeOrder(TradeOrderItem order) {
            OrderFormParameter p = new OrderFormParameter(Category.Change);
            p._targetOrder = order;
            p._position = order.TargetPosition;
            //ύXCloseƂ͌Ȃp͂Ȃ
            if(order.IsClosePositionDetailAvailable) {
                p._positionElement = null;
                p._closeType = ClosePositionType.MultiplePosition;
            }
            else {
                p._positionElement = order.TargetPositionElement;
                p._closeType = ClosePositionType.SpecifiedElement;
            }
            return p;
        }
    }

}
