/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Screening/ScreeningResultPane.cs#3 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Diagnostics;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

using Bellagio.Environment;
using Bellagio.Data;
using Bellagio.Forms;
using Bellagio.Values;
using Bellagio.Chart;
using Bellagio.Bookmark;

namespace Bellagio.Screening
{


	public class ScreeningResultPane : BellagioDefaultForm {
		protected class ItemTag {
			public int group; //-1:ʁA0:Zp[^A1:
			public ScreeningResultItem entry;

			public ItemTag(int g, ScreeningResultItem e) {
				group = g;
				entry = e;
			}

			public const int TOP = -1;
			public const int SEPARATOR = 0;
			public const int BOTTOM = 1;
		}

		private class ScreeningListView : ListView {
            protected override void OnMouseWheel(MouseEventArgs e) {
                if(ScreeningPlugin.Instance.Preferences.MouseWheelOnResultPane==MouseWheelAction.SwitchStock) {
                    ListViewItem item = ScreeningUtil.GetSelectedItem(this);
                    if(item!=null) {
                        int c = this.Items.Count;
                        int i = item.Index;
                        if(e.Delta<0)
                            item = this.Items[i==c-1? c-1 : i+1];
                        else
                            item = this.Items[i==0? 0 : i-1];

                        item.Selected = true;
                        item.EnsureVisible();
                        ((HandledMouseEventArgs)e).Handled = true;
                    }
                }
                else
                    base.OnMouseWheel(e);
            }
		}

		private ContextMenu _contextMenu;
		private ScreeningResult _result;
		private int _requiredWidth;

		private System.Windows.Forms.Label _explanation;
		private Button _exportButton;
		private ScreeningListView _listView;
		private System.Windows.Forms.ColumnHeader _colCode;
		private System.Windows.Forms.ColumnHeader _colName;

		public ScreeningResultPane(ScreeningResult result) {
            Debug.Assert(result!=null);
			// ̌ĂяóAWindows.Forms tH[ fUCiŕKvłB
			InitializeComponent();
            this.FormBorderStyle = FormBorderStyle.Sizable;
            this.Height = 640;

			_result = result;
			// TODO: InitializeComponent Ăяǒɏǉ܂B
			InitList();
            this.Width = _requiredWidth + 40;
		}


		private void InitializeComponent()
		{
			this._explanation = new System.Windows.Forms.Label();
			this._exportButton = new Button();
			this._listView = new ScreeningListView();
			this._colCode = new System.Windows.Forms.ColumnHeader();
			this._colName = new System.Windows.Forms.ColumnHeader();
			this.SuspendLayout();
			// 
			// _explanation
			// 
			this._explanation.Location = new System.Drawing.Point(0, 0);
			this._explanation.Name = "_explanation";
			this._explanation.Size = new System.Drawing.Size(150, 23);
			this._explanation.TabIndex = 0;
			this._explanation.TextAlign = ContentAlignment.MiddleLeft;
			// 
			// _exportButton
			// 
			this._exportButton.Location = new System.Drawing.Point(24, 23);
			this._exportButton.Name = "_exportButton";
			this._exportButton.Size = new System.Drawing.Size(96, 23);
			this._exportButton.TabIndex = 1;
			this._exportButton.FlatStyle = FlatStyle.System;
			this._exportButton.TextAlign = ContentAlignment.MiddleLeft;
			this._exportButton.Click += new EventHandler(OnExportButtonClicked);
			this._exportButton.Text = "GNX|[g(&E)...";
			// 
			// _listView
			// 
			this._listView.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							   this._colCode,
																							   this._colName});
			this._listView.Location = new System.Drawing.Point(0, 48);
			this._listView.Name = "_listView";
			this._listView.TabIndex = 1;
			this._listView.FullRowSelect = true;
			this._listView.GridLines = true;
			this._listView.Name = "_listView";
			this._listView.TabIndex = 1;
			this._listView.MultiSelect = false;
			this._listView.Activation = ItemActivation.OneClick;
			this._listView.View = System.Windows.Forms.View.Details;
			this._listView.SelectedIndexChanged += new EventHandler(OnItemActivated);
			// 
			// _colCode
			// 
			this._colCode.Text = "R[h";
			this._colCode.Width = 40;
			// 
			// _colName
			// 
			this._colName.Text = "O";
			this._colName.Width = 80;
			// 
			// ScreeningResultPane
			// 
			this.Controls.Add(this._listView);
			this.Controls.Add(this._exportButton);
			this.Controls.Add(this._explanation);
			this.Name = "ScreeningResultPane";
			this.ResumeLayout(false);

		}

		private void InitList() {
			_listView.SuspendLayout();
			_requiredWidth = _colCode.Width + _colName.Width;
            this.Text = _result.Query.Title;
			_explanation.Text = String.Format("Ώۓ {0}\nL {1}", BDate.FormatMMDD(new BDate(_result.Query.OriginDate)), _result.Count);
			foreach(ScreeningQuery.Column col in _result.Query.Columns)
				AddColumn(col.label);
			this.Width = _listView.Width+8;
			//this.Height = Env.Frame.ChartCanvas.Height - 40;

			_listView.BeginUpdate();
			switch(_result.Query.CountType) {
				case ScreeningResultCountType.Top100:
                    for(int i=0; i<Math.Min(_result.Count, 100); i++)
                        AddItem(_result[i], ItemTag.BOTTOM);
                    break;
                case ScreeningResultCountType.Bottom100:
                    for(int i=0; i<Math.Min(_result.Count, 100); i++)
                        AddItem(_result[_result.Count-1 - i], ItemTag.TOP);
                    break;
                case ScreeningResultCountType.All:
                    for(int i=0; i<_result.Count; i++)
                        AddItem(_result[i], ItemTag.TOP);
                    break;
                case ScreeningResultCountType.Both50:
                    for(int i=0; i<Math.Min(_result.Count, 50); i++)
                        AddItem(_result[i], ItemTag.TOP);
					AddSeparator();
                    for(int i=0; i<Math.Min(_result.Count, 50); i++)
                        AddItem(_result[_result.Count-1 - i], ItemTag.BOTTOM);
					break;
			}
			_listView.EndUpdate();

			_listView.ResumeLayout();
		}
		private void AddColumn(string name) {
			ColumnHeader ch = new ColumnHeader();
			ch.Text = name;
			ch.Width = 60;
			ch.TextAlign = HorizontalAlignment.Right; // lȂ̂ŉE
			_requiredWidth += ch.Width;
			_listView.Columns.Add(ch);
		}
		private void AddItem(ScreeningResultItem item, int group) {
			string[] values = new string[_listView.Columns.Count];
            AbstractStockProfile prof = item.StockProfile;
            values[0] = prof.Code;
			values[1] = prof.Name;
			for(int i=0; i<_result.Query.Columns.Length; i++)
                values[2+i] = FormatValue(item.Results[i], _result.Query.Columns[i].formatter);
			ListViewItem li = new ListViewItem(values);
			li.Tag = new ItemTag(group, item);
			_listView.Items.Add(li);
		}
        private string FormatValue(BV value, NumberFormatter format) {
            if(value==null || value.IsNil)
                return "-";
            return format.Format(value);
        }

		private void AddSeparator() {
			string[] values = new string[_result.Query.Columns.Length+2]; //code,name̕2𑫂
			values[0] = "-";
			values[1] = "---";
			for(int i=2; i<values.Length; i++) //ȍ~ "-"
				values[i] = "-";
			ListViewItem li = new ListViewItem(values);
			li.Tag = new ItemTag(ItemTag.SEPARATOR, null);
			_listView.Items.Add(li);
		}

		protected override void OnResize(EventArgs e) {
			base.OnResize (e);
			int w = this.ClientSize.Width;
			_explanation.Width = w;
			_exportButton.Left = w - _exportButton.Width;
			_listView.Width = w;
			_listView.Height = this.ClientSize.Height - _exportButton.Bottom;
		}

		private void InitContextMenu() {
			_contextMenu = new ContextMenu();
            AddMenuItem(_contextMenu, "Cɓ֒ǉ(&B)...", new EventHandler(OnAddToBookmark));
			AddMenuItem(_contextMenu, "Nbv{[hփRs[(&C)", new EventHandler(OnCopyResult));
		    AddMenuItem(_contextMenu, "CSV`ŕۑ(&S)...", new EventHandler(OnSaveResult));
		}
        private static void AddMenuItem(Menu parent, string text, EventHandler handler) {
            MenuItem mi = new MenuItem();
            mi.Text = text;
            mi.Click += handler;
            parent.MenuItems.Add(mi);
        }

		private void OnExportButtonClicked(object sender, EventArgs args) {
			if(_contextMenu==null) InitContextMenu();
			_contextMenu.Show(this, new Point(_exportButton.Left, _exportButton.Bottom));
		}

		private void OnItemActivated(object sender, EventArgs args) {
			ListView.SelectedListViewItemCollection t = _listView.SelectedItems;
			if(t.Count==1) { //ÎƂ͂̋@\͎gȂ
				ListViewItem li = t[0];
				ItemTag tag = li.Tag as ItemTag;
				if(tag!=null) {
                    AbstractStockProfile prof = tag.entry.StockProfile;
                    ChartSchema cs = BellagioRoot.SchemaRoot.FindStaticChartSchema("tactico.daily-default");
                    if(cs!=null && prof!=null) {
                        ScreeningPlugin.Instance.CommandManager.Execute(new ChartOpenCommand(cs, prof.Primary, ChartOpenCommand.OpenStyleT.SameSchema), BellagioPlugin.Instance.ActivePoderosaWindow);
                    }
				}
			}
		}


		private void OnAddToBookmark(object sender, EventArgs args) {
            //SturecturedText̊֌WŃXy[X܂߂Ȃ
            string default_folder_name = String.Format("{0}_{1}", BDate.FormatMMDD(new BDate(_result.Query.OriginDate)), _result.Query.Title);
            using(SelectBookmarkFolderDialog dlg = new SelectBookmarkFolderDialog()) {
                dlg.SetForceEmptyFolderMode(default_folder_name);
                if(dlg.ShowDialog(this)==DialogResult.OK) {
                    BookmarkFolder f = dlg.ResultFolder;
                    int count = _listView.Items.Count;
                    if(count > 100) {
                        BUtil.ShowInformationMessageBox("100̂ݓo^܂B");
                        count = 100;
                    }

                    for(int i=0; i<_listView.Items.Count; i++) {
                        ItemTag tag = _listView.Items[i].Tag as ItemTag;
                        if(tag.entry!=null)
                            f.AddItem(new StockBookmark(tag.entry.StockProfile.Primary));
                    }
                    BellagioRoot.Bookmark.FireEvent.RefreshFolder(f);
                }
            }
		}

		private void OnCopyResult(object sender, EventArgs args) {
			ListViewUtil.CopyListViewContentToClipboard(_listView, true, new ListViewUtil.ItemChecker(ListViewItemChecker));
		}
		private void OnSaveResult(object sender, EventArgs args) {
			ListViewUtil.SaveListViewContentToFile("XN[jOʂ̕ۑ", _listView, true, new ListViewUtil.ItemChecker(ListViewItemChecker));
		}
		private bool ListViewItemChecker(ListViewItem li) {
			ItemTag t = li.Tag as ItemTag;
			return t!=null && t.entry!=null;
		}

        /*
		public override AbstractBrand NextBrand {
			get {
				if(_listView.SelectedItems.Count==0) return null;

				ListViewItem li = _listView.SelectedItems[0];
				if(li.Index < _listView.Items.Count-1) {
					_listView.Items[li.Index].Selected = false;
					ListViewItem next = _listView.Items[li.Index+1];
					next.Selected = true;
					ItemTag tag = next.Tag as ItemTag;
					if(tag.entry!=null) return tag.entry.Brand;
				}
				return null;
			}
		}
		public override AbstractBrand PrevBrand {
			get {
				if(_listView.SelectedItems.Count==0) return null;

				ListViewItem li = _listView.SelectedItems[0];
				if(li.Index > 0) {
					_listView.Items[li.Index].Selected = false;
					ListViewItem next = _listView.Items[li.Index-1];
					next.Selected = true;
					ItemTag tag = next.Tag as ItemTag;
					if(tag.entry!=null) return tag.entry.Brand;
				}
				return null;
			}
		}
        */

	}
}
