/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: CoreServicesEx.cs,v 1.8 2006/08/23 03:14:47 osawa Exp $
 */
using System;
using System.Collections.Generic;
using System.Text;

using Poderosa.Forms;
using Poderosa.Preferences;
using Poderosa.Commands;
using Poderosa.Serializing;
using Poderosa.Sessions;
using Poderosa.Boot;

namespace Poderosa.Plugins {
    //po@\ւ̃ANZTBPoderosaWorldGetAdapterł悤ɂĂ܂I
    /// <summary>
    /// <ja>
    /// WvOC\IȃC^[tFCXg|CgԂvpeB񋟂܂B
    /// </ja>
    /// <en>
    /// Property that returns a typical interface and the extension point with which a standard plug-in provides is offered. 
    /// </en>
    /// </summary>
    /// <remarks>
    /// <ja>
    /// ICoreServicesC^[tFCX́A<seealso cref="IPoderosaWorld">IPoderosaWorldC^[tFCX</seealso>
    /// <see cref="IAdaptable.GetAdapter">GetAdapter\bh</see>Ŏ擾ł܂B
    /// </ja>
    /// <en>
    /// The ICoreServices interface can be got in the <see cref="IAdaptable.GetAdapter">GetAdapter method</see> of the <seealso cref="IPoderosaWorld">IPoderosaWorld interface</seealso>. 
    /// </en>
    /// </remarks>
    /// <example>
    /// <ja>
    /// ICoreServices擾܂B
    /// <code>
    /// ICoreServices cs = PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// // IWindowManagerC^[tFCX擾܂
    /// IWindowManager wm = cs.WindowManager;
    /// </code>
    /// </ja>
    /// <en>
    /// Get ICoreServices
    /// <code>
    /// ICoreServices cs = PoderosaWorld.GetAdapter(typeof(ICoreServices));
    /// // Get IWindowManager interface.
    /// IWindowManager wm = cs.WindowManager;
    /// </code>
    /// </en>
    /// </example>
    public interface ICoreServices : IAdaptable {
        /// <summary>
        /// <ja>
        /// IWindowManagerC^[tFCXԂ܂B
        /// </ja>
        /// <en>
        /// Return IWindowManager interface.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <seealso cref="IPluginManager">IPluginManager</seealso><see cref="IPluginManager.FindPlugin">FindPlugin\bh</see>
        /// gāuorg.poderosa.core.windowsv̂ƓłB
        /// </ja>
        /// <en>
        /// It is the same as the retrieval of "org.poderosa.core.windows" by using the <see cref="IPluginManager.FindPlugin">FindPlugin method</see> of <seealso cref="IPluginManager">IPluginManager</seealso>. 
        /// </en>
        /// </remarks>
        IWindowManager WindowManager { get; }
        /// <summary>
        /// <ja>
        /// IPreferencesC^[tFCXԂ܂B
        /// </ja>
        /// <en>
        /// Return IPreferences interface.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <seealso cref="IPluginManager">IPluginManager</seealso><see cref="IPluginManager.FindPlugin">FindPlugin\bh</see>
        /// gāuorg.poderosa.core.preferencesv̂ƓłB
        /// </ja>
        /// <en>
        /// It is the same as the retrieval of "org.poderosa.core.preferences" by using the <see cref="IPluginManager.FindPlugin">FindPlugin method</see> of <seealso cref="IPluginManager">IPluginManager</seealso>. 
        /// </en>
        /// </remarks>
        IPreferences Preferences { get; }
        /// <summary>
        /// <ja>
        /// ICommandManagerC^[tFCXԂ܂B
        /// </ja>
        /// <en>
        /// Return ICommandManager interface.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <seealso cref="IPluginManager">IPluginManager</seealso><see cref="IPluginManager.FindPlugin">FindPlugin\bh</see>
        /// gāuorg.poderosa.core.commandsv̂ƓłB
        /// </ja>
        /// <en>
        /// It is the same as the retrieval of "org.poderosa.core.commands" by using the <see cref="IPluginManager.FindPlugin">FindPlugin method</see> of <seealso cref="IPluginManager">IPluginManager</seealso>. 
        /// </en>
        /// </remarks>
        ICommandManager CommandManager { get; }
        /// <summary>
        /// <ja>
        /// ISessionManagerC^[tFCXԂ܂B
        /// </ja>
        /// <en>
        /// Return ISessionManager interface.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <seealso cref="IPluginManager">IPluginManager</seealso><see cref="IPluginManager.FindPlugin">FindPlugin\bh</see>
        /// gāuorg.poderosa.core.sessionsv̂ƓłB
        /// </ja>
        /// <en>
        /// It is the same as the retrieval of "org.poderosa.core.sessions" by using the <see cref="IPluginManager.FindPlugin">FindPlugin method</see> of <seealso cref="IPluginManager">IPluginManager</seealso>. 
        /// </en>
        /// </remarks>
        ISessionManager SessionManager { get; }
        /// <summary>
        /// <ja>
        /// ISerializeServiceC^[tFCXԂ܂B
        /// </ja>
        /// <en>
        /// Return ISerializeService interface.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <seealso cref="IPluginManager">IPluginManager</seealso><see cref="IPluginManager.FindPlugin">FindPlugin\bh</see>
        /// gāuorg.poderosa.core.serializingv̂ƓłB
        /// </ja>
        /// <en>
        /// It is the same as the retrieval of "org.poderosa.core.serializing" by using the <see cref="IPluginManager.FindPlugin">FindPlugin method</see> of <seealso cref="IPluginManager">IPluginManager</seealso>. 
        /// </en>
        /// </remarks>
        ISerializeService SerializeService { get; }

        //ȉ͕poExtensionPoint
        /// <summary>
        /// <ja>
        /// PreferencePluginvOC񋟂g|CgԂ܂B
        /// </ja>
        /// <en>
        /// Return the extension point of the PreferencePlugin plug-in.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <seealso cref="IPluginManager">IPluginManager</seealso><see cref="IPluginManager.FindExtensionPoint">FindExtensionPoint\bh</see>
        /// gāuorg.poderosa.core.preferencesv̂ƓłB
        /// </ja>
        /// <en>
        /// It is the same as the retrieval of "org.poderosa.core.preferences" by using the <see cref="IPluginManager.FindExtensionPoint">FindExtensionPoint method</see> of <seealso cref="IPluginManager">IPluginManager</seealso>. 
        /// </en>
        /// </remarks>
        IExtensionPoint PreferenceExtensionPoint { get; }
        /// <summary>
        /// <ja>
        /// SerializeServicePluginvOC񋟂g|CgԂ܂B
        /// </ja>
        /// <en>
        /// Return the extension point of the SerializeServicePlugin plug-in.
        /// </en>
        /// </summary>
        /// <remarks>
        /// <ja>
        /// <seealso cref="IPluginManager">IPluginManager</seealso><see cref="IPluginManager.FindExtensionPoint">FindExtensionPoint\bh</see>
        /// gāuorg.poderosa.core.serializeElementv̂ƓłB
        /// </ja>
        /// <en>
        /// It is the same as the retrieval of "org.poderosa.core.serializeElement" by using the <see cref="IPluginManager.FindExtensionPoint">FindExtensionPoint method</see> of <seealso cref="IPluginManager">IPluginManager</seealso>. 
        /// </en>
        /// </remarks>
        IExtensionPoint SerializerExtensionPoint { get; }
    }

    //Jp̃IvV܂Ƃ߂Ă
    public interface IPoderosaDevelop : IAdaptable {
        bool SavePreference { get; set; }
    }


    //̎Ɠo^
    internal class CoreServices : ICoreServices, IPoderosaDevelop {
        private IPoderosaWorld _world;
        private AF _adapterFactory;

        private IWindowManager _windowManager;
        private IPreferences _preferences;
        private ICommandManager _commandManager;
        private ISessionManager _sessionManager;
        private ISerializeService _serializeService;
        private IExtensionPoint _preferenceExtensionPoint;
        private IExtensionPoint _serializerExtensionPoint;

        private bool _savePreference;

        public CoreServices(IPoderosaWorld world) {
            _world = world;
            _adapterFactory = new AF(_world, this);
            _world.AdapterManager.RegisterFactory(_adapterFactory);

            _savePreference = true;
        }

        public IWindowManager WindowManager {
            get {
                if(_windowManager==null) _windowManager = (IWindowManager)_world.PluginManager.FindPlugin(WindowManagerPlugin.PLUGIN_ID, typeof(IWindowManager));
                return _windowManager;
            }
        }

        public IPreferences Preferences {
            get {
                if(_preferences==null) _preferences = (IPreferences)_world.PluginManager.FindPlugin(PreferencePlugin.PLUGIN_ID, typeof(IPreferences));
                return _preferences;
            }
        }

        public ICommandManager CommandManager {
            get {
                if(_commandManager==null) _commandManager = (ICommandManager)_world.PluginManager.FindPlugin(CommandManagerPlugin.PLUGIN_ID, typeof(ICommandManager));
                return _commandManager;
            }
        }

        public ISerializeService SerializeService {
            get {
                if(_serializeService==null) _serializeService = (ISerializeService)_world.PluginManager.FindPlugin(SerializeServicePlugin.PLUGIN_ID, typeof(ISerializeService));
                return _serializeService;
            }
        }

        public ISessionManager SessionManager {
            get {
                if(_sessionManager==null) _sessionManager = (ISessionManager)_world.PluginManager.FindPlugin(SessionManagerPlugin.PLUGIN_ID, typeof(ISessionManager));
                return _sessionManager;
            }
        }


        public IExtensionPoint PreferenceExtensionPoint {
            get {
                if(_preferenceExtensionPoint==null) _preferenceExtensionPoint = (IExtensionPoint)_world.PluginManager.FindExtensionPoint(PreferencePlugin.EXTENSIONPOINT_NAME);
                return _preferenceExtensionPoint;
            }
        }

        public IExtensionPoint SerializerExtensionPoint {
            get {
                if(_serializerExtensionPoint==null) _serializerExtensionPoint = (IExtensionPoint)_world.PluginManager.FindExtensionPoint(SerializeServicePlugin.EXTENSIONPOINT_NAME);
                return _serializerExtensionPoint;
            }
        }

        public bool SavePreference {
            get {
                return _savePreference;
            }
            set {
                _savePreference = value;
            }
        }

        public IAdaptable GetAdapter(Type adapter) {
            return _world.AdapterManager.GetAdapter(this, adapter);
        }

        private class AF : IDualDirectionalAdapterFactory {
            private IPoderosaWorld _world;
            private CoreServices _coreServices;

            public AF(IPoderosaWorld world, CoreServices cs) {
                _world = world;
                _coreServices = cs;
            }
            

            public Type SourceType {
                get {
                    return _world.GetType();
                }
            }

            public Type AdapterType {
                get {
                    return typeof(CoreServices);
                }
            }

            //CX^XȂ̂ƂɗB̂Ԃ
            public IAdaptable GetAdapter(IAdaptable obj) {
                return _coreServices;
            }

            public IAdaptable GetSource(IAdaptable obj) {
                return _world;
            }
        }
    }
}
