using System.Collections.Generic;

namespace Sansa.Runtime {
    public interface ITimerDownstream {
        void oninitialize();
        void onstart();
        void onend();
        void ontick();
    }
    public interface ITickListener {
        void beforeTick();
        void afterTick();
    }

    //fQ[gX^C
    public class DTimerHandler : ITimerDownstream {
        public delegate void D(); //̌^ŋLB悭ĝłP
        private D _initialize;
        private D _start;
        private D _end;
        private D _tick;

        public DTimerHandler(D init) {
            _initialize = init;
        }
        public DTimerHandler(D init, D tick) {
            _initialize = init;
            _tick = tick;
        }
        //start, end͌
        public DTimerHandler SetStart(D start) {
            _start = start;
            return this;
        }
        public DTimerHandler SetEnd(D end) {
            _end = end;
            return this;
        }

        public void oninitialize() {
            _initialize();
        }
        public void onstart() {
            if(_start!=null) _start();
        }
        public void onend() {
            if(_end!=null) _end();
        }

        public void ontick() {
            if(_tick!=null) _tick();
        }

        //nh̃Xg
        public class DList {
            private LinkedList<D> _list;
            private D _handler;
            public DList() {
                _list = new LinkedList<D>();
                _handler = delegate() {
                    foreach(D h in _list) h();
                };
            }
            public DList Add(D d) {
                _list.AddLast(d);
                return this;
            }
            public D D {
                get {
                    return _handler;
                }
            }
        }
    }


}
