/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Common/TestUtil.cs#6 $
 * $DateTime: 2007/10/25 12:56:12 $
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

#if UNITTEST
using System.Configuration;
using NUnit.Framework;
#endif

namespace Bellagio.UnitTests {
#if UNITTEST
    public static class UnitTestUtil {

        //configuration file烍[h ݂Poderosa.Monolithic.configt@C
        public static string GetUnitTestConfig(string entry_name) {
            string r = ConfigurationManager.AppSettings[entry_name];
            if(r==null) Assert.Fail("the entry \"{0}\" is not found in .config file.", entry_name);
            return r;
        }
    }


    public class ErrorMessageWriter {
        private TextWriter _writer;
        public delegate object DoString(string data);

        public ErrorMessageWriter(string filename) {
            _writer = new StreamWriter(filename);
        }
        public void Close() {
            _writer.Close();
        }

        //G[bZ[W̋L^
        public void ConfirmError(string label, DoString action, string data) {
            bool err = false;
            try {
                action(data);
            }
            catch(Exception ex) {
                _writer.Write(label);
                _writer.Write(",");
                _writer.Write(data);
                _writer.Write(",");
                _writer.WriteLine(ex.Message);
                err = true;
            }
            Assert.IsTrue(err);
        }
    }
#endif
}
