/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Data/RandomItaFeeder.cs#9 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 * łۂ
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Threading;
using TimeAndSales=Bellagio.Values.TimeAndSales;
using TickItaRelation=Bellagio.Values.TickItaRelation;
using TickData=Bellagio.Values.TickData;

namespace Bellagio.Data {
    public class RandomItaFeeder {
        private Random _random;
        private int _size;
        private Ita _askSnapshot;
        private Ita _bidSnapshot;
        private Ita _askCurrent;
        private Ita _bidCurrent;
        
        private ItaMotion _askResult;
        private ItaMotion _bidResult;

        private int _bidPower; //̐́B0-100
        private int _volumeFactor; //P̒ł̐ʏ
        private int _volumeUnit; //P̐
        private int _priceStep; //li̊Ԋu

        private int _tradeProb;        //ɂԂm
        private int[] _orderProb; //mz
        private int[] _cancelProb; //LZmz

        //ꂼ̊mvl
        private int _totalProb;

        //XV̂݃oɕێ
        private TimeAndSales _tradeRecorder;
        private int _currentTime;

        public RandomItaFeeder(int ita_size) {
            _size = ita_size;
            _random = new Random();
        
            _askSnapshot = new Ita(_size, AskBid.Ask);
            _askCurrent = new Ita(_size, AskBid.Ask);
            _bidSnapshot = new Ita(_size, AskBid.Bid);
            _bidCurrent = new Ita(_size, AskBid.Bid);
            _askResult = new ItaMotion(_size);
            _bidResult = new ItaMotion(_size);

            InitProbabilities();

            _bidPower = 50;
            _volumeFactor = 200;
            _priceStep = 10;
            _volumeUnit = 1;

            //vvZ
            _totalProb = _tradeProb;
            foreach(int t in _orderProb) _totalProb += t;
            foreach(int t in _cancelProb) _totalProb += t;
        }

        //ep[^
        public int BidPower {
            get {
                return _bidPower;
            }
            set {
                _bidPower = value;
            }
        }
        public int VolumeFactor {
            get {
                return _volumeFactor;
            }
            set {
                _volumeFactor = value;
            }
        }
        public int PriceStep {
            get {
                return _priceStep;
            }
            set {
                _priceStep = value;
            }
        }
        public int VolumeUnit {
            get {
                return _volumeUnit;
            }
            set {
                _volumeUnit = value;
            }
        }


        private void InitProbabilities() {
            _tradeProb = 20;
            _orderProb = new int[_askCurrent.Size];
            _cancelProb = new int[_askCurrent.Size];
            FillProbArray(_orderProb, 10,  8, 5);
            FillProbArray(_cancelProb, 5,  4, 3);
        }
        private void FillProbArray(int[] t, int first, int second, int later) {
            t[0] = first;
            t[1] = second;
            for(int i=2; i<t.Length; i++) t[i] = later;
        }

        public void InitIta(int price) {
            for(int i=0; i<_askCurrent.Size; i++) {
                _askCurrent.SetDirect(i, price + _priceStep * i, _volumeFactor/2*_volumeUnit + CreateVolume(5));
                _bidCurrent.SetDirect(i, price - _priceStep * (i+1), _volumeFactor/2*_volumeUnit + CreateVolume(5));
            }
            _askSnapshot.Import(_askCurrent);
            _bidSnapshot.Import(_bidCurrent);
        }

        public ItaMotion AskResult {
            get {
                return _askResult;
            }
        }
        public ItaMotion BidResult {
            get {
                return _bidResult;
            }
        }
        public Ita Ask {
            get {
                return _askCurrent;
            }
        }
        public Ita Bid {
            get {
                return _bidCurrent;
            }
        }

        public TickData Update(Ita ask, Ita bid, int time, int actioncount_min, int actioncount_max) {
            _tradeRecorder = new TimeAndSales();
            _currentTime = time;
            Debug.Assert(ask.Size==_askCurrent.Size);
            Debug.Assert(bid.Size==_bidCurrent.Size);

            _askCurrent.Import(ask);
            _bidCurrent.Import(bid);
            _askSnapshot.Import(_askCurrent);
            _bidSnapshot.Import(_bidCurrent);

            int actioncount = actioncount_min + _random.Next(actioncount_max-actioncount_min+1);
            int[] ask_vol = ToVolumeArray(_askCurrent);
            int[] bid_vol = ToVolumeArray(_bidCurrent);
            int[] ask_pri = ToPriceArray(_askCurrent);
            int[] bid_pri = ToPriceArray(_bidCurrent);

            //OɌԂȂP̃ANV𖄂߂̂Ɏg
            if(ask_pri[0] - bid_pri[0] > _priceStep) {
                if(_bidPower > _random.Next(100)) {
                    RotateInner(bid_vol, bid_pri, -_priceStep);
                    bid_vol[0] = CreateVolume(1);
                }
                else {
                    RotateInner(ask_vol, ask_pri, _priceStep);
                    ask_vol[0] = CreateVolume(1);
                }
                actioncount--;
            }

            for(int i=0; i<actioncount; i++) {
                if(UpdateVolume(ask_vol, bid_vol, CreateVolume(1))) break;
            }
            //̒
            int ask_top_vol = ask_vol[0]; //Ȃ΍RTopɂȂ
            int bid_top_vol = bid_vol[0];
            if(ask_top_vol < 0) {
                RotateOuter(ask_vol, ask_pri, _priceStep);
                RotateInner(bid_vol, bid_pri, -_priceStep);
                bid_vol[0] = -ask_top_vol;
            }
            else if(bid_top_vol < 0) {
                RotateInner(ask_vol, ask_pri, _priceStep);
                RotateOuter(bid_vol, bid_pri, -_priceStep);
                ask_vol[0] = -bid_top_vol;
            }
            CheckEmptySashine(ask_vol, ask_pri, _priceStep);
            CheckEmptySashine(bid_vol, bid_pri, -_priceStep);
            
            //߂
            for(int i=0; i<ask_vol.Length; i++) _askCurrent.SetDirect(i, ask_pri[i], ask_vol[i]);
            for(int i=0; i<bid_vol.Length; i++) _bidCurrent.SetDirect(i, bid_pri[i], bid_vol[i]);

            _askResult.Create(_askSnapshot, _askCurrent);
            _bidResult.Create(_bidSnapshot, _bidCurrent);

            //Debug.Assert(_tradeRecorder.Count <= 1);
            return _tradeRecorder.Count>0? _tradeRecorder.LastTick : null;
        }


        //ʂXVAuCNtrueԂ
        private bool UpdateVolume(int[] ask, int[] bid, int volume) {
            bool action_bid = _bidPower > _random.Next(100);
            int[] target = action_bid? bid : ask;
            int[] opposite = action_bid? ask : bid;
            int action = _random.Next(_totalProb);

            if(action < _tradeProb) { //
                volume = Math.Min(volume, opposite[0]);
                if(volume > 0) {
                    opposite[0] -= volume; //΍R̔炷
                    _tradeRecorder.Add(_currentTime, action_bid? _askCurrent.SashineAt(0).Price : _bidCurrent.SashineAt(0).Price, volume, action_bid? TickItaRelation.Bid : TickItaRelation.Ask);
                }
                return opposite[0] <= 0;
            }
            else {
                int t = _tradeProb;
                for(int i=0; i<_orderProb.Length; i++) {
                    t += _orderProb[i];
                    if(action < t) {
                        target[i] += volume; //ǉ
                        return false;
                    }
                }
                for(int i=0; i<_cancelProb.Length; i++) {
                    t += _cancelProb[i];
                    if(action < t) {
                        target[i] -= volume; //LZ
                        if(target[i] < 0) target[i] = 0;
                        return false;
                    }
                }
                return false;
            }
        }

        //wIz1_volumeFactor܂ł_ɕԂAmul{
        private int CreateVolume(double mul) {
            int r = (int)Math.Floor(mul * Math.Exp(_random.NextDouble() * Math.Log(_volumeFactor)));
            if(r < 1) r= 1;
            return r * _volumeUnit;
        }
        private int[] ToPriceArray(Ita ita) {
            int[] r = new int[ita.Size];
            for(int i=0; i<r.Length; i++) r[i] = ita.SashineAt(i).Price;
            return r;
        }
        private int[] ToVolumeArray(Ita ita) {
            int[] r = new int[ita.Size];
            for(int i=0; i<r.Length; i++) r[i] = ita.SashineAt(i).Volume;
            return r;
        }
        private void CheckEmptySashine(int[] vols, int[] prices, int step) {
            for(int i=0; i<vols.Length; i++) {
                if(vols[i] <= 0) {
                    for(int j=i; j<vols.Length-1; j++) {
                        vols[j] = vols[j+1];
                        prices[j] = prices[j+1];
                    }
                    //[̔
                    vols[vols.Length-1] = CreateVolume(5);
                    prices[vols.Length-1] = prices[vols.Length-2] + step;
                    i--; //Ƃă`FbN
                }
            }
        }

        //OPi悤Ƀ[e[gBőO͏
        private void RotateOuter(int[] vols, int[] prices, int step) {
            for(int i=0; i<vols.Length-1; i++) {
                vols[i] = vols[i+1];
                prices[i] = prices[i+1];
            }
            vols[vols.Length-1] = CreateVolume(5);
            prices[vols.Length-1] = prices[vols.Length-2] + step;
        }
        //Pii{[Oj悤Ƀ[e[gBŊO͏
        private void RotateInner(int[] vols, int[] prices, int step) {
            for(int i=vols.Length-1; i>=1; i--) {
                vols[i] = vols[i-1];
                prices[i] = prices[i-1];
            }
            vols[0] = 0;
            prices[0] = prices[1] - step;
        }

#if DEBUG
        //eXgp@̂łƓ
        public static void Main(string[] args) {
            RandomItaFeeder f = new RandomItaFeeder(3);
            f.BidPower = 80;
            f.VolumeFactor = 100;
            f.InitIta(16500);
            DumpCurrent(f);
            TimeAndSales ts = new TimeAndSales();
            Ita ask = new Ita(3, AskBid.Ask);
            Ita bid = new Ita(3, AskBid.Bid);
            ask.Import(f.Ask);
            bid.Import(f.Bid);

            for(int i=0; i<1000; i++) {
                //f.Update(ask, bid, i, 1, 1, ts); //TODO dlύXɂ̃eXgǐĂȂ
                DumpCurrent(f);
                Thread.Sleep(100);
            }
        }
        private static void DumpCurrent(RandomItaFeeder f) {
            for(int i=0; i<3; i++)
                DumpSashine(f.Ask.SashineAt(2-i));
            Debug.WriteLine("");
            for(int i=0; i<3; i++)
                DumpSashine(f.Bid.SashineAt(i));
            Debug.WriteLine("---------");
        }
        private static void DumpSashine(Sashine s) {
            Debug.WriteLine(String.Format("{0} {1:d5}", s.Price, s.Volume));
        }
#endif
    }
}
