/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Drawing/BlurFilter.cs#10 $
 * $DateTime: 2007/12/28 19:23:38 $
 * 
 * ɂ񂾏ԂotB^ ₪ărbg}bv̈Sʂ@\
 * 
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;
using System.Diagnostics;
using System.Runtime.InteropServices;


namespace Bellagio.Drawing {
    //TESTINFO GraphicViewer
    public class BlurFilter : IDisposable {
        public enum Mode {
            Normal,
            BlurToBack
        }

        private Mode _mode;
        private uint _backColor;

        private float[] _aveFilter; //ωtB^
        private int _aveFilterWidth; //ωtB^̃TCY
        private int _aveFilterHeight;
        
        private Bitmap _bitmap; //H
        private int _width; //摜̃TCY
        private int _height;
        
        public BlurFilter(int width, int height, int aveFilterWidth, int aveFilterHeight, double y_factor, double div2, double bright) {
            Constructor(width, height, aveFilterWidth, aveFilterHeight, CreateGaussFilter(aveFilterWidth, aveFilterHeight, y_factor, div2, bright));
        }
        public BlurFilter(int width, int height, int aveFilterWidth, int aveFilterHeight, float[] aveFilter) {
            Constructor(width, height, aveFilterWidth, aveFilterHeight, aveFilter);
        }
        private void Constructor(int width, int height, int aveFilterWidth, int aveFilterHeight, float[] aveFilter) {
            _width = width;
            _height = height;
            _aveFilterWidth = aveFilterWidth;
            _aveFilterHeight = aveFilterHeight;
            _aveFilter = aveFilter;
            _mode = Mode.Normal;

            //炪͒l@*łȂ
            Debug.Assert(_aveFilterWidth * _aveFilterHeight == _aveFilter.Length);
            Debug.Assert((_aveFilterWidth & 1)==1);
            Debug.Assert((_aveFilterHeight & 1)==1);
        }
        public void SetMode(Mode m, uint backColor) { //backColorCOLORREF`
            _mode = m;
            _backColor = backColor;
        }

        public Bitmap Convert(Bitmap src) {
            InitBitmap(src);
            Rectangle rc = new Rectangle(0, 0, _width, _height);
            PixelFormat pf = src.PixelFormat;
            Debug.Assert(pf==PixelFormat.Format32bppArgb); //łȂƖT|[g
            BitmapData src_bmp = src.LockBits(rc, ImageLockMode.ReadOnly, pf);
            BitmapData dst_bmp = _bitmap.LockBits(rc, ImageLockMode.ReadWrite, pf);

            unsafe {
                ConvertMain((byte*)src_bmp.Scan0.ToPointer(), (byte*)dst_bmp.Scan0.ToPointer());
            }

            src.UnlockBits(src_bmp);
            _bitmap.UnlockBits(dst_bmp);
            return _bitmap;
        }

        private unsafe void ConvertMain(byte* srcData, byte* dstData) {
            for(int y=0; y<_height; y++)
                for(int x=0; x<_width; x++)
                    ConvertPixel(srcData, dstData, x, y);
        }

        private unsafe void ConvertPixel(byte* srcData, byte* dstData, int x, int y) {
            int offset = (y*_width+x)*4;
            float b = 0;
            float g = 0;
            float r = 0;
            dstData[offset+3] = srcData[offset+3]; //Alpha͂̂܂

            if(_mode==Mode.BlurToBack) {
                //wiFɈvĂȂi{̂̂jsNZ̓\[XRs[
                if(_backColor!=GetPixelColorAsInt(srcData, offset)) {
                    dstData[offset] = srcData[offset];
                    dstData[offset+1] = srcData[offset+1];
                    dstData[offset+2] = srcData[offset+2];
                    return;
                }
            }


            int fw = _aveFilterWidth>>1;
            int fh = _aveFilterHeight>>1;

            for(int ddy = -fh; ddy<=fh; ddy++) {
                int dy = y + ddy;
                if(dy<0 || dy>=_height) continue;

                for(int ddx = -fw; ddx<=fw; ddx++) {
                    int dx = x + ddx;
                    if(dx<0 || dx>=_width) continue;

                    float filter = GetAveFilterAt(-ddx, -ddy); //dx,dyɏW߂ĂX^CȂƂɒ
                    int so = (dy*_width+dx)*4;
                    b += cv2f(srcData[so  ]) * filter;
                    g += cv2f(srcData[so+1]) * filter;
                    r += cv2f(srcData[so+2]) * filter;
                }
            }

            dstData[offset  ] = f2cv(b);
            dstData[offset+1] = f2cv(g);
            dstData[offset+2] = f2cv(r);
        }

        private void InitBitmap(Bitmap src) {
            if(_bitmap==null) _bitmap = new Bitmap(_width, _height);
            Debug.Assert(_width==src.Width);
            Debug.Assert(_height==src.Height);
        }

        //S_̂
        private float GetAveFilterAt(int dx, int dy) {
            return _aveFilter[(((_aveFilterHeight>>1)+dy) * _aveFilterWidth) + ((_aveFilterWidth>>1)+dx)];
        }

        public void Dispose() {
            _bitmap.Dispose();
        }

        //float<->byte
        private static float cv2f(byte value) {
            return (float)value;
        }
        private static byte f2cv(float value) {
            int iv = (int)value;
            return iv<255? (byte)iv : (byte)0xFF;
        }

        private static unsafe uint GetPixelColorAsInt(byte* data, int offset) {
            uint b = (uint)data[offset];
            uint g = (uint)data[offset+1];
            uint r = (uint)data[offset+2];
            return (b<<16) | (g<<8) | r;
        }

        //KEXzŕϊ}bv쐬 y_factory̔{Adiv͕ÛQA(width/4)̂Q悭炢
        public static float[] CreateGaussFilter(int width, int height, double y_factor, double div2, double bright) {
            Debug.Assert(width>1 && (width % 2)==1);
            Debug.Assert(height>1 && (height % 2)==1); //ƂɊł邱ƂK{

            float[] result = new float[width * height];
            int hw = width / 2 + 1;
            int hh = height / 2 + 1;
            for(int x=0; x < hw; x++) {
                for(int y=0; y < hh; y++) {
                    double xx = x * x;
                    double yy = y * y / (y_factor * y_factor);
                    double v = 1.0 / (Math.PI * div2 * 2) * Math.Exp((xx + yy) / (div2 * -2.0));

                    SetValue(result, hw-1, hh-1, x, y, (float)v);
                }
            }

            float sum = 0;
            for(int i=0; i<result.Length; i++) sum += result[i];
            sum /= (float)bright;
            for(int i=0; i<result.Length; i++) result[i] /= sum;

            return result;
        }
        private static void SetValue(float[] result, int hw, int hh, int x, int y, float value) {
            int width = hw * 2 + 1;
            //ʂȑ܂܂Ă͂邪
            result[width * (hh + y) + (hw + x)] = value;
            result[width * (hh + y) + (hw - x)] = value;
            result[width * (hh - y) + (hw + x)] = value;
            result[width * (hh - y) + (hw - x)] = value;
        }
        public static void DumpGaussFilter(int width, int height, float[] map) {
            for(int y = 0; y<height; y++) {
                for(int x = 0; x<width; x++) {
                    Debug.Write((int)((map[y*width + x]*100)));
                    Debug.Write(" ");
                }
                Debug.WriteLine("");
            }
        }
    }
}
