/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Environment/BellagioPlugin.cs#21 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * Poderosat[[ÑvOC̃x[X
 * 
 * N菇̑܂ȗ
 *   1. Poderosat[[Ñu[g
 *   2. BellagioPlugin(̃NX̏) , ̒BellagioRoot.Init܂Ŏs
 *   3. RunExtension, ̒BellagioRoot.LoadBKvȂ񓯊IOɂ鏉Jn
 *   4. ŏ̃EBhEo_Ŕ񓯊܂߂ĂׂĂRv[gAG[oĂΕ\
 */

#pragma warning disable 162

using System;
using System.IO;
using System.Threading;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;

using Poderosa;
using Poderosa.Plugins;
using Poderosa.Commands;
using Poderosa.Forms;
using Poderosa.Sessions;
using Poderosa.View;
using Poderosa.Preferences;
using Poderosa.Usability;

using Travis.ORT;

using Sansa.Runtime;
using Bellagio.Forms;
using Bellagio.Data;
using Bellagio.Values;
using Bellagio.FigureBoard;

[assembly: PluginDeclaration(typeof(Bellagio.Environment.BellagioPlugin))]

namespace Bellagio.Environment {

    //OvOCANZX{
    public interface IBellagioEnvironment {
        string DataHomeDir { get; }
        string AppHomeDir { get; }
        IBellagioLoadingLog LoadingLog { get; }
    }

    //GfBVɌŗL̏񋟂C^tF[X
    public interface IBellagioEditionSpecificInfo {
        void ShowAboutBox(Form parent);
        Icon AppIcon { get; }
    }

    [PluginInfo(ID=BellagioPlugin.PLUGIN_ID, Version=BellagioVersionInfo.PLUGIN_VERSION, Author=BellagioVersionInfo.AUTHOR_NAME, Dependencies="org.poderosa.core.sessions;org.poderosa.optiondialog")]
    public class BellagioPlugin : PluginBase, IMainWindowEventHandler, IRootExtension, IBellagioEnvironment, IActiveDocumentChangeListener {
        public const string PLUGIN_ID = BellagioConstants.BELLAGIO_PLUGIN_ID;

        private ICoreServices _coreServices;
        private ICommandManager _commandManager;
        private ISessionManager _sessionManager;
        private IWinFormsService _winFormsService;
        private BellagioViewFactory _viewFactory;
        private BellagioCommandCollection _commands;
        private LoginToolBarComponent _loginBar;
        private BellagioToolBar _toolBar;
        private PaneBridgeAdapter _paneBridgeAdapter;
        private BootProcedureServer _bootProcedureServer;
        private IExtensionPoint _bootProcedurePoint;
        private IExtensionPoint _dataSourcePoint;
        private IExtensionPoint _dailyDataPoint;
        private IExtensionPoint _advancedToolPoint;
        private IExtensionPoint _editionSpecificInfo;

        private SansaPlatform _sansaPlatform;

        private static BellagioPlugin _instance;
        public static BellagioPlugin Instance {
            get {
                return _instance;
            }
        }
        public override void InitializePlugin(IPoderosaWorld poderosa) {
            base.InitializePlugin(poderosa);
            _instance = this;

            PoderosaPluginEnv.WINDOW_CAPTION_KEY = BellagioVersionInfo.APPLICATION_CAPTION;
            //PoderosaPluginEnv.MODULE_FILENAME_KEY = ;

            IPluginManager pm = poderosa.PluginManager;
            ICoreServices cs = (ICoreServices)poderosa.GetAdapter(typeof(ICoreServices));
            IPoderosaDevelop dev = (IPoderosaDevelop)cs.GetAdapter(typeof(IPoderosaDevelop));

            Debug.Assert(cs!=null);

            //GfBVŋʕ̋@\RtBM[V
            pm.FindExtensionPoint("org.poderosa.root").RegisterExtension(this);

            _coreServices = cs;
            _commandManager = cs.CommandManager;
            _sessionManager = cs.SessionManager;
            _sessionManager.AddActiveDocumentChangeListener(this);
            _winFormsService = (IWinFormsService)cs.WindowManager.GetAdapter(typeof(IWinFormsService));
            poderosa.PluginManager.FindExtensionPoint(WindowManagerConstants.MAINWINDOWEVENTHANDLER_ID).RegisterExtension(this);
            Debug.Assert(_winFormsService!=null);

            //MarketProvider͂GetAdapter\
            poderosa.AdapterManager.RegisterFactory(new AdapterForMarketProvider());

            _sansaPlatform = new SansaPlatform();
            _commands = new BellagioCommandCollection(_commandManager);
            _toolBar = new BellagioToolBar();
            poderosa.PluginManager.FindExtensionPoint(WindowManagerConstants.TOOLBARCOMPONENT_ID).RegisterExtension(_toolBar);

            //r[t@Ng
            _viewFactory  = new BellagioViewFactory();
            pm.FindExtensionPoint(WindowManagerConstants.VIEW_FACTORY_ID).RegisterExtension(_viewFactory);
            foreach(IViewManagerFactory mf in pm.FindExtensionPoint(WindowManagerConstants.MAINWINDOWCONTENT_ID).GetExtensions())
                mf.DefaultViewFactory = _viewFactory;
            _paneBridgeAdapter = new PaneBridgeAdapter();
            poderosa.AdapterManager.RegisterFactory(_paneBridgeAdapter);

            //BellagioPluging邽߂̃|Cg쐬
            _bootProcedurePoint = pm.CreateExtensionPoint(BellagioConstants.BOOT_PROCEDURE_EXTENSION, typeof(IBellagioBootProcedure), this);
            _dailyDataPoint = pm.CreateExtensionPoint(BellagioConstants.DAILYDATA_PROVIDER_EXTENSION, typeof(IDailyDataLoader), this);
            _editionSpecificInfo = pm.CreateExtensionPoint(BellagioConstants.EDITION_SPECIFIC_INFO_EXTENSION, typeof(IBellagioEditionSpecificInfo), this);

            //GfBVʂ̋@\RtBM[V
            if(BellagioVersionInfo.EDITION==BellagioEditions.HatchukunTX) {
                _dataSourcePoint = pm.CreateExtensionPoint(BellagioConstants.DATASOURCE_EXTENSION, typeof(IDataSourceEnvironment), this);
                _loginBar = new LoginToolBarComponent();
                poderosa.PluginManager.FindExtensionPoint(WindowManagerConstants.TOOLBARCOMPONENT_ID).RegisterExtension(_loginBar);
            }

            //IuWFNgc[\z
            BellagioEnvironmentParam env_param = new BellagioEnvironmentParam();
#if DEBUG
            env_param.SetupForDevelopment();
#else
            env_param.SetupForRelease();
#endif
            BellagioRoot.Init(env_param);

            BellagioRoot.FixedPreferences.RegisterExtension(cs.PreferenceExtensionPoint);
            cs.PreferenceExtensionPoint.RegisterExtension(BellagioRoot.ExtensionKitPreference);
            cs.PreferenceExtensionPoint.RegisterExtension(BellagioRoot.Bookmark);

            //R}ho^
            _commands.Register();

            //c[j[
            IExtensionPoint tool = poderosa.PluginManager.FindExtensionPoint("org.poderosa.menu.tool");

            //eXgɂ̂ݎgj[\zEo^
#if DEBUG
            tool.RegisterExtension(new TestAndDebugMenuGroup());
#endif
            //uxȋ@\ṽj[|Cg\z
            _advancedToolPoint = pm.CreateExtensionPoint(BellagioConstants.ADVANCED_TOOL_POINT, typeof(IPoderosaMenuGroup), this);
            IOptionDialogPluginInfo pi = (IOptionDialogPluginInfo)poderosa.PluginManager.FindPlugin("org.poderosa.optiondialog", typeof(IOptionDialogPluginInfo));
            Debug.Assert(pi!=null);
            _advancedToolPoint.RegisterExtension(pi.PreferencEEditorMenuGroup);
            tool.RegisterExtension(new PoderosaMenuGroupImpl(new IPoderosaMenu[] {
                new AdvancedToolMenuFolder(_advancedToolPoint),
                new PoderosaMenuItemImpl(_commands.ReloadExtensionsCommand, "gLbg̃[h(&R)")}
                ));

            //XNvg̃eXgFFigureBoardvOCɂPersonalł͂ł͂
            IGeneralCommand gc = new GeneralCommandImpl("figureBoard.showScriptScratchPad", "XNvgXNb`pbh̕\", _commandManager.CommandCategories.Dialogs, new ExecuteDelegate(FigureBoardPlugin.ShowScriptScratchPad));
            _commandManager.Register(gc);
            poderosa.PluginManager.FindExtensionPoint(BellagioConstants.ADVANCED_TOOL_POINT).RegisterExtension(new PoderosaMenuGroupImpl(
                new PoderosaMenuItemImpl(gc, "XNvg̃eXg(&T)...")));

            //wvj[
            IPoderosaMenu[] help_menu = BellagioVersionInfo.EDITION==BellagioEditions.DataGetPersonal?
                new IPoderosaMenu[] {
                    new BellagioMenuItemImpl(_commands.AboutBox, "o[W(&A)..."),
                    new BellagioMenuItemImpl(_commands.OpenTacticoPage, "TacticoWebTCgJ(&W)") } :
                new IPoderosaMenu[] {
                    new BellagioMenuItemImpl(_commands.AboutBox, "o[W(&A)..."),
                    new BellagioMenuItemImpl(_commands.OpenHelpPage, "͂イNTX wv(&H)"),
                    new BellagioMenuItemImpl(_commands.OpenRiyoKiyaku, "pK(&C)") };
            poderosa.PluginManager.FindExtensionPoint("org.poderosa.menu.help").RegisterExtension(new PoderosaMenuGroupImpl(help_menu));

        }
        public override void TerminatePlugin() {
            base.TerminatePlugin();
            _sansaPlatform.Stop();
            BellagioRoot.Terminate();

            //TODO ZbVƂ̃vOCłsvɂȂ
            if(BDebugOpts.TRACE_INDICATOR_CACHE)
                Bellagio.Chart.ChartDrawingStats.Print();
        }
        
        //IRootExtension
        public void InitializeExtension() {
            //̎_ł͑SvOC[hς݁BłEBhE͂łĂȂ

            IDataSourceEnvironment[] ds = _dataSourcePoint==null? new IDataSourceEnvironment[0] : (IDataSourceEnvironment[])_dataSourcePoint.GetExtensions();
            Debug.Assert(ds.Length<=1); //f[^͖T|[g
            if(ds.Length==1)
                BellagioRoot.DataSourceHost.Initialize(ds[0]);
            
            Debug.Assert(_coreServices.WindowManager.MainWindows.Length==0);
            _bootProcedureServer = new BootProcedureServer();
            _bootProcedureServer.Run(_bootProcedurePoint);
        }


        public BellagioCommandCollection Commands {
            get {
                return _commands;
            }
        }

        public SansaPlatform SansaPlatform {
            get {
                return _sansaPlatform;
            }
        }
        public Form MainWindow {
            get {
                IPoderosaMainWindow mw = _coreServices.WindowManager.ActiveWindow;
                return mw==null? null : mw.AsForm();
            }
        }
        public IPoderosaMainWindow ActivePoderosaWindow {
            get {
                return _coreServices.WindowManager.ActiveWindow;
            }
        }
        public ISessionManager SessionManager {
            get {
                return _sessionManager;
            }
        }
        public ICommandManager CommandManager {
            get {
                return _commandManager;
            }
        }
        public IPreferences PoderosaPreference {
            get {
                return _coreServices.Preferences;
            }
        }
        public IWindowManager WindowManager {
            get {
                return _coreServices.WindowManager;
            }
        }
        public IWinFormsService WinFormsService {
            get {
                return _winFormsService;
            }
        }
        public IExtensionPoint BootProcedurePoint {
            get {
                return _bootProcedurePoint;
            }
        }
        public IExtensionPoint DailyDataProviderPoint {
            get {
                return _dailyDataPoint;
            }
        }
        public LoginToolBarComponent LoginToolBar {
            get {
                return _loginBar;
            }
        }
        public IPoderosaApplication PoderosaApplication {
            get {
                return (IPoderosaApplication)_poderosaWorld.GetAdapter(typeof(IPoderosaApplication));
            }
        }

        #region IActiveDocumentChangeListener
        void IActiveDocumentChangeListener.OnDocumentDeactivated(IPoderosaMainWindow window) {
            Debug.WriteLine("Deactivated event");
        }
        void IActiveDocumentChangeListener.OnDocumentActivated(IPoderosaMainWindow window, IPoderosaDocument document) {
            //SȂ߂
            foreach(ISession sess in _sessionManager.AllSessions) {
                BellagioSessionBase bsb = sess as BellagioSessionBase;
                if(bsb!=null && bsb.BellagioViewContent.ContainerControl!=null) { //łȂ
                    bsb.BellagioViewContent.AdjustActiveDocumentStatus(bsb.IPoderosaDocument==document);
                }
            }
        }
        #endregion


        #region IMainWindowEventHandler
        public void OnFirstMainWindowLoaded(IPoderosaMainWindow window) {
            _bootProcedureServer.MainWindowLoaded(window);
        }

        public void OnMainWindowLoaded(IPoderosaMainWindow window) {
            RefreshStatusBar(window);
        }

        public void OnMainWindowUnloaded(IPoderosaMainWindow window) {
        }

        public void OnLastMainWindowUnloaded(IPoderosaMainWindow window) {
        }
        public bool AskCancelClosingLastWindow(IPoderosaMainWindow window) {
            if(BellagioRoot.FixedPreferences.AskQuit) {
                WarningWithDisableOption dlg = new WarningWithDisableOption(BellagioVersionInfo.APPLICATION_CAPTION, String.Format("{0}I܂H", BellagioVersionInfo.APPLICATION_CAPTION), "Iɏɂ̃bZ[W\", MessageBoxButtons.OKCancel);
                dlg.CheckBoxChecked = BellagioRoot.FixedPreferences.AskQuit;
                bool ok = dlg.ShowDialog()==DialogResult.OK;
                BellagioRoot.FixedPreferences.AskQuit = dlg.CheckBoxChecked;
                dlg.Dispose();
                return !ok;
            }
            else
                return false; //ŕ
        }

        public void RefreshStatusBar() {
            foreach(IPoderosaMainWindow w in BellagioPlugin.Instance.WindowManager.MainWindows)
                RefreshStatusBar(w);
        }
        private void RefreshStatusBar(IPoderosaMainWindow w) {
            if(BellagioVersionInfo.EDITION==BellagioEditions.HatchukunTX)
                w.StatusBar.SetStatusIcon(BellagioRoot.CommonIcons.SmallCommandButtons.GetBitmap(BellagioRoot.DataSourceHost.CurrentStatus==DataSourceStatus.Connected? 3 : 4));
            else
                w.StatusBar.SetStatusIcon(null);
        }

        #endregion

        private class AdapterForMarketProvider : IDualDirectionalAdapterFactory {
            public Type SourceType {
                get { return typeof(BellagioPlugin); }
            }
            public Type AdapterType {
                get { return typeof(DataSourceHost); }
            }
            public IAdaptable GetAdapter(IAdaptable obj) {
                return BellagioRoot.DataSourceHost;
            }
            public IAdaptable GetSource(IAdaptable obj) {
                return BellagioPlugin.Instance;
            }
        }


        string IBellagioEnvironment.DataHomeDir {
            get {
                return BellagioRoot.PathInfo.DataHomeDir;
            }
        }
        string IBellagioEnvironment.AppHomeDir {
            get {
                return BellagioRoot.PathInfo.AppHomeDir;
            }
        }
        /*
        string IBellagioEnvironment.DailydataDir {
            get {
                return BellagioRoot.FixedPreferences.DailyDataDir;
            }
        }
        */
        IBellagioLoadingLog IBellagioEnvironment.LoadingLog {
            get {
                return _bootProcedureServer.LoadingLog;
            }
        }

    }

    //BellagioPlugin.RunExtensionX^[gȂ
    public interface IBellagioBootProcedure {
        //JnB񓯊X^[g邱Ƃł
        void RunBootProcedure(IAdaptable server, IBellagioLoadingLog log);
        //IB񓯊Ƃ͂̒Ŋ҂
        void Join();
    }

    //BellagioPlugin.RunExtensionȌ̋NsBɁA
    // * RunExtensionƂƂɁAO̊gɂ镔܂߂ċNBKvȂ񓯊ɂȂB
    // * NɋNG[L^
    // * ŏ̃EBhE\ꂽ_Ŕ񓯊𓯊AUI̕KvȏےɈڂ
    public class BootProcedureServer : IStockListConstructor {
        private BellagioLoadingLog _loadingLog;
        private List<IBellagioBootProcedure> _procedures;

        public BootProcedureServer() {
            _procedures = new List<IBellagioBootProcedure>();
            _loadingLog = new BellagioLoadingLog(BellagioPlugin.Instance.PoderosaWorld);
        }
        public IBellagioLoadingLog LoadingLog {
            get {
                return _loadingLog;
            }
        }

        public void Run(IExtensionPoint procs) {
            //Xbhv[mF
            /*
            int work_threads, io_threads;
            ThreadPool.GetMaxThreads(out work_threads, out io_threads);
            //ƓĂ݂500,1000ƂB{ɂ̐̃Xbhҋ@Ă킯͂Ȃ̂ŎԂ͕s...
            Debug.WriteLine(String.Format("ThreadPoolCount work {0}, io {1}", work_threads, io_threads));
            */
            _procedures.AddRange((IBellagioBootProcedure[])procs.GetExtensions());
            _procedures.Add(new ExtensionFileLoader());
            foreach(IBellagioBootProcedure proc in _procedures)
                proc.RunBootProcedure(this, _loadingLog);
        }
        public void MainWindowLoaded(IPoderosaMainWindow window) {

            BellagioRoot.UIError.AttachToApplication();

            //҂
            foreach(IBellagioBootProcedure proc in _procedures)
                proc.Join();

            //ŏڑŃXe[^Xo[Zbg
            if(BellagioVersionInfo.EDITION==BellagioEditions.HatchukunTX)
                window.StatusBar.SetStatusIcon(BellagioRoot.CommonIcons.SmallCommandButtons.GetBitmap(4));
            
            if(BellagioRoot.EnvironmentParam.USE_DEMONSTRATION_STOCKS) {
                DemonstrationStocks.CreateAndStartRandomFeed();
            }

            //NG[Ε\
            if(_loadingLog.HasError) {
                SimpleLogViewer v = new SimpleLogViewer();
                v.Text = String.Format("{0} - NG[", BellagioVersionInfo.APPLICATION_CAPTION);
                v.SetMultiLineText(_loadingLog.GetMessagesAsStringArray());
                v.ShowDialog(window.AsForm());
                v.Dispose();
            }

            //gLbgǂݍ݂͔񓯊Ȃ̂ŁAPreferenceǂݍ݂ƕs邱ƂɂȂBƕs˂ȂB͂ł̂AL[̃JX^}CYƂɖ肪o
            BellagioPlugin.Instance.CommandManager.CurrentKeyBinds.ResetToDefault();

            //UÎޏ
            if(BellagioRoot.DataSourceHost.ExternalEnvironment!=null)
                BellagioRoot.DataSourceHost.CheckDataSource(); //NɃOC𑣂BJ̓_CAȌoȂ悤ɂׂ

            //OCIĂȂƖ̗LłȂ
            //ǂݍłȂƁAubN}[NJȂ܂܏IƂtbVĂ܂
            //ÎƂ́A܂XgǂłȂ̂ł͔̓
            if(!BellagioPlugin.Instance.PoderosaApplication.IsExitingApplication)
                BellagioRoot.Bookmark.AssureLateBind();
        }
        public void AddStock(AbstractStockProfile stock) {
            BellagioRoot.GlobalStockCollection.Add(stock);
        }
        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
    }

    //񓯊ɊgLbgt@Cǂݍ
    public class ExtensionFileLoader : IBellagioBootProcedure {
        private ManualResetEvent _event;
        private IBellagioLoadingLog _log;
        private SchemaRoot _schemaRoot;

        public void RunBootProcedure(IAdaptable server, IBellagioLoadingLog log) {
            _log = log;
            _schemaRoot = BellagioRoot.SchemaRoot;
            _schemaRoot.Unload();
            _event = new ManualResetEvent(false);
            ThreadPool.QueueUserWorkItem(new WaitCallback(AsyncLoadMain));
        }

        //[hł͔񓯊
        public SchemaRoot Reload(IBellagioLoadingLog log) {
            _log = log;
            _schemaRoot = BellagioRoot.SchemaRoot.CreateNewRoot();
            LoadMain();
            return _schemaRoot;
        }

        public void Join() {
            _event.WaitOne();
            _event.Close();

            //[h͂
            List<ExtensionKit> errors = new List<ExtensionKit>();
            foreach(ExtensionKit k in _schemaRoot.EnumExtensionKits()) {
                try {
                    k.Load();
                }
                catch(Exception ex) {
                    Debug.WriteLine(ex.StackTrace);
                    errors.Add(k);
                    _log.Add(ex.Message);
                }
            }

            foreach(ExtensionKit k in errors)
                _schemaRoot.RemoveExtensionKitDirect(k);
        }

        private void AsyncLoadMain(object state) {
            try {
                LoadMain();
            }
            finally {
                _event.Set();
            }
        }
        private void LoadMain() {
            string dir = BellagioRoot.PathInfo.ExtensionDir;
            if(Directory.Exists(dir)) {
                foreach(string file in Directory.GetFiles(dir, "*.tactico")) {
                    LoadOneExtensionFile(file);
                }
                foreach(string file in Directory.GetFiles(dir, "*.xml")) {
                    LoadOneExtensionFile(file);
                }
            }
        }
        private void LoadOneExtensionFile(string filename) {
            StreamReader sr = null;
            try {
                sr = new StreamReader(filename, Encoding.Default); //NOTE GR[fBOɂȂĂ
                XmlORReader xr = new XmlORReader(filename, sr);
                ExtensionKit kit = new ExtensionKit(filename);
                xr.Read(_schemaRoot.ExtensionKitSchema, kit);
                _schemaRoot.AddFixedExtensionKit(kit);
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.StackTrace);
                _log.Add(ex.Message);
            }
            finally {
                if(sr!=null) sr.Close();
            }
        }
    }

    public class AdvancedToolMenuFolder : IPoderosaMenuFolder {
        private IExtensionPoint _advancedTool;

        public AdvancedToolMenuFolder(IExtensionPoint advanced) {
            _advancedTool = advanced;
        }
        public IPoderosaMenuGroup[] ChildGroups {
            get {
                return (IPoderosaMenuGroup[])_advancedTool.GetExtensions();
            }
        }

        public string Text {
            get {
                return "xȋ@\(&A)";
            }
        }

        public bool IsEnabled(ICommandTarget target) {
            return true;
        }

        public bool IsChecked(ICommandTarget target) {
            return false;
        }


        public IAdaptable GetAdapter(Type adapter) {
            return BUtil.DefaultGetAdapter(this, adapter);
        }
    }


    public class SansaPlatform : IPlatformBridge {
        private RootTimer _rootTimer;
        private bool _started;
        public SansaPlatform() {
            _rootTimer = new RootTimer(30);
        }

        public object getAdapter(Type klass) {
            return klass==typeof(IPlatformBridge)? this : null;
        }

        public RootTimer getRootTimer() {
            return _rootTimer;
        }

        public void invalidate(int x, int y, int width, int height) {
        }

        //xJn
        public void AssureStart() {
            if(_started) return;

            _rootTimer.start();
            _started = true;
        }
        public void Stop() {
            if(_started) _rootTimer.stop();
            _started = false;
        }
    }

}
