/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: //depot/Bellagio/Demeter/Forms/FontDialog.cs#2 $
 */
using System;
using System.Drawing;
using System.Drawing.Text;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Diagnostics;
using System.Runtime.InteropServices;

using Poderosa;
using Poderosa.Usability;

namespace Bellagio.Forms {
    /// <summary>
    /// GFontDialog ̊Tv̐łB
    /// </summary>
    public class BFontDialog : System.Windows.Forms.Form {

        //̃_CAO͌ɂėlqĂ
        //private Language _language;

        private System.Windows.Forms.Label _lFontSize;
        private ComboBox _fontSizeList;
        private System.Windows.Forms.CheckBox _checkBoldStyle;
        private System.Windows.Forms.Label _lJapaneseFont;
        private System.Windows.Forms.ListBox _japaneseFontList;
        private Label _lJapaneseSample;
        private System.Windows.Forms.Button _okButton;
        private System.Windows.Forms.Button _cancelButton;
        /// <summary>
        /// KvȃfUCiϐłB
        /// </summary>
        private System.ComponentModel.Container components = null;

        private bool _ignoreEvent;

        private Font _japaneseFont;
        public Font JapaneseFont {
            get {
                return _japaneseFont;
            }
        }
        public bool EnableBoldStyle {
            get {
                return _checkBoldStyle.Checked;
            }
        }

        public void SetFont(bool enable_bold, Font japanese) {
            _ignoreEvent = true;
            _japaneseFont = japanese;
            _checkBoldStyle.Checked = enable_bold;
            //_lJapaneseSample.ClearType = true;
            int s = (int)japanese.Size;
            _fontSizeList.SelectedIndex = _fontSizeList.FindStringExact(s.ToString());
            _japaneseFontList.SelectedIndex = _japaneseFontList.FindStringExact(japanese.Name);

            if(_japaneseFontList.SelectedIndex==-1) _japaneseFontList.SelectedIndex = _japaneseFontList.FindStringExact("lr SVbN");

            _lJapaneseSample.Font = japanese;
            _ignoreEvent = false;
        }

        public BFontDialog() {
            //
            // Windows tH[ fUCi T|[gɕKvłB
            //
            InitializeComponent();

            this._lJapaneseFont.Text = "";
            this._lFontSize.Text = "TCY";
            this._checkBoldStyle.Text = "{[h(&B)";
            this._okButton.Text = "OK";
            this._cancelButton.Text = "LZ";
            this._lJapaneseSample.Text = "Tv";
            this.Text = "tHgݒ";
            InitUI();
        }

        /// <summary>
        /// gpĂ郊\[XɌ㏈s܂B
        /// </summary>
        protected override void Dispose(bool disposing) {
            if(disposing) {
                if(components != null) {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
        /// R[h GfB^ŕύXȂłB
        /// </summary>
        private void InitializeComponent() {
            this._lFontSize = new System.Windows.Forms.Label();
            this._fontSizeList = new System.Windows.Forms.ComboBox();
            this._checkBoldStyle = new System.Windows.Forms.CheckBox();
            this._lJapaneseFont = new System.Windows.Forms.Label();
            this._japaneseFontList = new System.Windows.Forms.ListBox();
            this._lJapaneseSample = new System.Windows.Forms.Label();
            this._okButton = new System.Windows.Forms.Button();
            this._cancelButton = new System.Windows.Forms.Button();
            this.SuspendLayout();
            // 
            // _lFontSize
            // 
            this._lFontSize.Location = new System.Drawing.Point(16, 12);
            this._lFontSize.Name = "_lFontSize";
            this._lFontSize.Size = new System.Drawing.Size(72, 16);
            this._lFontSize.TabIndex = 0;
            // 
            // _fontSizeList
            // 
            this._fontSizeList.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this._fontSizeList.Location = new System.Drawing.Point(94, 9);
            this._fontSizeList.Name = "_fontSizeList";
            this._fontSizeList.Size = new System.Drawing.Size(121, 20);
            this._fontSizeList.TabIndex = 1;
            this._fontSizeList.SelectedIndexChanged += new System.EventHandler(this.UpdateFontSample);
            // 
            // _checkBoldStyle
            // 
            this._checkBoldStyle.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._checkBoldStyle.Location = new System.Drawing.Point(18, 35);
            this._checkBoldStyle.Name = "_checkBoldStyle";
            this._checkBoldStyle.Size = new System.Drawing.Size(197, 15);
            this._checkBoldStyle.TabIndex = 3;
            this._checkBoldStyle.CheckedChanged += new System.EventHandler(this.UpdateFontSample);
            // 
            // _lJapaneseFont
            // 
            this._lJapaneseFont.Location = new System.Drawing.Point(144, 88);
            this._lJapaneseFont.Name = "_lJapaneseFont";
            this._lJapaneseFont.Size = new System.Drawing.Size(128, 23);
            this._lJapaneseFont.TabIndex = 6;
            this._lJapaneseFont.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // _japaneseFontList
            // 
            this._japaneseFontList.ItemHeight = 12;
            this._japaneseFontList.Location = new System.Drawing.Point(18, 56);
            this._japaneseFontList.Name = "_japaneseFontList";
            this._japaneseFontList.Size = new System.Drawing.Size(193, 100);
            this._japaneseFontList.TabIndex = 7;
            this._japaneseFontList.SelectedIndexChanged += new System.EventHandler(this.OnJapaneseFontChange);
            // 
            // _lJapaneseSample
            // 
            this._lJapaneseSample.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this._lJapaneseSample.Location = new System.Drawing.Point(18, 159);
            this._lJapaneseSample.Name = "_lJapaneseSample";
            this._lJapaneseSample.Size = new System.Drawing.Size(193, 40);
            this._lJapaneseSample.TabIndex = 9;
            this._lJapaneseSample.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // _okButton
            // 
            this._okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
            this._okButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._okButton.Location = new System.Drawing.Point(55, 208);
            this._okButton.Name = "_okButton";
            this._okButton.Size = new System.Drawing.Size(75, 23);
            this._okButton.TabIndex = 10;
            this._okButton.Click += new System.EventHandler(this.OnOK);
            // 
            // _cancelButton
            // 
            this._cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this._cancelButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._cancelButton.Location = new System.Drawing.Point(136, 208);
            this._cancelButton.Name = "_cancelButton";
            this._cancelButton.Size = new System.Drawing.Size(75, 23);
            this._cancelButton.TabIndex = 11;
            this._cancelButton.Click += new System.EventHandler(this.OnCancel);
            // 
            // BFontDialog
            // 
            this.AcceptButton = this._okButton;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.CancelButton = this._cancelButton;
            this.ClientSize = new System.Drawing.Size(223, 238);
            this.Controls.Add(this._cancelButton);
            this.Controls.Add(this._okButton);
            this.Controls.Add(this._lJapaneseSample);
            this.Controls.Add(this._japaneseFontList);
            this.Controls.Add(this._lJapaneseFont);
            this.Controls.Add(this._checkBoldStyle);
            this.Controls.Add(this._fontSizeList);
            this.Controls.Add(this._lFontSize);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "BFontDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.ResumeLayout(false);

        }
        #endregion


        private void InitUI() {
            _fontSizeList.Items.Add("6");
            _fontSizeList.Items.Add("8");
            _fontSizeList.Items.Add("9");
            _fontSizeList.Items.Add("10");
            _fontSizeList.Items.Add("11");
            _fontSizeList.Items.Add("12");
            _fontSizeList.Items.Add("14");
            _fontSizeList.Items.Add("16");
            _fontSizeList.Items.Add("18");
            _fontSizeList.Items.Add("20");

            InitFontList();
            /*
            foreach(FontFamily f in FontFamily.Families) {
                if(!f.IsStyleAvailable(FontStyle.Regular|FontStyle.Underline|FontStyle.Bold)) continue;
                Win32.LOGFONT lf = new Win32.LOGFONT();
                new Font(f, 10).ToLogFont(lf);
                //if((lf.lfPitchAndFamily & 0x01)==0) continue; //fixed pitcĥݔF߂
                Debug.WriteLine(lf.lfFaceName+" " + lf.lfCharSet + " " + lf.lfPitchAndFamily);
                if(lf.lfCharSet==128)
                    _japaneseFontList.Items.Add(f.GetName(0));
                if(lf.lfCharSet!=2) //Symbolp͏
                    _asciiFontList.Items.Add(f.GetName(0));
            }
            */
        }

        private void InitFontList() {
            Win32.tagLOGFONT lf = new Win32.tagLOGFONT();
            Graphics g = CreateGraphics();
            IntPtr hDC = g.GetHdc();

            Win32.EnumFontFamExProc proc = new Win32.EnumFontFamExProc(FontProc);
            IntPtr lParam = new IntPtr(0);
            lf.lfCharSet = 1; //default
            Win32.EnumFontFamiliesEx(hDC, ref lf, proc, lParam, 0);
            //lf.lfCharSet = 128; //{
            //lParam = new IntPtr(128);
            //Win32.EnumFontFamiliesEx(hDC, ref lf, proc, lParam, 0);
            g.ReleaseHdc(hDC);
        }

        private int FontProc(ref Win32.ENUMLOGFONTEX lpelfe, ref Win32.NEWTEXTMETRICEX lpntme, uint FontType, IntPtr lParam) {
            //(lpelfe.lfPitchAndFamily & 2)==0)
            bool interesting = FontType==4 && (lpntme.ntmTm.tmPitchAndFamily & 1)==0 && lpelfe.lfFaceName[0]!='@';
            //Terminal͈ˑR_
            //if(!interesting)
            //	if(lpelfe.lfFaceName=="FixedSys" || lpelfe.lfFaceName=="Terminal") interesting = true; //̂QTrueTypełȂƂXgɂ

            if(interesting) { //cłȂƂ͂łłȂ̂H
                //ڂ
                if(/*_language==Language.Japanese && */lpntme.ntmTm.tmCharSet==128) {
                    _japaneseFontList.Items.Add(lpelfe.lfFaceName);
                }
            }
            return 1;
        }

        private void UpdateFontSample(object sender, EventArgs args) {
            if(_ignoreEvent) return;
            //_lJapaneseSample.ClearType = _checkClearType.Checked;
            OnJapaneseFontChange(sender, args);
            //OnASCIIFontChange(sender, args);
            _lJapaneseSample.Invalidate();
        }
        private void OnJapaneseFontChange(object sender, EventArgs args) {
            if(_ignoreEvent || _japaneseFontList.SelectedIndex==-1) return;
            string fontname = (string)_japaneseFontList.Items[_japaneseFontList.SelectedIndex];
            _japaneseFont = RuntimeUtil.CreateFont(fontname, GetFontSize());
            _lJapaneseSample.Font = _japaneseFont;
        }
        private void OnOK(object sender, EventArgs args) {
            if(!CheckFixedSizeFont("FixedSys", 14) || !CheckFixedSizeFont("Terminal", 6, 10, 14, 17, 20))
                this.DialogResult = DialogResult.None;
            else {
                this.DialogResult = DialogResult.OK;
                try {
                    Close();
                }
                catch(Exception ex) {
                    Debug.WriteLine(ex.Message);
                    Debug.WriteLine(ex.StackTrace);
                }
            }
        }
        private void OnCancel(object sender, EventArgs args) {
            this.DialogResult = DialogResult.Cancel;
            Close();
        }

        //Œ蒷tHggĂƂAF߂ĂȂTCYw肵ĂxfalseԂB
        //allowed_sizes̓TCYw̃XgɊ܂܂Ă̂gp邱ƁI
        private bool CheckFixedSizeFont(string name, params float[] allowed_sizes) {
            if(_japaneseFont.Name==name) {
                float sz = GetFontSize();
                bool contained = false;
                float diff = Single.MaxValue;
                float nearest = 0;
                foreach(float t in allowed_sizes) {
                    if(t==sz) {
                        contained = true;
                        break;
                    }
                    else {
                        if(diff > Math.Abs(sz - t)) {
                            diff = Math.Abs(sz - t);
                            nearest = t;
                        }
                    }
                }

                if(!contained) {
                    BUtil.ShowWarningMessageBox(String.Format("TrueTypetHgȊO͎wł܂B", name, nearest));
                    _fontSizeList.SelectedIndex = _fontSizeList.FindStringExact(nearest.ToString());
                    return false;
                }
                else
                    return true;
            }
            else
                return true;
        }

        private float GetFontSize() {
            return Single.Parse((string)_fontSizeList.Items[_fontSizeList.SelectedIndex]);
        }


    }

    /// <summary>
    /// 
    /// </summary>
    /// <exclude/>
    class ClearTypeAwareLabel : Label {
        private bool _clearType;
        public bool ClearType {
            get {
                return _clearType;
            }
            set {
                _clearType = value;
            }
        }
        protected override void OnPaint(PaintEventArgs args) {
            base.OnPaint(args);
            args.Graphics.TextRenderingHint = _clearType? TextRenderingHint.ClearTypeGridFit : TextRenderingHint.SystemDefault;
        }
    }
}
