/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Forms/FormUtil.cs#16 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Resources;
using System.Windows.Forms;
using System.Drawing;
using System.Diagnostics;


namespace Bellagio.Forms {
    public static class FormUtil {

        //tH[_CAOɂ悭X^Cɐݒ
        public static void AdjustStyleForModalDialog(Form f) {
            f.Icon = BellagioRoot.CommonIcons.AppIcon16;
            f.ShowInTaskbar = false;
            f.StartPosition = FormStartPosition.CenterParent;
            f.MaximizeBox = false;
            f.MinimizeBox = false;
            f.FormBorderStyle = FormBorderStyle.FixedDialog;
        }
        public static void AdjustStyleForModelessSizableDialog(Form f, Form owner) {
            f.Icon = BellagioRoot.CommonIcons.AppIcon16;
            f.ShowInTaskbar = false;
            f.Owner = owner;
            if(!f.Visible) FormUtil.SetLocationToCenter(f, owner);
            f.StartPosition = FormStartPosition.Manual;
            f.MaximizeBox = false;
            f.MinimizeBox = false;
            f.FormBorderStyle = FormBorderStyle.Sizable;
        }
        public static void AdjustStyleForModelessFixedDialog(Form f, Form owner) {
            f.Icon = BellagioRoot.CommonIcons.AppIcon16;
            f.ShowInTaskbar = false;
            f.Owner = owner;
            if(!f.Visible) FormUtil.SetLocationToCenter(f, owner);
            f.StartPosition = FormStartPosition.Manual;
            f.MaximizeBox = false;
            f.MinimizeBox = false;
            f.FormBorderStyle = FormBorderStyle.FixedDialog;
        }
        //rc̒_ɍ悤ɃtH[̈ʒu킹
        public static void AdjustFormLocationToCenter(Form f, Rectangle rc) {
            f.Location = new Point(rc.X + (rc.Width - f.Width)/2, rc.Y + (rc.Height - f.Height)/2);
        }


        public static Button CreateOKButton() {
            Button b = new Button();
            b.Text = "OK";
            b.FlatStyle = FlatStyle.System;
            b.DialogResult = DialogResult.OK;
            return b;
        }
        public static Button CreateOKButton(EventHandler click) {
            Button b = CreateOKButton();
            b.Click += click;
            return b;
        }

        public static Button CreateCancelButton() {
            Button b = new Button();
            b.Text = "LZ";
            b.FlatStyle = FlatStyle.System;
            b.DialogResult = DialogResult.Cancel;
            return b;
        }
        public static Button CreateCancelButton(EventHandler click) {
            Button b = CreateCancelButton();
            b.Click += click;
            return b;
        }

        public static Label CreateLabel(string text) {
            Label l = new Label();
            l.Text = text;
            l.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            l.FlatStyle = FlatStyle.Flat;
            return l;
        }
        public static Label CreateLabelVT(string text) {
            Label l = new Label();
            l.Text = text;
            l.TextAlign = System.Drawing.ContentAlignment.TopLeft;
            l.FlatStyle = FlatStyle.Flat;
            return l;
        }
        //{[_[ăTCYƃZp[^ƂĎg
        public static Label CreateSeparatorAsLabel() {
            Label l = new Label();
            l.Text = "";
            l.BorderStyle = BorderStyle.Fixed3D;
            return l;
        }

        public static Label CreateImageLabel(Image img) {
            Label l = new Label();
            l.Size = img.Size;
            l.Image = img;
            l.BorderStyle = BorderStyle.None;
            return l;
        }

        public static RadioButton CreateRadioButton(string text, EventHandler checked_handler) {
            RadioButton b = new RadioButton();
            b.FlatStyle = FlatStyle.System;
            b.Text = text;
            b.CheckedChanged += checked_handler;
            return b;
        }

        public static ComboBox CreateComboBox() {
            return CreateComboBox(null);
        }
        public static ComboBox CreateComboBox(params string[] items) {
            ComboBox cb = new ComboBox();
            cb.DropDownStyle = ComboBoxStyle.DropDownList;
            if(items!=null) {
                foreach(string i in items) cb.Items.Add(i);
            }
            cb.SelectedIndex = cb.Items.Count==0? -1 : 0;
            return cb;
        }

        public static RibbonMenuButton CreateRibbonMenuButton(string text, Image image, MouseEventHandler click_handler) {
            RibbonMenuButton b = new RibbonMenuButton();
            b.Text = text;
            b.ShowBase = RibbonMenuButton.showbase.Yes;
            b.TextAlign = ContentAlignment.BottomCenter;
            b.MouseUp += click_handler;
            if(image!=null) {
                b.Image = image;
            }
            //Office2007J[O
            b.ColorBase =      Color.FromArgb(189, 205, 230);
            b.ColorOn =        Color.FromArgb(233, 204, 88);
            b.ColorChecked =   Color.FromArgb(233, 204, 88);
            b.ColorCheckedOn = Color.FromArgb(236, 209, 47);
            b.ColorPress =     Color.FromArgb(240, 213, 15);
            return b;
        }

        public static RibbonMenuButton CreateRibbonTextButton(string text, MouseEventHandler click_handler) {
            RibbonMenuButton b = new RibbonMenuButton();
            b.Text = text;
            b.ShowBase = RibbonMenuButton.showbase.Yes;
            b.TextAlign = ContentAlignment.MiddleLeft;
            b.MouseUp += click_handler;
            //Office2007J[O
            b.ColorBase =      Color.FromArgb(189, 205, 230);
            b.ColorOn =        Color.FromArgb(233, 204, 88);
            b.ColorChecked =   Color.FromArgb(233, 204, 88);
            b.ColorCheckedOn = Color.FromArgb(236, 209, 47);
            b.ColorPress =     Color.FromArgb(240, 213, 15);
            return b;
        }



        public static RibbonMenuButton CreateRibbonCommandButton(string text, Image image, MouseEventHandler click_handler) {
            RibbonMenuButton b = new RibbonMenuButton();
            b.ShowBase = RibbonMenuButton.showbase.Yes;
            b.Text = text;
            b.TextAlign = ContentAlignment.BottomCenter;
            b.MouseUp += click_handler;
            if(image!=null) {
                b.Image = image;
            }
            //Office2007J[O
            b.ColorBase =      Color.FromArgb(189, 205, 230);
            b.ColorOn =        Color.FromArgb(233, 204, 88);
            b.ColorPress =     Color.FromArgb(240, 213, 15);
            return b;
        }

        //C[WAeLXgẼ{^
        public static Button CreateImageAndTextButton(Image img, string text, EventHandler click) {
            Button b = new Button();
            b.Image = img;
            b.ImageAlign = ContentAlignment.MiddleLeft;
            //b.FlatStyle = FlatStyle.System;
            b.Text = text;
            b.TextAlign = ContentAlignment.MiddleCenter;
            b.Click += click;
            return b;
        }
        //{^UIŃ`FbN{bNXɂȂĂ̂쐬
        public static CheckBox CreateImageAndTextToggleButton(Image img, string text, EventHandler click) {
            CheckBox c = new CheckBox();
            c.Appearance = Appearance.Button;
            c.Text = text;
            c.TextAlign = ContentAlignment.MiddleRight;
            if(img!=null) {
                c.Image = img;
                c.ImageAlign = ContentAlignment.MiddleLeft;
            }
            //c.FlatStyle = FlatStyle.System;
            c.Click += click;
            return c;
        }
        //VvȃR}h{^
        public static Button CreateTextButton(string text, EventHandler click) {
            Button b = new Button();
            b.Text = text;
            b.Click += click;
            b.FlatStyle = FlatStyle.System;
            return b;
        }

        //I[itH[̒
        public static void SetLocationToCenter(Form target, Form owner) {
            Point pt = new Point(owner.Left + (owner.Width - target.Width)/2, owner.Top + (owner.Height - target.Height)/2);
            if(pt.X < 0) pt.X = 0;
            if(pt.Y < 0) pt.Y = 0;
            target.Location = pt;

        }

        //R{{bNX̒gZbg
        public static void SetComboBoxCandidates(ComboBox box, string[] values) {
            box.Items.Clear();
            box.Items.AddRange(values);
            box.SelectedIndex = values.Length==0? -1 : 0;
        }

        //`̂ݎOōsRg[B̂̓x
        public static Control CreateCustomPaintControl(PaintEventHandler paint) {
            Label l = new Label();
            l.BorderStyle = BorderStyle.None;
            l.Paint += paint;
            return l;
        }

        
        //KV[X^C̃j[쐬
        public static MenuItem AddMenuItem(Menu parent, string text, EventHandler handler) {
            MenuItem mi = new MenuItem();
            mi.Text = text;
            mi.Index = parent.MenuItems.Count;
            mi.Click += handler;
            parent.MenuItems.Add(mi);
            return mi;
        }

    }

    //SetStyle߂̃tH[
    public class BellagioDefaultForm : Form {
        public BellagioDefaultForm() {
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer|ControlStyles.AllPaintingInWmPaint, true);
        }
    }
    public class BellagioDefaultPanel : Panel {
        public BellagioDefaultPanel() {
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer|ControlStyles.AllPaintingInWmPaint, true);
        }
    }

}
