/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id$
 * $DateTime$
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Windows.Forms;
using System.IO;

namespace Bellagio.Forms {
    public class ListViewUtil {
        public delegate bool ItemChecker(ListViewItem li);

        public static void CopyListViewContentToClipboard(ListView lv, bool with_headers, ItemChecker checker) {
            StringBuilder bld = new StringBuilder();
            bool first = true;
            if(with_headers) {
                foreach(ColumnHeader h in lv.Columns) {
                    if(!first) bld.Append("\t");
                    bld.Append(h.Text);
                    first = false;
                }
                bld.Append("\r\n");
            }
            foreach(ListViewItem item in lv.Items) {
                if(checker(item)) {
                    first = true;
                    foreach(ListViewItem.ListViewSubItem si in item.SubItems) {
                        if(!first) bld.Append("\t");
                        bld.Append(si.Text);
                        first = false;
                    }
                    bld.Append("\r\n");
                }
            }
            try {
                Clipboard.SetDataObject(bld.ToString(), true);
            }
            catch(Exception ex) {
                MessageBox.Show("Nbv{[hɎs܂BAvP[Vł̓ƏՓ˂\܂B");
                Debug.WriteLine(ex.Message); //HɎs邱Ƃ
            }
        }

        public static void SaveListViewContentToFile(string caption, ListView lv, bool with_headers, ItemChecker checker) {
            SaveFileDialog dlg = new SaveFileDialog();
            dlg.Title = caption;
            dlg.Filter = "CSV Files(*.csv)|*.csv";
            dlg.DefaultExt = "csv";
            if(dlg.ShowDialog()==DialogResult.OK) {
                StreamWriter st = null;
                try {
                    st = new StreamWriter(dlg.FileName, false, Encoding.Default);
                    bool first = true;
                    if(with_headers) {
                        foreach(ColumnHeader h in lv.Columns) {
                            if(!first) st.Write(",");
                            st.Write(h.Text);
                            first = false;
                        }
                        st.WriteLine();
                    }
                    foreach(ListViewItem item in lv.Items) {
                        if(checker(item)) {
                            first = true;
                            foreach(ListViewItem.ListViewSubItem si in item.SubItems) {
                                if(!first) st.Write(",");
                                st.Write(si.Text);
                                first = false;
                            }
                            st.WriteLine();
                        }
                    }
                }
                catch(Exception ex) {
                    Debug.WriteLine(ex.StackTrace);
                    BUtil.ShowWarningMessageBox("ʂ̕ۑɎs܂B" + ex.Message);
                }
                finally {
                    if(st!=null) st.Close();
                }
            }
        }
    }
}
