/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Ordering/OrderingPreference.cs#6 $
 * $DateTime: 2008/04/17 18:18:30 $
 */
using System;
using System.Collections.Generic;
using System.Text;

using Bellagio.Environment;
using Bellagio.Forms;

using Poderosa.Plugins;
using Poderosa.Preferences;

namespace Bellagio.Ordering {
    //̂Ƃǂ\邩
    public enum PartialTradeDisplay {
        Traded, //ςݐʂ\
        Remaining //cʂ\
    }

    public enum OrderFormStyle {
        Owned,      //CEBhEɏL
        StandAlone, //CEBhEƓiB^XNo[ɂ\
        //TopMost,    //őOʕ\
    }

    public class OrderingPreferences : PreferenceSupplierImpl, IPreferenceChangeListener {
        private IStringPreferenceItem _tradeSoundFile; //ʒmpX
        private IBoolPreferenceItem _showOrderConfirmDialog; //mF\邩ǂ
        private IBoolPreferenceItem _showTradeNotification; //ʒm\邩ǂ
        private EnumPreferenceItem<PartialTradeDisplay> _partialTradeDisplay; //莞̐ʕ\͎cϐ
        private IBoolPreferenceItem _showMultipleCreditCloseWarning; //̌ʂ̓ςƂx{bNXoǂ
        private IBoolPreferenceItem _positionRefreshByTrade; //ʒmŃ|WVXV邩
        private IBoolPreferenceItem _halfTransparentView; //Ɖʂ𔼓ɂ邩
        private IIntPreferenceItem _maxTradeElementForToolTip; //ڍׂc[`bv\ɂȂő吔
        //private IBoolPreferenceItem _omitDisplayIfDateIsToday; //̎ł͓t\ȗ
        private IIntPreferenceItem _powerInfoDisplayStyle; //]͏\X^C
        private IBoolPreferenceItem _showSuccessfulOrderMessage; //̃bZ[W\邩ǂ
        private IStringPreferenceItem _orderListHiddenColumns; //ƉJ\ݒ
        private IStringPreferenceItem _positionListHiddenColumns; //|WVƉJ\ݒ
        private IIntPreferenceItem _orderListSortOption; //Ɖ\[gw
        private IIntPreferenceItem _positionListSortOption; //|WVƉ\[gw
        private IBoolPreferenceItem _askPriceDragDropOrder; //lĩhbOhbvŔ/\Ƃxoǂ
        private IBoolPreferenceItem _closeFormOnOrder;      //邩ǂ
        private EnumPreferenceItem<OrderFormStyle> _orderFormStyle; //tH[̃X^C

        private TradeOrderListDrawingSettings _orderListDrawingSettings;
        private PositionListDrawingSettings _positionListDrawingSettings;
        private TradeNotificationDrawingSettings _tradeNotificationDrawingSettings;
        private PowerInfoDrawingSettings _powerInfoDrawingSettings;
        private OrderConfirmDrawingSettings _orderConfirmDrawingSettings;

        public OrderingPreferences()
            : base("tactico.ordering") {
        }

        public void RegisterExtension(IExtensionPoint pt) {
            _orderListDrawingSettings = new TradeOrderListDrawingSettings("tactico.orderListDrawing");
            _positionListDrawingSettings = new PositionListDrawingSettings("tactico.positionListDrawing");
            _tradeNotificationDrawingSettings = new TradeNotificationDrawingSettings("tactico.tradeNotificationDrawing");
            _powerInfoDrawingSettings = new PowerInfoDrawingSettings("tactico.powerInfoDrawing");
            _orderConfirmDrawingSettings = new OrderConfirmDrawingSettings("tactico.orderConfirmDrawing");

            pt.RegisterExtension(this);
            pt.RegisterExtension(_orderListDrawingSettings);
            pt.RegisterExtension(_positionListDrawingSettings);
            pt.RegisterExtension(_tradeNotificationDrawingSettings);
            pt.RegisterExtension(_powerInfoDrawingSettings);
            pt.RegisterExtension(_orderConfirmDrawingSettings);
        }

        public override void InitializePreference(IPreferenceBuilder builder, IPreferenceFolder folder) {
            folder.AddChangeListener(this);
            _tradeSoundFile = builder.DefineStringValue(folder, "tradeSoundFile", "Execution.wav", null);
            _showOrderConfirmDialog = builder.DefineBoolValue(folder, "showOrderConfirmDialog", true, null);
            _showTradeNotification = builder.DefineBoolValue(folder, "showTradeNotification", true, null);
            _showMultipleCreditCloseWarning = builder.DefineBoolValue(folder, "showMultipleCreditCloseWarning", true, null);
            _positionRefreshByTrade = builder.DefineBoolValue(folder, "positionRefreshByTrade", true, null);
            _halfTransparentView = builder.DefineBoolValue(folder, "halfTransparent", false, null);
            _maxTradeElementForToolTip = builder.DefineIntValue(folder, "maxTradeElementForToolTip", 15, null);
            _powerInfoDisplayStyle = builder.DefineIntValue(folder, "powerInfoDisplayStyle", 1, null);
            _showSuccessfulOrderMessage = builder.DefineBoolValue(folder, "showSuccessfulOrderMessage", true, null);

            _partialTradeDisplay = new EnumPreferenceItem<PartialTradeDisplay>(builder.DefineStringValue(folder, "partialTradeDisplay", "Traded", null), PartialTradeDisplay.Traded);
            _orderListHiddenColumns = builder.DefineStringValue(folder, "orderListHiddenColumns", "9,11", null);
            _positionListHiddenColumns = builder.DefineStringValue(folder, "positionListHiddenColumns", "", null);

            _orderListSortOption = builder.DefineIntValue(folder, "orderListSortOption", 0, null);
            _positionListSortOption = builder.DefineIntValue(folder, "positionListSortOption", 0, null);

            _askPriceDragDropOrder = builder.DefineBoolValue(folder, "askPriceDragDropOrder", true, null);
            _closeFormOnOrder = builder.DefineBoolValue(folder, "closeFormOnOrder", true, null);
            _orderFormStyle = new EnumPreferenceItem<OrderFormStyle>(builder.DefineStringValue(folder, "orderFormStyle", "Owned", null), OrderFormStyle.Owned);
        }

        public void OnPreferenceImport(IPreferenceFolder oldvalues, IPreferenceFolder newvalues) {
        }

        //KKvȍڂύXꂽƂ͌ȂAxReloadPreferenceŝ邽ߑ\FixedPreferenceʒm󂯂
        public void OnPreferenceImportFinish() {
            ReloadPreference();
        }


        public string TradeSoundFile {
            get {
                return _tradeSoundFile.Value;
            }
            set {
                _tradeSoundFile.Value = value;
            }
        }
        public IStringPreferenceItem TradeSoundFileItem {
            get {
                return _tradeSoundFile;
            }
        }
        public bool ShowOrderConfirmDialog {
            get {
                return _showOrderConfirmDialog.Value;
            }
            set {
                _showOrderConfirmDialog.Value = value;
            }
        }
        public IBoolPreferenceItem ShowOrderConfirmDialogItem {
            get {
                return _showOrderConfirmDialog;
            }
        }
        public bool ShowTradeNotification {
            get {
                return _showTradeNotification.Value;
            }
            set {
                _showTradeNotification.Value = value;
            }
        }
        public IBoolPreferenceItem ShowTradeNotificationItem {
            get {
                return _showTradeNotification;
            }
        }
        public bool ShowMultipleCreditCloseWarning {
            get {
                return _showMultipleCreditCloseWarning.Value;
            }
            set {
                _showMultipleCreditCloseWarning.Value = value;
            }
        }
        public IBoolPreferenceItem ShowMultipleCreditCloseWarningItem {
            get {
                return _showMultipleCreditCloseWarning;
            }
        }
        public PartialTradeDisplay PartialTradeDisplay {
            get {
                return _partialTradeDisplay.Value;
            }
            set {
                _partialTradeDisplay.Value = value;
            }
        }
        public EnumPreferenceItem<PartialTradeDisplay> PartialTradeDisplayItem {
            get {
                return _partialTradeDisplay;
            }
        }
        public bool PositionRefreshByTrade {
            get {
                return _positionRefreshByTrade.Value;
            }
        }
        public IBoolPreferenceItem PositionRefreshByTradeItem {
            get {
                return _positionRefreshByTrade;
            }
        }
        public bool HalfTransparentView {
            get {
                return _halfTransparentView.Value;
            }
        }
        public IBoolPreferenceItem HalfTransparentViewItem {
            get {
                return _halfTransparentView;
            }
        }
        public int MaxTradeElementForToolTip {
            get {
                return _maxTradeElementForToolTip.Value;
            }
            set {
                _maxTradeElementForToolTip.Value = value;
            }
        }
        public int PowerInfoDisplayStyle {
            get {
                return _powerInfoDisplayStyle.Value;
            }
            set {
                _powerInfoDisplayStyle.Value = value;
            }
        }
        public bool ShowSuccessfulOrderMessage {
            get {
                return _showSuccessfulOrderMessage.Value;
            }
            set {
                _showSuccessfulOrderMessage.Value = value;
            }
        }
        public IBoolPreferenceItem ShowSuccessfulOrderMessageItem {
            get {
                return _showSuccessfulOrderMessage;
            }
        }
        public string OrderListHiddenColumns {
            get {
                return _orderListHiddenColumns.Value;
            }
            set {
                _orderListHiddenColumns.Value = value;
            }
        }

        public string PositionListHiddenColumns {
            get {
                return _positionListHiddenColumns.Value;
            }
            set {
                _positionListHiddenColumns.Value = value;
            }
        }
        public int OrderListSortOption {
            get {
                return _orderListSortOption.Value;
            }
            set {
                _orderListSortOption.Value = value;
            }
        }
        public int PositionListSortOption {
            get {
                return _positionListSortOption.Value;
            }
            set {
                _positionListSortOption.Value = value;
            }
        }
        public IBoolPreferenceItem AskPriceDragDropOrderItem {
            get {
                return _askPriceDragDropOrder;
            }
        }
        public bool AskPriceDragDropOrder {
            get {
                return _askPriceDragDropOrder.Value;
            }
            set {
                _askPriceDragDropOrder.Value = value;
            }
        }
        public IBoolPreferenceItem CloseFormOnOrderItem {
            get {
                return _closeFormOnOrder;
            }
        }
        public bool CloseFormOnOrder {
            get {
                return _closeFormOnOrder.Value;
            }
            set {
                _closeFormOnOrder.Value = value;
            }
        }
        public OrderFormStyle OrderFormStyle {
            get {
                return _orderFormStyle.Value;
            }
            set {
                _orderFormStyle.Value = value;
            }
        }
        public EnumPreferenceItem<OrderFormStyle> OrderFormStyleItem {
            get {
                return _orderFormStyle;
            }
        }




        public TradeOrderListDrawingSettings OrderListDrawingSettings {
            get {
                return _orderListDrawingSettings;
            }
        }
        public PositionListDrawingSettings PositionListDrawingSettings {
            get {
                return _positionListDrawingSettings;
            }
        }
        public TradeNotificationDrawingSettings TradeNotificationDrawingSettings {
            get {
                return _tradeNotificationDrawingSettings;
            }
        }
        public PowerInfoDrawingSettings PowerInfoDrawingSettings {
            get {
                return _powerInfoDrawingSettings;
            }
        }
        public OrderConfirmDrawingSettings OrderConfirmDrawingSettings {
            get {
                return _orderConfirmDrawingSettings;
            }
        }

        public void ReloadPreference() {
            OrderAndPositionListFormBase c = OrderingPlugin.Instance.Commands.PositionListForm;
            if(c!=null) c.MainListControl.ReloadPreference();

            c = OrderingPlugin.Instance.Commands.OrderListForm;
            if(c!=null) c.MainListControl.ReloadPreference();
        }

        public void Dispose() {
            _orderListDrawingSettings.Dispose();
            _positionListDrawingSettings.Dispose();
            _tradeNotificationDrawingSettings.Dispose();
        }


    }
}
