/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Screening/AutoTradingResultPane.cs#3 $
 * $DateTime: 2008/05/14 13:05:12 $
 */
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

using Bellagio.Environment;
using Bellagio.Data;
using Bellagio.Forms;
using Bellagio.Values;
using Bellagio.Chart;

using Travis.Collections;

using Poderosa.Sessions;


namespace Bellagio.Screening {
    internal class AutoTradingResultPane : BellagioDefaultForm, BellagioListView.IBellagioListViewClient {
        private AutoTradingResult _result;

        private Button _summaryButton;
        private Button _exportButton;
        private Button _sortButton;
        private System.Windows.Forms.Label _explanation;
        private BellagioListView _listView;
        private System.Windows.Forms.ColumnHeader _colBrand;
        private System.Windows.Forms.ColumnHeader _colSignalDate;
        private System.Windows.Forms.ColumnHeader _colEntryPrice;
        private System.Windows.Forms.ColumnHeader _colResult;
        private System.Windows.Forms.ColumnHeader _colEndDate;
        private System.Windows.Forms.ColumnHeader _colEndPrice;
        private System.Windows.Forms.ColumnHeader _colPerformance;

        private ChartSessionBase _currentSession; //ڂI^[QbgƂȂZbV

        /// <summary>
        /// KvȃfUCiϐłB
        /// </summary>
        private System.ComponentModel.Container components = null;

        //\[g܂
        private int _sortComparisonIndex;

        private static string[] _sortMenuTexts = new string[] {
            " > t",
            " > ptH[}X",
            "ptH[}X > t",
            "ptH[}X > ",
            "t > ptH[}X",
            "t > "
        };
        private static Comparison<SignalResult>[] _sortComparisons = new Comparison<SignalResult>[] {
            ComparisonChain<SignalResult>.Make(SignalResult.stockComparison, SignalResult.dateComparison),
            ComparisonChain<SignalResult>.Make(SignalResult.stockComparison, SignalResult.performanceComparison, SignalResult.dateComparison),
            ComparisonChain<SignalResult>.Make(SignalResult.performanceComparison, SignalResult.dateComparison, SignalResult.stockComparison),
            ComparisonChain<SignalResult>.Make(SignalResult.performanceComparison, SignalResult.stockComparison, SignalResult.dateComparison),
            ComparisonChain<SignalResult>.Make(SignalResult.dateComparison, SignalResult.performanceComparison, SignalResult.stockComparison),
            ComparisonChain<SignalResult>.Make(SignalResult.dateComparison, SignalResult.stockComparison)
        };

        public AutoTradingResultPane(AutoTradingResult result) {
            // ̌ĂяóAWindows.Forms tH[ fUCiŕKvłB
            InitializeComponent();

            _result = result;
            // TODO: InitializeComponent Ăяǒɏǉ܂B
            InitList();
        }
        /*
        public int RequiredWidth {
            get {
                return 468;
            }
        }
        */
        /// <summary>
        /// gpĂ郊\[XɌ㏈s܂B
        /// </summary>
        protected override void Dispose(bool disposing) {
            if(disposing) {
                if(components != null) {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region R|[lg fUCiŐꂽR[h
        /// <summary>
        /// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
        /// R[h GfB^ŕύXȂłB
        /// </summary>
        private void InitializeComponent() {
            this._summaryButton = new System.Windows.Forms.Button();
            this._exportButton = new System.Windows.Forms.Button();
            this._explanation = new System.Windows.Forms.Label();
            this._sortButton = new Button();
            this._listView = new BellagioListView(this);
            this._colBrand = new System.Windows.Forms.ColumnHeader();
            this._colSignalDate = new System.Windows.Forms.ColumnHeader();
            this._colEntryPrice = new System.Windows.Forms.ColumnHeader();
            this._colResult = new System.Windows.Forms.ColumnHeader();
            this._colEndDate = new System.Windows.Forms.ColumnHeader();
            this._colEndPrice = new System.Windows.Forms.ColumnHeader();
            this._colPerformance = new System.Windows.Forms.ColumnHeader();
            this.SuspendLayout();
            // 
            // _summaryButton
            // 
            this._summaryButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._summaryButton.Location = new System.Drawing.Point(8, 24);
            this._summaryButton.Name = "_summaryButton";
            this._summaryButton.Size = new System.Drawing.Size(64, 23);
            this._summaryButton.TabIndex = 0;
            this._summaryButton.Text = "Wv(&R)...";
            this._summaryButton.Click += new System.EventHandler(this.OnShowSummary);
            // 
            // _sortButton
            // 
            this._sortButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._sortButton.Location = new System.Drawing.Point(80, 24);
            this._sortButton.Name = "_sortButton";
            this._sortButton.Size = new System.Drawing.Size(96, 23);
            this._sortButton.TabIndex = 1;
            this._sortButton.Text = "\[g(&S)...";
            this._sortButton.Click += new System.EventHandler(this.OnSortMenu);
            // 
            // _exportButton
            // 
            this._exportButton.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this._exportButton.Location = new System.Drawing.Point(184, 24);
            this._exportButton.Name = "_exportButton";
            this._exportButton.Size = new System.Drawing.Size(96, 23);
            this._exportButton.TabIndex = 2;
            this._exportButton.Text = "GNX|[g(&E)...";
            this._exportButton.Click += new System.EventHandler(this.OnExport);
            // 
            // _explanation
            // 
            this._explanation.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
            this._explanation.Location = new System.Drawing.Point(8, 4);
            this._explanation.Name = "_explanation";
            this._explanation.Size = new System.Drawing.Size(56, 19);
            this._explanation.TabIndex = 0;
            this._explanation.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // _listView
            // 
            this._listView.Activation = System.Windows.Forms.ItemActivation.OneClick;
            this._listView.FullRowSelect = true;
            this._listView.GridLines = true;
            this._listView.Location = new System.Drawing.Point(0, 48);
            this._listView.MultiSelect = false;
            this._listView.Name = "_listView";
            this._listView.Size = new System.Drawing.Size(144, 96);
            this._listView.TabIndex = 1;
            this._listView.View = System.Windows.Forms.View.Details;
            this._listView.SelectedIndexChanged += new System.EventHandler(this.OnItemActivated);
            // 
            // _colBrand
            // 
            this._colBrand.Text = "";
            _colBrand.Width = 88;
            // 
            // _colSignalDate
            // 
            this._colSignalDate.Width = 88;
            // 
            // _colEntryPrice
            // 
            this._colEntryPrice.TextAlign = System.Windows.Forms.HorizontalAlignment.Left;
            this._colEntryPrice.Width = 72;
            // 
            // _colResult
            // 
            this._colResult.Text = "";
            this._colResult.Width = 48;
            // 
            // _colEndDate
            // 
            this._colEndDate.Width = 88;
            // 
            // _colEndPrice
            // 
            this._colEndPrice.TextAlign = System.Windows.Forms.HorizontalAlignment.Left;
            this._colEndPrice.Width = 72;
            // 
            // _colPerformance
            // 
            this._colPerformance.Text = "ptH[}X";
            this._colPerformance.TextAlign = System.Windows.Forms.HorizontalAlignment.Left;
            this._colPerformance.Width = 200;
            // 
            // AutoTradingResultPane
            // 
            this.Controls.Add(this._listView);
            this.Controls.Add(this._summaryButton);
            this.Controls.Add(this._sortButton);
            this.Controls.Add(this._exportButton);
            this.Controls.Add(this._explanation);
            this.Name = "AutoTradingResultPane";
            this.Size = new System.Drawing.Size(640, 400);
            this.ResumeLayout(false);

        }
        #endregion

        private void InitList() {
            this.Text = _result.Query.Title;
            _explanation.Text = String.Format("Gg[F{0}  COWbgF{1}  XJbgF{2}", CondToText(_result.Query.Entry.type), CondToText(_result.Query.Exit.type), CondToText(_result.Query.Losscut.type));
            _listView.SuspendLayout();
            _listView.BeginUpdate();

            _colSignalDate.Text = ScreeningPlugin.Instance.Preferences.AutoTradingDateDisplay==AutoTradingDateDisplay.Condition? "VOit" : "Ggt";
            _colEndDate.Text = "It";
            if(_result.Query.LongShort==LongShort.Long) {
                _colEntryPrice.Text = "wi";
                _colEndPrice.Text = "pi";
            }
            else { //̌؂ł͕\ւ
                _colEntryPrice.Text = "pi";
                _colEndPrice.Text = "wi";
            }

            //J\z
            List<ColumnHeader> headers = new List<ColumnHeader>();
            headers.Add(_colBrand);
            headers.Add(_colSignalDate);
            headers.Add(_colEntryPrice);
            foreach(AutoTradingQuery.Column col in _result.Query.EntryAdditionalColumns)
                headers.Add(CreateAdditionalColHeader(col));
            headers.Add(_colEndDate);
            headers.Add(_colEndPrice);
            headers.Add(_colResult);
            foreach(AutoTradingQuery.Column col in _result.Query.ExitAdditionalColumns)
                headers.Add(CreateAdditionalColHeader(col));
            headers.Add(_colPerformance);

            _listView.Columns.AddRange(headers.ToArray());
            _listView.EndUpdate();

            _sortComparisonIndex = 0;
            FillData();

            _listView.ResumeLayout();
        }
        private void FillData() {

            _result.SortExternal(_sortComparisons[_sortComparisonIndex]);

            _listView.BeginUpdate();

            _listView.Items.Clear();

            for(int i=0; i<_result.Count; i++) {
                AddItem(_result[i]);
            }
            _listView.EndUpdate();
        }

        private static ColumnHeader CreateAdditionalColHeader(AutoTradingQuery.Column col) {
            ColumnHeader h = new ColumnHeader();
            h.Text = col.label;
            h.Width = 80;
            return h;
        }
        private static string CondToText(ConditionType ct) {
            switch(ct) {
                case ConditionType.TodayClose: return "Il";
                case ConditionType.TomorrowOpen: return "nl";
                case ConditionType.Sashine: return "wl";
                case ConditionType.Gyakusashine: return "twl";
                default: return "";
            }

        }

        private void AddItem(SignalResult sr) {
            Debug.Assert(sr.ResultType!=SignalResultType.None);

            string[] values = new string[_listView.Columns.Count];
            //AGgtAGgiAItAIiAʃ}[NAptH[}X܂̓bZ[W̏
            int ci = 0;
            values[ci++] = sr.StockProfile.Name;
            values[ci++] = BDate.FormatYYMMDD(new BDate(sr.SignalDate));
            values[ci++] = sr.SignalPrice.ToString("F0");
            for(int i=0; i<sr.EntryAdditionalValues.Length; i++) {
                string t = FormatValue(sr.EntryAdditionalValues[i], _result.Query.EntryAdditionalColumns[i].formatter);
                /*if(t=="-") {
                    Debugger.Break();
                    ConcreteQuote q = ScreeningPlugin.Instance.DailyDataCache.Request(sr.StockProfile);
                    int i = q.FindExactly(sr.SignalDate);

                }*/
                values[ci++] = t;
            }

            if(sr.ResultType==SignalResultType.Timeout || sr.ResultType==SignalResultType.EndOfData) {
                for(int i=ci; i<values.Length; i++) values[i] = "-";
            }
            else {
                if(sr.ResultType==SignalResultType.Exit || sr.ResultType==SignalResultType.Losscut) {
                    values[ci++] = BDate.FormatYYMMDD(new BDate(sr.ExitDate));
                    values[ci++] = sr.ExitPrice.ToString("F0");
                    values[ci++] = sr.ResultType==SignalResultType.Exit? "" : "~";
                }
                else {
                    values[ci++] = BDate.FormatYYMMDD(new BDate(sr.ExitDate));
                    values[ci++] = "-";
                    values[ci++] = "-";
                }

                for(int i=0; i<sr.ExitAdditionalValues.Length; i++) {
                    values[ci++] = FormatValue(sr.ExitAdditionalValues[i], _result.Query.ExitAdditionalColumns[i].formatter);
                }
            }

            double p = 0;
            string msg = "";
            if(sr.CheckResult(ref p, ref msg))
                values[ci++] = String.Format("{0}{1:F2}%", p>=0? "+" : "", p*100);
            else
                values[ci++] = msg;
            
            ListViewItem li = new ListViewItem(values);
            li.Tag = sr;
            _listView.Items.Add(li);
        }
        private string FormatValue(BV value, NumberFormatter format) {
            if(value==null || value.IsNil)
                return "-";
            return format.Format(value);
        }

        private void OnItemActivated(object sender, EventArgs args) {
            ListView.SelectedListViewItemCollection t = _listView.SelectedItems;
            if(t.Count>0) {
                ListViewItem li = t[0];
                SignalResult sr = li.Tag as SignalResult;
                if(sr!=null) ShowSignalResult(sr);
            }
        }
        protected override void OnResize(EventArgs e) {
            base.OnResize(e);
            int w = this.ClientSize.Width;
            _explanation.Width = w;
            _listView.Width = w;
            _listView.Height = this.ClientSize.Height - _exportButton.Bottom;
        }

        private void OnShowSummary(object sender, EventArgs args) {
            AutoTradingSummaryDialog dlg = new AutoTradingSummaryDialog(_result);
            dlg.ShowDialog(this.ParentForm);
            dlg.Dispose();
        }
        private void OnExport(object sender, EventArgs args) {
            ContextMenu cm = new ContextMenu();
            AddMenuItem(cm, "Nbv{[hփRs[(&C)", new EventHandler(OnCopyResult));
            AddMenuItem(cm, "CSV`ŕۑ(&S)...", new EventHandler(OnSaveResult));
            cm.Show(this, new Point(_exportButton.Left, _exportButton.Bottom));
        }
        private void OnSortMenu(object sender, EventArgs args) {
            ContextMenu cm = new ContextMenu();
            EventHandler eh = delegate(object menu, EventArgs args_) {
                _sortComparisonIndex = ((MenuItem)menu).Index;
                FillData();
            };
            foreach(string text in _sortMenuTexts)
                AddMenuItem(cm, text, eh);
            cm.Show(this, new Point(_sortButton.Left, _sortButton.Bottom));
        }
        private static void AddMenuItem(Menu parent, string text, EventHandler handler) {
            MenuItem mi = new MenuItem();
            mi.Text = text;
            mi.Click += handler;
            parent.MenuItems.Add(mi);
        }

        //Ώۖ̃`[g\AnCCg\
        private void ShowSignalResult(SignalResult result) {
            //XN[ʒuZbgȂǂ́ȀŎsƂƃhLg[hɂƂƂQƂ肠BɂĂdelegatep
            VoidVoidDelegate set_signal_action = delegate() {
                _currentSession.ChartDocument.CandleExtraModifier = new HighlightInfo(result);
                ChartViewContentBase view = (ChartViewContentBase)_currentSession.BellagioViewContent;
                view.SetScrollPositionByDateTime(result.SignalDate);
                //Debug.WriteLine("SetSignalResult");
            };

            ChartSessionBase session = GetOrCreateTargetSession(result.StockProfile.Primary, set_signal_action);
            if(_currentSession!=null && _currentSession!=session) {
                //nCCgZbVقȂƂ͊̂̂NA
                _currentSession.ChartDocument.CandleExtraModifier = null;
                RefreshChart();
            }

            //XN[ƃnCCg
            //̑̌ʐVKɃZbVƂ(GetOrCreateTargetSessionŃ[hXe[^X̂Ƃ)͊҂Ăȉ̑˂΂Ȃ炸ʓ|Ȃ̂łڂ
            _currentSession = session;
            if(session.ChartDocument.DocumentStatus==BellagioDocumentStatus.Complete) {
                set_signal_action(); //̏Ŏs
                RefreshChart();
            }
        }
        private void RefreshChart() {
            _currentSession.ChartDocument.ValueCache.Clear();
            BellagioDefaultControl c;
            c = _currentSession.BellagioViewContent.ContainerControl;
            if(c!=null) c.Invalidate();
        }
        private ChartSessionBase GetOrCreateTargetSession(Stock stock, VoidVoidDelegate set_signal_action) {
            foreach(ISession s in BellagioPlugin.Instance.SessionManager.AllSessions) {
                ChartSessionBase sb = s as ChartSessionBase;
                if(sb!=null && sb.GetSourceSchema().ChartUnit==Quote.QuoteUnit.Daily && sb.CurrentStock==stock) return sb;
            }

            ChartSchema sc = BellagioRoot.SchemaRoot.FindStaticChartSchema("tactico.daily-default");
            ChartOpenCommand cmd = new ChartOpenCommand(sc, stock, ChartOpenCommand.OpenStyleT.SameSchema);
            BellagioPlugin.Instance.CommandManager.Execute(cmd, BellagioPlugin.Instance.ActivePoderosaWindow);
            //؂ւȂRv[gɎsXN[ʒuCȂǂZbg
            ((ChartViewContentBase)cmd.ResultSession.BellagioViewContent).SubscribeCompleteEvent = set_signal_action;
            return cmd.ResultSession;
        }


        private void OnCopyResult(object sender, EventArgs args) {
            ListViewUtil.CopyListViewContentToClipboard(_listView, true, new ListViewUtil.ItemChecker(ListViewItemChecker));
        }
        private void OnSaveResult(object sender, EventArgs args) {
            ListViewUtil.SaveListViewContentToFile("ʂ̕ۑ", _listView, true, new ListViewUtil.ItemChecker(ListViewItemChecker));
        }
        private bool ListViewItemChecker(ListViewItem li) {
            return true; //Ƀf[^͗L
        }



        void BellagioListView.IBellagioListViewClient.DrawColumnHeader(Graphics g, Rectangle r, ColumnHeader header) {
        }

        void BellagioListView.IBellagioListViewClient.DrawItemBackground(Graphics g, Rectangle r, ListViewItem item) {
        }

        void BellagioListView.IBellagioListViewClient.DrawItemBody(Graphics g, Rectangle r, int[] lefts, ListViewItem item) {
            SignalResult sr = (SignalResult)item.Tag;
            Color col = item.Selected? Color.Coral :
                sr.ResultType==SignalResultType.Exit? Color.White :
                sr.ResultType==SignalResultType.Losscut? Color.LightGray :
                Color.FromArgb(0xFF, 0xC0, 0xC0);
            Brush br = new SolidBrush(col);
            g.FillRectangle(br, r);
            br.Dispose();

            Brush text_br = SystemBrushes.WindowText;
            for(int i=0; i<lefts.Length-1; i++) {
                Rectangle clip = new Rectangle(r.Left+lefts[i], r.Top, lefts[i+1]-lefts[i], r.Height);
                Travis.DrawStringUtil.Clipped(g, item.SubItems[i].Text, _listView.Font, text_br, clip, r.Left+lefts[i], r.Top);
            }
        }

        void BellagioListView.IBellagioListViewClient.OnMouseMoveInListView(MouseEventArgs e) {
        }

        void BellagioListView.IBellagioListViewClient.OnMouseEnterToListView(EventArgs e) {
        }

        private class HighlightInfo : ICandleExtraModifier {
            private SignalResult _result;

            public HighlightInfo(SignalResult sr) {
                _result = sr;
            }

            public bool IsHighlight(Candle candle) {
                if(_result.ResultType!=SignalResultType.EndOfData) {
                    int t = candle.Time;
                    return _result.SignalDate<=t && t<=_result.ExitDate;
                }
                else
                    return false;
            }

        }

        protected override void OnClosed(EventArgs e) {
            base.OnClosed(e);
            if(_currentSession!=null) {
                _currentSession.ChartDocument.CandleExtraModifier = null;
                RefreshChart();
            }

        }

    }
}
