// $ANTLR 2.7.7 (20060930): "expression.g" -> "ExpressionParser.cs"$

namespace Bellagio.Script.Parser
{
	// Generate the header common to all output files.
	using System;
	
	using TokenBuffer              = antlr.TokenBuffer;
	using TokenStreamException     = antlr.TokenStreamException;
	using TokenStreamIOException   = antlr.TokenStreamIOException;
	using ANTLRException           = antlr.ANTLRException;
	using LLkParser = antlr.LLkParser;
	using Token                    = antlr.Token;
	using IToken                   = antlr.IToken;
	using TokenStream              = antlr.TokenStream;
	using RecognitionException     = antlr.RecognitionException;
	using NoViableAltException     = antlr.NoViableAltException;
	using MismatchedTokenException = antlr.MismatchedTokenException;
	using SemanticException        = antlr.SemanticException;
	using ParserSharedInputState   = antlr.ParserSharedInputState;
	using BitSet                   = antlr.collections.impl.BitSet;
	

	internal 	class ExpressionParser : antlr.LLkParser
	{
		public const int EOF = 1;
		public const int NULL_TREE_LOOKAHEAD = 3;
		// "," = 4
		// "?" = 5
		// ":" = 6
		// "." = 7
		// "(" = 8
		// ")" = 9
		// "[" = 10
		// "]" = 11
		public const int BOOLEAN_TRUE = 12;
		public const int BOOLEAN_FALSE = 13;
		public const int NUMBER = 14;
		// "@t" = 15
		// "@d" = 16
		public const int LITERAL_STRING = 17;
		public const int IDENTIFIER = 18;
		// "$" = 19
		// "{" = 20
		// "}" = 21
		public const int LITERAL_lambda = 22;
		public const int LITERAL_let = 23;
		// "=" = 24
		public const int ARRAY_TYPE = 25;
		public const int TYPE_ARROW = 26;
		public const int LOGICAL_AND = 27;
		public const int LOGICAL_OR = 28;
		public const int COMP_OP_GT = 29;
		public const int COMP_OP_GTE = 30;
		public const int COMP_OP_LT = 31;
		public const int COMP_OP_LTE = 32;
		public const int COMP_OP_EQ = 33;
		public const int COMP_OP_NEQ = 34;
		public const int ARITH_OP_ADD = 35;
		public const int ARITH_OP_SUB = 36;
		public const int ARITH_OP_MUL = 37;
		public const int ARITH_OP_DIV = 38;
		public const int ARITH_OP_MOD = 39;
		public const int LOGICAL_NOT = 40;
		public const int DUMMY_FOR_LEX = 41;
		public const int NL = 42;
		public const int WS = 43;
		public const int IGNORE = 44;
		public const int ID_CHAR = 45;
		
		
		
		protected void initialize()
		{
			tokenNames = tokenNames_;
		}
		
		
		protected ExpressionParser(TokenBuffer tokenBuf, int k) : base(tokenBuf, k)
		{
			initialize();
		}
		
		public ExpressionParser(TokenBuffer tokenBuf) : this(tokenBuf,1)
		{
		}
		
		protected ExpressionParser(TokenStream lexer, int k) : base(lexer,k)
		{
			initialize();
		}
		
		public ExpressionParser(TokenStream lexer) : this(lexer,1)
		{
		}
		
		public ExpressionParser(ParserSharedInputState state) : base(state,1)
		{
			initialize();
		}
		
	public Expression[]  top_expr_list() //throws RecognitionException, TokenStreamException
{
		Expression[] l;
		
		
		System.Collections.ArrayList a = new System.Collections.ArrayList(); Expression e;
		{
			switch ( LA(1) )
			{
			case 8:
			case BOOLEAN_TRUE:
			case BOOLEAN_FALSE:
			case NUMBER:
			case 15:
			case 16:
			case LITERAL_STRING:
			case IDENTIFIER:
			case 19:
			case LITERAL_lambda:
			case LITERAL_let:
			case ARITH_OP_SUB:
			case LOGICAL_NOT:
			{
				e=expr();
				a.Add(e);
				{    // ( ... )*
					for (;;)
					{
						if ((LA(1)==4))
						{
							match(4);
							e=expr();
							a.Add(e);
						}
						else
						{
							goto _loop4_breakloop;
						}
						
					}
_loop4_breakloop:					;
				}    // ( ... )*
				break;
			}
			case EOF:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		match(Token.EOF_TYPE);
		l=(Expression[])a.ToArray(typeof(Expression));
		return l;
	}
	
	public Expression  expr() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		
		Expression r1 = null, r2 = null;
		e=cond_expr();
		{
			switch ( LA(1) )
			{
			case 5:
			{
				match(5);
				r1=cond_expr();
				match(6);
				r2=expr();
				e = new ConditionalExpression(e, r1, r2);
				break;
			}
			case EOF:
			case 4:
			case 9:
			case 11:
			case 21:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		return e;
	}
	
	public Expression  top_expr() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		
		e=expr();
		match(Token.EOF_TYPE);
		return e;
	}
	
	public Expression  cond_expr() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		
		Expression r=null; IToken op=null;
		e=logical_expr();
		{    // ( ... )*
			for (;;)
			{
				if ((LA(1)==LOGICAL_AND||LA(1)==LOGICAL_OR))
				{
					op=logical_ops();
					r=logical_expr();
					e = new BinaryOpExpression(op, e, r);
				}
				else
				{
					goto _loop10_breakloop;
				}
				
			}
_loop10_breakloop:			;
		}    // ( ... )*
		return e;
	}
	
	public Expression  logical_expr() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		
		Expression r=null; IToken op=null;
		e=arith_expr();
		{    // ( ... )*
			for (;;)
			{
				if (((LA(1) >= COMP_OP_GT && LA(1) <= COMP_OP_NEQ)))
				{
					op=comp_ops();
					r=arith_expr();
					e = new BinaryOpExpression(op, e, r);
				}
				else
				{
					goto _loop13_breakloop;
				}
				
			}
_loop13_breakloop:			;
		}    // ( ... )*
		return e;
	}
	
	public IToken  logical_ops() //throws RecognitionException, TokenStreamException
{
		IToken t = null;
		
		IToken  t1 = null;
		IToken  t2 = null;
		
		switch ( LA(1) )
		{
		case LOGICAL_AND:
		{
			t1 = LT(1);
			match(LOGICAL_AND);
			t=t1;
			break;
		}
		case LOGICAL_OR:
		{
			t2 = LT(1);
			match(LOGICAL_OR);
			t=t2;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		 }
		return t;
	}
	
	public Expression  arith_expr() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		
		Expression r=null; IToken op=null;
		e=term_expr();
		{    // ( ... )*
			for (;;)
			{
				if ((LA(1)==ARITH_OP_ADD||LA(1)==ARITH_OP_SUB))
				{
					op=arith_addsub_ops();
					r=term_expr();
					e=new BinaryOpExpression(op, e, r);
				}
				else
				{
					goto _loop16_breakloop;
				}
				
			}
_loop16_breakloop:			;
		}    // ( ... )*
		return e;
	}
	
	public IToken  comp_ops() //throws RecognitionException, TokenStreamException
{
		IToken t = null;
		
		IToken  t1 = null;
		IToken  t2 = null;
		IToken  t3 = null;
		IToken  t4 = null;
		IToken  t5 = null;
		IToken  t6 = null;
		
		switch ( LA(1) )
		{
		case COMP_OP_GT:
		{
			t1 = LT(1);
			match(COMP_OP_GT);
			t=t1;
			break;
		}
		case COMP_OP_GTE:
		{
			t2 = LT(1);
			match(COMP_OP_GTE);
			t=t2;
			break;
		}
		case COMP_OP_LT:
		{
			t3 = LT(1);
			match(COMP_OP_LT);
			t=t3;
			break;
		}
		case COMP_OP_LTE:
		{
			t4 = LT(1);
			match(COMP_OP_LTE);
			t=t4;
			break;
		}
		case COMP_OP_EQ:
		{
			t5 = LT(1);
			match(COMP_OP_EQ);
			t=t5;
			break;
		}
		case COMP_OP_NEQ:
		{
			t6 = LT(1);
			match(COMP_OP_NEQ);
			t=t6;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		 }
		return t;
	}
	
	public Expression  term_expr() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		
		Expression r=null; IToken op=null;
		e=unary_expr();
		{    // ( ... )*
			for (;;)
			{
				if (((LA(1) >= ARITH_OP_MUL && LA(1) <= ARITH_OP_MOD)))
				{
					op=arith_muldiv_ops();
					r=unary_expr();
					e=new BinaryOpExpression(op,e,r);
				}
				else
				{
					goto _loop19_breakloop;
				}
				
			}
_loop19_breakloop:			;
		}    // ( ... )*
		return e;
	}
	
	public IToken  arith_addsub_ops() //throws RecognitionException, TokenStreamException
{
		IToken t = null;
		
		IToken  t1 = null;
		IToken  t2 = null;
		
		switch ( LA(1) )
		{
		case ARITH_OP_ADD:
		{
			t1 = LT(1);
			match(ARITH_OP_ADD);
			t=t1;
			break;
		}
		case ARITH_OP_SUB:
		{
			t2 = LT(1);
			match(ARITH_OP_SUB);
			t=t2;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		 }
		return t;
	}
	
	public Expression  unary_expr() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		
		switch ( LA(1) )
		{
		case 8:
		case BOOLEAN_TRUE:
		case BOOLEAN_FALSE:
		case NUMBER:
		case 15:
		case 16:
		case LITERAL_STRING:
		case IDENTIFIER:
		case 19:
		case LITERAL_lambda:
		case LITERAL_let:
		{
			e=value_expr();
			break;
		}
		case ARITH_OP_SUB:
		case LOGICAL_NOT:
		{
			IToken op;
			op=unary_ops();
			e=value_expr();
			e = new UnaryOpExpression(op, e);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		 }
		return e;
	}
	
	public IToken  arith_muldiv_ops() //throws RecognitionException, TokenStreamException
{
		IToken t = null;
		
		IToken  t1 = null;
		IToken  t2 = null;
		IToken  t3 = null;
		
		switch ( LA(1) )
		{
		case ARITH_OP_MUL:
		{
			t1 = LT(1);
			match(ARITH_OP_MUL);
			t=t1;
			break;
		}
		case ARITH_OP_DIV:
		{
			t2 = LT(1);
			match(ARITH_OP_DIV);
			t=t2;
			break;
		}
		case ARITH_OP_MOD:
		{
			t3 = LT(1);
			match(ARITH_OP_MOD);
			t=t3;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		 }
		return t;
	}
	
	public Expression  value_expr() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		
		Expression r = null;
		e=reference_expr();
		{    // ( ... )*
			for (;;)
			{
				if ((LA(1)==7))
				{
					match(7);
					r=reference_expr();
					e = new ReferenceExpression(e, r);
				}
				else
				{
					goto _loop23_breakloop;
				}
				
			}
_loop23_breakloop:			;
		}    // ( ... )*
		return e;
	}
	
	public IToken  unary_ops() //throws RecognitionException, TokenStreamException
{
		IToken t = null;
		
		IToken  t1 = null;
		IToken  t2 = null;
		
		switch ( LA(1) )
		{
		case ARITH_OP_SUB:
		{
			t1 = LT(1);
			match(ARITH_OP_SUB);
			t=t1;
			break;
		}
		case LOGICAL_NOT:
		{
			t2 = LT(1);
			match(LOGICAL_NOT);
			t=t2;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		 }
		return t;
	}
	
	public Expression  reference_expr() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		
		Expression a = null; InvokeExpression ie=null;
		e=leaf_expr();
		{    // ( ... )*
			for (;;)
			{
				switch ( LA(1) )
				{
				case 8:
				{
					{
						match(8);
						ie=new InvokeExpression(e);
						{
							switch ( LA(1) )
							{
							case 8:
							case BOOLEAN_TRUE:
							case BOOLEAN_FALSE:
							case NUMBER:
							case 15:
							case 16:
							case LITERAL_STRING:
							case IDENTIFIER:
							case 19:
							case LITERAL_lambda:
							case LITERAL_let:
							case ARITH_OP_SUB:
							case LOGICAL_NOT:
							{
								a=expr();
								ie.AddArg(a);
								{    // ( ... )*
									for (;;)
									{
										if ((LA(1)==4))
										{
											match(4);
											a=expr();
											ie.AddArg(a);
										}
										else
										{
											goto _loop29_breakloop;
										}
										
									}
_loop29_breakloop:									;
								}    // ( ... )*
								break;
							}
							case 9:
							{
								break;
							}
							default:
							{
								throw new NoViableAltException(LT(1), getFilename());
							}
							 }
						}
						match(9);
						e=ie;
					}
					break;
				}
				case 10:
				{
					{
						match(10);
						a=expr();
						match(11);
						e=new ArrayExpression(e, a);
					}
					break;
				}
				default:
				{
					goto _loop31_breakloop;
				}
				 }
			}
_loop31_breakloop:			;
		}    // ( ... )*
		return e;
	}
	
	public Expression  leaf_expr() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		
		switch ( LA(1) )
		{
		case 8:
		{
			match(8);
			e=expr();
			match(9);
			break;
		}
		case BOOLEAN_TRUE:
		case BOOLEAN_FALSE:
		case NUMBER:
		case 15:
		case 16:
		case LITERAL_STRING:
		case IDENTIFIER:
		{
			e=literal_expr();
			break;
		}
		case 19:
		{
			e=parameter_expr();
			break;
		}
		case LITERAL_lambda:
		case LITERAL_let:
		{
			e=special_function();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		 }
		return e;
	}
	
	public Expression  literal_expr() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		IToken  num = null;
		IToken  t = null;
		IToken  d = null;
		IToken  s = null;
		IToken  id = null;
		
		switch ( LA(1) )
		{
		case BOOLEAN_TRUE:
		{
			match(BOOLEAN_TRUE);
			e = new LiteralBooleanExpression(true);
			break;
		}
		case BOOLEAN_FALSE:
		{
			match(BOOLEAN_FALSE);
			e = new LiteralBooleanExpression(false);
			break;
		}
		case NUMBER:
		{
			num = LT(1);
			match(NUMBER);
			e = new LiteralNumberExpression(num.getText());
			break;
		}
		case 15:
		{
			{
				match(15);
				t = LT(1);
				match(NUMBER);
				e = new LiteralTimeExpression(t.getText());
			}
			break;
		}
		case 16:
		{
			{
				match(16);
				d = LT(1);
				match(NUMBER);
				e = new LiteralDateExpression(d.getText());
			}
			break;
		}
		case LITERAL_STRING:
		{
			{
				s = LT(1);
				match(LITERAL_STRING);
				e = new LiteralStringExpression(s.getText());
			}
			break;
		}
		case IDENTIFIER:
		{
			id = LT(1);
			match(IDENTIFIER);
			e = new SymbolExpression(id.getText());
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		 }
		return e;
	}
	
	public Expression  parameter_expr() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		IToken  name = null;
		IToken  name2 = null;
		
		match(19);
		{
			switch ( LA(1) )
			{
			case IDENTIFIER:
			{
				name = LT(1);
				match(IDENTIFIER);
				e = new ParameterExpression(name.getText());
				break;
			}
			case 20:
			{
				match(20);
				name2 = LT(1);
				match(IDENTIFIER);
				e = new ParameterExpression(name2.getText());
				match(21);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		return e;
	}
	
	public Expression  special_function() //throws RecognitionException, TokenStreamException
{
		Expression e;
		
		IToken  n1 = null;
		IToken  n2 = null;
		
		switch ( LA(1) )
		{
		case LITERAL_lambda:
		{
			ParameterListDefinition al = null;
			{
				match(LITERAL_lambda);
				match(8);
				match(8);
				al=parameter_list_def();
				match(9);
				e=expr();
				match(9);
				e = new LambdaExpression(al, e);
			}
			break;
		}
		case LITERAL_let:
		{
			Expression df = null; LetExpression l;
			{
				match(LITERAL_let);
				match(8);
				match(8);
				n1 = LT(1);
				match(IDENTIFIER);
				match(24);
				df=expr();
				l = new LetExpression(); l.DefLocal(n1.getText(), df);
				{    // ( ... )*
					for (;;)
					{
						if ((LA(1)==4))
						{
							match(4);
							n2 = LT(1);
							match(IDENTIFIER);
							match(24);
							df=expr();
							l.DefLocal(n2.getText(), df);
						}
						else
						{
							goto _loop43_breakloop;
						}
						
					}
_loop43_breakloop:					;
				}    // ( ... )*
				match(9);
				df=expr();
				l.SetBody(df); e = l;
				match(9);
			}
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		 }
		return e;
	}
	
	public ParameterListDefinition  parameter_list_def() //throws RecognitionException, TokenStreamException
{
		ParameterListDefinition al;
		
		IToken  n1 = null;
		IToken  n2 = null;
		
		TypeDesc t = null; al = new ParameterListDefinition();
		{
			switch ( LA(1) )
			{
			case 8:
			case IDENTIFIER:
			{
				t=type_desc();
				n1 = LT(1);
				match(IDENTIFIER);
				al.Add(t, n1.getText());
				{    // ( ... )*
					for (;;)
					{
						if ((LA(1)==4))
						{
							match(4);
							t=type_desc();
							n2 = LT(1);
							match(IDENTIFIER);
							al.Add(t, n2.getText());
						}
						else
						{
							goto _loop47_breakloop;
						}
						
					}
_loop47_breakloop:					;
				}    // ( ... )*
				break;
			}
			case EOF:
			case 9:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		return al;
	}
	
	public TypeDesc  type_desc() //throws RecognitionException, TokenStreamException
{
		TypeDesc t;
		
		
		t=not_array_type_desc();
		{    // ( ... )*
			for (;;)
			{
				if ((LA(1)==ARRAY_TYPE))
				{
					match(ARRAY_TYPE);
					t = new ArrayTypeDesc(t);
				}
				else
				{
					goto _loop52_breakloop;
				}
				
			}
_loop52_breakloop:			;
		}    // ( ... )*
		return t;
	}
	
	public ParameterListDefinition  top_parameter_list_def() //throws RecognitionException, TokenStreamException
{
		ParameterListDefinition al;
		
		
		al=parameter_list_def();
		match(Token.EOF_TYPE);
		return al;
	}
	
	public TypeDesc  top_type_desc() //throws RecognitionException, TokenStreamException
{
		TypeDesc t;
		
		
		t=type_desc();
		match(Token.EOF_TYPE);
		return t;
	}
	
	public TypeDesc  not_array_type_desc() //throws RecognitionException, TokenStreamException
{
		TypeDesc t;
		
		IToken  s = null;
		
		{
			switch ( LA(1) )
			{
			case IDENTIFIER:
			{
				s = LT(1);
				match(IDENTIFIER);
				t = TypeDesc.FromName(s.getText());
				break;
			}
			case 8:
			{
				TypeDesc a = null; LambdaTypeDesc l = null;
				match(8);
				a=type_desc();
				l = new LambdaTypeDesc(); l.AddArg(a);
				{    // ( ... )*
					for (;;)
					{
						if ((LA(1)==4))
						{
							match(4);
							a=type_desc();
							l.AddArg(a);
						}
						else
						{
							goto _loop56_breakloop;
						}
						
					}
_loop56_breakloop:					;
				}    // ( ... )*
				match(TYPE_ARROW);
				a=type_desc();
				l.Fix(a); t=l;
				match(9);
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		return t;
	}
	
	public FunctionDefinitionList  top_function_definition_list() //throws RecognitionException, TokenStreamException
{
		FunctionDefinitionList fl;
		
		
		fl = new FunctionDefinitionList(); FunctionDefinition f = null;
		{    // ( ... )*
			for (;;)
			{
				if ((LA(1)==8||LA(1)==IDENTIFIER))
				{
					f=function_definition();
					fl.Add(f);
				}
				else
				{
					goto _loop59_breakloop;
				}
				
			}
_loop59_breakloop:			;
		}    // ( ... )*
		match(Token.EOF_TYPE);
		return fl;
	}
	
	public FunctionDefinition  function_definition() //throws RecognitionException, TokenStreamException
{
		FunctionDefinition fd;
		
		IToken  n = null;
		
		TypeDesc rt; ParameterListDefinition pl; Expression body;
		rt=type_desc();
		n = LT(1);
		match(IDENTIFIER);
		match(8);
		pl=parameter_list_def();
		match(9);
		match(20);
		body=expr();
		match(21);
		fd=new FunctionDefinition(n.getText(), rt, pl, body, n.getLine());
		return fd;
	}
	
	public void dummy_for_lex() //throws RecognitionException, TokenStreamException
{
		
		
		match(DUMMY_FOR_LEX);
	}
	
	private void initializeFactory()
	{
	}
	
	public static readonly string[] tokenNames_ = new string[] {
		@"""<0>""",
		@"""EOF""",
		@"""<2>""",
		@"""NULL_TREE_LOOKAHEAD""",
		@""",""",
		@"""?""",
		@""":""",
		@""".""",
		@"""(""",
		@""")""",
		@"""[""",
		@"""]""",
		@"""true""",
		@"""false""",
		@"""a number""",
		@"""@t""",
		@"""@d""",
		@"""LITERAL_STRING""",
		@"""an identifier""",
		@"""$""",
		@"""{""",
		@"""}""",
		@"""lambda""",
		@"""let""",
		@"""=""",
		@"""ARRAY_TYPE""",
		@"""TYPE_ARROW""",
		@"""LOGICAL_AND""",
		@"""LOGICAL_OR""",
		@"""COMP_OP_GT""",
		@"""COMP_OP_GTE""",
		@"""COMP_OP_LT""",
		@"""COMP_OP_LTE""",
		@"""COMP_OP_EQ""",
		@"""COMP_OP_NEQ""",
		@"""ARITH_OP_ADD""",
		@"""ARITH_OP_SUB""",
		@"""ARITH_OP_MUL""",
		@"""ARITH_OP_DIV""",
		@"""ARITH_OP_MOD""",
		@"""LOGICAL_NOT""",
		@"""DUMMY_FOR_LEX""",
		@"""NL""",
		@"""WS""",
		@"""IGNORE""",
		@"""ID_CHAR"""
	};
	
	
}
}
