/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Script/Visitor.cs#6 $
 * $DateTime: 2007/10/25 12:56:12 $
 * Expression Visitor
 */

namespace Bellagio.Script
{
	public abstract class ExpressionVisitor<T> {
        public abstract T LiteralNumber(LiteralNumberExpression expr);
        public abstract T LiteralBoolean(LiteralBooleanExpression expr);
        public abstract T LiteralTime(LiteralTimeExpression expr);
        public abstract T LiteralDate(LiteralDateExpression expr);
        public abstract T LiteralString(LiteralStringExpression expr);

        public abstract T Symbol(SymbolExpression expr);
        public abstract T Parameter(ParameterExpression expr);

		public abstract T UnaryOp(UnaryOpExpression expr); 
		public abstract T BinaryOp(BinaryOpExpression expr);
        public abstract T Condition(ConditionalExpression expr);

        public abstract T Reference(ReferenceExpression expr);
        public abstract T Array(ArrayExpression expr);
        public abstract T Invoke(InvokeExpression expr);

        public abstract T Lambda(LambdaExpression expr);
        public abstract T Let(LetExpression expr);
	}

}
