﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

using Bellagio.Data;
using Bellagio.Values;
using Bellagio.Chart;

namespace Bellagio.TestData {
    public static class QuoteUtil {
        //逆順読み込み
        internal static TimeAndSales StreamToTimeAndSales(TextReader reader) {
            List<TickData> r = new List<TickData>();
            string line = reader.ReadLine();
            while(line!=null && line.Length>0) {
                string[] es = line.Split(new char[] {' '}, StringSplitOptions.RemoveEmptyEntries);
                if(es.Length==3) {
                    int t = BTime.ParseToInt(es[0]);
                    r.Add(new TickData(t, Int32.Parse(es[1]), Int32.Parse(es[2]), TickItaRelation.Unknown));
                }
                line = reader.ReadLine();
            }

            TimeAndSales ts = new TimeAndSales();
            for(int i=r.Count-1; i>=0; i--)
                ts.Add(r[i]);

            return ts;
        }
        public static ITimeAndSales StringToTimeAndSales(string text) {
            TimeAndSales ts = StreamToTimeAndSales(new StringReader(text));
            return ts;
        }
        public static ITimeAndSales FileToTimeAndSales(string filename) {
            TextReader reader = new StreamReader(filename);
            TimeAndSales ts = StreamToTimeAndSales(reader);
            reader.Close();
            return ts;
        }

        public static Quote StringToMinutelyQuote(string text) {
            TimeAndSales ts = StreamToTimeAndSales(new StringReader(text));
            return ConvertToQuotes(ts);
        }
        public static Quote FileToMinutelyQuote(string filename) {
            TextReader reader = new StreamReader(filename);
            TimeAndSales ts = StreamToTimeAndSales(reader);
            reader.Close();
            return ConvertToQuotes(ts);
        }
        private static Quote ConvertToQuotes(TimeAndSales ts) {
            ConcreteQuote q = ts.ConvertToQuotes(new BTime(9, 0, 0).AsInt(), new BTime(15, 0, 0).AsInt(), StockExchange.T);
            return q;
        }

        //GradChartのためにテスト用のChartDocumentを作る
        public static IChartDataSourceBase CreateTestChartDocumentForGradient(ITimeAndSales ts, int origin) {
            BasicStockProfile prof = new BasicStockProfile("grad_test", "gr1", StockProfileFlags.None, 1);

            IntraDayTrade dt = new IntraDayTrade(prof.CreatePrimary(StockExchange.T, StockExchangeSubType.Ichibu, StockFlags.None));
            dt.CurrentPriceInfo.LastClose.SetValue(origin);
            dt.ReplaceQuotes(((TimeAndSales)ts).ConvertToQuotes(new BTime(9, 0, 0).AsInt(), new BTime(15, 0, 0).AsInt(), StockExchange.T));
            
            ExternalIntraDayTradeChartDocument doc = new ExternalIntraDayTradeChartDocument(dt, 1);
            
            return doc;
            
        }

    }
}
