/*
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Travis/SingleLinkedList.cs#8 $
 * $DateTime: 2007/12/28 19:23:38 $
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

#if UNITTEST
using NUnit.Framework;
#endif

namespace Travis.Collections {
    //VOÑXg
    //Remove͂Ȃ̂œK..
    public class SingleLinkedList<T> : IEnumerable<T> where T:class {
        public class Node {
            public T value;
            public Node next;
            public Node(T v) {
                value = v;
            }
        }
        private Node _first;
        private int _count;

        public void Add(T v) {
            Node n = GetLastNode();
            Node c = new Node(v);
            if(n==null)
                _first = c;
            else
                n.next = c;

            _count++;
        }
        public void Clear() {
            _first = null;
            _count = 0;
        }
        public int Count {
            get {
                return _count;
            }
        }

        private Node GetLastNode() {
            Node n = _first;
            if(n==null) return null;

            while(n.next!=null) n = n.next;
            return n;
        }

        // true Ԃ
        public bool Remove(T v) {
            Node current = _first;
            Node prev = null;

            while(current!=null) {
                if(current.value==v) break;
                prev = current;
                current = current.next;
            }

            if(current==null)
                return false;
            else {
                if(prev==null)
                    _first = current.next;  //̂Ƃ_first==current
                else
                    prev.next = current.next;
                _count--;
                return true;
            }
        }

        private Node FindNode(T v) {
            Node n = _first;
            while(n!=null) {
                if(n.value==v) return n;
                n = n.next;
            }
            return null;
        }

        private class Enumerator : IEnumerator<T> {
            private Node _node;
            private bool _new;

            public Enumerator(Node n) {
                _node = n;
                _new = true;
            }
            public T Current {
                get {
                    return _node.value;
                }
            }

            public void Dispose() {
            }

            object System.Collections.IEnumerator.Current {
                get {
                    return _node.value;
                }
            }

            public bool MoveNext() {
                if(_new)
                    _new = false;
                else
                    _node = _node.next;
                return _node!=null;
            }

            public void Reset() {
                throw new Exception("unimplemented");
            }
        }

        public IEnumerator<T> GetEnumerator() {
            return new Enumerator(_first);
        }

        IEnumerator IEnumerable.GetEnumerator() {
            return new Enumerator(_first);
        }

        public delegate bool Finder(T v);
        public T Find(Finder f) {
            Node n = _first;
            while(n!=null) {
                if(f(n.value)) return n.value;
                n = n.next;
            }
            return null;
        }
        public delegate void Each(T v);
        public void Apply(Each f) {
            Node n = _first;
            while(n!=null) {
                f(n.value);
                n = n.next;
            }
        }

        public T[] ToArray() {
            T[] r = new T[_count];
            int i = 0;
            Node n = _first;
            while(n!=null) {
                r[i++] = n.value;
                n = n.next;
            }
            return r;
        }

    }
#if UNITTEST
    [TestFixture]
    public class SingleLinkedListTests {
        [Test]
        public void Enumeration() {
            SingleLinkedList<string> c = new SingleLinkedList<string>();
            c.Add("A");
            c.Add("B");
            c.Add("C");

            Assert.AreEqual(3, c.Count);
            Assert.AreEqual("ABC", CollectionToString(c));

            //
            c = new SingleLinkedList<string>();
            
            Assert.AreEqual(0, CollectionToString(c).Length);
        }
        [Test]
        public void Functions() {
            SingleLinkedList<string> c = new SingleLinkedList<string>();
            c.Add("A");
            c.Add("B");
            c.Add("C");

            Assert.AreEqual(3, c.Count);
            Assert.AreEqual("ABC", CollectionToString(c));

            string r = c.Find(delegate(string x) { return x.Length==2; });
            Assert.IsNull(r);
            r = c.Find(delegate(string x) { return x[0]=='B'; });
            Assert.AreEqual("B", r);
        }
        [Test]
        public void Remove() {
            SingleLinkedList<string> c = new SingleLinkedList<string>();
            c.Add("A");
            c.Add("B");
            c.Add("C");

            //萔internĂ邱ƂOɂĂ
            c.Remove("B");
            Assert.AreEqual(2, c.Count);
            Assert.AreEqual("AC", CollectionToString(c));

            c.Remove("A");
            Assert.AreEqual(1, c.Count);
            Assert.AreEqual("C", CollectionToString(c));

            c.Remove("C");
            Assert.AreEqual(0, c.Count);
            Assert.AreEqual("", CollectionToString(c));
        }

        private string CollectionToString(SingleLinkedList<string> c) {
            StringBuilder bld = new StringBuilder();
            c.Apply(delegate(string x) { bld.Append(x); });
            return bld.ToString();
        }

    }
#endif
}
