/*
 * Trading Platform "Bellagio"
 * Copyright (c) 2006, 2007  Lagarto Technology, Inc.
 * 
 * $Id: //depot/Bellagio/Demeter/Values/DateTime.cs#12 $
 * $DateTime: 2008/05/14 13:05:12 $
 * 
 * BV̂AtƎ
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

//using Bellagio.Data;

#if UNITTEST
using NUnit.Framework;
#endif


namespace Bellagio.Values {

    //̒̎bPʂŎB
    public class BTime : BV, IComparable {

        private int _value;
        public BTime(int v) {
            _value = v;
        }
        public BTime(BTime v) {
            _value = v._value;
        }
        public BTime(int hour, int minute, int second) {
            _value = hour*3600 + minute*60 + second;
        }
        public int AsInt() {
            return _value;
        }
        public void LetInt(int value) {
            _value = value;
        }
        //IuWFNgnullȂ璼ڑAłȂΐVK쐬
        public static BTime LetRaw(BTime target, int value) {
            if(target==null)
                return new BTime(value);
            else {
                target.LetInt(value);
                return target;
            }
        }
        public override BT BT {
            get {
                return BT.Time;
            }
        }
        public override void Format(BVFormatter formatter) {
            formatter.BTime(this);
        }
        //staticint𒼐ڂƂ, HHMM`
        public static void FormatInt(int value, StringBuilder bld) {
            bld.Append(String.Format("{0:D2}:{1:D2}:{2:D2}", value / 3600, (value % 3600) / 60, value % 60));
        }
        //TODO FormatñVOl`܂łĂȂ
        public static string FormatHHMM(BTime value) {
            return String.Format("{0:D2}:{1:D2}", value.Hour, value.Minute);
        }
        public static string FormatHHMM(int value) {
            return String.Format("{0:D2}:{1:D2}", value/3600, (value % 3600) / 60);
        }
        public static string FormatHHMMSS(BTime value) {
            return String.Format("{0:D2}:{1:D2}:{2:D2}", value.Hour, value.Minute, value.Second);
        }
        public override void Let(BV value) {
            _value = ((BTime)value)._value;
        }

        public void AddSec(int value) {
            _value += value;
        }
        public void AddMin(int value) {
            _value += value * 60;
        }

        public int Hour {
            get {
                return _value / 3600;
            }
        }
        public int Minute {
            get {
                return (_value % 3600) / 60;
            }
        }
        public int Second {
            get {
                return _value % 60;
            }
        }

        public static BTime Parse(string fmt) {
            return new BTime(ParseToInt(fmt));
        }
        public static int ParseToInt(string fmt) {
            string[] t = fmt.Split(':', ' ', '\t');
            if(t.Length > 3 || t.Length < 2) throw new FormatException("BTime format error " + fmt); //b͏ȗł

            int hour = Int32.Parse(t[0]);
            int minute = Int32.Parse(t[1]);
            int seconds = t.Length==2? 0 : Int32.Parse(t[2]);
            if(hour<0 || hour>=24 || minute<0 || minute>=60 || seconds<0 || seconds>=60) throw new FormatException("BTime format error " + fmt);

            return hour*3600 + minute*60 + seconds;
        }
        public static BTime FromDateTime(DateTime t) {
            return new BTime(t.Hour, t.Minute, t.Second);
        }

        //static
        private static BTime max = new BTime(23, 59, 59);
        public static int MaxAsInt {
            get {
                return max.AsInt();
            }
        }

        public int AsMinutelyInt() {
            return AsMinutelyInt(_value);
        }
        public static int AsMinutelyInt(int value) {
            int t = value;
            return t - t % 60;
        }


        public int CompareTo(object obj) {
            return _value.CompareTo(((BTime)obj)._value);
        }

    }
    public class BDate : BV, IComparable {
        private static string[] _dayOfWeeks = new string[] { "", "", "", "", "", "", "y" };

        private int _value; //yyyymmdd`̐
        public BDate(int v) {
            _value = v;
        }
        public BDate(BDate src) {
            _value = src._value;
        }
        public BDate(int year, int month, int day) {
            _value = year * 10000 + month * 100 + day;
        }
        public int AsInt() {
            return _value;
        }
        public void LetInt(int value) {
            _value = value;
        }

        //IuWFNgnullȂ璼ڑAłȂΐVK쐬
        public static BDate LetRaw(BDate target, int value) {
            if(target==null)
                return new BDate(value);
            else {
                target.LetInt(value);
                return target;
            }
        }

        public int Year {
            get {
                return _value / 10000;
            }
        }
        public int Month {
            get {
                return (_value / 100) % 100;
            }
        }
        public int Day {
            get {
                return _value % 100;
            }
        }
        public DateTime ToDateTime() {
            return new DateTime(this.Year, this.Month, this.Day);
        }
        public static DateTime ToDateTime(int value) {
            return new DateTime(value / 10000, (value / 100) % 100, value % 100);
        }
        public string DayOfWeekString {
            get {
                DateTime dt = ToDateTime();
                return _dayOfWeeks[(int)dt.DayOfWeek];
            }
        }
        public override BT BT {
            get {
                return BT.Date;
            }
        }
        public override void Format(BVFormatter formatter) {
            formatter.BDate(this);
        }
        public override void Let(BV value) {
            _value = ((BDate)value)._value;
        }
        public static int DateTimeToInt(DateTime t) {
            return t.Year*10000 + t.Month*100 + t.Day;
        }
        public static string FormatYYMMDD(BDate value) {
            return String.Format("{0:D2}/{1:D2}/{2:D2}", value.Year % 100, value.Month, value.Day);
        }
        public static string FormatMMDD(BDate value) {
            return String.Format("{0:D2}/{1:D2}", value.Month, value.Day);
        }

        public int CompareTo(object obj) {
            return _value.CompareTo(((BDate)obj)._value);
        }

    }

    /*
    //cƓ}bvB̓tǂꂾĂ邩AƂƂ͂jƂl\Ă̂͂₢
    public class DateMap {
        private int[] _dates;
        private int _todayIndex;

        public DateMap(int past_length, int future_length, DateTime today) {
            _dates = new int[past_length + future_length];
            _todayIndex = past_length;

            DateTime t = today;
            int i = 0;
            while(i<future_length) {
                if(PublicMarketUtil.IsMarketOpenDate(t)) {
                    _dates[past_length + i++] = BDate.DateTimeToInt(t);
                }
                t = t.AddDays(1);
            }

            t = today.AddDays(-1);
            i = 0;
            while(i<past_length) {
                if(PublicMarketUtil.IsMarketOpenDate(t)) {
                    _dates[past_length - 1 - i++] = BDate.DateTimeToInt(t);
                }
                t = t.AddDays(-1);
            }
        }
        public int DateAt(int index) {
            return _dates[index];
        }
        public int Length {
            get {
                return _dates.Length;
            }
        }

        public int FindExact(int date) {
            //'today'ߕӂł̃T[`͂Ȃ̂
            int t = _dates[_todayIndex];
            if(date >= t)
                return FindExact(date, _todayIndex, _dates.Length);
            else if(date >= _dates[_todayIndex-128])
                return FindExact(date, _todayIndex-128, _todayIndex);
            else
                return FindExact(date, 0, _todayIndex-128);
        }

        //Ƃ̓oCiT[`
        private int FindExact(int date, int start, int end) {
            Debug.Assert(start < end);
            if(start+1==end) { //Pɍiꂽ
                return date==_dates[start]? start : -1; //vOK
            }
            else {
                int mid = (start + end) / 2;
                Debug.Assert(start < mid && mid < end);
                int t = _dates[mid];
                if(t > date)
                    return FindExact(date, start, mid);
                else
                    return FindExact(date, mid, end);
            }
        }

    }
    */

#if UNITTEST
    [TestFixture]
    public class DateTimeTests {
        [Test]
        public void BTime0() {
            BTime t = BTime.Parse("10:11:12");
            Assert.AreEqual(10, t.Hour);
            Assert.AreEqual(11, t.Minute);
            Assert.AreEqual(12, t.Second);

            t = BTime.Parse("10:11");
            Assert.AreEqual(10, t.Hour);
            Assert.AreEqual(11, t.Minute);
            Assert.AreEqual(0, t.Second);
        }
        [Test]
        public void BTime1() {
            BTime t = BTime.Parse("9:59:59");
            Assert.AreEqual("09:59:59", BV.DefaultFormat(t));

            t.AddSec(3);
            Assert.AreEqual("10:00:02", BV.DefaultFormat(t));

            t.AddSec(-3);
            Assert.AreEqual("09:59:59", BV.DefaultFormat(t));
        }
        /*
        [Test]
        public void DateMap() {
            DateTime dt = new DateTime(2007, 1, 4);
            int past_len = 2000;
            DateMap m = new DateMap(past_len, 100, dt);

            int a = m.FindExact(20070104);
            Assert.AreEqual(past_len, a);

            Assert.AreEqual(20061229, m.DateAt(a-1)); //PO
            Assert.AreEqual(20070112, m.DateAt(a+5)); //PTԌ

            Assert.AreEqual(MarketUtil.GetSQDate(2007, 3), 20070309); //RSQ
        }
        */
    }
#endif
}
