/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: //depot/Bellagio/Hermes/Poderosa/Core/MainWindowMenu.cs#6 $
 */
using System;
using System.Diagnostics;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Text;

using Poderosa.Util;
using Poderosa.Util.Collections;
using Poderosa.Plugins;
//using Poderosa.UI;
using Poderosa.Commands;

namespace Poderosa.Forms
{
    //Cj[
    //  }`EBhE\ł̂ŁAMainMenuItem̃c[̓AvP[VŗB(WindowManagerۗL)A
    //  Windows.Formsx[X̃j[ڂ͕KvɉĂ̓sx쐬邱Ƃɒӂ
	internal class MainWindowMenu {
        private TypedSequentialTable<string, MainMenuItem> _idToMenu;
        private MainMenuItem _fileMenu;
        //private MainMenuItem _editMenu;
        //private MainMenuItem _consoleMenu;
        private MainMenuItem _toolMenu;
        private MainMenuItem _windowMenu;
        //private MainMenuItem _pluginMenu;
        private MainMenuItem _helpMenu;

        //QƂ郁j[O[v
        private SplitMenuGroup _splitMenuGroup;

        public MainWindowMenu() {
            _idToMenu = new TypedSequentialTable<string, MainMenuItem>();

            _fileMenu    = CreateMainMenu("Menu.File",    "org.poderosa.menu.file");
            //_editMenu    = CreateMainMenu("Menu.Edit",    "org.poderosa.menu.edit");
            //_consoleMenu = CreateMainMenu("Menu.Console", "org.poderosa.menu.console");
            _toolMenu    = CreateMainMenu("Menu.Tool",    "org.poderosa.menu.tool");
            _windowMenu  = CreateMainMenu("Menu.Window", "org.poderosa.menu.window");
            //_pluginMenu  = CreateMainMenu("Menu.Plugin",  "org.poderosa.menu.plugin");
            _helpMenu    = CreateMainMenu("Menu.Help",    "org.poderosa.menu.help");

            _splitMenuGroup = new SplitMenuGroup();
            _fileMenu.ExtensionPoint.RegisterExtension(new NewWindowMenuGroup());
            _fileMenu.ExtensionPoint.RegisterExtension(new QuitMenuGroup());
            //_pluginMenu.ExtensionPoint.RegisterExtension(new DefaultPluginMenuGroup());
            _windowMenu.ExtensionPoint.RegisterExtension(_splitMenuGroup);
            _windowMenu.ExtensionPoint.RegisterExtension(new CloseAllMenuGroup(_splitMenuGroup));
            _windowMenu.ExtensionPoint.RegisterExtension(new SetTabRowCountMenuGroup(_splitMenuGroup));
            _windowMenu.ExtensionPoint.RegisterExtension(new DocActivationMenuGroup());
            //_helpMenu.ExtensionPoint.RegisterExtension(new DefaultHelpMenuGroup());
        }
        private MainMenuItem CreateMainMenu(string text_id, string extension_point_name) {
            StringResource str = CoreUtil.Strings;
            MainMenuItem item = new MainMenuItem(text_id, extension_point_name, _idToMenu.Count);
            _idToMenu.Add(extension_point_name, item);
            return item;
        }

        public void FullBuild(MenuStrip mainmenu, ICommandTarget target) {
            foreach(Pair<string,MainMenuItem> p in _idToMenu.Pairs) {
                mainmenu.Items.Add(MenuUtil.CreateMenuItem(p.Second, target));
            }
        }

        public SplitMenuGroup SplitMenuGroup {
            get {
                return _splitMenuGroup;
            }
        }

        public MainMenuItem FindMainMenuItem(string extension_point_name) {
            return _idToMenu[extension_point_name];
        }

        //ʂ̃vOC̒ǉpC^tF[X
        public void AddItemFirst(string text, string extension_point_name) {
            MainMenuItem item = new MainMenuItem(text, extension_point_name, _idToMenu.Count);
            item.UseStringResource = false;
            _idToMenu.Add(extension_point_name, item);
        }
        
        public void InsertItem(MainMenuItem pos, string extension_point_name, string text) {
            MainMenuItem item = new MainMenuItem(text, extension_point_name, pos.Index + 1);
            item.UseStringResource = false;
            for(int i=pos.Index+1; i<_idToMenu.Count; i++)
                _idToMenu.ValueAt(i).Index += 1;
            _idToMenu.Insert(pos.ExtensionPoint.ID, extension_point_name, item);
        }

    }

    internal class MainMenuItem : IPoderosaMenuFolder {
        private List<IPoderosaMenuGroup> _children;
        private bool _created;
        private bool _useStringResource;
        private int _index;
        private string _text;
        private IExtensionPoint _extensionPoint;

        public MainMenuItem(string text, string extension_point_name, int index) {
            _children = new List<IPoderosaMenuGroup>();
            _index = index;
            _text = text;
            _extensionPoint = WindowManagerPlugin.Instance.PoderosaWorld.PluginManager.CreateExtensionPoint(extension_point_name, typeof(IPoderosaMenuGroup), WindowManagerPlugin.Instance);
            _created = false;
            _useStringResource = true;
        }

        public void Create() {
            if(_created) return;

            _children.Clear();
            IPoderosaMenuGroup[] me = (IPoderosaMenuGroup[])_extensionPoint.GetExtensions();
            
            //\[găRNVɒǉ
            foreach (IPoderosaMenuGroup g in PositionDesignationSorter.SortItems(me)) {
                _children.Add(g);
            }

            _created = true;
        }

        public IPoderosaMenuGroup[] ChildGroups {
            get {
                return _children.ToArray();
            }
        }

        public string Text {
            get {
                return _useStringResource? CoreUtil.Strings.GetString(_text) : _text;
            }
        }
        public int Index {
            get {
                return _index;
            }
            set {
                _index = value;
            }
        }
        public bool UseStringResource {
            get {
                return _useStringResource;
            }
            set {
                _useStringResource = value;
            }
        }
        public IExtensionPoint ExtensionPoint {
            get {
                return _extensionPoint;
            }
        }

        public bool IsEnabled(ICommandTarget target) {
            return true;
        }
        public bool IsChecked(ICommandTarget target) {
            return false;
        }
        public IAdaptable GetAdapter(Type adapter) {
            return WindowManagerPlugin.Instance.PoderosaWorld.AdapterManager.GetAdapter(this, adapter);
        }
    }

    internal class DefaultMenuItemGroup : IPoderosaMenuGroup {
        private List<IPoderosaMenu> _children;

        public DefaultMenuItemGroup() {
            _children = new List<IPoderosaMenu>();
        }


        public IPoderosaMenu[] ChildMenus {
            get {
                return _children.ToArray();
            }
        }

        public bool IsVolatileContent {
            get {
                return false;
            }
        }
        public bool ShowSeparator {
            get {
                return true;
            }
        }

        public IAdaptable GetAdapter(Type adapter) {
            return WindowManagerPlugin.Instance.PoderosaWorld.AdapterManager.GetAdapter(this, adapter);
        }
    }
    

}
