/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: Selection.cs,v 1.3 2006/06/22 12:16:25 okajima Exp $
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

using Poderosa.View;
using Poderosa.Commands;
using Poderosa.Sessions;

//Ï̊ǗƁAÎɊւ{R}hiRs[Ȃǁj̎

namespace Poderosa.Forms {
    internal class SelectionService : ISelectionService {

        private WindowManagerPlugin _parent;
        //!!private SelectedTextCopyCommand _copyCommand;

        public SelectionService(WindowManagerPlugin parent) {
            _parent = parent;
            //!!    _copyCommand = new SelectedTextCopyCommand();
        }

        public ISelection ActiveSelection {
            get {
                IPoderosaMainWindow window = _parent.ActiveWindow;
                if(window==null) return null;

                IPoderosaView view = window.LastActivatedView;
                if(view==null) return null;

                return view.CurrentSelection;
            }
        }

        public IPoderosaCommand DefaultCopyCommand {
            get {
                return null;
            }
        }
    }
}
