/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: AdpaterManager.cs,v 1.2 2006/05/18 09:20:43 okajima Exp $
 */
using System;
using System.Collections.Generic;
using System.Diagnostics;
using Poderosa.Util.Collections;

namespace Poderosa
{
	//ʂ̓AvŗBBeAdapterFactoryǗ
	internal class AdapterManager : IAdapterManager	{
	
		//ϊIuWFNgTypeΉFactorỹRNVւ̃}bsO
        //ôǂ瑤Ȃ͖̂^q˂A
		private TypedHashtable<Type, List<IDualDirectionalAdapterFactory>> _classToFactoryList;

		public AdapterManager() {
            _classToFactoryList= new TypedHashtable<Type, List<IDualDirectionalAdapterFactory>>();
        }

        #region IAdapterManager
        public void RegisterFactory(IDualDirectionalAdapterFactory factory) {
            Debug.Assert(factory.SourceType.IsClass, "source type must be a class");
            RegisterFactory(factory.SourceType, factory);
            Debug.Assert(factory.AdapterType.IsClass, "adapter type must be a class");
            RegisterFactory(factory.AdapterType, factory);
		}
        private void RegisterFactory(Type type, IDualDirectionalAdapterFactory factory) {
            List<IDualDirectionalAdapterFactory> l = FindFactoryList(type);
            if(l==null) {
                l = new List<IDualDirectionalAdapterFactory>();
                _classToFactoryList.Add(type, l);
            }
            l.Add(factory);
        }

        public void RemoveFactory(IDualDirectionalAdapterFactory factory) {
            RemoveFactory(factory.SourceType, factory);
            RemoveFactory(factory.AdapterType, factory);
        }
        private void RemoveFactory(Type type, IDualDirectionalAdapterFactory factory) {
            List<IDualDirectionalAdapterFactory> l = FindFactoryList(type);
            if(l!=null) {
                l.Remove(factory);
                if(l.Count==0)
                    _classToFactoryList.Remove(type);
            }
        }

	    public IAdaptable GetAdapter(IAdaptable obj, Type adapter) {
			//V[gJbg: ڌ^ꍇAdapterFactory݂̑Ɋ֌WȂϊ\
			if(adapter.IsInstanceOfType(obj)) return obj;

            //TĂ݂
            List<IDualDirectionalAdapterFactory> l = FindFactoryList(obj.GetType());
            if(l==null) return null;

            foreach(IDualDirectionalAdapterFactory f in l) {
                IAdaptable r = ChallengeUsingAdapterFactory(f, obj, adapter);
                if(r!=null) return r;
            }

            return null;
		}

        private IAdaptable ChallengeUsingAdapterFactory(IDualDirectionalAdapterFactory factory, IAdaptable obj, Type adapter) {
            Type dest = factory.SourceType==obj.GetType()? factory.AdapterType : factory.SourceType; //ϊNX

            if(adapter.IsAssignableFrom(dest)) { //ȂrSƂĂB݂͂̃P[XȂ͂
                IAdaptable t = factory.SourceType==obj.GetType()? factory.GetAdapter(obj) : factory.GetSource(obj);
                Debug.Assert(adapter.IsInstanceOfType(t));
                return t;
            }

            //GȃP[XB
            //ϊ̃IuWFNgGetAdapterǂł݂iċAĂяo΍KvjA
            //QXebvȏFactorygpAȂǂKvB
            //TODO ݖT|[g
            return null;
        }

        //Generic
        T IAdapterManager.GetAdapter<T>(IAdaptable obj) {
            return (T)GetAdapter(obj, typeof(T));
        }
        #endregion

        private List<IDualDirectionalAdapterFactory> FindFactoryList(Type adapter) {
			return _classToFactoryList[adapter];
		}

	}
}
