/*
 * Copyright 2004,2006 The Poderosa Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 *
 * $Id: PoderosaLogEx.cs,v 1.8 2006/08/23 06:45:16 dan-iwasaki Exp $
 */
using System;
using System.Collections.Generic;
using System.Text;

namespace Poderosa {
    /// <summary>
    /// <ja>
    /// ÕJeSC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface of category of log.
    /// </en>
    /// </summary>
    public interface IPoderosaLogCategory : IAdaptable {
        /// <summary>
        /// <ja>
        /// JeSłB
        /// </ja>
        /// <en>
        /// Name of category.
        /// </en>
        /// </summary>
        string Name { get; }
    }
    /// <summary>
    /// <ja>
    /// ÕACeC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface of log items
    /// </en>
    /// </summary>
    public interface IPoderosaLogItem : IAdaptable {
        /// <summary>
        /// <ja>
        /// ÕJeSłB
        /// </ja>
        /// <en>
        /// Category of log.
        /// </en>
        /// </summary>
        IPoderosaLogCategory Category { get; }
        /// <summary>
        /// <ja>
        /// ÕeLXgłB
        /// </ja>
        /// <en>
        /// Text of log.
        /// </en>
        /// </summary>
        string Text { get; }

        /// <summary>
        /// <ja>
        /// OACẽCfbNXԍłB
        /// </ja>
        /// <en>
        /// Index number of log item.
        /// </en>
        /// </summary>
        int Index { get; }
        //TimeĂ
    }

    /// <summary>
    /// <ja>
    /// O@\񋟂܂B
    /// </ja>
    /// <en>
    /// Offered log function.
    /// </en>
    /// </summary>
    public interface IPoderosaLog : IAdaptable, IEnumerable<IPoderosaLogItem> {
        /// <summary>
        /// <ja>
        /// O̗eʂ擾^ݒ肵܂B
        /// </ja>
        /// <en>
        /// Get / set the capacity of log.
        /// </en>
        /// </summary>
        int Capacity { get; set; }
        /// <summary>
        /// <ja>
        /// Oɏ݂܂B
        /// </ja>
        /// <en>
        /// Write log.
        /// </en>
        /// </summary>
        /// <param name="category">
        /// <ja>ÕJeSłB</ja>
        /// <en>Category of log.</en>
        /// </param>
        /// <param name="text">
        /// <ja>ރeLXgłB</ja>
        /// <en>Text to write.</en>
        /// </param>
        void AddItem(IPoderosaLogCategory category, string text);
        /// <summary>
        /// <ja>
        /// ÕACě܂B
        /// </ja>
        /// <en>
        /// Count of log item.
        /// </en>
        /// </summary>
        int Count { get; }

        /// <summary>
        /// <ja>
        /// ÕXio^܂B
        /// </ja>
        /// <en>
        /// Add the log listener
        /// </en>
        /// </summary>
        /// <param name="listener">
        /// <ja>o^郊Xi</ja>
        /// <en>Listener to regist.</en>
        /// </param>
        void AddChangeListener(IPoderosaLogListener listener);

        /// <summary>
        /// <ja>
        /// ÕXi܂B
        /// </ja>
        /// <en>
        /// Remove the log listener
        /// </en>
        /// </summary>
        /// <param name="listener">
        /// <ja>郊Xi</ja>
        /// <en>Listener to release.</en>
        /// </param>
        void RemoveChangeListener(IPoderosaLogListener listener);

        /// <summary>
        /// <ja>
        /// W̃OJeS܂B
        /// </ja>
        /// <en>
        /// Get the generic category of log.
        /// </en>
        /// </summary>
        IPoderosaLogCategory GenericCategory { get; }

    }

    /// <summary>
    /// <ja>
    /// OXiC^[tFCXłB
    /// </ja>
    /// <en>
    /// Interface of loglistener.
    /// </en>
    /// </summary>
    public interface IPoderosaLogListener {
        /// <summary>
        /// <ja>
        /// VOACeǉƂɌĂяo܂B
        /// </ja>
        /// <en>
        /// Called when added the new log item.
        /// </en>
        /// </summary>
        /// <param name="item">
        /// <ja>ǉACełB</ja>
        /// <en>Item to add.</en>
        /// </param>
        void OnNewItem(IPoderosaLogItem item);
    }

    /// <summary>
    /// <ja>
    /// OJeSwpNXłB
    /// </ja>
    /// <en>
    /// Helperclasss for implementation of category of log.
    /// </en>
    /// </summary>
    public class PoderosaLogCategoryImpl : IPoderosaLogCategory {
        private string _name;
        /// <summary>
        /// <ja>
        /// OJeS쐬܂B
        /// </ja>
        /// <en>
        /// Create the category of log.
        /// </en>
        /// </summary>
        /// <param name="name">
        /// <ja>OJeS̖OłB</ja>
        /// <en>Name of category of log.</en>
        /// </param>
        public PoderosaLogCategoryImpl(string name) {
            _name = name;
        }
        /// <summary>
        /// <ja>
        /// OJeSԂ܂B
        /// </ja>
        /// <en>
        /// Get the category of log.
        /// </en>
        /// </summary>
        public string Name {
            get {
                return _name;
            }
        }

        public IAdaptable GetAdapter(Type adapter) {
            return PoderosaLog.Instance.PoderosaWorld.AdapterManager.GetAdapter(this, adapter);
        }
    }
    
    /// <summary>
    /// <ja>
    /// OACe\wpNXłB
    /// </ja>
    /// <en>
    /// Helper class to compose the log item.
    /// </en>
    /// </summary>
    public class PoderosaLogItemImpl : IPoderosaLogItem {
        private IPoderosaLogCategory _category;
        private string _text;
        private int _index;

        /// <summary>
        /// <ja>
        /// OACe쐬܂B
        /// </ja>
        /// <en>
        /// Create the log item.
        /// </en>
        /// </summary>
        /// <param name="category"><ja>OACẽJeSłB</ja>
        /// <en>Category of log item.</en>
        /// </param>
        /// <param name="text"><ja>ÕeLXgłB</ja>
        /// <en>Text of log.</en>
        /// </param>
        /// <param name="index"><ja>ÕCfbNXʒułB</ja>
        /// <en>Index position of log.</en></param>
        public PoderosaLogItemImpl(IPoderosaLogCategory category, string text, int index) {
            _category = category;
            _text = text;
            _index = index;
        }

        /// <summary>
        /// <ja>
        /// OJeS܂B
        /// </ja>
        /// <en>
        /// Category of log.
        /// </en>
        /// </summary>
        public IPoderosaLogCategory Category {
            get {
                return _category;
            }
        }

        /// <summary>
        /// <ja>
        /// ÕeLXg܂B
        /// </ja>
        /// <en>
        /// Text of log.
        /// </en>
        /// </summary>
        public string Text {
            get {
                return _text;
            }
        }

        /// <summary>
        /// <ja>
        /// ÕCfbNXʒu܂B
        /// </ja>
        /// <en>
        /// Index of log.
        /// </en>
        /// </summary>
        public int Index {
            get {
                return _index;
            }
        }

        public IAdaptable GetAdapter(Type adapter) {
            return PoderosaLog.Instance.PoderosaWorld.AdapterManager.GetAdapter(this, adapter); 
        }
    }
}
